/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometPoArtiklimaNovi;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.stampa.NPrintUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StampaPrometPoArtiklimaBlicArtikliNovi {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    double ukupno = 0.0;
    double neto = 0.0;
    double srvc = 0.0;
    double ppst = 0.0;
    private Integer quantWidth = 5;

    public StampaPrometPoArtiklimaBlicArtikliNovi(List<Map<String, Object>> ppaArtData, Date from, Date to, Stampac printer, RestoranServer server) throws Exception {
        try {
            String content = this.writeContent(ppaArtData, from, to, printer.getTip().getBrojKarakteraURedu(), server);
            NPrintUtils.printContent(content, printer, 1);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    public StampaPrometPoArtiklimaBlicArtikliNovi(RestoranServer server, boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, boolean buyingPrices, boolean subtotal) throws Exception {
        try {
            EnumSet<NacinPlacanja> bp = EnumSet.copyOf(belaPlacanja);
            List<Map<String, Object>> ppaArtData = null;
            if (!bltz) {
                ppaArtData = server.getNewRevenueByArticlesArticleData(bp, cp, from, to, odeljenja, kase, podgrupe, ppaArtData, false, false, subtotal);
            }
            Stampac stampac = server.readIzvestajiStampacObject();
            String content = this.writeContent(ppaArtData, from, to, stampac.getTip().getBrojKarakteraURedu(), server);
            NPrintUtils.printContent(content, stampac, 1);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    private String writeContent(List<Map<String, Object>> ppaArtData, Date from, Date to, int bkur, RestoranServer server) {
        Double quant;
        if (ppaArtData == null || ppaArtData.isEmpty()) {
            return null;
        }
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(NPrintUtils.centerSplitToCenter(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date()))).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_PREGLED_PRODATIH_ARTIKALA"), new Object[0]).toUpperCase())).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateTimeString(from != null ? from : server.getLastOpenZD().getZakljucenje()))).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateTimeString(to != null ? to : new Date()))).append("\n");
        contentBuilder.append(NPrintUtils.spaceFill(bkur)).append("\n");
        contentBuilder.append(NPrintUtils.centerSplitToEnds(bkur, String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]), String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]))).append("\n");
        contentBuilder.append(NPrintUtils.minusFill(bkur)).append("\n");
        LinkedHashMap<String, Double> artQuantMap = new LinkedHashMap<String, Double>();
        for (Map<String, Object> row : ppaArtData) {
            String art = (String)row.get("artikal");
            quant = (Double)row.get("kolicina");
            if (!artQuantMap.containsKey(art)) {
                artQuantMap.put(art, 0.0);
            }
            artQuantMap.put(art, (Double)artQuantMap.get(art) + quant);
        }
        LinkedList arts = new LinkedList(artQuantMap.keySet());
        Collections.sort(arts);
        for (String art : arts) {
            quant = (Double)artQuantMap.get(art);
            contentBuilder.append(NPrintUtils.leftText(bkur - this.quantWidth - 1, art));
            contentBuilder.append(" ");
            contentBuilder.append(NPrintUtils.rightText(this.quantWidth, StatLogic.getNumber02NG(quant)));
            contentBuilder.append("\n");
        }
        return contentBuilder.toString();
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

