/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class StampaPrometPoArtiklima {
    File print;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    String naziv;
    RestoranServer server;
    List<String> crnaPlacanja = new ArrayList<String>();
    boolean odstampanazbirna = false;
    Stampac stampac;
    Double servis;
    Double popust;

    public StampaPrometPoArtiklima(List<StavkaRacuna> stavkeKonacno, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuna, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, double mz, Double servis, Double popust) {
        System.out.println("que passo hombre");
        this.server = restoran.getServer();
        for (CrnoPlacanje cp : this.server.readCrnaPlacanja()) {
            this.crnaPlacanja.add(cp.getNaziv());
        }
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        this.servis = servis;
        this.popust = popust;
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            String content = this.writeInString(stavkeKonacno, restoran, podgrupe, grupe, mapaPG, mapaP, nacinP, nacinPCrno, brRacuna, blic, day1, day2, crno, kombPlacanje, odeljenje, mz, 4);
            NPrintUtils.printContent(content, this.stampac, 1);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            return;
        }
    }

    public void writeInFile(List<StavkaRacuna> stavkeKonacno, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuna, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, double medjuzbir, int extraLinija) {
        HashMap mapG = new HashMap();
        HashMap mapPG = new HashMap();
        HashMap<GrupaArtikala, Double> mapGP = new HashMap<GrupaArtikala, Double>();
        HashMap<PodgrupaArtikala, Double> mapPGP = new HashMap<PodgrupaArtikala, Double>();
        for (StavkaRacuna sr : stavkeKonacno) {
            StavkaRacuna srn;
            Artikal art = sr.getArtikal();
            PodgrupaArtikala pg = art.getPodgrupa();
            GrupaArtikala ga = pg.getGrupa();
            String key = sr.getNaziv() + "~" + sr.getCena();
            if (mapG.containsKey(ga)) {
                if (!((List)mapG.get(ga)).contains(pg)) {
                    ((List)mapG.get(ga)).add(pg);
                }
            } else {
                LinkedList<PodgrupaArtikala> list = new LinkedList<PodgrupaArtikala>();
                list.add(pg);
                mapG.put(ga, list);
            }
            if (mapPG.containsKey(pg)) {
                if (((Map)mapPG.get(pg)).containsKey(key)) {
                    double kolicina = ((StavkaRacuna)((Map)mapPG.get(pg)).get(key)).getKolicina();
                    ((StavkaRacuna)((Map)mapPG.get(pg)).get(key)).setKolicina(kolicina += sr.getKolicina().doubleValue());
                } else {
                    srn = (StavkaRacuna)SerializationUtils.clone((Serializable)sr);
                    srn.setId(null);
                    ((Map)mapPG.get(pg)).put(key, srn);
                }
            } else {
                srn = (StavkaRacuna)SerializationUtils.clone((Serializable)sr);
                srn.setId(null);
                HashMap<String, StavkaRacuna> map = new HashMap<String, StavkaRacuna>();
                map.put(key, srn);
                mapPG.put(pg, map);
            }
            if (!mapGP.containsKey(ga)) {
                mapGP.put(ga, 0.0);
            }
            Double gp = (Double)mapGP.get(ga);
            gp = gp + sr.getVrednost();
            mapGP.put(ga, gp);
            if (!mapPGP.containsKey(pg)) {
                mapPGP.put(pg, 0.0);
            }
            Double pgp = (Double)mapPGP.get(pg);
            pgp = pgp + sr.getVrednost();
            mapPGP.put(pg, pgp);
        }
        System.out.println(mapG.keySet().size());
        System.out.println(mapPG.keySet().size());
        Comparator<GrupaArtikala> cga = new Comparator<GrupaArtikala>(){

            @Override
            public int compare(GrupaArtikala o1, GrupaArtikala o2) {
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        Comparator<PodgrupaArtikala> cpg = new Comparator<PodgrupaArtikala>(){

            @Override
            public int compare(PodgrupaArtikala o1, PodgrupaArtikala o2) {
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        Comparator<StavkaRacuna> csr = new Comparator<StavkaRacuna>(){

            @Override
            public int compare(StavkaRacuna o1, StavkaRacuna o2) {
                if (o1.getNaziv().compareTo(o2.getNaziv()) == 0) {
                    return o1.getCena().compareTo(o2.getCena());
                }
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        try {
            LinkedList listGA;
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\artikli.txt");
            PrintStream ps = new PrintStream(this.fos);
            ps.println(Konstante.getDate(new Date()) + "\t\t" + Konstante.getfullTime(new Date()));
            ps.println(StringUtils.center((String)"PREGLED PRODATIH ARTIKALA", (int)34));
            ps.println(StringUtils.center((String)("od " + Konstante.getDate(day1) + " do " + Konstante.getDate(day2)), (int)34));
            int pgIndent = 2;
            int srIndent = 4;
            char[] pgic = new char[pgIndent];
            char[] sric = new char[srIndent];
            char[] eql = new char[34];
            char[] minl = new char[34];
            Arrays.fill(pgic, ' ');
            Arrays.fill(sric, ' ');
            Arrays.fill(eql, '=');
            Arrays.fill(minl, '-');
            if (!blic) {
                listGA = new LinkedList(mapG.keySet());
                Collections.sort(listGA, cga);
                for (GrupaArtikala ga : listGA) {
                    ps.println(new String(eql));
                    ps.println(new StringAlign(34, 108).format(ga.getNaziv()));
                    ps.println(new String(minl));
                    NacinPlacanja[] listPG = (NacinPlacanja[])mapG.get(ga);
                    Collections.sort(listPG, cpg);
                    int i = 0;
                    Iterator iterator = listPG.iterator();
                    while (iterator.hasNext()) {
                        PodgrupaArtikala pg = (PodgrupaArtikala)iterator.next();
                        if (++i > 1) {
                            ps.println(new String(minl));
                        }
                        ps.println(new String(pgic) + new StringAlign(34 - pgic.length, 108).format(pg.getNaziv()));
                        ps.println(new String(minl));
                        LinkedList listSR = new LinkedList(((Map)mapPG.get(pg)).values());
                        Collections.sort(listSR, csr);
                        for (StavkaRacuna sr : listSR) {
                            double kol = sr.getKolicina();
                            double cena = sr.getArtikal().getCena();
                            ps.println(new String(sric) + new StringAlign(34 - sric.length, 108).format(sr.getArtikal().getName()));
                            ps.println(new String(sric) + new StringAlign(5, 108).format(Konstante.getNumber02(kol)) + new StringAlign(12 - (sric.length - sric.length % 2) / 2, 114).format(Konstante.getNumber2(cena)) + new StringAlign(17 - (sric.length - sric.length % 2) / 2 + sric.length % 2, 114).format(Konstante.getNumber2(kol * cena)));
                        }
                    }
                }
                ps.println(new String(eql));
            }
            if (!blic) {
                ps.println(StringUtils.center((String)"Podgrupe", (int)34));
                ps.println(new String(minl));
            } else {
                ps.println();
            }
            ps.println(new StringAlign(9, 108).format("VRSTA") + new StringAlign(25, 114).format("PROD. VRED."));
            ps.println(new String(minl));
            if (!blic) {
                LinkedList listPG = new LinkedList(mapPGP.keySet());
                Collections.sort(listPG, cpg);
                for (PodgrupaArtikala pg : listPG) {
                    ps.println(pg.getNaziv() + new StringAlign(34 - pg.getNaziv().length(), 114).format(Konstante.getNumber2((Double)mapPGP.get(pg))));
                }
                ps.println(new String(eql));
                ps.println(StringUtils.center((String)"Grupe", (int)34));
                ps.println(new String(minl));
                ps.println(new StringAlign(9, 108).format("VRSTA") + new StringAlign(25, 114).format("PROD. VRED."));
                ps.println(new String(minl));
            }
            listGA = new LinkedList(mapGP.keySet());
            Collections.sort(listGA, cga);
            for (GrupaArtikala g : listGA) {
                ps.println(g.getNaziv() + new StringAlign(34 - g.getNaziv().length(), 114).format(Konstante.getNumber2((Double)mapGP.get(g))));
            }
            ps.println(new String(eql));
            ps.println(new StringAlign(24, 108).format("INSTRUMENTI") + new StringAlign(10, 114).format("NETO"));
            ps.println(new StringAlign(24, 108).format("PLACANJA") + new StringAlign(10, 114).format("IZNOS"));
            ps.println(new String(minl));
            double ukupno = 0.0;
            if (!kombPlacanje) {
                for (NacinPlacanja np : NacinPlacanja.values()) {
                    if (!nacinP.containsKey((Object)np)) continue;
                    ps.println(np.name() + new StringAlign(34 - np.name().length(), 114).format(Konstante.getNumber2(nacinP.get((Object)np))));
                    ukupno += nacinP.get((Object)np).doubleValue();
                }
                if (crno) {
                    for (String cp : this.crnaPlacanja) {
                        if (!nacinPCrno.containsKey(cp)) continue;
                        if (!cp.equals("Medjuzbir")) {
                            ps.println(cp + new StringAlign(30 - cp.length(), 114).format(Konstante.getNumber2(nacinPCrno.get(cp))));
                            ukupno += nacinPCrno.get(cp).doubleValue();
                            continue;
                        }
                        ps.println(cp + new StringAlign(30 - cp.length(), 114).format(Konstante.getNumber2(medjuzbir)));
                    }
                }
                if (this.servis != null || this.popust != null) {
                    ps.println(new String(minl));
                }
                if (this.servis != null) {
                    ps.println(new StringAlign(9, 108).format("SERVIS") + new StringAlign(25, 114).format(Konstante.getNumber2(this.servis)));
                }
                if (this.popust != null) {
                    ps.println(new StringAlign(9, 108).format("POPUST") + new StringAlign(25, 114).format(Konstante.getNumber2(this.popust)));
                }
                ps.println(new String(minl));
                ps.println(new StringAlign(9, 108).format("TOTAL") + new StringAlign(25, 114).format(Konstante.getNumber2(ukupno)));
                ps.println(new String(eql));
                if (brRacuna != null) {
                    ps.println("Nacin placanja" + new StringAlign(18, 114).format("Broj racuna"));
                    boolean ukupnoRacuna = false;
                    for (NacinPlacanja np : NacinPlacanja.values()) {
                        if (!brRacuna.containsKey(np.name())) continue;
                        String nacinPlacanja = "";
                        nacinPlacanja = np.name().equalsIgnoreCase("GOTOVINA") ? "GOTOV." : (np.name().equalsIgnoreCase("KARTICA") ? "KART." : (np.name().equalsIgnoreCase("CEK") ? "CHECK" : "FAKTURA"));
                        ps.println(nacinPlacanja + new StringAlign(34 - nacinPlacanja.length(), 114).format(Integer.toString(brRacuna.get(np.name()))));
                    }
                    for (String cp : this.crnaPlacanja) {
                        if (!brRacuna.containsKey(cp)) continue;
                        String nacinPlacanja = cp;
                        ps.println(nacinPlacanja + new StringAlign(34 - nacinPlacanja.length(), 114).format(Integer.toString(brRacuna.get(cp))));
                    }
                }
                ps.println(new String(eql));
            }
            for (int i = 0; i < extraLinija; ++i) {
                ps.println();
            }
            this.fos.close();
            List<String> lines = Files.readAllLines(new File(this.print.getCanonicalPath(), "\\artikli.txt").toPath(), Charset.defaultCharset());
            for (String s : lines) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPrometPoArtiklima.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String writeInString(List<StavkaRacuna> stavkeKonacno, Restoran restoran, List<PodgrupaArtikala> podgrupe, List<GrupaArtikala> grupe, Map<PodgrupaArtikala, Double> mapaPG, Map<GrupaArtikala, Double> mapaP, Map<NacinPlacanja, Double> nacinP, Map<String, Double> nacinPCrno, Map<String, Integer> brRacuna, boolean blic, Date day1, Date day2, boolean crno, boolean kombPlacanje, Odeljenje odeljenje, double medjuzbir, int extraLinija) {
        HashMap mapG = new HashMap();
        HashMap mapPG = new HashMap();
        HashMap<GrupaArtikala, Double> mapGP = new HashMap<GrupaArtikala, Double>();
        HashMap<PodgrupaArtikala, Double> mapPGP = new HashMap<PodgrupaArtikala, Double>();
        for (StavkaRacuna sr : stavkeKonacno) {
            StavkaRacuna srn;
            Artikal art = sr.getArtikal();
            PodgrupaArtikala pg = art.getPodgrupa();
            GrupaArtikala ga = pg.getGrupa();
            String key = sr.getNaziv() + "~" + sr.getCena();
            if (mapG.containsKey(ga)) {
                if (!((List)mapG.get(ga)).contains(pg)) {
                    ((List)mapG.get(ga)).add(pg);
                }
            } else {
                LinkedList<PodgrupaArtikala> list = new LinkedList<PodgrupaArtikala>();
                list.add(pg);
                mapG.put(ga, list);
            }
            if (mapPG.containsKey(pg)) {
                if (((Map)mapPG.get(pg)).containsKey(key)) {
                    double kolicina = ((StavkaRacuna)((Map)mapPG.get(pg)).get(key)).getKolicina();
                    ((StavkaRacuna)((Map)mapPG.get(pg)).get(key)).setKolicina(kolicina += sr.getKolicina().doubleValue());
                } else {
                    srn = (StavkaRacuna)SerializationUtils.clone((Serializable)sr);
                    srn.setId(null);
                    ((Map)mapPG.get(pg)).put(key, srn);
                }
            } else {
                srn = (StavkaRacuna)SerializationUtils.clone((Serializable)sr);
                srn.setId(null);
                HashMap<String, StavkaRacuna> map = new HashMap<String, StavkaRacuna>();
                map.put(key, srn);
                mapPG.put(pg, map);
            }
            if (!mapGP.containsKey(ga)) {
                mapGP.put(ga, 0.0);
            }
            Double gp = (Double)mapGP.get(ga);
            gp = gp + sr.getVrednost();
            mapGP.put(ga, gp);
            if (!mapPGP.containsKey(pg)) {
                mapPGP.put(pg, 0.0);
            }
            Double pgp = (Double)mapPGP.get(pg);
            pgp = pgp + sr.getVrednost();
            mapPGP.put(pg, pgp);
        }
        System.out.println(mapG.keySet().size());
        System.out.println(mapPG.keySet().size());
        Comparator<GrupaArtikala> cga = new Comparator<GrupaArtikala>(){

            @Override
            public int compare(GrupaArtikala o1, GrupaArtikala o2) {
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        Comparator<PodgrupaArtikala> cpg = new Comparator<PodgrupaArtikala>(){

            @Override
            public int compare(PodgrupaArtikala o1, PodgrupaArtikala o2) {
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        Comparator<StavkaRacuna> csr = new Comparator<StavkaRacuna>(){

            @Override
            public int compare(StavkaRacuna o1, StavkaRacuna o2) {
                if (o1.getNaziv().compareTo(o2.getNaziv()) == 0) {
                    return o1.getCena().compareTo(o2.getCena());
                }
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        try {
            LinkedList listGA;
            int bkur = this.stampac.getTip().getBrojKarakteraURedu();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            ps.println(NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())));
            ps.println(NPrintUtils.spaceFill(bkur));
            ps.println(NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_PREGLED_PRODATIH_ARTIKALA"), new Object[0])));
            ps.println(NPrintUtils.spaceFill(bkur));
            ps.println(NPrintUtils.centerSplitToMiddle(bkur, String.format(Konstante.getBundle().getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateString(day1) + " ", String.format(Konstante.getBundle().getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateString(day2)));
            int pgIndent = 2;
            int srIndent = 4;
            char[] pgic = new char[pgIndent];
            char[] sric = new char[srIndent];
            char[] eql = new char[bkur];
            char[] minl = new char[bkur];
            Arrays.fill(pgic, ' ');
            Arrays.fill(sric, ' ');
            Arrays.fill(eql, '=');
            Arrays.fill(minl, '-');
            if (!blic) {
                listGA = new LinkedList(mapG.keySet());
                Collections.sort(listGA, cga);
                for (GrupaArtikala ga : listGA) {
                    ps.println(new String(eql));
                    ps.println(new StringAlign(bkur, 108).format(ga.getNaziv()));
                    ps.println(new String(minl));
                    NacinPlacanja[] listPG = (NacinPlacanja[])mapG.get(ga);
                    Collections.sort(listPG, cpg);
                    int i = 0;
                    Iterator iterator = listPG.iterator();
                    while (iterator.hasNext()) {
                        PodgrupaArtikala pg = (PodgrupaArtikala)iterator.next();
                        if (++i > 1) {
                            ps.println(new String(minl));
                        }
                        ps.println(new String(pgic) + new StringAlign(bkur - pgic.length, 108).format(pg.getNaziv()));
                        ps.println(new String(minl));
                        LinkedList listSR = new LinkedList(((Map)mapPG.get(pg)).values());
                        Collections.sort(listSR, csr);
                        for (StavkaRacuna sr : listSR) {
                            double kol = sr.getKolicina();
                            double cena = sr.getArtikal().getCena();
                            ps.println(new String(sric) + new StringAlign(bkur - sric.length, 108).format(sr.getArtikal().getName()));
                            ps.println(new String(sric) + new StringAlign(5, 108).format(StatLogic.getNumber03NGF(kol)) + new StringAlign(12 - (sric.length - sric.length % 2) / 2, 114).format(StatLogic.getNumber02NG(cena)) + new StringAlign(bkur - 17 - (sric.length - sric.length % 2) / 2 + sric.length % 2, 114).format(StatLogic.getNumber02NG(kol * cena)));
                        }
                    }
                }
                ps.println(new String(eql));
            }
            if (!blic) {
                ps.println(NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_PODGRUPE"), new Object[0])));
                ps.println(new String(minl));
            } else {
                ps.println();
            }
            ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_VREDNOST"), new Object[0])));
            ps.println(new String(minl));
            if (!blic) {
                LinkedList listPG = new LinkedList(mapPGP.keySet());
                Collections.sort(listPG, cpg);
                for (PodgrupaArtikala pg : listPG) {
                    ps.println(NPrintUtils.leftText(bkur - 12, pg.getNaziv()) + NPrintUtils.rightText(12, StatLogic.getNumber02NG((Double)mapPGP.get(pg))));
                }
                ps.println(new String(eql));
                ps.println(NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_GRUPE"), new Object[0])));
                ps.println(new String(minl));
                ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_VREDNOST"), new Object[0])));
                ps.println(new String(minl));
            }
            listGA = new LinkedList(mapGP.keySet());
            Collections.sort(listGA, cga);
            for (GrupaArtikala g : listGA) {
                ps.println(NPrintUtils.leftText(bkur - 12, g.getNaziv()) + NPrintUtils.rightText(12, StatLogic.getNumber02NG((Double)mapGP.get(g))));
            }
            ps.println(new String(eql));
            ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_INSTRUMENTI_PLACANJA_LINIJA1"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_NETO_IZNOS_LINIJA1"), new Object[0])));
            ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_INSTRUMENTI_PLACANJA_LINIJA2"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_NETO_IZNOS_LINIJA2"), new Object[0])));
            ps.println(new String(minl));
            double ukupno = 0.0;
            if (!kombPlacanje) {
                for (NacinPlacanja np : NacinPlacanja.values()) {
                    if (!nacinP.containsKey((Object)np)) continue;
                    ps.println(NPrintUtils.centerSplitToEnds(bkur, np.getOpis(), StatLogic.getNumber02NG(nacinP.get((Object)np))));
                    ukupno += nacinP.get((Object)np).doubleValue();
                }
                if (crno) {
                    for (String cp : this.crnaPlacanja) {
                        if (!nacinPCrno.containsKey(cp)) continue;
                        if (!cp.equalsIgnoreCase(String.format(Konstante.getBundle().getString("TEXT_MEDJUZBIR"), new Object[0]))) {
                            ukupno += nacinPCrno.get(cp).doubleValue();
                        }
                        ps.println(NPrintUtils.centerSplitToEnds(bkur, cp, StatLogic.getNumber02NG(nacinPCrno.get(cp))));
                    }
                }
                if (this.servis != null || this.popust != null) {
                    ps.println(new String(minl));
                }
                if (this.servis != null) {
                    ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_SERVIS"), new Object[0]), StatLogic.getNumber02NG(this.servis)));
                }
                if (this.popust != null) {
                    ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0]), StatLogic.getNumber02NG(this.popust)));
                }
                ps.println(new String(minl));
                ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]), StatLogic.getNumber02NG(ukupno)));
                ps.println(new String(eql));
                if (brRacuna != null) {
                    ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_INSTRUMENTI_PLACANJA_LINIJA1"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_BROJ_RACUNA_LINIJA1"), new Object[0])));
                    ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_INSTRUMENTI_PLACANJA_LINIJA2"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_BROJ_RACUNA_LINIJA2"), new Object[0])));
                    ps.println(NPrintUtils.minusFill(bkur));
                    boolean ukupnoRacuna = false;
                    for (NacinPlacanja np : NacinPlacanja.values()) {
                        if (!brRacuna.containsKey(np.getOpis())) continue;
                        String nacinPlacanja = np.getOpis();
                        ps.println(NPrintUtils.centerSplitToEnds(bkur, nacinPlacanja, Integer.toString(brRacuna.get(nacinPlacanja))));
                    }
                    for (String cp : this.crnaPlacanja) {
                        if (!brRacuna.containsKey(cp)) continue;
                        String nacinPlacanja = cp;
                        ps.println(NPrintUtils.centerSplitToEnds(bkur, nacinPlacanja, Integer.toString(brRacuna.get(nacinPlacanja))));
                    }
                }
                ps.println(new String(eql));
            }
            String content = new String(bos.toByteArray());
            bos.close();
            return content;
        }
        catch (Exception e) {
            Logger.getLogger(StampaPrometPoArtiklima.class.getName()).log(Level.SEVERE, null, e);
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPrometPoArtiklima.class.getName()).log(Level.SEVERE, null, ex);
            }
            return "";
        }
    }

    public void printFromFile(String putanja) {
        String stampacN = this.stampac.getNaziv();
        if (stampacN.equals(TipStampaca.FP550.toString()) || stampacN.equals(TipStampaca.HCPP2DS.toString()) || stampacN.equals(TipStampaca.HCPBEST.toString())) {
            return;
        }
        try {
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\artikli.txt");
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            byte[] by = this.stampac.getTip() == TipStampaca.STARTCP100 ? new byte[]{27, 100, 51} : new byte[]{27, 105};
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaPrometPoArtiklima.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }
}

