/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Proizvodnja;
import com.dev63.restoran.model.ProizvodnjaStavka;
import com.dev63.restoran.model.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StampaProizvodnje {
    private final Restoran restoran;
    SWTContainer parent;
    Panel panel;
    Proizvodnja proizvodnja;
    double total = 0.0;
    Shell shell;
    boolean sifre;
    DecimalFormat df = new DecimalFormat("#.##");

    public StampaProizvodnje(SWTContainer owner, Proizvodnja pr, Restoran r) {
        this.restoran = r;
        this.parent = owner;
        this.proizvodnja = pr;
        this.shell = this.parent.getControl().getShell();
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        Document doc = new Document(false);
        this.makeHeader(doc);
        List<ProizvodnjaStavka> stavke = this.restoran.getServer().readStavkeProizvodnje(this.proizvodnja);
        for (ProizvodnjaStavka ps : stavke) {
            this.total += ps.getKolicina() * ps.getArtikal().getTrenutnaNV();
        }
        if (stavke.size() > 0) {
            ProizvodnjaTableModel model = new ProizvodnjaTableModel(stavke);
            ArrayList<TableColumn> list = new ArrayList<TableColumn>();
            TableColumn tc = new TableColumn("artikal", "Naziv artikla");
            tc.setWidth(60);
            list.add(tc);
            tc = new TableColumn("jm", "Jed. mere");
            tc.setWidth(30);
            list.add(tc);
            tc = new TableColumn("kol", "Kolicina");
            tc.setWidth(30);
            list.add(tc);
            tc = new TableColumn("nv", "Nabavna Vrednost");
            tc.setWidth(35);
            list.add(tc);
            tc = new TableColumn("uk", "Ukupno");
            tc.setWidth(35);
            list.add(tc);
            Table table = new Table((TableModel)model, list);
            table.setHeaderBorder(true);
            doc.addElement((Element)table);
        }
        doc.addElement((Element)this.makePotpisFooter());
        this.restoran.getServer().refresh();
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(1150, 700);
        Composite composite = new Composite((Composite)this.shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError list) {
            // empty catch block
        }
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        this.panel = new Panel(new BorderLayout()){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        frame.add((Component)Print.printPreview((Document)doc));
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeader(Document doc) {
        Block b = new Block();
        Block c = new Block("Tahoma", 16, false, true);
        c.addElement((Element)new Text("PROIZVODNjA"));
        c.setTextAlign("center");
        Center center = new Center((Element)c);
        center.setContentHeight(6);
        center.setContentWidth(50);
        b.addElement((Element)center);
        Block c22 = new Block("Tahoma", 10, false, false);
        String s1 = "Odeljenje: " + this.proizvodnja.getOdeljenje().getNaziv();
        c22.addElement((Element)new Text(s1));
        c22.setTextAlign("center");
        Center center2 = new Center((Element)c22);
        center2.setContentHeight(6);
        center2.setContentWidth(50);
        b.addElement((Element)center2);
        Split s = new Split();
        c = new Block("Tahoma", 12, false, false);
        Setting naziv = this.restoran.getServer().getSetting(Option.OBJEKAT_NAZIV);
        String text = "Naziv ugostiteljskog objekta: ";
        if (naziv == null) {
            Konstante.getPoruka(this.shell, "Naziv objekta nije podesen!");
            text = text + "";
        } else {
            text = text + naziv.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        Setting maticniBroj = this.restoran.getServer().getSetting(Option.OBJEKAT_MATICNI_BROJ);
        text = "Maticni broj: ";
        if (maticniBroj == null) {
            Konstante.getPoruka(this.shell, "Maticni broj objekta nije podesen!");
            text = text + "";
        } else {
            text = text + maticniBroj.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b.addElement((Element)s);
        b.setBox(true);
        s = new Split();
        Block b2 = new Block();
        Block c2 = new Block("Tahoma", 12, false, false);
        c2 = new Block("Tahoma", 12, false, false);
        b2.addElement((Element)s);
        s = new Split();
        c = new Block("Tahoma", 12, false, false);
        text = "Datum proizvodnje: " + Konstante.getDate(this.proizvodnja.getDatum());
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        text = "Datum unosa: " + Konstante.getDate(this.proizvodnja.getDatumUnosa());
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b2.addElement((Element)s);
        b.setPaddingBottom(3);
        b.setPaddingTop(3);
        b2.setPaddingBottom(3);
        b2.setPaddingTop(6);
        Block d = new Block();
        d.addElement((Element)b);
        d.addElement((Element)b2);
        d.setPaddingBottom(3);
        d.setPaddingTop(3);
        doc.addElement((Element)d);
        doc.setDefaultFooter();
    }

    public Block makePotpisFooter() {
        Split s = new Split();
        Block b7 = new Block("Tahoma", 10, false, false);
        String text = this.total != -1.0 ? "NABAVNA VREDNOST: " + Konstante.getNumber2(this.total) : "";
        b7.addElement((Element)new Text(text));
        s.setRight((Element)b7);
        b7.setPaddingTop(3);
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("________________________");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block("________________________");
        b3.setTextAlign("center");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        b1.setPaddingTop(10);
        b2.setPaddingTop(10);
        b3.setPaddingTop(10);
        Block b4 = new Block("Odgovorna osoba");
        b4.setTextAlign("center");
        Block b5 = new Block("");
        Block b6 = new Block("Kontrolor");
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        return b;
    }

    private class ProizvodnjaTableModel
    extends AbstractTableModel {
        private List<ProizvodnjaStavka> list;

        public ProizvodnjaTableModel(List<ProizvodnjaStavka> list) {
            this.list = list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "artikal";
                }
                case 1: {
                    return "jm";
                }
                case 2: {
                    return "kol";
                }
                case 3: {
                    return "nv";
                }
                case 4: {
                    return "uk";
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String s;
            ProizvodnjaStavka ps = this.list.get(rowIndex);
            String n = ps.getArtikal().getName();
            String string = s = ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : "";
            if (n.contains("&")) {
                n = n.replace("&", " ");
            }
            switch (columnIndex) {
                case 0: {
                    return StampaProizvodnje.this.sifre ? s + " (" + n + ")" : n;
                }
                case 1: {
                    return ps.getArtikal().getJedinicaMere();
                }
                case 2: {
                    return ps.getKolicina();
                }
                case 3: {
                    return Konstante.getNumber2(ps.getArtikal().getTrenutnaNV());
                }
                case 4: {
                    return Konstante.getNumber2(ps.getKolicina() * ps.getArtikal().getTrenutnaNV());
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + columnIndex);
        }

        public void setList(List<ProizvodnjaStavka> list) {
            this.list = list;
        }

        public List<ProizvodnjaStavka> getList() {
            return this.list;
        }
    }
}

