/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class StampaPregledaTura {
    private Stampac stampac;
    private int brojKopija = 1;
    private List<Tura> ture;
    private StalniGost stalniGost;

    public StampaPregledaTura(List<Tura> ture, StalniGost sg, Stampac stampac, Konobar k, int brojKopija) {
        this.ture = ture;
        this.stalniGost = sg;
        this.stampac = stampac;
        this.brojKopija = brojKopija;
        this.writeInFile(ture, sg, k, brojKopija, stampac.getTip().getBrojDodatnihLinija(), stampac.getTip().getBrojKarakteraURedu());
    }

    public void writeInFile(List<Tura> ture, StalniGost sg, Konobar k, int brojKopija, int extraLinija, int brojKarakteraURedu) {
        Date datum = new Date();
        int brojStola = ture.get(0).getBrojStola();
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        char[] ula = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        Arrays.fill(ula, '_');
        String content = "";
        content = content + new String(ela) + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BROJ_STOLA") + ":" + brojStola);
        content = content + "\n";
        content = content + new String(ela) + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PREGLED_PORUDZBINA"));
        content = content + "\n";
        content = content + NPrintUtils.centerSplitToEnds(brojKarakteraURedu, StatLogic.getDateString(datum), StatLogic.getTimeString(datum));
        content = content + "\n";
        content = content + new String(ela);
        content = content + "\n";
        double vrednost = 0.0;
        for (Tura tura : ture) {
            for (StavkaRacuna sr : tura.getStavkeSumarno()) {
                Artikal art = sr.getArtikal();
                if (art.getName().length() > brojKarakteraURedu - 10 - 10 - Konstante.getNumber1(sr.getKolicina()).length() - 2) {
                    content = content + new StringAlign(brojKarakteraURedu, 108).format(art.getName()) + "\n";
                    content = content + new StringAlign(brojKarakteraURedu - 10 - 10, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x");
                    content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCenaBezPopusta()));
                    content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost()));
                    content = content + "\n";
                    if (sr.getPodStavke() != null && !sr.getPodStavke().isEmpty()) {
                        for (StavkaRacuna child : sr.getPodStavke()) {
                            if (child.getName().length() <= brojKarakteraURedu - 10 - 10 - Konstante.getNumber1(sr.getKolicina()).length() - 2) continue;
                            content = content + new StringAlign(brojKarakteraURedu, 108).format("--" + child.getName()) + "\n";
                            content = content + new StringAlign(brojKarakteraURedu - 10 - 10, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x");
                            content = content + new StringAlign(10, 114).format(Konstante.getNumber2(child.getCenaBezPopusta()));
                            content = content + new StringAlign(10, 114).format(Konstante.getNumber2(child.getVrednost()));
                            content = content + "\n";
                            vrednost += child.getVrednost().doubleValue();
                        }
                    }
                    vrednost += sr.getVrednost().doubleValue();
                    continue;
                }
                content = content + new StringAlign(brojKarakteraURedu - 10 - 10 - Konstante.getNumber1(sr.getKolicina()).length() - 2, 108).format(art.getName());
                content = content + new StringAlign(Konstante.getNumber1(sr.getKolicina()).length() + 2, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x");
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCenaBezPopusta()));
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost()));
                content = content + "\n";
                vrednost += sr.getVrednost().doubleValue();
            }
            content = content + new String(mla);
            content = content + "\n";
        }
        content = content + new StringAlign(10, 108).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO"));
        content = content + new StringAlign(brojKarakteraURedu - 10, 114).format(StatLogic.getNumber02(vrednost));
        content = content + "\n";
        content = content + new String(mla);
        content = content + "\n";
        if (sg != null && !sg.getNaziv().isEmpty()) {
            content = content + new StringAlign(8, 108).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_GOST"));
            boolean nl = sg.getNaziv().length() > brojKarakteraURedu - 8 - 1;
            content = content + (nl ? "\n" : "");
            content = content + new StringAlign(nl ? brojKarakteraURedu : brojKarakteraURedu - 8 - 1, 114).format(sg.getNaziv());
            content = content + "\n";
            content = content + new StringAlign(10, 108).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POPUST"));
            content = content + new StringAlign(brojKarakteraURedu - 10 - 1, 114).format(StatLogic.getNumber02(sg.getPopust() == null ? 0.0 : sg.getPopust()));
            content = content + new String(this.stampac.getTip().getEmulacija().getDblHghtBldOn());
            content = content + "\n";
            content = content + new StringAlign(15, 108).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_SA_POPUSTOM"));
            content = content + new StringAlign(brojKarakteraURedu - 15 - 1, 114).format(StatLogic.getNumber02(vrednost * (100.0 - (sg.getPopust() == null ? 0.0 : sg.getPopust())) / 100.0));
            content = content + new String(this.stampac.getTip().getEmulacija().getDblHghtBldOff());
            content = content + "\n";
            content = content + "\n";
            content = content + "\n";
            content = content + new StringAlign(brojKarakteraURedu, 99).format(new String(ula).substring(4));
            content = content + "\n";
            content = content + "\n";
        }
        content = content + new String(mla);
        content = content + "\n";
        String kon = k != null ? (k.getSkrIme() != null ? k.getSkrIme() : k.getPunoime()) : "";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(kon.length() > 0 ? ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KONOBAR") + ": " + kon : "");
        content = content + "\n";
        content = content + new String(ela) + "\n";
        NPrintUtils.printContent(content, this.stampac, brojKopija);
    }
}

