/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.stampa.NPrintUtils;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class StampaPorudzbine2 {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    boolean odstampanazbirna = false;
    boolean stampaBrPor;
    boolean hght = false;
    private Map<Odeljenje, List<StavkaRacuna>> mapa;
    private List<StavkaRacuna> stavke;
    private String nazivStola;
    private Sto astal;
    private List<Stampac> stampaci;
    private Kasa kasa;

    public StampaPorudzbine2(List<StavkaRacuna> st, boolean stampaBrPor, String nazivStola, Sto astal, List<Stampac> stampaci, Kasa kasa) {
        this.mapa = StavkeSumarno.MakeMapForOrderPrintForKasa(st, kasa);
        try {
            this.hght = BMTerminalSettings.getSetting(OptionBO.VISOKI_FONT_PORUDZBINE).booleanValue();
        }
        catch (Exception e) {
            this.hght = false;
        }
        this.kasa = kasa;
        this.nazivStola = nazivStola;
        this.astal = astal;
        this.stampaci = stampaci;
        this.stampaBrPor = stampaBrPor;
        for (Odeljenje o : this.mapa.keySet()) {
            System.out.println("o = " + o);
            if (o.getStampac() == null || o.getStampac().getTip() == null) {
                return;
            }
            String content = this.writeContent(this.mapa.get(o), o, o.getStampac().getTip().getBrojDodatnihLinija(), o.getStampac().getTip().getBrojKarakteraURedu());
            System.out.println("content = " + content);
            if (content == null) {
                return;
            }
            NPrintUtils.printContent(content, o.getStampac(), o.getStampac().getBrojKopijaPorudzbine());
        }
    }

    private String writeContent(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija, int brojKarakteraURedu) {
        int bkur = brojKarakteraURedu;
        String t1 = "";
        String t2 = "";
        String t3 = "";
        t1 = t1 + NPrintUtils.spaceFill(bkur) + "\n";
        t1 = t1 + NPrintUtils.centerSplitToCenter(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())) + "\n";
        if (this.kasa != null) {
            if (this.kasa.getProdajnoMesto() != null) {
                t1 = t1 + NPrintUtils.centerText(brojKarakteraURedu, String.format(Konstante.getBundle().getString("TEXT_PRODAJNO_MESTO"), new Object[0]) + ": " + this.kasa.getProdajnoMesto().getNaziv()) + "\n";
            }
            t1 = t1 + NPrintUtils.centerText(brojKarakteraURedu, String.format(Konstante.getBundle().getString("TEXT_KASA"), new Object[0]) + ": " + this.kasa.getOznaka()) + "\n";
        }
        t1 = t1 + NPrintUtils.spaceFill(bkur) + "\n";
        if (this.stampaBrPor) {
            t1 = t1 + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_PORUDZBINA_BR"), new Object[0]) + " " + stavke.get(0).getTura().getBrojTure()) + "\n";
        }
        t1 = t1 + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + ": " + (this.nazivStola == null ? this.astal.getBroj().toString() : this.nazivStola)) + "\n";
        t1 = t1 + NPrintUtils.centerText(bkur, o != null ? o.getNaziv() : "") + "\n";
        t1 = t1 + NPrintUtils.spaceFill(bkur) + "\n";
        double vr = 0.0;
        for (StavkaRacuna sr : stavke) {
            if (o == null) {
                t2 = t2 + NPrintUtils.leftText(bkur, sr.getArtikal().getSkrNaziv()) + "\n";
                t2 = t2 + NPrintUtils.rightText(bkur - 16, StatLogic.getNumber03NGF(sr.getKolicina()) + "x  ") + NPrintUtils.rightText(7, StatLogic.getNumber02NG(sr.getArtikal().getCena())) + NPrintUtils.rightText(9, StatLogic.getNumber02NG(sr.getVrednost())) + "\n";
                vr += sr.getVrednost().doubleValue();
                continue;
            }
            if (o.getStampac().getStampaCene() != null) {
                if (o.getStampac().getStampaCene().booleanValue()) {
                    t2 = t2 + NPrintUtils.leftText(bkur, sr.getArtikal().getSkrNaziv()) + "\n";
                    t2 = t2 + NPrintUtils.rightText(bkur - 16, StatLogic.getNumber03NGF(sr.getKolicina()) + "x ") + NPrintUtils.rightText(7, StatLogic.getNumber02NG(sr.getArtikal().getCena())) + NPrintUtils.rightText(9, StatLogic.getNumber02NG(sr.getVrednost())) + "\n";
                    vr += sr.getVrednost().doubleValue();
                    continue;
                }
                t2 = t2 + NPrintUtils.rightText(8, StatLogic.getNumber03NGF(sr.getKolicina()) + "x ") + NPrintUtils.leftText(bkur - 8, sr.getArtikal().getSkrNaziv()) + "\n";
                continue;
            }
            t2 = t2 + NPrintUtils.rightText(8, StatLogic.getNumber03NG(sr.getKolicina()) + "x ") + NPrintUtils.leftText(bkur - 8, sr.getArtikal().getSkrNaziv()) + "\n";
        }
        if (o == null) {
            t2 = t2 + NPrintUtils.spaceFill(bkur) + "\n";
            t2 = t2 + NPrintUtils.leftText(bkur - 12, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + NPrintUtils.rightText(12, StatLogic.getNumber02(vr)) + "\n";
        } else if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
            t2 = t2 + NPrintUtils.leftText(bkur - 12, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + NPrintUtils.rightText(12, StatLogic.getNumber02(vr)) + "\n";
        }
        t3 = t3 + NPrintUtils.spaceFill(bkur) + "\n";
        Sto sto = this.astal;
        String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
        t3 = t3 + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ": " + kon);
        t3 = t3 + NPrintUtils.spaceFill(bkur) + "\n";
        if (o != null) {
            for (int i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                t3 = t3 + NPrintUtils.spaceFill(bkur) + "\n";
            }
        }
        Stampac stampac = o.getStampac();
        byte[] h = t1.getBytes(Charset.forName("UTF8"));
        byte[] b = t2.getBytes(Charset.forName("UTF8"));
        byte[] f = t3.getBytes(Charset.forName("UTF8"));
        byte[] dblH = this.hght ? stampac.getTip().getEmulacija().getDblHghtBldOn() : new byte[]{};
        byte[] offH = this.hght ? stampac.getTip().getEmulacija().getDblHghtBldOff() : new byte[]{};
        byte[] out = new byte[h.length + b.length + f.length + dblH.length + offH.length];
        int pointer = 0;
        System.arraycopy(h, 0, out, pointer, h.length);
        pointer += h.length;
        if (this.hght) {
            System.arraycopy(dblH, 0, out, pointer, dblH.length);
            pointer += dblH.length;
        }
        System.arraycopy(b, 0, out, pointer, b.length);
        pointer += b.length;
        if (this.hght) {
            System.arraycopy(offH, 0, out, pointer, offH.length);
            pointer += offH.length;
        }
        System.arraycopy(f, 0, out, pointer, f.length);
        String content = new String(out, Charset.forName("UTF8"));
        return content;
    }

    public void podeliStavkePoOdeljenjima() {
        this.mapa = new HashMap<Odeljenje, List<StavkaRacuna>>();
        for (StavkaRacuna sr : this.stavke) {
            Artikal artikal = sr.getArtikal();
        }
    }
}

