/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaPorudzbine1 {
    RestoranServer server;
    boolean odstampanazbirna = false;
    boolean stampaBrPor;
    boolean hght = false;
    private Map<Odeljenje, List<StavkaRacuna>> mapa;
    private List<StavkaRacuna> stavke;

    public StampaPorudzbine1(List<StavkaRacuna> st, Restoran restoran) {
        this.mapa = StavkeSumarno.MakeMap(st, restoran);
        this.server = restoran.getServer();
        try {
            this.hght = restoran.getServerBO().getSetting(OptionBO.VISOKI_FONT_PORUDZBINE).booleanValue();
        }
        catch (Exception e) {
            this.hght = false;
        }
        try {
            this.stampaBrPor = this.server.getSetting(Option.TURA_PRIKAZ_BROJA).booleanValue();
        }
        catch (Exception e) {
            this.stampaBrPor = false;
        }
        block12: for (Odeljenje o : this.mapa.keySet()) {
            if (o.getStampac() == null || o.getStampac().getTip() == null) {
                return;
            }
            switch (o.getStampac().getTip()) {
                case HCPP2DS: {
                    String print = this.writeInString(this.mapa.get(o), o, 0);
                    for (int no = 0; no < o.getStampac().getBrojKopijaPorudzbine(); ++no) {
                        this.printFromString(o.getStampac().getNaziv(), print);
                    }
                    continue block12;
                }
                case EPSONTMT: {
                    this.print(this.mapa.get(o), o, 4);
                    break;
                }
                case EPSONTMT80: {
                    this.print(this.mapa.get(o), o, 4);
                    break;
                }
                case EPP: {
                    this.print(this.mapa.get(o), o, 8);
                    break;
                }
                case STARTCP100: {
                    System.out.println("STAR");
                    this.print(this.mapa.get(o), o, 0);
                    break;
                }
                case POSBANK80MM: {
                    System.out.println("POSBANK");
                    this.print80(this.mapa.get(o), o, 4);
                    break;
                }
                default: {
                    System.out.println("DEFAULT");
                    this.print(this.mapa.get(o), o, 0);
                }
            }
        }
        System.out.println("NESTO");
        this.print(st, null, 4);
    }

    public String writeInString(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija) {
        int i;
        String print = "";
        print = print + StringUtils.center((String)(Konstante.getDate(new Date()) + ""), (int)16);
        print = print + StringUtils.center((String)("" + Konstante.getfullTime(new Date())), (int)16);
        print = print + StringUtils.center((String)"", (int)32);
        if (this.stampaBrPor) {
            print = print + StringUtils.center((String)("Poruzbina br. " + stavke.get(0).getTura().getBrojTure()), (int)32);
        }
        try {
            print = print + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(stavke.get(0).getBrojStola(), this.server)), (int)32);
        }
        catch (Exception exception) {
            // empty catch block
        }
        print = print + StringUtils.center((String)(o != null ? o.getNaziv() : ""), (int)32);
        print = print + StringUtils.center((String)"", (int)32);
        double vr = 0.0;
        for (StavkaRacuna sr : stavke) {
            int broj;
            String temp;
            if (o.getStampac().getStampaCene() != null) {
                if (!o.getStampac().getStampaCene().booleanValue()) continue;
                temp = sr.getArtikal().getSkrNaziv();
                broj = temp.length();
                for (int i2 = 32; i2 > broj; --i2) {
                    temp = temp + " ";
                }
                print = print + temp.substring(0, 32);
                String temp2 = sr.getKolicina() + "x  " + sr.getArtikal().getCena() + "\t" + sr.getVrednost();
                int broj2 = temp2.length();
                for (int i3 = 32; i3 > broj2; --i3) {
                    temp2 = temp2 + " ";
                }
                print = print + temp2.substring(0, 32);
                print = print + sr.getKolicina() + "x  " + sr.getArtikal().getCena() + "\t" + sr.getVrednost();
                vr += sr.getVrednost().doubleValue();
                continue;
            }
            temp = sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv();
            broj = temp.length();
            for (int i4 = 32; i4 > broj; --i4) {
                temp = temp + " ";
            }
            print = print + temp.substring(0, 32);
        }
        if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
            print = print + StringUtils.center((String)"", (int)32);
            print = print + "UKUPNO:\t" + Konstante.getNumber2(vr);
        }
        print = print + StringUtils.center((String)"", (int)32);
        Sto sto = this.server.getSto(stavke.get(0).getBrojStola());
        String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
        print = print + StringUtils.center((String)("Konobar: " + kon), (int)32);
        print = print + "\t\t\t";
        for (i = 0; i < extraLinija; ++i) {
            print = print + StringUtils.center((String)"", (int)32);
        }
        if (o != null) {
            for (i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                print = print + StringUtils.center((String)"", (int)32);
            }
        }
        return print;
    }

    public void printFromString(String stampac, String print) {
        try {
            XMLWriterHCP.writeNonFiscal(print);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void print(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija) {
        int brk;
        int i;
        String t1 = "";
        String t2 = "";
        String t3 = "";
        t1 = t1 + Konstante.getDate(new Date()) + "\t\t" + Konstante.getfullTime(new Date()) + "\n";
        t1 = t1 + "\n";
        if (this.stampaBrPor) {
            t1 = t1 + StringUtils.center((String)("Poruzbina br. " + stavke.get(0).getTura().getBrojTure()), (int)34) + "\n";
        }
        t1 = t1 + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(stavke.get(0).getBrojStola(), this.server)), (int)34) + "\n";
        t1 = t1 + StringUtils.center((String)(o != null ? o.getNaziv() : ""), (int)34) + "\n";
        t1 = t1 + "\n";
        double vr = 0.0;
        for (StavkaRacuna sr : stavke) {
            if (o == null) {
                t2 = t2 + sr.getArtikal().getSkrNaziv() + "\n";
                t2 = t2 + sr.getKolicina() + "x  " + sr.getArtikal().getCena() + "  -  " + sr.getVrednost() + "\n";
                vr += sr.getVrednost().doubleValue();
                continue;
            }
            if (o.getStampac().getStampaCene() != null) {
                if (o.getStampac().getStampaCene().booleanValue()) {
                    t2 = t2 + sr.getArtikal().getSkrNaziv() + "\n";
                    t2 = t2 + sr.getKolicina() + "x  " + Konstante.getNumber2(sr.getArtikal().getCena()) + (o.getStampac().getTip() == TipStampaca.STARTCP100 ? "  -  " : "\t") + Konstante.getNumber2(sr.getVrednost()) + "\n";
                    vr += sr.getVrednost().doubleValue();
                    continue;
                }
                t2 = t2 + sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv() + "\n";
                continue;
            }
            t2 = t2 + sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv() + "\n";
        }
        if (o == null) {
            t2 = t2 + "\n";
            t2 = t2 + "UKUPNO:\t" + Konstante.getNumber2(vr) + "\n";
        } else if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
            t2 = t2 + "\n";
            t2 = t2 + "UKUPNO:\t" + Konstante.getNumber2(vr) + "\n";
        }
        t3 = t3 + "\n";
        Sto sto = this.server.getSto(stavke.get(0).getBrojStola());
        String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
        t3 = t3 + StringUtils.center((String)("Konobar: " + kon), (int)34) + "\n";
        t3 = t3 + "\t\t\t\n";
        for (i = 0; i < extraLinija; ++i) {
            t3 = t3 + "\n";
        }
        if (o != null) {
            for (i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                t3 = t3 + "\n";
            }
        }
        int n = brk = o != null ? o.getStampac().getBrojKopijaPorudzbine() : 1;
        if (o != null && o.getStampac().getTip() == TipStampaca.FP550) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String s : t1.split("\n")) {
                tmp.add(s);
            }
            for (String s : t2.split("\n")) {
                tmp.add(s);
            }
            for (String s : t3.split("\n")) {
                tmp.add(s);
            }
            for (int x = 0; x < o.getStampac().getBrojKopijaPorudzbine(); ++x) {
                try {
                    XMLWriter.writeNonFiscal(tmp);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(StampaPorudzbine1.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        for (int no = 0; no < brk; ++no) {
            try {
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                if (pservices.length == 0) {
                    return;
                }
                DocPrintJob pj = null;
                Stampac stampac = null;
                for (PrintService printer : pservices) {
                    if (o == null) {
                        for (Stampac s : this.server.readStampac()) {
                            if (!printer.getName().toUpperCase().contains(s.getNaziv().toUpperCase()) || s.getBrojKopijaZbirne() <= 0) continue;
                            stampac = s;
                            pj = printer.createPrintJob();
                        }
                        continue;
                    }
                    if (!printer.getName().toUpperCase().contains(o.getStampac().getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                    stampac = o.getStampac();
                }
                byte[] h = t1.getBytes();
                byte[] b = t2.getBytes();
                byte[] f = t3.getBytes();
                byte[] dblH = new byte[]{27, 33, 16};
                byte[] offH = new byte[]{27, 57};
                byte[] out = stampac == null || stampac.getTip() != TipStampaca.STARTCP100 ? new byte[h.length + b.length + f.length + dblH.length + offH.length + 2] : new byte[h.length + b.length + f.length + dblH.length + offH.length + 3];
                int pointer = 0;
                System.arraycopy(h, 0, out, pointer, h.length);
                pointer += h.length;
                if (this.hght) {
                    System.arraycopy(dblH, 0, out, pointer, dblH.length);
                    pointer += dblH.length;
                }
                System.arraycopy(b, 0, out, pointer, b.length);
                pointer += b.length;
                if (this.hght) {
                    System.arraycopy(offH, 0, out, pointer, offH.length);
                    pointer += offH.length;
                }
                System.arraycopy(f, 0, out, pointer, f.length);
                if (stampac != null && stampac.getTip() == TipStampaca.STARTCP100) {
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                File fout = new File("C:/barmaster/proba.txt");
                if (fout.exists()) {
                    fout.delete();
                }
                FileWriter fw = new FileWriter(fout);
                fw.append(new String(out));
                fw.flush();
                fw.close();
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                if (pj != null) {
                    pj.print(doc, aset);
                } else {
                    System.out.println("Definisani printer nije pronadjen");
                }
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void print80(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija) {
        int brk;
        int i;
        String t1 = "";
        String t2 = "";
        String t3 = "";
        t1 = t1 + new StringAlign(22, 108).format(Konstante.getDate(new Date())) + new StringAlign(20, 114).format(Konstante.getfullTime(new Date())) + "\n";
        t1 = t1 + "\n";
        if (this.stampaBrPor) {
            t1 = t1 + StringUtils.center((String)("Poruzbina br. " + stavke.get(0).getTura().getBrojTure()), (int)42) + "\n";
        }
        t1 = t1 + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(stavke.get(0).getBrojStola(), this.server)), (int)42) + "\n";
        t1 = t1 + StringUtils.center((String)(o != null ? o.getNaziv() : ""), (int)42) + "\n";
        t1 = t1 + "\n";
        double vr = 0.0;
        for (StavkaRacuna sr : stavke) {
            if (o == null) {
                t2 = t2 + sr.getArtikal().getSkrNaziv() + "\n";
                t2 = t2 + sr.getKolicina() + "x  " + sr.getArtikal().getCena() + "  -  " + sr.getVrednost() + "\n";
                vr += sr.getVrednost().doubleValue();
                continue;
            }
            if (o.getStampac().getStampaCene() != null) {
                if (o.getStampac().getStampaCene().booleanValue()) {
                    t2 = t2 + sr.getArtikal().getSkrNaziv() + "\n";
                    t2 = t2 + sr.getKolicina() + "x  " + Konstante.getNumber2(sr.getArtikal().getCena()) + (o.getStampac().getTip() == TipStampaca.STARTCP100 ? "  -  " : "\t") + Konstante.getNumber2(sr.getVrednost()) + "\n";
                    vr += sr.getVrednost().doubleValue();
                    continue;
                }
                t2 = t2 + sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv() + "\n";
                continue;
            }
            t2 = t2 + sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv() + "\n";
        }
        if (o == null) {
            t2 = t2 + "\n";
            t2 = t2 + "UKUPNO:\t" + Konstante.getNumber2(vr) + "\n";
        } else if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
            t2 = t2 + "\n";
            t2 = t2 + "UKUPNO:\t" + Konstante.getNumber2(vr) + "\n";
        }
        t3 = t3 + "\n";
        Sto sto = this.server.getSto(stavke.get(0).getBrojStola());
        String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
        t3 = t3 + StringUtils.center((String)("Konobar: " + kon), (int)42) + "\n";
        t3 = t3 + "\t\t\t\n";
        for (i = 0; i < extraLinija; ++i) {
            t3 = t3 + "\n";
        }
        if (o != null) {
            for (i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                t3 = t3 + "\n";
            }
        }
        int n = brk = o != null ? o.getStampac().getBrojKopijaPorudzbine() : 1;
        if (o != null && o.getStampac().getTip() == TipStampaca.FP550) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String s : t1.split("\n")) {
                tmp.add(s);
            }
            for (String s : t2.split("\n")) {
                tmp.add(s);
            }
            for (String s : t3.split("\n")) {
                tmp.add(s);
            }
            for (int x = 0; x < o.getStampac().getBrojKopijaPorudzbine(); ++x) {
                try {
                    XMLWriter.writeNonFiscal(tmp);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(StampaPorudzbine1.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        for (int no = 0; no < brk; ++no) {
            try {
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                if (pservices.length == 0) {
                    return;
                }
                DocPrintJob pj = null;
                Stampac stampac = null;
                for (PrintService printer : pservices) {
                    if (o == null) {
                        for (Stampac s : this.server.readStampac()) {
                            if (!printer.getName().toUpperCase().contains(s.getNaziv().toUpperCase()) || s.getBrojKopijaZbirne() <= 0) continue;
                            stampac = s;
                            pj = printer.createPrintJob();
                        }
                        continue;
                    }
                    if (!printer.getName().toUpperCase().contains(o.getStampac().getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                    stampac = o.getStampac();
                }
                byte[] h = t1.getBytes();
                byte[] b = t2.getBytes();
                byte[] f = t3.getBytes();
                byte[] dblH = new byte[]{27, 33, 16};
                byte[] offH = new byte[]{27, 57};
                byte[] out = stampac == null || stampac.getTip() != TipStampaca.STARTCP100 ? new byte[h.length + b.length + f.length + dblH.length + offH.length + 2] : new byte[h.length + b.length + f.length + dblH.length + offH.length + 3];
                int pointer = 0;
                System.arraycopy(h, 0, out, pointer, h.length);
                pointer += h.length;
                if (this.hght) {
                    System.arraycopy(dblH, 0, out, pointer, dblH.length);
                    pointer += dblH.length;
                }
                System.arraycopy(b, 0, out, pointer, b.length);
                pointer += b.length;
                if (this.hght) {
                    System.arraycopy(offH, 0, out, pointer, offH.length);
                    pointer += offH.length;
                }
                System.arraycopy(f, 0, out, pointer, f.length);
                if (stampac != null && stampac.getTip() == TipStampaca.STARTCP100) {
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                if (pj != null) {
                    pj.print(doc, aset);
                } else {
                    System.out.println("Definisani printer nije pronadjen");
                }
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void podeliStavkePoOdeljenjima() {
        this.mapa = new HashMap<Odeljenje, List<StavkaRacuna>>();
        for (StavkaRacuna sr : this.stavke) {
            Artikal artikal = sr.getArtikal();
        }
    }
}

