/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.FiscalPrinter;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import org.apache.commons.lang.StringUtils;

public class StampaPorudzbine {
    File print;
    RestoranServer server;
    boolean odstampanazbirna = false;
    boolean stampaBrPor;
    FiscalPrinter fiscal;

    public StampaPorudzbine(List<StavkaRacuna> st, Restoran restoran) {
        Map mapa = StavkeSumarno.MakeMap(st, restoran);
        this.server = restoran.getServer();
        this.fiscal = restoran.getFiscal();
        try {
            this.stampaBrPor = this.server.getSetting(Option.TURA_PRIKAZ_BROJA).booleanValue();
        }
        catch (Exception e) {
            this.stampaBrPor = false;
        }
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        for (Odeljenje o : mapa.keySet()) {
            if (o.getStampac() == null) {
                return;
            }
            if (o.getStampac().getTip() == TipStampaca.HCPP2DS) {
                String print = this.writeInString((List)mapa.get(o), o, 0);
                for (int no = 0; no < o.getStampac().getBrojKopijaPorudzbine(); ++no) {
                    this.printFromString(o.getStampac().getNaziv(), print);
                }
                continue;
            }
            if (o.getStampac().getTip() == TipStampaca.EPSONTMT) {
                this.writeInFile((List)mapa.get(o), o, 4);
            } else if (o.getStampac().getTip() == TipStampaca.EPSONTMT80) {
                this.writeInFile((List)mapa.get(o), o, 4);
            } else if (o.getStampac().getTip() == TipStampaca.EPP) {
                this.writeInFile((List)mapa.get(o), o, 8);
            } else {
                this.writeInFile((List)mapa.get(o), o, 0);
            }
            for (int no = 0; no < o.getStampac().getBrojKopijaPorudzbine(); ++no) {
                this.printFromFile(o.getStampac().getNaziv());
            }
        }
    }

    public String writeInString(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija) {
        int i;
        String print = "";
        print = print + StringUtils.center((String)(Konstante.getDate(new Date()) + ""), (int)16);
        print = print + StringUtils.center((String)("" + Konstante.getfullTime(new Date())), (int)16);
        print = print + StringUtils.center((String)"", (int)32);
        if (this.stampaBrPor) {
            print = print + StringUtils.center((String)("Poruzbina br. " + stavke.get(0).getTura().getBrojTure()), (int)32);
        }
        try {
            print = print + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(stavke.get(0).getBrojStola(), this.server)), (int)32);
        }
        catch (Exception exception) {
            // empty catch block
        }
        print = print + StringUtils.center((String)(o != null ? o.getNaziv() : ""), (int)32);
        print = print + StringUtils.center((String)"", (int)32);
        double vr = 0.0;
        for (StavkaRacuna sr : stavke) {
            String temp = sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv();
            int broj = temp.length();
            for (int i2 = 32; i2 > broj; --i2) {
                temp = temp + " ";
            }
            print = print + temp.substring(0, 32);
            if (o.getStampac().getStampaCene() == null || !o.getStampac().getStampaCene().booleanValue()) continue;
            String temp2 = sr.getKolicina() + "x  " + sr.getArtikal().getCena() + (o.getStampac().getTip() == TipStampaca.STARTCP100 ? "\\t" : "\t") + sr.getVrednost();
            int broj2 = temp2.length();
            for (int i3 = 32; i3 > broj2; --i3) {
                temp2 = temp2 + " ";
            }
            print = print + temp2.substring(0, 32);
            print = print + sr.getKolicina() + "x  " + sr.getArtikal().getCena() + (o.getStampac().getTip() == TipStampaca.STARTCP100 ? "\\t" : "\t") + sr.getVrednost();
            vr += sr.getVrednost().doubleValue();
        }
        if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
            print = print + StringUtils.center((String)"", (int)32);
            print = print + "UKUPNO:\t" + Konstante.getNumber2(vr);
        }
        print = print + StringUtils.center((String)"", (int)32);
        Sto sto = this.server.getSto(stavke.get(0).getBrojStola());
        String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
        print = print + StringUtils.center((String)("Konobar: " + kon), (int)32);
        print = print + "\t\t\t";
        for (i = 0; i < extraLinija; ++i) {
            print = print + StringUtils.center((String)"", (int)32);
        }
        if (o != null) {
            for (i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                print = print + StringUtils.center((String)"", (int)32);
            }
        }
        return print;
    }

    public void printFromString(String stampac, String print) {
        try {
            XMLWriterHCP.writeNonFiscal(print);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeInFile(List<StavkaRacuna> stavke, Odeljenje o, int extraLinija) {
        FileOutputStream fos = null;
        try {
            int i;
            fos = new FileOutputStream(this.print.getCanonicalPath() + "\\proba.txt");
            PrintStream ps = new PrintStream(fos);
            ps.println(Konstante.getDate(new Date()) + "\t\t" + Konstante.getfullTime(new Date()));
            ps.println();
            if (this.stampaBrPor) {
                ps.println(StringUtils.center((String)("Poruzbina br. " + stavke.get(0).getTura().getBrojTure()), (int)34));
            }
            try {
                ps.println(StringUtils.center((String)("Sto : " + Konstante.getNazivStola(stavke.get(0).getBrojStola(), this.server)), (int)34));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ps.println(StringUtils.center((String)(o != null ? o.getNaziv() : ""), (int)34));
            ps.println();
            double vr = 0.0;
            for (StavkaRacuna sr : stavke) {
                ps.println(sr.getKolicina() + "x  " + sr.getArtikal().getSkrNaziv());
                if (o.getStampac().getStampaCene() == null || !o.getStampac().getStampaCene().booleanValue()) continue;
                ps.println(sr.getKolicina() + "x  " + sr.getArtikal().getCena() + "\t" + sr.getVrednost());
                vr += sr.getVrednost().doubleValue();
            }
            if (o.getStampac().getStampaCene() != null && o.getStampac().getStampaCene().booleanValue()) {
                ps.println();
                ps.println("UKUPNO:\t" + Konstante.getNumber2(vr));
            }
            ps.println();
            Sto sto = this.server.getSto(stavke.get(0).getBrojStola());
            String kon = sto.getKonobar().getSkrIme() != null ? sto.getKonobar().getSkrIme() : sto.getKonobar().getPunoime();
            ps.println(StringUtils.center((String)("Konobar: " + kon), (int)34));
            ps.println("\t\t\t");
            for (i = 0; i < extraLinija; ++i) {
                ps.println("");
            }
            if (o != null) {
                for (i = 0; i < o.getStampac().getBlankoLinija(); ++i) {
                    ps.println();
                }
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void printFromFile(String stampac) {
        FileInputStream fis = null;
        try {
            if (stampac.equals(TipStampaca.FP550.toString())) {
                String strLine;
                fis = new FileInputStream(this.print.getCanonicalPath() + "\\proba.txt");
                DataInputStream in = new DataInputStream(fis);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                ArrayList<String> text = new ArrayList<String>();
                while ((strLine = br.readLine()) != null) {
                    text.add(strLine);
                }
                XMLWriter.writeNonFiscal(text);
                return;
            }
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(stampac.toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            fis = new FileInputStream(this.print.getCanonicalPath() + "\\proba.txt");
            SimpleDoc doc = new SimpleDoc(fis, flavor, null);
            PrintJobWatcher pjDone = new PrintJobWatcher(pj);
            pj.print(doc, aset);
            pjDone.waitForDone();
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            byte[] by = new byte[]{27, 105};
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            PrintJobWatcher pjDone2 = new PrintJobWatcher(pj2);
            pj2.print(doc2, aset);
            pjDone2.waitForDone();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PrintJobWatcher {
        boolean done = false;

        PrintJobWatcher(DocPrintJob job) {
            job.addPrintJobListener(new PrintJobAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void printJobCanceled(PrintJobEvent pje) {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void printJobCompleted(PrintJobEvent pje) {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void printJobFailed(PrintJobEvent pje) {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void printJobNoMoreEvents(PrintJobEvent pje) {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notify();
                    }
                }
            });
        }

        public synchronized void waitForDone() {
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

