/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class StampaKopijeRacunaSaPorezom2 {
    String nazivStola = null;
    Stampac stampac;
    CrnoPlacanje cp;
    int brojKopija = 1;
    String codePage;

    public StampaKopijeRacunaSaPorezom2(Racun racun, CrnoPlacanje cp, String nazivStola) {
        this.cp = cp;
        this.nazivStola = nazivStola;
        this.brojKopija = cp.getBrKopija();
        if (cp.getStampac() == null) {
            return;
        }
        this.stampac = cp.getStampac();
        this.codePage = this.stampac.getKodnaStrana();
        if (this.stampac != null) {
            String content = this.writeContent(racun, 0, this.stampac.getTip().getBrojKarakteraURedu());
            NPrintUtils.printContent(content, this.stampac, this.brojKopija);
            return;
        }
        if (this.stampac.getTip() == TipStampaca.EPSONTMT) {
            this.writeInFile(racun, 8, 34);
        } else if (this.stampac.getTip() == TipStampaca.EPSONTMT80) {
            this.writeInFile(racun, 8, 34);
        } else if (this.stampac.getTip() == TipStampaca.POSBANK80MM) {
            this.writeInFile(racun, 4, 42);
        } else if (this.stampac.getTip() == TipStampaca.EPP) {
            this.writeInFile(racun, 8, 34);
        } else {
            this.writeInFile(racun, 0, 34);
        }
    }

    public void writeInFile(Racun racun, int extraLinija, int brojKarakteraURedu) {
        int i;
        double porez;
        Object pg;
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        String content = "";
        content = content + new String(ela) + "\n";
        if (this.cp != null && (this.cp.getHeader1() != null || this.cp.getHeader2() != null || this.cp.getHeader3() != null || this.cp.getHeader4() != null || this.cp.getHeader5() != null || this.cp.getHeader6() != null || this.cp.getHeader7() != null)) {
            if (this.cp.getHeader1() != null && this.cp.getHeader1().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader1()) + "\n";
            }
            if (this.cp.getHeader2() != null && this.cp.getHeader2().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader2()) + "\n";
            }
            if (this.cp.getHeader3() != null && this.cp.getHeader3().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader3()) + "\n";
            }
            if (this.cp.getHeader4() != null && this.cp.getHeader4().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader4()) + "\n";
            }
            if (this.cp.getHeader5() != null && this.cp.getHeader5().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader5()) + "\n";
            }
            if (this.cp.getHeader6() != null && this.cp.getHeader6().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader6()) + "\n";
            }
            if (this.cp.getHeader7() != null && this.cp.getHeader7().length() > 0) {
                content = content + "\n";
                content = content + new StringAlign(brojKarakteraURedu, 108).format(this.cp.getHeader7()) + "\n";
            }
            if (this.cp.getHeader8() != null && this.cp.getHeader8().length() > 0) {
                content = content + new String(mla) + "\n";
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader8()) + "\n";
            }
            content = content + new String(mla) + "\n";
        }
        double aZbir = 0.0;
        double eZbir = 0.0;
        double gZbir = 0.0;
        double djZbir = 0.0;
        double pTotal = 0.0;
        block10: for (StavkaRacuna sr : racun.getStavke()) {
            Artikal art = sr.getArtikal();
            if (art.getName().length() > brojKarakteraURedu - 10 - 10 - Konstante.getNumber1(sr.getKolicina()).length() - 5) {
                content = content + new StringAlign(brojKarakteraURedu, 108).format(art.getName()) + "\n";
                content = content + new StringAlign(brojKarakteraURedu - 10 - 10 - 3, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x");
                if (sr.getCena() != 0.0) {
                    content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena()));
                }
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost()));
                content = content + new StringAlign(3, 114).format(" " + (this.cp.getRekapitulacijaPoreza() != null && this.cp.getRekapitulacijaPoreza() != false ? StampaKopijeRacunaSaPorezom2.getPGMark(art.getPoreskaGrupa()) : "")) + "\n";
            } else {
                content = content + new StringAlign(brojKarakteraURedu - 10 - 10 - Konstante.getNumber1(sr.getKolicina()).length() - 5, 108).format(art.getName());
                content = content + new StringAlign(Konstante.getNumber1(sr.getKolicina()).length() + 2, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x");
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena()));
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost()));
                content = content + new StringAlign(3, 114).format(" " + (this.cp.getRekapitulacijaPoreza() != null && this.cp.getRekapitulacijaPoreza() != false ? StampaKopijeRacunaSaPorezom2.getPGMark(art.getPoreskaGrupa()) : "")) + "\n";
            }
            switch (art.getPoreskaGrupa()) {
                case GRUPA_A: {
                    aZbir += sr.getCena() * sr.getKolicina();
                    continue block10;
                }
                case GRUPA_G: {
                    gZbir += sr.getCena() * sr.getKolicina();
                    continue block10;
                }
                case GRUPA_E: {
                    eZbir += sr.getCena() * sr.getKolicina();
                    continue block10;
                }
                case GRUPA_DJ: {
                    djZbir += sr.getCena() * sr.getKolicina();
                    continue block10;
                }
            }
            aZbir += sr.getCena() * sr.getKolicina();
        }
        content = content + new String(mla) + "\n";
        LinkedList<String> lStopa = new LinkedList<String>();
        LinkedList<String> lPorez = new LinkedList<String>();
        LinkedList<String> lEvidencija = new LinkedList<String>();
        if (aZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_A;
            porez = Konstante.getPorezFromBruto(aZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(aZbir)));
            pTotal += porez;
        }
        if (gZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_G;
            porez = Konstante.getPorezFromBruto(gZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(gZbir)));
            pTotal += porez;
        }
        if (eZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_E;
            porez = Konstante.getPorezFromBruto(eZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(eZbir)));
            pTotal += porez;
        }
        if (djZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_DJ;
            porez = Konstante.getPorezFromBruto(djZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(djZbir)));
            pTotal += porez;
        }
        lPorez.add(new StringAlign(4, 108).format("PT: ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(pTotal)));
        lEvidencija.add(new StringAlign(4, 108).format("ET: ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(racun.total())));
        if (this.cp.getRekapitulacijaPoreza() != null && this.cp.getRekapitulacijaPoreza().booleanValue()) {
            for (String string : lStopa) {
                content = content + string + "\n";
            }
            for (String string : lPorez) {
                content = content + string + "\n";
            }
            for (String string : lEvidencija) {
                content = content + string + "\n";
            }
            content = content + new String(mla) + "\n";
        }
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("ZA UPLATU: ");
        content = this.cp.getPrikaziPopust() != false ? content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n" : content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n";
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("GOTOVINA: ");
        content = this.cp.getPrikaziPopust() != false ? content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n" : content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n";
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("UPLACENO: ");
        content = this.cp.getPrikaziPopust() != false ? content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n" : content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n";
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("POVRACAJ: ");
        content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(0.0)) + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 108).format(new SimpleDateFormat("dd.MM.yyyy-HH:mm").format(racun.getDatum())) + "\n";
        content = content + new String(ela) + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(5);
        nf.setMaximumIntegerDigits(5);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        nf.setGroupingUsed(false);
        content = content + new StringAlign(6, 108).format(nf.format(racun.getKonobar().getId()));
        content = content + new StringAlign(brojKarakteraURedu - 6 - 4, 108).format(kon);
        content = content + "# 01\n";
        content = content + new String(mla) + "\n";
        if (this.cp.getPrikaziPopust().booleanValue() && racun.getStalniGost() != null) {
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("GOST: ");
            content = content + racun.getStalniGost().getNaziv();
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Popust: ");
            content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.getStalniGost().getPopust())) + "\n";
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Sa Popustom: ");
            content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n";
        }
        if (this.cp != null && (this.cp.getFooter1() != null || this.cp.getFooter2() != null || this.cp.getFooter3() != null)) {
            if (this.cp.getFooter1() != null && this.cp.getFooter1().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getFooter1()) + "\n";
            }
            if (this.cp.getFooter2() != null && this.cp.getFooter2().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getFooter2()) + "\n";
            }
            if (this.cp.getFooter3() != null && this.cp.getFooter3().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getFooter3()) + "\n";
            }
            content = content + new String(mla) + "\n";
            if (this.cp.getPrikaziPopust().booleanValue() && racun.getStalniGost() != null) {
                content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("GOST: ");
                content = content + racun.getStalniGost().getNaziv();
                content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Popust: ");
                content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.getStalniGost().getPopust())) + "\n";
                content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Sa Popustom: ");
                content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n";
            }
        }
        for (i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        System.out.println(content);
        for (i = 0; i < this.brojKopija; ++i) {
            try {
                byte[] out;
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                Charset cs = null;
                try {
                    cs = Charset.forName(this.codePage);
                }
                catch (Exception e) {
                    System.out.println("Nije prepoznat Charset za ime " + cs);
                }
                byte[] bb = cs == null ? StatLogic.clearFromEasternLatinChars(content).getBytes() : (cs.equals(Charset.forName("Cp852")) || cs.equals(Charset.forName("Cp1250")) || cs.equals(Charset.forName("Cp1252")) || cs.equals(Charset.forName("UTF8")) ? content.getBytes(this.codePage) : StatLogic.clearFromEasternLatinChars(content).getBytes(this.codePage));
                if (this.stampac.getTip() == TipStampaca.STARTCP100) {
                    out = new byte[bb.length + 3];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out = new byte[bb.length + 2];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                pj.print(doc, aset);
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String writeContent(Racun racun, int extraLinija, int brojKarakteraURedu) {
        double porez;
        Object pg;
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        String content = "";
        content = content + new String(ela) + "\n";
        if (this.cp != null && (this.cp.getHeader1() != null || this.cp.getHeader2() != null || this.cp.getHeader3() != null || this.cp.getHeader4() != null || this.cp.getHeader5() != null || this.cp.getHeader6() != null || this.cp.getHeader7() != null)) {
            if (this.cp.getHeader1() != null && this.cp.getHeader1().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader1()) + "\n";
            }
            if (this.cp.getHeader2() != null && this.cp.getHeader2().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader2()) + "\n";
            }
            if (this.cp.getHeader3() != null && this.cp.getHeader3().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader3()) + "\n";
            }
            if (this.cp.getHeader4() != null && this.cp.getHeader4().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader4()) + "\n";
            }
            if (this.cp.getHeader5() != null && this.cp.getHeader5().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader5()) + "\n";
            }
            if (this.cp.getHeader6() != null && this.cp.getHeader6().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader6()) + "\n";
            }
            if (this.cp.getHeader7() != null && this.cp.getHeader7().length() > 0) {
                content = content + NPrintUtils.spaceFill(brojKarakteraURedu) + "\n";
                content = content + new StringAlign(brojKarakteraURedu, 108).format(this.cp.getHeader7()) + "\n";
            }
            if (this.cp.getHeader8() != null && this.cp.getHeader8().length() > 0) {
                content = content + new String(mla) + "\n";
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getHeader8()) + "\n";
            }
            content = content + new String(mla) + "\n";
        }
        double aZbir = 0.0;
        double eZbir = 0.0;
        double gZbir = 0.0;
        double djZbir = 0.0;
        double pTotal = 0.0;
        block6: for (StavkaRacuna sr : racun.getStavke()) {
            sr.setRacun(racun);
            if (sr.getArtikal().getTip() != null && sr.getCena() == 0.0 & sr.getArtikal().getTip().equals((Object)TipArtikla.DODA)) continue;
            Artikal art = sr.getArtikal();
            if (art.getName().length() > brojKarakteraURedu - 10 - 10 - Konstante.getNumber2(sr.getKolicina()).length() - 5) {
                content = content + new StringAlign(brojKarakteraURedu, 108).format(art.getName()) + "\n";
                content = content + new StringAlign(brojKarakteraURedu - 11 - 10 - 3, 114).format(Konstante.getNumber2(sr.getKolicina()) + "x");
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena()));
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednostSaPopustom())) + "\n";
            } else {
                content = content + new StringAlign(brojKarakteraURedu - 10 - 10 - Konstante.getNumber2(sr.getKolicina()).length() - 5, 108).format(art.getName());
                content = content + new StringAlign(Konstante.getNumber2(sr.getKolicina()).length() + 2, 114).format(Konstante.getNumber2(sr.getKolicina()) + "x");
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena()));
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednostSaPopustom())) + "\n";
            }
            switch (art.getPoreskaGrupa()) {
                case GRUPA_A: {
                    aZbir += sr.getCena() * sr.getKolicina();
                    continue block6;
                }
                case GRUPA_G: {
                    gZbir += sr.getCena() * sr.getKolicina();
                    continue block6;
                }
                case GRUPA_E: {
                    eZbir += sr.getCena() * sr.getKolicina();
                    continue block6;
                }
                case GRUPA_DJ: {
                    djZbir += sr.getCena() * sr.getKolicina();
                    continue block6;
                }
            }
            aZbir += sr.getCena() * sr.getKolicina();
        }
        content = content + new String(mla) + "\n";
        LinkedList<String> lStopa = new LinkedList<String>();
        LinkedList<String> lPorez = new LinkedList<String>();
        LinkedList<String> lEvidencija = new LinkedList<String>();
        if (aZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_A;
            porez = Konstante.getPorezFromBruto(aZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(aZbir)));
            pTotal += porez;
        }
        if (gZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_G;
            porez = Konstante.getPorezFromBruto(gZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(gZbir)));
            pTotal += porez;
        }
        if (eZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_E;
            porez = Konstante.getPorezFromBruto(eZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(eZbir)));
            pTotal += porez;
        }
        if (djZbir > 0.0) {
            pg = PoreskaGrupa.GRUPA_DJ;
            porez = Konstante.getPorezFromBruto(djZbir, (PoreskaGrupa)pg);
            lStopa.add(new StringAlign(4, 108).format("S" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 108).format(Konstante.getNumber2(Konstante.getPGStopaProcenat((PoreskaGrupa)pg)) + "%"));
            lPorez.add(new StringAlign(4, 108).format("P" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(porez)));
            lEvidencija.add(new StringAlign(4, 108).format("E" + StampaKopijeRacunaSaPorezom2.getPGMark((PoreskaGrupa)pg) + ": ") + new StringAlign(brojKarakteraURedu - 5, 114).format(Konstante.getNumber2(djZbir)));
            pTotal += porez;
        }
        lPorez.add(new StringAlign(4, 108).format("PT: ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(pTotal)));
        lEvidencija.add(new StringAlign(4, 108).format("ET: ") + new StringAlign(brojKarakteraURedu - 4, 114).format(Konstante.getNumber2(racun.total())));
        if (this.cp.getRekapitulacijaPoreza() != null && this.cp.getRekapitulacijaPoreza().booleanValue()) {
            for (String string : lStopa) {
                content = content + string + "\n";
            }
            for (String string : lPorez) {
                content = content + string + "\n";
            }
            for (String string : lEvidencija) {
                content = content + string + "\n";
            }
            content = content + new String(mla) + "\n";
        }
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("ZA UPLATU: ");
        content = this.cp.getPrikaziPopust() != false ? content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n" : content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("GOTOVINA: ");
        content = this.cp.getPrikaziPopust() != false ? content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n" : content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("UPLACENO: ");
        content = this.cp.getPrikaziPopust() != false ? content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n" : content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("POVRACAJ: ");
        content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(0.0)) + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 108).format(new SimpleDateFormat("dd.MM.yyyy-HH:mm").format(racun.getDatum())) + "\n";
        content = content + new String(ela) + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(5);
        nf.setMaximumIntegerDigits(5);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        nf.setGroupingUsed(false);
        content = content + new StringAlign(6, 108).format(nf.format(racun.getKonobar().getId()));
        content = content + new StringAlign(brojKarakteraURedu - 6 - 4, 108).format(kon);
        content = content + "# 01\n";
        content = content + new String(mla) + "\n";
        if (this.cp.getPrikaziPopust().booleanValue() && racun.getStalniGost() != null) {
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("GOST: ");
            content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(racun.getStalniGost().getNaziv()) + "\n";
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Popust: ");
            System.out.println(racun.getStalniGost().getPopust());
            content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.getStalniGost().getPopust())) + "\n";
            content = content + new String(this.stampac.getTip().getEmulacija().getDblHghtBldOn());
            content = content + "\n";
            content = content + new StringAlign(brojKarakteraURedu / 2, 108).format("Sa Popustom: ");
            content = content + new StringAlign(brojKarakteraURedu - brojKarakteraURedu / 2, 114).format(Konstante.getNumber2(racun.total())) + "\n";
            content = content + new String(this.stampac.getTip().getEmulacija().getDblHghtBldOff());
        }
        if (this.cp != null && (this.cp.getFooter1() != null || this.cp.getFooter2() != null || this.cp.getFooter3() != null)) {
            if (this.cp.getFooter1() != null && this.cp.getFooter1().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getFooter1()) + "\n";
            }
            if (this.cp.getFooter2() != null && this.cp.getFooter2().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getFooter2()) + "\n";
            }
            if (this.cp.getFooter3() != null && this.cp.getFooter3().length() > 0) {
                content = content + new StringAlign(brojKarakteraURedu, 99).format(this.cp.getFooter3()) + "\n";
            }
            content = content + new String(mla) + "\n";
        }
        for (int i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        return content;
    }

    public void resetStavki(Racun racun) {
        List<StavkaRacuna> stavke = racun.getStavke1();
        for (StavkaRacuna s : stavke) {
            s.setRacun(null);
        }
        racun.setStavke1(stavke);
    }

    public static void main(String[] args) {
        CrnoPlacanje cp = new CrnoPlacanje();
        cp.setBrKopija(1);
        cp.setHeader1("METRO CASH & CARRY D.O.O.");
        cp.setHeader2("AUTOPUT ZA NOVI SAD 120");
        cp.setHeader3("BEOGRAD-ZEMUN");
        cp.setHeader4("PJ.IBARSKI PUT 20");
        cp.setHeader5("IBARSKI PUT 20");
        cp.setHeader6("BEOGRAD \u010cUKARICA");
        cp.setHeader7("PIB: 102864104");
        cp.setFooter1("I ZAPAMTI TUPAVKO");
        cp.setFooter2("OVO NIJE FISKALNI RA\u010cUN");
        cp.setRekapitulacijaPoreza(Boolean.TRUE);
        cp.setNaziv("Proba");
        cp.setPrikazEkran(false);
        Stampac s = new Stampac();
        s.setTip(TipStampaca.POSBANK80MM);
        s.setNaziv("SANK1");
        cp.setStampac(s);
        Racun r = new Racun();
        r.setBrojStola(0);
        r.setCrnoPlacanje("Proba");
        r.setDatum(new Date());
        r.setFiskalniOdstampan(Boolean.FALSE);
        r.setPopust(0.0);
        r.setStorniran(false);
        r.setZatvoren(false);
        Konobar k = new Konobar();
        k.setPunoIme("\u0160alabajzer");
        k.setId(1L);
        k.setSkrIme(k.getPunoime());
        r.setKonobar(k);
        Tura t = new Tura();
        t.setBrojStola(0);
        t.setBrojTure(0);
        t.setRacun(r);
        String[] ss = new String[]{"\u0160", "\u0106", "\u010c", "\u0110", "\u017d", "\u0161", "\u0107", "\u010d", "\u0111", "\u017e"};
        LinkedList<StavkaRacuna> srl = new LinkedList<StavkaRacuna>();
        for (int i = 0; i < 10; ++i) {
            Artikal a = new Artikal();
            a.setName("artikal" + ss[i % ss.length] + " " + (i % 2 == 0 ? "na popustu " : "") + i);
            a.setId(Long.valueOf(i));
            a.setSkrNaziv(a.getName());
            a.setPoreskaGrupa(PoreskaGrupa.values()[i % 3 == 0 ? 0 : i % 3 + 2]);
            a.setJedinicaMere((new String[]{JedMere.KOM.name(), JedMere.KG.name(), JedMere.LIT.name(), JedMere.POR.name()})[i % 4]);
            a.setCena(150.0 * (double)(i % 5 + 1));
            a.setDozvoljenPopust(Boolean.TRUE);
            StavkaRacuna sr = new StavkaRacuna();
            sr.setArtikal(a);
            sr.setBrojStola(0);
            sr.setCena(a.getCena());
            sr.setKolicina(Double.valueOf(i % 3 + 1));
            sr.setNaziv(a.getName());
            sr.setRacun(r);
            sr.setTura(t);
            srl.add(sr);
        }
        t.setStavke(srl);
        r.setStavke1(srl);
        LinkedList<Tura> tl = new LinkedList<Tura>();
        tl.add(t);
        r.setTure(tl);
        LinkedList<String> list = new LinkedList<String>();
        list.add("METRO CASH & CARRY D.O.O.");
        list.add("AUTOPUT ZA NOVI SAD 120");
        list.add("BEOGRAD-ZEMUN");
        list.add("PJ.IBARSKI PUT 20");
        list.add("IBARSKI PUT 20");
        list.add("BEOGRAD \u010cUKARICA");
        new StampaKopijeRacunaSaPorezom2(r, cp, "Ludilo");
    }

    public static String getPGMark(PoreskaGrupa pg) {
        return new String(new char[]{Konstante.getPGOznaka(pg)});
    }
}

