/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaKopijeRacuna2 {
    String nazivStola = null;
    Stampac stampac;
    CrnoPlacanje cp;
    int brojKopija = 1;
    boolean priceChanger = false;

    public StampaKopijeRacuna2(Racun racun, CrnoPlacanje cp, String nazivStola) {
        this.cp = cp;
        this.nazivStola = nazivStola;
        this.brojKopija = cp.getBrKopija();
        this.priceChanger = BMTerminalSettings.getSetting(OptionBO.PRICE_CHANGER).booleanValue();
        if (cp.getStampac() == null) {
            return;
        }
        this.stampac = cp.getStampac();
        if (this.stampac != null) {
            String content = this.writeContent(racun, 5, this.stampac.getTip().getBrojKarakteraURedu());
            NPrintUtils.printContent(content, this.stampac, this.brojKopija);
            return;
        }
        if (this.stampac.getTip() == TipStampaca.EPSONTMT) {
            this.writeInFile(racun, 8);
        } else if (this.stampac.getTip() == TipStampaca.EPSONTMT80) {
            this.writeInFile(racun, 8);
        } else if (this.stampac.getTip() == TipStampaca.POSBANK58MM) {
            this.writeInFile(racun, 4);
        } else if (this.stampac.getTip() == TipStampaca.POSBANK80MM) {
            this.writeInFile80MM(racun, 4);
        } else if (this.stampac.getTip() == TipStampaca.EPP) {
            this.writeInFile(racun, 8);
        } else {
            this.writeInFile(racun, 4);
        }
    }

    public String writeContent(Racun racun, int extraLinija, int bkur) {
        String content = "";
        if (this.cp != null) {
            if (this.cp.getHeader1() != null && this.cp.getHeader1().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader1()) + "\n";
            }
            if (this.cp.getHeader2() != null && this.cp.getHeader2().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader2()) + "\n";
            }
            if (this.cp.getHeader3() != null && this.cp.getHeader3().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader3()) + "\n";
            }
            if (this.cp.getHeader4() != null && this.cp.getHeader4().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader4()) + "\n";
            }
            if (this.cp.getHeader5() != null && this.cp.getHeader5().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader5()) + "\n";
            }
            if (this.cp.getHeader6() != null && this.cp.getHeader6().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader6()) + "\n";
            }
            if (this.cp.getHeader7() != null && this.cp.getHeader7().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader7()) + "\n";
            }
            if (this.cp.getHeader8() != null && this.cp.getHeader8().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getHeader8()) + "\n";
            }
        }
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        try {
            if (racun.getFiskalniOdstampan().booleanValue() && racun.getCrnoPlacanje() != null) {
                content = content + NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_KOPIJA_RACUNA"), new Object[0])) + "\n";
                content = content + NPrintUtils.minusFill(bkur) + "\n";
            }
            content = content + NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(racun.getDatum()), StatLogic.getTimeString(racun.getDatum())) + "\n";
            if (racun.getBrojStola() != 0) {
                content = content + NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_STO"), new Object[0]) + ": " + (this.nazivStola == null ? racun.getBrojStola() : this.nazivStola)) + "\n";
            }
            if (racun.getOznakaSobe() != null) {
                content = content + NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_SOBA"), new Object[0]) + ": " + racun.getOznakaSobe()) + "\n";
            }
            content = content + NPrintUtils.minusFill(bkur) + "\n";
            content = content + NPrintUtils.leftText(bkur - 22, String.format(Konstante.getBundle().getString("TEXT_ARTIKAL"), new Object[0])) + NPrintUtils.leftText(7, String.format(Konstante.getBundle().getString("TEXT_KOLICINA_SKR"), new Object[0])) + NPrintUtils.leftText(6, String.format(Konstante.getBundle().getString("TEXT_CENA"), new Object[0])) + NPrintUtils.rightText(8, String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0])) + "\n";
            content = content + NPrintUtils.minusFill(bkur) + "\n";
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        double razlika = 0.0;
        double fullCena = 0.0;
        for (StavkaRacuna sr : racun.getStavke()) {
            if (sr.isMenipromet() && sr.getCena() == 0.0 && sr.getArtikal().getTip().equals((Object)TipArtikla.DODA)) continue;
            fullCena += sr.getCena().doubleValue();
            Artikal art = sr.getArtikal();
            double tmp = sr.getCena() - sr.getArtikal().getCena();
            if (tmp > 0.01 && !this.priceChanger) {
                content = content + new StringAlign(30, 108).format(art.getName()) + "\n";
                content = content + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getKolicina())) + new StringAlign(10, 114).format(Konstante.getNumber2(art.getCena())) + new StringAlign(10, 114).format(Konstante.getNumber2(art.getCena() * sr.getKolicina())) + "\n";
                razlika += tmp * sr.getKolicina();
                continue;
            }
            content = content + NPrintUtils.leftText(bkur, art.getName()) + "\n";
            content = content + NPrintUtils.rightText(bkur - 10 - 10, StatLogic.getNumber03NGF(sr.getKolicina())) + NPrintUtils.rightText(10, StatLogic.getNumber02(this.priceChanger ? sr.getCena() : sr.getCenaBezPopustaSaCenomArtikla())) + NPrintUtils.rightText(10, StatLogic.getNumber02(sr.getVrednost())) + "\n";
        }
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        double totalBezPopustaSaCenomArtikla = racun.totalBezPopustaSaCenomArtikla();
        double totalSaPopustom = racun.total();
        double popustI = (this.priceChanger ? fullCena : totalBezPopustaSaCenomArtikla) - totalSaPopustom;
        double popust = this.priceChanger ? (fullCena - totalSaPopustom) / fullCena * 100.0 : (totalBezPopustaSaCenomArtikla - totalSaPopustom) / totalBezPopustaSaCenomArtikla * 100.0;
        content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]) + " ", StatLogic.getNumber02(this.priceChanger ? racun.total() : racun.totalBezPopustaSaCenomArtikla())) + "\n";
        content = content + NPrintUtils.leftText(bkur - 10 - 10, popust < 0.0 ? String.format(Konstante.getBundle().getString("TEXT_SERVIS"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0])) + NPrintUtils.rightText(10, StatLogic.getNumber02NGF(Math.abs(popust)) + "%") + NPrintUtils.rightText(10, StatLogic.getNumber02(Math.abs(popustI))) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur, NPrintUtils.spaceFill(bkur), NPrintUtils.underFill(bkur)) + "\n";
        content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]), StatLogic.getNumber02(totalSaPopustom)) + "\n";
        if (racun.getCrnoPlacanje() == null) {
            content = content + NPrintUtils.minusFill(bkur) + "\n";
            for (Placanje p : racun.getPlacanja()) {
                content = content + NPrintUtils.centerSplitToEnds(bkur, p.getNacin().getOpis() + ": ", StatLogic.getNumber02(racun.total()));
            }
        }
        content = content + NPrintUtils.spaceFill(bkur) + "\n";
        String korL = String.format(Konstante.getBundle().getString("TEXT_KORISNIK"), new Object[0]);
        String string = korL = korL == null ? "" : korL + ": ";
        if (racun.getStalniGost() != null && !racun.getStalniGost().getNaziv().isEmpty()) {
            content = content + NPrintUtils.labelValueSplitToEnds(bkur, korL, racun.getStalniGost().getNaziv()) + "\n";
            content = content + NPrintUtils.spaceFill(bkur) + "\n";
            content = content + NPrintUtils.labelValueSplitToEnds(bkur, NPrintUtils.spaceFill(10), NPrintUtils.underFill(bkur - 10)) + "\n";
        } else if (!(this.cp == null || this.cp.getMedjuZbir() != null && this.cp.getMedjuZbir().booleanValue())) {
            content = content + NPrintUtils.labelValueSplitToEnds(bkur, korL, NPrintUtils.underFill(bkur - korL.length())) + "\n";
        }
        content = content + NPrintUtils.spaceFill(bkur) + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        content = content + NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_KONOBAR"), new Object[0]) + ": " + kon) + "\n";
        if (this.cp != null) {
            if (this.cp.getFooter1() != null && this.cp.getFooter1().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getFooter1()) + "\n";
            }
            if (this.cp.getFooter2() != null && this.cp.getFooter2().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getFooter2()) + "\n";
            }
            if (this.cp.getFooter3() != null && this.cp.getFooter3().length() > 0) {
                content = content + NPrintUtils.centerText(bkur, this.cp.getFooter3()) + "\n";
            }
        }
        System.out.println("content = " + content);
        return content;
    }

    public void writeInFile(Racun racun, int extraLinija) {
        int i;
        String content = "";
        if (this.cp != null) {
            if (this.cp.getHeader1() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader1(), (int)34) + "\n";
            }
            if (this.cp.getHeader2() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader2(), (int)34) + "\n";
            }
            if (this.cp.getHeader3() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader3(), (int)34) + "\n";
            }
        }
        content = content + "---------------------------------\n";
        if (racun.getFiskalniOdstampan().booleanValue() && racun.getCrnoPlacanje() != null) {
            content = content + StringUtils.center((String)"KOPIJA RACUNA", (int)34) + "\n";
            content = content + "---------------------------------\n";
        }
        content = content + new StringAlign(15, 108).format(Konstante.getDate(racun.getDatum())) + new StringAlign(15, 114).format(Konstante.getTime(racun.getDatum())) + "\n";
        if (racun.getBrojStola() != 0) {
            content = content + StringUtils.center((String)("Sto : " + (this.nazivStola == null ? racun.getBrojStola() : this.nazivStola)), (int)34) + "\n";
        }
        content = content + "---------------------------------\n";
        content = content + "artikal    kol.   cena    ukupno\n";
        content = content + "---------------------------------\n";
        double razlika = 0.0;
        LinkedList<StavkaRacuna> novaLista = new LinkedList<StavkaRacuna>();
        for (StavkaRacuna sr : racun.getStavke()) {
            novaLista.add(sr);
            for (StavkaRacuna srPod : sr.getPodStavke()) {
                novaLista.add(srPod);
            }
        }
        racun.setStavke1(novaLista);
        for (StavkaRacuna sr : racun.getStavke()) {
            Artikal art = sr.getArtikal();
            content = content + new StringAlign(30, 108).format(art.getName()) + "\n";
            content = content + new StringAlign(10, 114).format(Konstante.getNumber1(sr.getKolicina())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost())) + "\n";
        }
        content = content + "---------------------------------\n";
        content = content + "UKUPNO" + new StringAlign(25, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        double popust = racun.getPopust();
        double popustI = racun.totalBezPopusta() * popust / 100.0;
        content = content + "POPUST" + new StringAlign(10, 114).format(Konstante.getNumber02(popust) + "%") + new StringAlign(15, 114).format(Konstante.getNumber2(popustI)) + "\n";
        content = content + "               _________________\n";
        content = content + "TOTAL" + new StringAlign(26, 114).format(Konstante.getNumber2(racun.totalBezPopusta() - popustI)) + "\n";
        if (racun.getCrnoPlacanje() == null) {
            content = content + "---------------------------------\n";
            for (Placanje p : racun.getPlacanja()) {
                content = content + p.getNacin().name() + ":   " + Konstante.getNumber2(racun.total()) + "\n";
            }
        }
        content = content + "\n";
        if (racun.getStalniGost() != null && !racun.getStalniGost().getNaziv().isEmpty()) {
            content = content + "Korisnik:" + new StringAlign(22, 114).format(racun.getStalniGost().getNaziv()) + "\n";
        }
        content = content + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        content = content + StringUtils.center((String)("Konobar: " + kon), (int)34) + "\n";
        if (this.cp != null) {
            if (this.cp.getFooter1() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter1(), (int)34) + "\n";
            }
            if (this.cp.getFooter2() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter2(), (int)34) + "\n";
            }
            if (this.cp.getFooter3() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter3(), (int)34) + "\n";
            }
        }
        for (i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        System.out.println("content = " + content);
        for (i = 0; i < this.brojKopija; ++i) {
            try {
                byte[] out;
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                byte[] bb = content.getBytes();
                if (this.stampac.getTip() == TipStampaca.STARTCP100) {
                    out = new byte[bb.length + 3];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out = new byte[bb.length + 2];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                pj.print(doc, aset);
                ((InputStream)is).close();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeInFile80MM(Racun racun, int extraLinija) {
        int i;
        String content = "";
        if (this.cp != null) {
            if (this.cp.getHeader1() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader1(), (int)42) + "\n";
            }
            if (this.cp.getHeader2() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader2(), (int)42) + "\n";
            }
            if (this.cp.getHeader3() != null) {
                content = content + StringUtils.center((String)this.cp.getHeader3(), (int)42) + "\n";
            }
        }
        content = content + "------------------------------------------\n";
        if (racun.getFiskalniOdstampan().booleanValue() && racun.getCrnoPlacanje() != null) {
            content = content + StringUtils.center((String)"KOPIJA RACUNA", (int)42) + "\n";
            content = content + "------------------------------------------\n";
        }
        content = content + new StringAlign(22, 108).format(Konstante.getDate(racun.getDatum())) + new StringAlign(20, 114).format(Konstante.getTime(racun.getDatum())) + "\n";
        if (racun.getBrojStola() != 0) {
            content = content + StringUtils.center((String)("Sto : " + (this.nazivStola == null ? racun.getBrojStola() : this.nazivStola)), (int)42) + "\n";
        }
        content = content + "------------------------------------------\n";
        content = content + new StringAlign(12, 108).format("artikal") + new StringAlign(13, 114).format("kolicina") + new StringAlign(7, 114).format("cena") + new StringAlign(10, 114).format("ukupno") + "\n";
        content = content + "------------------------------------------\n";
        double razlika = 0.0;
        for (StavkaRacuna sr : racun.getStavke()) {
            Artikal art = sr.getArtikal();
            double tmp = sr.getCena() - sr.getArtikal().getCena();
            content = content + new StringAlign(42, 108).format(art.getName()) + "\n";
            content = content + new StringAlign(22, 114).format(Konstante.getNumber1(sr.getKolicina()) + "x") + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getCena())) + new StringAlign(10, 114).format(Konstante.getNumber2(sr.getVrednost())) + "\n";
        }
        content = content + "------------------------------------------\n";
        content = content + "UKUPNO" + new StringAlign(36, 114).format(Konstante.getNumber2(racun.totalBezPopusta())) + "\n";
        double popust = racun.getPopust();
        double popustI = racun.totalBezPopusta() * popust / 100.0;
        content = content + "POPUST" + new StringAlign(10, 114).format(Konstante.getNumber02(popust) + "%") + new StringAlign(26, 114).format(Konstante.getNumber2(popustI)) + "\n";
        content = content + new StringAlign(42, 114).format("_____________") + "\n";
        content = content + "TOTAL" + new StringAlign(37, 114).format(Konstante.getNumber2(racun.totalBezPopusta() - popustI)) + "\n";
        if (racun.getCrnoPlacanje() == null) {
            content = content + "------------------------------------------\n";
            for (Placanje p : racun.getPlacanja()) {
                content = content + p.getNacin().name() + ":   " + Konstante.getNumber2(racun.total()) + "\n";
            }
        }
        content = content + "\n";
        if (racun.getStalniGost() != null && !racun.getStalniGost().getNaziv().isEmpty()) {
            content = content + "Korisnik:" + new StringAlign(33, 114).format(racun.getStalniGost().getNaziv()) + "\n";
        }
        content = content + "\n";
        String kon = racun.getKonobar().getSkrIme() != null ? racun.getKonobar().getSkrIme() : racun.getKonobar().getPunoime();
        content = content + StringUtils.center((String)("Konobar: " + kon), (int)42) + "\n";
        if (this.cp != null) {
            if (this.cp.getFooter1() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter1(), (int)42) + "\n";
            }
            if (this.cp.getFooter2() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter2(), (int)42) + "\n";
            }
            if (this.cp.getFooter3() != null) {
                content = content + StringUtils.center((String)this.cp.getFooter3(), (int)42) + "\n";
            }
        }
        for (i = 0; i < extraLinija; ++i) {
            content = content + "\n";
        }
        for (i = 0; i < this.brojKopija; ++i) {
            try {
                byte[] out;
                Thread.sleep(500L);
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                byte[] bb = content.getBytes();
                if (this.stampac.getTip() == TipStampaca.STARTCP100) {
                    out = new byte[bb.length + 3];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                } else {
                    out = new byte[bb.length + 2];
                    System.arraycopy(bb, 0, out, 0, bb.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                pj.print(doc, aset);
                ((InputStream)is).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

