/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.BorderPrint;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class StampaKalkulacijeNPC
extends PagePrint {
    private final String fontName;
    private final FontData titleFont;
    private final FontData textFont;
    private final FontData cellHeaderFont;
    private final FontData cellFont;
    private final FontData footerFont;
    private Prijemnica prijemnica;

    public StampaKalkulacijeNPC(Prijemnica prijemnica, TipPrijemnice tip, String nazivObjekta, String maticniBroj, String adresa, String pib) {
        super((Print)new EmptyPrint());
        this.fontName = "Tahoma";
        this.footerFont = new FontData(this.fontName, 6, 2);
        this.cellFont = new FontData(this.fontName, 7, 0);
        this.cellHeaderFont = new FontData(this.fontName, 7, 1);
        this.textFont = new FontData(this.fontName, 12, 0);
        this.titleFont = new FontData(this.fontName, 16, 1);
        this.prijemnica = prijemnica;
        LinkedList<TwoTypeWrapper<String, String>> hData = new LinkedList<TwoTypeWrapper<String, String>>();
        TwoTypeWrapper<String, String> entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_NAZIV_UGOSTITELJSKOG_OBJEKTA"), new Object[0]), nazivObjekta);
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_MATICNI_BROJ"), new Object[0]), maticniBroj);
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_ADRESA"), new Object[0]), adresa);
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_PIB"), new Object[0]), pib);
        hData.add(entry);
        this.setHeader(this.makeHeader(tip, hData));
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 100), new GridColumn(16384, 1, 100)});
        body.setLook((GridLook)new DefaultGridLook(0, 5));
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_BROJ_PRIJEMNICE"), new Object[0]) + ": " + prijemnica.getBrPrijemnice(), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_DOBAVLJAC"), new Object[0]) + ": " + (prijemnica.getDobavljac() != null ? prijemnica.getDobavljac().getNaziv() : ""), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_DATUM_PRIJEMNICE"), new Object[0]) + ": " + StatLogic.getDateString(prijemnica.getDatumPrijemnice()), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_DATUM_UNOSA"), new Object[0]) + ": " + StatLogic.getDateString(prijemnica.getDatumUnosa()), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NAPOMENA"), new Object[0]) + ": " + prijemnica.getOpis(), this.textFont, 16384), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add(this.makeDataGrid(prijemnica), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add((Print)new NoBreakPrint(this.makeSignature()), -1);
        this.setBody((Print)body);
        super.setFooter(this.makeFooter());
    }

    private Print makeSignature() {
        GridPrint signature = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50)});
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_ODGOVORNA_OSOBA"), new Object[0]), this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_KONTROLOR"), new Object[0]), this.textFont));
        return signature;
    }

    private Print makeDataGrid(Prijemnica p) {
        LinkedList<PrijemnicaStavka> sirovine = new LinkedList<PrijemnicaStavka>();
        LinkedList<PrijemnicaStavka> prod = new LinkedList<PrijemnicaStavka>();
        Double ncbpD = 0.0;
        Double nvbpD = 0.0;
        Double punD = 0.0;
        Double totalProdajna = 0.0;
        Double pvbpD = 0.0;
        Double ppD = 0.0;
        Double pcD = 0.0;
        Double totalMarza = 0.0;
        Double totalPorez = 0.0;
        Double total = 0.0;
        for (PrijemnicaStavka ps : p.getStavke()) {
            double procenat = ps.getPdvStopa() == null ? Konstante.getPdvPoPG(ps.getArtikal().getPoreskaGrupa()) : ps.getPdvStopa() / 100.0;
            double kontra = ps.getPdvStopa() == null ? Konstante.getKontraPdvPoPG(ps.getArtikal().getPoreskaGrupa()) : 1.0 / (1.0 + ps.getPdvStopa() / 100.0) * ps.getPdvStopa() / 100.0;
            ncbpD = ncbpD + ps.getKomad();
            nvbpD = nvbpD + (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina());
            punD = punD + (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina()) * procenat;
            if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                sirovine.add(ps);
                totalProdajna = totalProdajna + (ps.getVrednostSPDV() != null ? ps.getVrednostSPDV() : ps.getKolicina() * ps.getKomad() * (1.0 + procenat));
                pvbpD = pvbpD + (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina());
                ppD = ppD + (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina()) * procenat;
            } else {
                prod.add(ps);
                pcD = pcD + ps.getArtikal().getCena() * (1.0 / ps.getArtikal().getMera());
                ppD = ppD + ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra;
                pvbpD = pvbpD + ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra);
                totalProdajna = totalProdajna + ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera());
                totalMarza = totalMarza + (ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra) - ps.getKomad() * ps.getKolicina());
                totalPorez = totalPorez + (ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra - ps.getKomad() * ps.getKolicina() * procenat);
            }
            total = total + (ps.getVrednostSPDV() != null ? ps.getVrednostSPDV() : ps.getKolicina() * ps.getKomad() * (1.0 + procenat));
        }
        GridPrint main = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 100)}, (GridLook)new DefaultGridLook(0, 15));
        GridColumn[] cols = new GridColumn[]{new GridColumn(131072, 1, 30), new GridColumn(16384, 1, 50), new GridColumn(0x1000000, 1, 15), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 25), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30)};
        GridPrint gridP = new GridPrint(cols);
        GridPrint gridS = new GridPrint(cols);
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        gridP.setLook((GridLook)gl);
        gridS.setLook((GridLook)gl);
        gridP.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNI"), new Object[0]), this.cellHeaderFont), -1);
        this.addHeader(gridP);
        gridS.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_SIROVINE"), new Object[0]), this.cellHeaderFont), -1);
        this.addHeader(gridS);
        this.addContent(gridP, prod);
        this.addContent(gridS, sirovine);
        GridPrint suma = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 50), new GridColumn(16384, 1, 50)});
        suma.add((Print)new EmptyPrint());
        suma.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_SA_POREZOM"), new Object[0]) + ": " + StatLogic.getNumber02NG(total), this.textFont));
        suma.add((Print)new EmptyPrint());
        suma.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_VREDNOST"), new Object[0]) + ": " + StatLogic.getNumber02NG(totalProdajna), this.textFont));
        suma.add((Print)new EmptyPrint());
        suma.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_MARZA"), new Object[0]) + ": " + StatLogic.getNumber02NG(totalMarza), this.textFont));
        suma.add((Print)new EmptyPrint());
        suma.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA_PDV"), new Object[0]) + ": " + StatLogic.getNumber02NG(totalPorez), this.textFont));
        main.add((Print)gridP);
        main.add((Print)gridS);
        main.add((Print)new NoBreakPrint((Print)suma));
        return main;
    }

    private void addHeader(GridPrint grid) {
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_SIFRA_ARTIKLA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NAZIV_ARTIKLA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PORESKA_STOPA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_KOLICINA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_BEZ_PDV"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_BEZ_PDV"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_POREZ_U_NABAVCI"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_MARZA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_UKUPAN_POREZ"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_CENA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_VREDNOST_BEZ_POREZA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNI_POREZ"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_VREDNOST"), new Object[0]), this.cellHeaderFont));
    }

    private void addContent(GridPrint grid, List<PrijemnicaStavka> p) {
        if (grid == null || p == null || p.isEmpty()) {
            return;
        }
        Double nvbpdv = 0.0;
        Double ncbpDS = 0.0;
        Double nvbpDS = 0.0;
        Double punDS = 0.0;
        Double totalS = 0.0;
        Double totalMarzaS = 0.0;
        Double totalPorezS = 0.0;
        Double pcDS = 0.0;
        Double pvbpDS = 0.0;
        Double totalProdajnaS = 0.0;
        Double ppDS = 0.0;
        for (PrijemnicaStavka ps : p) {
            double procenat = Konstante.getPdvPoPG(ps.getArtikal().getPoreskaGrupa());
            double kontra = Konstante.getKontraPdvPoPG(ps.getArtikal().getPoreskaGrupa());
            boolean sirov = ps.getArtikal().getTip() == TipArtikla.SIRO;
            grid.add((Print)new TextPrint("" + (ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : ""), this.cellFont));
            grid.add((Print)new TextPrint("" + ps.getArtikal().getName(), this.cellFont));
            grid.add((Print)new TextPrint("" + ps.getArtikal().getJedinicaMere(), this.cellFont));
            grid.add((Print)new TextPrint("" + (int)(procenat * 100.0) + " %", this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ps.getKolicina()), this.cellFont));
            ncbpDS = ncbpDS + ps.getKomad();
            grid.add((Print)new TextPrint("" + StatLogic.getNumber04NG(ps.getKomad()), this.cellFont));
            Double vred = ps.getKomad() * ps.getKolicina();
            nvbpDS = nvbpDS + vred;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(vred), this.cellFont));
            Double pun = vred * procenat;
            punDS = punDS + pun;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pun), this.cellFont));
            Double total = ps.getVrednostSPDV() != null ? ps.getVrednostSPDV() : ps.getKolicina() * ps.getKomad() * (1.0 + procenat);
            totalS = totalS + total;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(total), this.cellFont));
            Double marzaS = sirov ? 0.0 : ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra) - (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina());
            totalMarzaS = totalMarzaS + marzaS;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(marzaS), this.cellFont));
            Double porezS = sirov ? 0.0 : ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra - (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina()) * procenat;
            totalPorezS = totalPorezS + porezS;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(porezS), this.cellFont));
            Double pc = sirov ? 0.0 : ps.getArtikal().getCena() * (1.0 / ps.getArtikal().getMera());
            pcDS = pcDS + pc;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pc), this.cellFont));
            Double pvbp = sirov ? (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina()) : ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra);
            pvbpDS = pvbpDS + pvbp;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pvbp), this.cellFont));
            Double pp = sirov ? (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina()) * procenat : ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra;
            ppDS = ppDS + pp;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pp), this.cellFont));
            Double prodajnaS = sirov ? (ps.getVrednost() != null ? ps.getVrednost() : ps.getKomad() * ps.getKolicina()) * (1.0 + procenat) : ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera());
            totalProdajnaS = totalProdajnaS + prodajnaS;
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(prodajnaS), this.cellFont));
        }
        grid.add(131072, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]), this.cellHeaderFont), 6);
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(nvbpDS), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(punDS), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(totalS), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(totalMarzaS), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(totalPorezS), this.cellFont));
        grid.add((Print)new EmptyPrint());
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pvbpDS), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(ppDS), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(totalProdajnaS), this.cellFont));
    }

    public Prijemnica getPrijemnica() {
        return this.prijemnica;
    }

    public void setPrijemnica(Prijemnica trebovanje) {
        this.prijemnica = trebovanje;
    }

    private PageDecoration makeFooter() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint print = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 50), new GridColumn(131072, -1, 50)});
                print.add(16384, 1024, (Print)new TextPrint(StatLogic.getDateTimeString(new Date()), StampaKalkulacijeNPC.this.footerFont, 16384));
                PageNumberPrint pnp = new PageNumberPrint(pn, StampaKalkulacijeNPC.this.footerFont, 131072);
                pnp.setPageNumberFormat(new PageNumberFormat(){

                    public String format(PageNumber pn) {
                        return String.format(Konstante.getBundle().getString("TEXT_STRANA"), new Object[0]) + " " + (pn.getPageNumber() + 1) + String.format(Konstante.getBundle().getString("TEXT_STRANA_UKUPNO_SPLITER"), new Object[0]) + pn.getPageCount();
                    }
                });
                print.add(131072, 1024, (Print)pnp);
                return print;
            }
        };
    }

    private PageDecoration makeHeader(final TipPrijemnice tip, final List<TwoTypeWrapper<String, String>> podaci) {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint hgp = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 50), new GridColumn(16384, 1, 50)});
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                hgp.add(0x1000000, 0x1000000, (Print)new TextPrint(tip.getInterName(), StampaKalkulacijeNPC.this.titleFont, 0x1000000), -1);
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                if (podaci != null) {
                    for (TwoTypeWrapper ttw : podaci) {
                        Object p = ttw != null ? new TextPrint((String)ttw.getA() + ": " + (String)ttw.getB(), StampaKalkulacijeNPC.this.textFont) : new EmptyPrint();
                        hgp.add(16384, (Print)p);
                    }
                }
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                BorderPrint h = new BorderPrint((Print)hgp, (Border)new LineBorder());
                return h;
            }
        };
    }
}

