/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.comparators.PrijemnicaStavkaRedniBrojComparator;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.porezi.TaxCalculation;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class StampaKalkulacijeBA
extends PagePrint {
    private final String fontName;
    private final FontData titleFont;
    private final FontData textFont;
    private final FontData cellHeaderFont;
    private final FontData cellFont;
    private final FontData footerFont;
    private Prijemnica prijemnica;
    private String magacin;

    public StampaKalkulacijeBA(Prijemnica prijemnica, TipPrijemnice tip, String nazivObjekta, String maticniBroj, String adresa, String pib, String mesto, String nazivPreduzeca, String adresaPreduzeca, String mestoPreduzeca, String magacin, boolean materijal) {
        super((Print)new EmptyPrint());
        this.fontName = "Arial";
        this.footerFont = new FontData(this.fontName, 6, 2);
        this.cellFont = new FontData(this.fontName, 7, 0);
        this.cellHeaderFont = new FontData(this.fontName, 7, 1);
        this.textFont = new FontData(this.fontName, 9, 1);
        this.titleFont = new FontData(this.fontName, 16, 0);
        this.prijemnica = prijemnica;
        this.magacin = magacin;
        LinkedList<TwoTypeWrapper<String, String>> hData = new LinkedList<TwoTypeWrapper<String, String>>();
        TwoTypeWrapper<String, String> entry = new TwoTypeWrapper<String, String>("NAZIV I SJEDI\u0160TE ", nazivPreduzeca + (StringUtils.isNotEmpty((String)mestoPreduzeca) ? " - " + mestoPreduzeca : "") + (StringUtils.isNotEmpty((String)adresaPreduzeca) ? " - " + adresaPreduzeca : ""));
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("DOBAVLJA\u010c", this.prijemnica.getDobavljac().getNaziv());
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("NAZIV I SJEDI\u0160TE MALOPRODAJNOG OBJEKTA", nazivObjekta + (StringUtils.isNotEmpty((String)mesto) ? " - " + mesto : "") + (StringUtils.isNotEmpty((String)adresa) ? " - " + adresa : ""));
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("SJEDI\u0160TE DOBAVLJA\u010cA", this.prijemnica.getDobavljac().getMesto() != null ? this.prijemnica.getDobavljac().getMesto() : ("" + this.prijemnica.getDobavljac().getAdersa() != null ? " - " + this.prijemnica.getDobavljac().getAdersa() : ""));
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("DATUM SA\u010cINJAVANJA KALKULACIJE", StatLogic.getDateString(this.prijemnica.getDatumPrijemnice()));
        hData.add(entry);
        entry = new TwoTypeWrapper<String, Object>("NAZIV BROJ I DATUM DOKUMENTA PO KOME JE NABAVKA", null);
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("VRSTA DOKUMENTA", tip == TipPrijemnice.PRIJEMNICA ? "ULAZ" : "IZLAZ");
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("IZVR\u0160ENA", this.prijemnica.getOznakaDokumenta() + " - " + StatLogic.getDateString(this.prijemnica.getDatumPrijemnice()));
        hData.add(entry);
        this.setHeader(this.makeHeader(tip, hData, materijal));
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 100), new GridColumn(16384, 1, 100)});
        body.setLook((GridLook)new DefaultGridLook(0, 5));
        body.add(this.makeDataGrid(prijemnica), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add((Print)new NoBreakPrint(this.makeSignature()), -1);
        this.setBody((Print)body);
        super.setFooter(this.makeFooter());
    }

    private Print makeSignature() {
        GridPrint signature = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50)});
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add((Print)new EmptyPrint());
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_ODGOVORNA_OSOBA"), new Object[0]), this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("M.P.", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_KONTROLOR"), new Object[0]), this.textFont));
        return signature;
    }

    private Print makeDataGrid(Prijemnica p) {
        LinkedList<PrijemnicaStavka> stavke = new LinkedList<PrijemnicaStavka>(p.getStavke());
        Collections.sort(stavke, new PrijemnicaStavkaRedniBrojComparator());
        GridPrint main = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 100)}, (GridLook)new DefaultGridLook(0, 15));
        GridColumn[] cols = new GridColumn[]{new GridColumn(131072, 1, 10), new GridColumn(131072, 1, 30), new GridColumn(16384, 1, 78), new GridColumn(0x1000000, 1, 12), new GridColumn(131072, 1, 25), new GridColumn(131072, 1, 25), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 15), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 15), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30)};
        GridPrint gridP = new GridPrint(cols);
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        RGB hfBack = new RGB(96, 197, 255);
        gl.setHeaderBackground(hfBack);
        gl.setFooterBackground(hfBack);
        gl.setHeaderGap(-3);
        gl.setFooterGap(-3);
        gl.setCellPadding(-2, -2, -2, -2);
        gridP.setLook((GridLook)gl);
        this.addHeader(gridP);
        ContentSummary summary = this.addContent(gridP, stavke);
        GridPrint suma = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 70), new GridColumn(16384, 1, 30), new GridColumn(16384, 1, 70), new GridColumn(16384, 1, 30), new GridColumn(16384, 1, 70), new GridColumn(16384, 1, 30), new GridColumn(16384, 1, 70), new GridColumn(16384, 1, 30)});
        DefaultGridLook sumaLook = new DefaultGridLook();
        sumaLook.setCellSpacing(20, 0);
        suma.setLook((GridLook)sumaLook);
        suma.add(16384, 0x1000000, (Print)new TextPrint("FAKTURNI IZNOS: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getNVredBPDVSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("UKUPNO(3+4): ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getZTrosNVredBPDVSum() + summary.getNPdvSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("ZAVISNI TRO\u0160KOVI: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("RAZLIKA U CIJENI: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getRucSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("RABAT: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("ZAVISNI TRO\u0160KOVI: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("IZNOS AKCIZE: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("IZNOS BEZ PDV: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getPVredMeraBPDVSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("FAKT. IZNOS - RABAT: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getZTrosNVredBPDVSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("UL. PDV: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("IZNOS TAKSE: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("IZL. PDV: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getPdvSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("UL. PDV: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getNPdvSum()), this.textFont, 131072));
        suma.add(16384, 0x1000000, (Print)new TextPrint("UKUPNO(6+7): ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(0.0), this.textFont, 131072));
        suma.add((Print)new EmptyPrint());
        suma.add((Print)new EmptyPrint());
        suma.add(16384, 0x1000000, (Print)new TextPrint("PRODAJNA VRIJEDNOST: ", this.textFont, 16384));
        suma.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getPVredMeraSPDVSum()), this.textFont, 131072));
        GridColumn[] taxRecapHolderCols = new GridColumn[]{new GridColumn(0x1000000, 1, 60), new GridColumn(0x1000000, 1, 40)};
        GridPrint taxRecapHolder = new GridPrint(taxRecapHolderCols);
        GridColumn[] taxRecapCols = new GridColumn[]{new GridColumn(0x1000000, 1, 20), new GridColumn(0x1000000, 1, 10), new GridColumn(0x1000000, 1, 10), new GridColumn(0x1000000, 1, 10), new GridColumn(0x1000000, 1, 10)};
        GridPrint taxRecap = new GridPrint(taxRecapCols);
        taxRecap.setLook((GridLook)gl);
        taxRecap.addHeader(16384, 0x1000000, (Print)new TextPrint("REKAPITULACIJA POREZA", this.textFont, 16384));
        taxRecap.addHeader(131072, 0x1000000, (Print)new TextPrint("STOPA", this.textFont, 131072));
        taxRecap.addHeader(131072, 0x1000000, (Print)new TextPrint("OSNOVICA", this.textFont, 131072));
        taxRecap.addHeader(131072, 0x1000000, (Print)new TextPrint("PDV", this.textFont, 131072));
        taxRecap.addHeader(131072, 0x1000000, (Print)new TextPrint("UKUPNO", this.textFont, 131072));
        taxRecap.addFooter(16384, 0x1000000, (Print)new TextPrint("TOTAL", this.textFont, 16384));
        taxRecap.addFooter((Print)new EmptyPrint());
        taxRecap.addFooter(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getNVredBPDVSum()), this.textFont, 131072));
        taxRecap.addFooter(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getNPdvSum()), this.textFont, 131072));
        taxRecap.addFooter(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(summary.getNVredBPDVSum() + summary.getNPdvSum()), this.textFont, 131072));
        for (Map.Entry<Double, TwoTypeWrapper<Double, Double>> entry : summary.getTaxRecap().entrySet()) {
            Double taxRate = entry.getKey();
            TwoTypeWrapper<Double, Double> taxes = entry.getValue();
            taxRecap.add(16384, 0x1000000, (Print)new TextPrint("PDV " + StatLogic.getNumber01NG(taxRate * 100.0) + "%", this.textFont, 16384));
            taxRecap.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(taxRate * 100.0), this.textFont, 131072));
            taxRecap.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(taxes.getA()), this.textFont, 131072));
            taxRecap.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(taxes.getB()), this.textFont, 131072));
            taxRecap.add(131072, 0x1000000, (Print)new TextPrint(StatLogic.getNumber02NG(taxes.getA() + taxes.getB()), this.textFont, 131072));
        }
        taxRecapHolder.add((Print)taxRecap);
        taxRecapHolder.add((Print)new EmptyPrint());
        main.add((Print)gridP);
        main.add((Print)new NoBreakPrint((Print)suma));
        main.add((Print)new NoBreakPrint((Print)taxRecapHolder));
        return main;
    }

    private void addHeader(GridPrint grid) {
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Rbr", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("\u0160ifra", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Naziv robe, materijala", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("JM", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Koli\u010dina", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Fakturna cijena po JM bez PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Fakturna vrijednost bez PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Rab%", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Zavisni tro\u0161kovi bez PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Nabavna cijena po JM bez PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Nabavna vrijednost bez PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Ruc%", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Iznos razlike u cijeni", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Prodajna vrijednost robe bez PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Stopa PDV-a", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Iznos PDV", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Prodajna vrijednost sa PDV-om", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("Prodajna cijena sa PDV-om", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("1", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("2", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("3", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("4", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("5", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("6", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("7", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("8", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("9", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("10", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("11", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("12", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("13", this.cellHeaderFont, 0x1000000));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("14", this.cellHeaderFont, 0x1000000));
    }

    private ContentSummary addContent(GridPrint grid, List<PrijemnicaStavka> p) {
        if (grid == null || p == null || p.isEmpty()) {
            return null;
        }
        ContentSummary summary = new ContentSummary();
        for (PrijemnicaStavka ps : p) {
            Double pdvProcenat = ps.getPdvStopa() / 100.0;
            Double rabatProcenat = ps.getRabat();
            Double zTrosBPDV = 0.0;
            Boolean sirov = ps.getArtikal().getTip() == TipArtikla.SIRO;
            Boolean potrosni = ps.getArtikal().getTip() == TipArtikla.POTR;
            Double nCenBPDV = ps.getKomad();
            Double nVredBPDV = nCenBPDV * ps.getKolicina();
            Double rabatNVredBPDV = nVredBPDV * (1.0 - rabatProcenat);
            Double zTrosNVredBPDV = rabatNVredBPDV + zTrosBPDV;
            Double pCenMeraSPDV = sirov != false ? TaxCalculation.bruttoFromNetto(nCenBPDV, pdvProcenat) : ps.getArtikal().getCena() * (1.0 / (ps.getArtikal().getMera() != null ? ps.getArtikal().getMera() : 1.0));
            Double pVredMeraSPDV = pCenMeraSPDV * ps.getKolicina();
            Double pCenMeraBPDV = TaxCalculation.nettoFromBrutto(pCenMeraSPDV, pdvProcenat);
            Double pVredMeraBPDV = pCenMeraBPDV * ps.getKolicina();
            Double rucPercent = 0.0;
            Double ruc = 0.0;
            if (!sirov.booleanValue() && !potrosni.booleanValue()) {
                rucPercent = ((pVredMeraBPDV.equals(nVredBPDV) ? 1.0 : pVredMeraBPDV / nVredBPDV) - 1.0) * 100.0;
                ruc = pVredMeraBPDV - nVredBPDV;
            }
            Double pdv = TaxCalculation.taxFromNetto(pVredMeraBPDV, pdvProcenat);
            Double nPdv = TaxCalculation.taxFromNetto(zTrosNVredBPDV, pdvProcenat);
            summary.addNVredBPDVSum(nVredBPDV);
            summary.addZTrosSum(zTrosBPDV);
            summary.addZTrosNVredBPDVSum(zTrosNVredBPDV);
            summary.addPVredMeraBPDVSum(pVredMeraBPDV);
            summary.addPVredMeraSPDVSum(pVredMeraSPDV);
            summary.addRucSum(ruc);
            summary.addPdvSum(pdv);
            summary.addNPdvSum(nPdv);
            summary.addRabatNVredBPDVSum(rabatNVredBPDV);
            summary.addToTaxRecap(nVredBPDV, pdvProcenat);
            grid.add((Print)new TextPrint("" + (ps.getRedniBroj() != null ? ps.getRedniBroj() : ""), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + (ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : ""), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + ps.getArtikal().getName(), this.cellFont, 16384));
            grid.add((Print)new TextPrint("" + ps.getArtikal().getJedinicaMere(), this.cellFont, 0x1000000));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ps.getKolicina()), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber04NG(ps.getKomad()), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(nVredBPDV), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(rabatProcenat * 100.0), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(zTrosBPDV), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber04NG(ps.getKomad()), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(nVredBPDV), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(rucPercent), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(ruc), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pVredMeraBPDV), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pdvProcenat * 100.0), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pdv), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pVredMeraSPDV), this.cellFont, 131072));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(pCenMeraSPDV), this.cellFont, 131072));
        }
        grid.add(131072, 0x1000000, (Print)new TextPrint("UKUPNO", this.cellHeaderFont, 131072), 6);
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getNVredBPDVSum()), this.cellFont, 131072));
        grid.add((Print)new EmptyPrint());
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getZTrosSum()), this.cellFont, 131072));
        grid.add((Print)new EmptyPrint());
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getZTrosNVredBPDVSum()), this.cellFont, 131072));
        grid.add((Print)new EmptyPrint());
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getRucSum()), this.cellFont, 131072));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getPVredMeraBPDVSum()), this.cellFont, 131072));
        grid.add((Print)new EmptyPrint());
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getPdvSum()), this.cellFont, 131072));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(summary.getPVredMeraSPDVSum()), this.cellFont, 131072));
        grid.add((Print)new EmptyPrint());
        return summary;
    }

    public Prijemnica getPrijemnica() {
        return this.prijemnica;
    }

    public void setPrijemnica(Prijemnica trebovanje) {
        this.prijemnica = trebovanje;
    }

    private PageDecoration makeFooter() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint print = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 50), new GridColumn(131072, -1, 50)});
                print.add(16384, 1024, (Print)new TextPrint(StatLogic.getDateTimeString(new Date()), StampaKalkulacijeBA.this.footerFont, 16384));
                PageNumberPrint pnp = new PageNumberPrint(pn, StampaKalkulacijeBA.this.footerFont, 131072);
                pnp.setPageNumberFormat(new PageNumberFormat(){

                    public String format(PageNumber pn) {
                        return String.format(Konstante.getBundle().getString("TEXT_STRANA"), new Object[0]) + " " + (pn.getPageNumber() + 1) + String.format(Konstante.getBundle().getString("TEXT_STRANA_UKUPNO_SPLITER"), new Object[0]) + pn.getPageCount();
                    }
                });
                print.add(131072, 1024, (Print)pnp);
                return print;
            }
        };
    }

    private PageDecoration makeHeader(TipPrijemnice tip, final List<TwoTypeWrapper<String, String>> podaci, final boolean materijal) {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint hgp = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 65), new GridColumn(16384, 1, 35)});
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                hgp.add((Print)new EmptyPrint(5, 5));
                hgp.add(131072, 0x1000000, (Print)new TextPrint("Obrazac \"KL\"", StampaKalkulacijeBA.this.textFont, 0x1000000));
                String naziv = "Maloprodajna Kalkulacija";
                if (materijal) {
                    naziv = "Kalkulacija ulaznog materijala";
                }
                hgp.add(0x1000000, 0x1000000, (Print)new TextPrint(naziv + " (" + StampaKalkulacijeBA.this.magacin + ") - " + StampaKalkulacijeBA.this.prijemnica.getBrPrijemnice() + " - " + StatLogic.getDateString(StampaKalkulacijeBA.this.prijemnica.getDatumPrijemnice()), StampaKalkulacijeBA.this.titleFont, 0x1000000), -1);
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                hgp.add((Print)new LinePrint(256, 1.0), -1);
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                if (podaci != null) {
                    for (TwoTypeWrapper ttw : podaci) {
                        Object p = ttw != null ? new TextPrint((String)ttw.getA() + (ttw.getB() != null ? ": " + (String)ttw.getB() : ""), StampaKalkulacijeBA.this.textFont) : new EmptyPrint();
                        hgp.add(16384, (Print)p);
                    }
                }
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                return hgp;
            }
        };
    }

    private static class ContentSummary {
        private Double nVredBPDVSum = 0.0;
        private Double zTrosSum = 0.0;
        private Double zTrosNVredBPDVSum = 0.0;
        private Double pVredMeraBPDVSum = 0.0;
        private Double pdvSum = 0.0;
        private Double nPdvSum = 0.0;
        private Double rucSum = 0.0;
        private Double pVredMeraSPDVSum = 0.0;
        private Double rabatNVredBPDVSum = 0.0;
        private Map<Double, TwoTypeWrapper<Double, Double>> taxRecap = new LinkedHashMap<Double, TwoTypeWrapper<Double, Double>>();

        public Double getNVredBPDVSum() {
            return this.nVredBPDVSum;
        }

        public void addNVredBPDVSum(Double nVredBPDVSum) {
            ContentSummary contentSummary = this;
            contentSummary.nVredBPDVSum = contentSummary.nVredBPDVSum + nVredBPDVSum;
        }

        public Double getZTrosSum() {
            return this.zTrosSum;
        }

        public void addZTrosSum(Double zTrosSum) {
            ContentSummary contentSummary = this;
            contentSummary.zTrosSum = contentSummary.zTrosSum + zTrosSum;
        }

        public Double getZTrosNVredBPDVSum() {
            return this.zTrosNVredBPDVSum;
        }

        public void addZTrosNVredBPDVSum(Double zTrosNVredBPDVSum) {
            ContentSummary contentSummary = this;
            contentSummary.zTrosNVredBPDVSum = contentSummary.zTrosNVredBPDVSum + zTrosNVredBPDVSum;
        }

        public Double getPVredMeraBPDVSum() {
            return this.pVredMeraBPDVSum;
        }

        public void addPVredMeraBPDVSum(Double pVredMeraBPDVSum) {
            ContentSummary contentSummary = this;
            contentSummary.pVredMeraBPDVSum = contentSummary.pVredMeraBPDVSum + pVredMeraBPDVSum;
        }

        public Double getPdvSum() {
            return this.pdvSum;
        }

        public void addPdvSum(Double pdvSum) {
            ContentSummary contentSummary = this;
            contentSummary.pdvSum = contentSummary.pdvSum + pdvSum;
        }

        public Double getNPdvSum() {
            return this.nPdvSum;
        }

        public void addNPdvSum(Double nPdvSum) {
            ContentSummary contentSummary = this;
            contentSummary.nPdvSum = contentSummary.nPdvSum + nPdvSum;
        }

        public Double getRucSum() {
            return this.rucSum;
        }

        public void addRucSum(Double rucSum) {
            ContentSummary contentSummary = this;
            contentSummary.rucSum = contentSummary.rucSum + rucSum;
        }

        public Double getPVredMeraSPDVSum() {
            return this.pVredMeraSPDVSum;
        }

        public void addPVredMeraSPDVSum(Double pVredMeraSPDVSum) {
            ContentSummary contentSummary = this;
            contentSummary.pVredMeraSPDVSum = contentSummary.pVredMeraSPDVSum + pVredMeraSPDVSum;
        }

        public Double getRabatNVredBPDVSum() {
            return this.rabatNVredBPDVSum;
        }

        public void addRabatNVredBPDVSum(Double rabatNVredBPDVSum) {
            ContentSummary contentSummary = this;
            contentSummary.rabatNVredBPDVSum = contentSummary.rabatNVredBPDVSum + rabatNVredBPDVSum;
        }

        public Map<Double, TwoTypeWrapper<Double, Double>> getTaxRecap() {
            return this.taxRecap;
        }

        public void addToTaxRecap(Double netto, Double taxRate) {
            if (!this.taxRecap.containsKey(taxRate)) {
                this.taxRecap.put(taxRate, new TwoTypeWrapper<Double, Double>(0.0, 0.0));
            }
            TwoTypeWrapper<Double, Double> val = this.taxRecap.get(taxRate);
            val.setA(val.getA() + netto);
            val.setB(val.getB() + TaxCalculation.taxFromNetto(netto, taxRate));
            this.taxRecap.put(taxRate, val);
        }
    }
}

