/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StampaFakePovratnica {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private final Restoran restoran;
    SWTContainer parent;
    Panel panel;
    double total = 0.0;
    Shell shell;
    boolean sifre;
    DecimalFormat df = new DecimalFormat("#.##");
    Format format = new SimpleDateFormat("ddMM/yy");

    public StampaFakePovratnica(SWTContainer owner, List<StavkaRacuna> stavkeR, Restoran r, String naslov) {
        this.restoran = r;
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        Document doc = new Document(false);
        this.makeHeader(doc, naslov);
        for (StavkaRacuna sr : stavkeR) {
            this.total += sr.getVrednost().doubleValue();
        }
        if (stavkeR.size() > 0) {
            TrebovanjeTableModel model = new TrebovanjeTableModel(stavkeR);
            ArrayList<TableColumn> list = new ArrayList<TableColumn>();
            TableColumn tc = new TableColumn("artikal", String.format(this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
            tc.setWidth(50);
            list.add(tc);
            tc = new TableColumn("jm", String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
            tc.setWidth(15);
            list.add(tc);
            tc = new TableColumn("kol", String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
            tc.setWidth(20);
            list.add(tc);
            tc = new TableColumn("ncbp", String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_BEZ_PDV"), new Object[0]));
            tc.setWidth(25);
            list.add(tc);
            tc = new TableColumn("kom", String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA"), new Object[0]));
            tc.setWidth(25);
            list.add(tc);
            tc = new TableColumn("nvbp", String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST_BEZ_PDV"), new Object[0]));
            tc.setWidth(25);
            list.add(tc);
            tc = new TableColumn("vred", String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST"), new Object[0]));
            tc.setWidth(25);
            list.add(tc);
            Table table = new Table((TableModel)model, list);
            table.setHeaderBorder(true);
            doc.addElement((Element)table);
        }
        doc.addElement((Element)this.makePotpisFooter());
        this.restoran.getServer().refresh();
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(1150, 700);
        Composite composite = new Composite((Composite)this.shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError list) {
            // empty catch block
        }
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        this.panel = new Panel(new BorderLayout()){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        frame.add((Component)Print.printPreview((Document)doc));
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeader(Document doc, String naslov) {
        Block b = new Block();
        Block c = new Block("Tahoma", 16, false, true);
        c.addElement((Element)new Text(naslov));
        Center center = new Center((Element)c);
        center.setContentHeight(6);
        center.setContentWidth(50);
        b.addElement((Element)center);
        Block c22 = new Block("Tahoma", 10, false, false);
        String s1 = String.format(this.barmasterText.getString("TEXT_MALOPRODAJA"), new Object[0]) + "  -->  ";
        String s2 = String.format(this.barmasterText.getString("TEXT_GLAVNI_MAGACIN"), new Object[0]);
        c22.addElement((Element)new Text(s1 + s2));
        Center center2 = new Center((Element)c22);
        center2.setContentHeight(6);
        center2.setContentWidth(50);
        b.addElement((Element)center2);
        Split s = new Split();
        c = new Block("Tahoma", 12, false, false);
        Setting naziv = this.restoran.getServer().getSetting(Option.OBJEKAT_NAZIV);
        String text = String.format(this.barmasterText.getString("TEXT_NAZIV_OBJEKTA"), new Object[0]) + ": ";
        if (naziv == null) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_NAZIV_OBJEKTA_NIJE_PODESEN"), new Object[0]));
            text = text + "";
        } else {
            text = text + naziv.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        Setting maticniBroj = this.restoran.getServer().getSetting(Option.OBJEKAT_MATICNI_BROJ);
        text = String.format(this.barmasterText.getString("TEXT_MATICNI_BROJ"), new Object[0]) + ": ";
        if (maticniBroj == null) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("TEXT_MATICNI_BROJ_OBJEKTA_NIJE_PODESEN"), new Object[0]));
            text = text + "";
        } else {
            text = text + maticniBroj.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b.addElement((Element)s);
        b.setBox(true);
        s = new Split();
        Block b2 = new Block();
        Block c2 = new Block("Tahoma", 12, false, false);
        String text2 = String.format(this.barmasterText.getString("TEXT_BROJ_DOKUMENTA"), new Object[0]) + ": ";
        text2 = text2 + this.format.format(new Date());
        c2.addElement((Element)new Text(text2));
        s.setLeft((Element)c2);
        c2 = new Block("Tahoma", 12, false, false);
        text = String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ": ";
        c2.addElement((Element)new Text(text));
        s.setRight((Element)c2);
        b2.addElement((Element)s);
        s = new Split();
        c = new Block("Tahoma", 12, false, false);
        text = String.format(this.barmasterText.getString("TEXT_DATUM_DOKUMENTA"), new Object[0]) + ": " + Konstante.getDate(new Date());
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        text = String.format(this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]) + ": " + Konstante.getDate(new Date());
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b2.addElement((Element)s);
        s = new Split();
        c = new Block("Tahoma", 12, false, false);
        text = String.format(this.barmasterText.getString("TEXT_NAPOMENA"), new Object[0]) + ": ";
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        b2.addElement((Element)s);
        b.setPaddingBottom(3);
        b.setPaddingTop(3);
        b2.setPaddingBottom(3);
        b2.setPaddingTop(6);
        Block d = new Block();
        d.addElement((Element)b);
        d.addElement((Element)b2);
        d.setPaddingBottom(3);
        d.setPaddingTop(3);
        doc.addElement((Element)d);
        doc.setDefaultFooter();
    }

    public Block makePotpisFooter() {
        Split s = new Split();
        Block b7 = new Block("Tahoma", 10, false, false);
        String text = this.total != -1.0 ? String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST"), new Object[0]).toUpperCase() + ": " + Konstante.getNumber2(this.total) : "";
        b7.addElement((Element)new Text(text));
        s.setRight((Element)b7);
        b7.setPaddingTop(3);
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("________________________________");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block("________________________________");
        b3.setTextAlign("center");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        b1.setPaddingTop(32);
        b2.setPaddingTop(32);
        b3.setPaddingTop(32);
        Block b4 = new Block(String.format(this.barmasterText.getString("TEXT_ODGOVORNA_OSOBA"), new Object[0]));
        b4.setTextAlign("center");
        Block b5 = new Block("                      ");
        Block b6 = new Block(String.format(this.barmasterText.getString("TEXT_KONTROLOR"), new Object[0]));
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        return b;
    }

    private class TrebovanjeTableModel
    extends AbstractTableModel {
        private List<StavkaRacuna> list;

        public TrebovanjeTableModel(List<StavkaRacuna> list) {
            this.list = list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "artikal";
                }
                case 1: {
                    return "jm";
                }
                case 2: {
                    return "kol";
                }
                case 3: {
                    return "ncbp";
                }
                case 4: {
                    return "vred";
                }
                case 5: {
                    return "nvbp";
                }
                case 6: {
                    return "kom";
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String s;
            StavkaRacuna ps = this.list.get(rowIndex);
            String n = ps.getArtikal().getName();
            String string = s = ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : "";
            if (n.contains("&")) {
                n = n.replace("&", " ");
            }
            switch (columnIndex) {
                case 0: {
                    return StampaFakePovratnica.this.sifre ? s + " (" + n + ")" : n;
                }
                case 1: {
                    return ps.getArtikal().getJedinicaMere();
                }
                case 2: {
                    return Konstante.getNumber14(ps.getKolicina());
                }
                case 3: {
                    return Konstante.getNumber14(ps.getCena() * Konstante.getKontraPdvPoPG(ps.getArtikal().getPoreskaGrupa()));
                }
                case 4: {
                    return Konstante.getNumber14(ps.getCena());
                }
                case 5: {
                    return Konstante.getNumber14(ps.getVrednost() * Konstante.getKontraPdvPoPG(ps.getArtikal().getPoreskaGrupa()));
                }
                case 6: {
                    return Konstante.getNumber14(ps.getVrednost());
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + columnIndex);
        }

        public void setList(List<StavkaRacuna> list) {
            this.list = list;
        }

        public List<StavkaRacuna> getList() {
            return this.list;
        }
    }
}

