/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StoNaziv;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.util.Arrays;
import java.util.Date;
import java.util.ResourceBundle;

public class StampaBrojaPorudzbine {
    private Stampac stampac;
    private int brojKopija = 1;
    private Tura ture;
    private StoNaziv sn;

    public StampaBrojaPorudzbine(Tura ture, StoNaziv sn, Stampac stampac, Konobar k, int brojKopija) {
        this.ture = ture;
        this.stampac = stampac;
        this.brojKopija = brojKopija;
        this.sn = sn;
        this.writeInFile(ture, k, brojKopija, stampac.getTip().getBrojDodatnihLinija(), stampac.getTip().getBrojKarakteraURedu());
    }

    public void writeInFile(Tura ture, Konobar k, int brojKopija, int extraLinija, int brojKarakteraURedu) {
        Date datum = new Date();
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        char[] ula = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        Arrays.fill(ula, '_');
        String content = "";
        content = content + new String(ela);
        content = content + "\n";
        String brojStola = this.sn.getNaziv() != null ? this.sn.getNaziv() : (ture.getBrojStola() != null ? ture.getBrojStola().toString() : "");
        content = content + new StringAlign(brojKarakteraURedu, 99).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_PORUDZBINE") + ": " + StatLogic.getDateTimeString(ture.getDatum()));
        content = content + "\n";
        content = content + new String(mla);
        content = content + "\n";
        content = content + new String(mla);
        content = content + "\n";
        content = content + new String(this.stampac.getTip().getEmulacija().getDblHghtBldOn());
        content = content + new StringAlign(brojKarakteraURedu, 99).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_VAS_BROJ_PORUDZBINE_JE") + ":");
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(brojStola);
        content = content + "\n";
        content = content + new String(this.stampac.getTip().getEmulacija().getDblHghtBldOff());
        content = content + new String(mla);
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_HVALA_NA_STRPLJENJU") + "!");
        content = content + "\n";
        content = content + new String(mla);
        content = content + "\n";
        String kon = k != null ? (k.getSkrIme() != null ? k.getSkrIme() : k.getPunoime()) : "";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(kon.length() > 0 ? ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OPERATER") + ": " + kon : "");
        content = content + "\n";
        content = content + new String(ela) + "\n";
        NPrintUtils.printContent(content, this.stampac, brojKopija);
    }
}

