/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaBrisanjaRacuna {
    String naziv;
    RestoranServer server;

    public StampaBrisanjaRacuna(Racun racun, Restoran restoran) {
        Setting objekat = restoran.getServer().getSetting(Option.OBJEKAT_NAZIV);
        this.naziv = objekat == null ? "" : objekat.stringValue();
        this.server = restoran.getServer();
        this.write(racun);
    }

    public void write(Racun r) {
        String content = "";
        content = content + StringUtils.center((String)"BRISANJE RACUNA!", (int)34) + "\n";
        content = content + StringUtils.center((String)this.naziv, (int)34) + "\n";
        content = content + Konstante.getDate(new Date()) + "\t\t" + Konstante.getfullTime(new Date()) + "\n";
        content = content + StringUtils.center((String)("Sto : " + Konstante.getNazivStola(r.getBrojStola(), this.server)), (int)34) + "\n";
        content = content + "---------------------------------\n";
        for (StavkaRacuna sr : r.getStavke()) {
            content = content + sr.getKolicina() + "x  " + sr.getArtikal().getName() + "\n";
        }
        content = content + "---------------------------------\n";
        content = content + StringUtils.center((String)("Konobar: " + r.getKonobar().getPunoime()), (int)34) + "\n";
        content = content + StringUtils.center((String)"BRISANJE RACUNA!", (int)34) + "\n";
        for (int no = 0; no < 2; ++no) {
            try {
                byte[] out;
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
                DocPrintJob pj = null;
                Stampac stampac = this.server.readIzvestajiStampacObject();
                if (stampac == null) continue;
                for (PrintService printer : pservices) {
                    if (!printer.getName().toUpperCase().contains(stampac.getNaziv().toUpperCase())) continue;
                    pj = printer.createPrintJob();
                }
                byte[] bb = content.getBytes();
                switch (stampac.getTip()) {
                    case STARTCP100: {
                        out = new byte[bb.length + 3];
                        System.arraycopy(bb, 0, out, 0, bb.length);
                        out[out.length - 3] = 27;
                        out[out.length - 2] = 100;
                        out[out.length - 1] = 51;
                        break;
                    }
                    default: {
                        out = new byte[bb.length + 2];
                        System.arraycopy(bb, 0, out, 0, bb.length);
                        out[out.length - 2] = 27;
                        out[out.length - 1] = 105;
                    }
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out);
                SimpleDoc doc = new SimpleDoc(is, flavor, null);
                if (pj != null) {
                    pj.print(doc, aset);
                } else {
                    System.out.println("Definisani printer nije pronadjen");
                }
                ((InputStream)is).close();
                continue;
            }
            catch (IOException flavor) {
                continue;
            }
            catch (PrintException flavor) {
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }
}

