/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.exceptions.MenuVATGroupUndefinedException;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.TipFiskalnogPrintera;
import com.dev63.restoran.stampa.StampaKopijeRacuna2;
import com.dev63.restoran.stampa.StampaKopijeRacunaAustrija;
import com.dev63.restoran.stampa.StampaKopijeRacunaSaPorezom2;
import com.dev63.restoran.stampa.StampaKopijeRacunaSaPorezomQuorion;

public class KopijaRacuna {
    public KopijaRacuna(RestoranServer server, Racun rCopy) throws MenuVATGroupUndefinedException {
        CrnoPlacanje cp = server.getCrnoNaziv(rCopy.getCrnoPlacanje());
        String nazivStola = Konstante.getNazivStola(rCopy.getBrojStola(), server);
        if (rCopy.getMeniPromet() != null) {
            PoreskaGrupa pg;
            Setting meniPG = server.getSetting(Option.MENI_REDNI_BROJ_PG);
            try {
                int pgIdx = 0;
                pgIdx = meniPG.intValue();
                pg = PoreskaGrupa.values()[pgIdx - 1];
            }
            catch (Exception ex) {
                throw new MenuVATGroupUndefinedException();
            }
            rCopy = Konstante.createStavkaFromMeniPromet(rCopy.getMeniPromet(), rCopy, server.getSledeciPLUMenija(), pg);
        }
        System.out.println("rCopy " + rCopy.getStavke());
        System.out.println("Naziv stola " + nazivStola);
        new KopijaRacunaPrintRunner(cp, rCopy, nazivStola, false);
    }

    private class KopijaRacunaPrintRunner {
        private CrnoPlacanje cp;
        private Racun r;
        private String nazivStola;

        public KopijaRacunaPrintRunner(CrnoPlacanje cp, Racun r, String nazivStola, boolean run) {
            this.cp = cp;
            this.r = r;
            this.nazivStola = nazivStola;
            if (cp != null && cp.getRekapitulacijaPoreza() != null && cp.getRekapitulacijaPoreza().booleanValue()) {
                String tfp = BMTerminalSettings.getSetting(OptionBO.TIP_FISKALNOG_PRINTERA).stringValue();
                if (tfp.equals(TipFiskalnogPrintera.QUORION.getName())) {
                    new StampaKopijeRacunaSaPorezomQuorion(r, cp, nazivStola);
                } else if (tfp.equals(TipFiskalnogPrintera.AUSTRIA.getName())) {
                    new StampaKopijeRacunaAustrija(r, cp);
                } else {
                    new StampaKopijeRacunaSaPorezom2(r, cp, nazivStola);
                }
            } else {
                new StampaKopijeRacuna2(r, cp, nazivStola);
            }
        }
    }
}

