/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.utils.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.BorderPrint;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.page.SimplePageDecoration;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class InvoicePrintBuilder {
    public static RestoranServer server;
    static Setting meniPG;
    public static String fontName;
    public static int textSize;
    public static int titleTextSize;
    public static int headingSize;
    public static int printMargin;

    public static PagePrint createNewDocument() {
        return new PagePrint((Print)new EmptyPrint());
    }

    public static PagePrint createNewDocument(Print body) {
        return new PagePrint(body);
    }

    public static PagePrint createNewDocument(SimplePageDecoration header, Print body) {
        return new PagePrint((PageDecoration)header, body);
    }

    public static PagePrint createNewDocument(Print body, SimplePageDecoration footer) {
        return new PagePrint(body, (PageDecoration)footer);
    }

    public static PagePrint createNewDocument(SimplePageDecoration header, Print body, SimplePageDecoration footer) {
        return new PagePrint((PageDecoration)header, body, (PageDecoration)footer);
    }

    public static PagePrint createNewDocument(Print header, Print body, Print footer) {
        return new PagePrint((PageDecoration)new SimplePageDecoration(header), body, (PageDecoration)new SimplePageDecoration(footer));
    }

    public static SimplePageDecoration createPageHeader(Print header) {
        return new SimplePageDecoration(header);
    }

    public static SimplePageDecoration createPageFooter(Print footer) {
        return new SimplePageDecoration(footer);
    }

    public static Print createBody(Print[] bodyParts) {
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 600, 1)});
        for (Print print : bodyParts) {
            body.add(print);
        }
        return body;
    }

    public static void printToDefault(Print document, String printName) {
        PrinterData pd = PaperClips.getDefaultPrinterData();
        PrintJob pj = new PrintJob(printName, document);
        pj.setMargins(printMargin);
        for (int i = 0; i < Integer.valueOf(printName); ++i) {
            InvoicePrintBuilder.print(pj, pd);
        }
    }

    public static void printToDefault(Print document, String printName, int copies) {
        PrinterData pd = PaperClips.getDefaultPrinterData();
        Printer p = new Printer(pd);
        PrintJob pj = new PrintJob(printName, document);
        pj.setMargins(printMargin);
        for (int i = 0; i < copies; ++i) {
            InvoicePrintBuilder.print(pj, pd);
        }
    }

    public static Print makeTitle(InvoiceData data) {
        GridPrint header;
        String logoPath = data.getLogoPath();
        String title = data.getPreduzece();
        GridPrint mainPrint = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 600)});
        FontData fd = new FontData(fontName, titleTextSize, 1);
        File f = new File(logoPath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        mainPrint.add((Print)new EmptyPrint(20, 20));
        if (fis == null) {
            header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 1)});
            header.add(0x1000000, (Print)new EmptyPrint(26, 26));
            header.add((Print)new TextPrint(title, fd, 0x1000000));
            header.add(0x1000000, (Print)new EmptyPrint(26, 26));
        } else {
            ImageData id = new ImageData((InputStream)fis);
            id = id.scaledTo(Math.round(Float.valueOf(id.width).floatValue() / Float.valueOf(id.height).floatValue() * Float.valueOf(400.0f).floatValue()), 400);
            header = new ImagePrint(id);
            ((ImagePrint)header).setDPI(300, 300);
        }
        mainPrint.add(0x1000000, 0x1000000, (Print)header, -1);
        mainPrint.add((Print)new EmptyPrint(20, 20));
        return mainPrint;
    }

    public static Print makeOfferHeader(InvoiceData hd) {
        String brojRacuna;
        String fakturaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PROFAKTURA_BR") + ":";
        String datumIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_IZDAVANJA") + ":";
        String mestoIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_IZDAVANJA") + ":";
        try {
            brojRacuna = hd.getRacun().getZbirnaFaktura().equals("") ? hd.getRacun().getZbirnaFaktura() : hd.getBrRacuna() + "/" + new SimpleDateFormat("yyyy").format(hd.getDatumIzdavanja());
        }
        catch (NullPointerException e) {
            brojRacuna = hd.getBrRacuna() + "/" + new SimpleDateFormat("yyyy").format(hd.getDatumIzdavanja());
        }
        String datumI = StatLogic.getDateString(hd.getDatumIzdavanja());
        String mestoI = hd.getMestoIzdavanja();
        String podaciOKupcu = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PODACI_O_KUPCU") + "";
        String pibL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PIB") + ": ";
        String mbL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MB") + ": ";
        GridPrint header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 300), new GridColumn(0x1000000, -1, 300)});
        GridPrint rData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 40), new GridColumn(16384, -1, 100), new GridColumn(16384, -1, 10), new GridColumn(16384, -1, 120), new GridColumn(16384, -1, 20)});
        FontData fdf = new FontData(fontName, headingSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdbtb = new FontData(fontName, headingSize, 1);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRDLbls = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 100)});
        gpRDLbls.add(131072, (Print)new TextPrint(fakturaL, fdf, 16384));
        gpRDLbls.add((Print)new EmptyPrint(15, 15));
        gpRDLbls.add((Print)new TextPrint(datumIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoIL, fdt, 16384));
        rData.add((Print)gpRDLbls);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 120)});
        gpRData.add((Print)new TextPrint(brojRacuna, fdf, 16384));
        gpRData.add((Print)new EmptyPrint(15, 15));
        gpRData.add((Print)new TextPrint(datumI, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoI, fdt, 16384));
        rData.add((Print)gpRData);
        rData.add((Print)new EmptyPrint());
        header.add((Print)rData);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 20), new GridColumn(0x1000000, -1, 240), new GridColumn(0x1000000, -1, 40)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 240)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint("     " + podaciOKupcu, fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        LinePrint lp = new LinePrint(256);
        gpBuyerData.add((Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getNazivKupca(), fdbtb, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getAdresaKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(pibL + hd.getPibKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(mbL + hd.getMbKupca(), fdbt, 0x1000000));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        header.add((Print)gpBuyerRight);
        return header;
    }

    public static Print makeOfferHeaderOtpremnica(InvoiceData hd) {
        String fakturaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OTPREMNICA_BR") + ":";
        String datumIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_IZDAVANJA") + ":";
        String mestoIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_IZDAVANJA") + ":";
        String brojRacuna = hd.getBrRacuna() + "/" + new SimpleDateFormat("yyyy").format(hd.getDatumIzdavanja());
        String datumI = StatLogic.getDateString(hd.getDatumIzdavanja());
        String mestoI = hd.getMestoPrometa();
        String podaciOKupcu = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PODACI_O_KUPCU") + "";
        String pibL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PIB") + ": ";
        String mbL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MB") + ": ";
        GridPrint header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 300), new GridColumn(0x1000000, -1, 300)});
        GridPrint rData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 40), new GridColumn(16384, -1, 100), new GridColumn(16384, -1, 10), new GridColumn(16384, -1, 120), new GridColumn(16384, -1, 20)});
        FontData fdf = new FontData(fontName, headingSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdbtb = new FontData(fontName, headingSize, 1);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRDLbls = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 100)});
        gpRDLbls.add(131072, (Print)new TextPrint(fakturaL, fdf, 16384));
        gpRDLbls.add((Print)new EmptyPrint(15, 15));
        gpRDLbls.add((Print)new TextPrint(datumIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoIL, fdt, 16384));
        rData.add((Print)gpRDLbls);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 120)});
        gpRData.add((Print)new TextPrint(brojRacuna, fdf, 16384));
        gpRData.add((Print)new EmptyPrint(15, 15));
        gpRData.add((Print)new TextPrint(datumI, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoI, fdt, 16384));
        rData.add((Print)gpRData);
        rData.add((Print)new EmptyPrint());
        header.add((Print)rData);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 20), new GridColumn(0x1000000, -1, 240), new GridColumn(0x1000000, -1, 40)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 240)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint("     " + podaciOKupcu, fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        LinePrint lp = new LinePrint(256);
        gpBuyerData.add((Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getNazivKupca(), fdbtb, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getAdresaKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(pibL + hd.getPibKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(mbL + hd.getMbKupca(), fdbt, 0x1000000));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        header.add((Print)gpBuyerRight);
        return header;
    }

    public static Print makeCashHeader(InvoiceData hd) {
        String fakturaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_RACUN_BR") + ":";
        String datumPL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_PROMETA") + ":";
        String mestoPL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_PROMETA") + ":";
        String datumIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_IZDAVANJA") + ":";
        String mestoIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_IZDAVANJA") + ":";
        String brojRacuna = hd.getBrRacuna() + "/" + new SimpleDateFormat("yyyy").format(hd.getDatumPrometa());
        String datumP = StatLogic.getDateString(hd.getDatumPrometa());
        String mestoP = hd.getMestoIzdavanja();
        String datumI = StatLogic.getDateString(hd.getDatumIzdavanja());
        String mestoI = hd.getMestoPrometa();
        String podaciOKupcu = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PODACI_O_KUPCU");
        String pibL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PIB") + ": ";
        String mbL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MB") + ": ";
        GridPrint header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 300), new GridColumn(0x1000000, -1, 300)});
        GridPrint rData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 40), new GridColumn(16384, -1, 100), new GridColumn(16384, -1, 10), new GridColumn(16384, -1, 120), new GridColumn(16384, -1, 20)});
        FontData fdf = new FontData(fontName, headingSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdbtb = new FontData(fontName, headingSize, 1);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRDLbls = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 100)});
        gpRDLbls.add(131072, (Print)new TextPrint(fakturaL, fdf, 16384));
        gpRDLbls.add((Print)new EmptyPrint(15, 15));
        gpRDLbls.add((Print)new TextPrint(datumIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(datumPL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoPL, fdt, 16384));
        rData.add((Print)gpRDLbls);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 120)});
        gpRData.add((Print)new TextPrint(brojRacuna, fdf, 16384));
        gpRData.add((Print)new EmptyPrint(15, 15));
        gpRData.add((Print)new TextPrint(datumI, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoI, fdt, 16384));
        gpRData.add((Print)new TextPrint(datumP, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoP, fdt, 16384));
        rData.add((Print)gpRData);
        rData.add((Print)new EmptyPrint());
        header.add((Print)rData);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 20), new GridColumn(0x1000000, -1, 240), new GridColumn(0x1000000, -1, 40)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 240)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint("     " + podaciOKupcu, fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        LinePrint lp = new LinePrint(256);
        gpBuyerData.add((Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getNazivKupca(), fdbtb, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getAdresaKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(pibL + hd.getPibKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(mbL + hd.getMbKupca(), fdbt, 0x1000000));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        header.add((Print)gpBuyerRight);
        return header;
    }

    public static Print makeTransactionHeader(InvoiceData hd, String brZbirne) {
        String fakturaL = "";
        fakturaL = brZbirne.isEmpty() ? (hd.isVp() ? hd.getServer().getSetting(Option.NASLOV_VPFAKTURA).getActual() + ": " : (hd.isOtp() ? ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OTPREMNICA_BR") + ":" : ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_FAKTURA_OTPREMNICA_BR") + ":")) : ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZBIRNA_FAKTURA_BR") + ":";
        String datumPL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_PROMETA") + ":";
        String mestoPL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_PROMETA") + ":";
        String datumIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_IZDAVANJA") + ":";
        String mestoIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_IZDAVANJA") + ":";
        String datumVL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_VALUTE") + ":";
        String brojRacuna = brZbirne.isEmpty() ? hd.getBrRacuna() + "/" + new SimpleDateFormat("yyyy").format(hd.getDatumPrometa()) : brZbirne + "/" + new SimpleDateFormat("yyyy").format(hd.getDatumPrometa());
        String datumP = StatLogic.getDateString(hd.getDatumPrometa());
        String mestoP = hd.getMestoIzdavanja();
        String datumI = StatLogic.getDateString(hd.getDatumIzdavanja());
        String mestoI = hd.getMestoPrometa();
        String datumV = StatLogic.getDateString(hd.getDatumValute());
        String podaciOKupcu = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PODACI_O_KUPCU");
        String pibL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PIB") + ": ";
        String mbL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MB") + ": ";
        GridPrint header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 300), new GridColumn(0x1000000, -1, 300)});
        GridPrint rData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 40), new GridColumn(16384, -1, 100), new GridColumn(16384, -1, 10), new GridColumn(16384, -1, 120), new GridColumn(16384, -1, 20)});
        FontData fdf = new FontData(fontName, headingSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdbtb = new FontData(fontName, headingSize, 1);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRDLbls = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 100)});
        gpRDLbls.add(131072, (Print)new TextPrint(fakturaL, fdf, 16384));
        gpRDLbls.add((Print)new EmptyPrint(15, 15));
        gpRDLbls.add((Print)new TextPrint(datumIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(datumPL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoPL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(datumVL, fdt, 16384));
        rData.add((Print)gpRDLbls);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 120)});
        gpRData.add((Print)new TextPrint(brojRacuna, fdf, 16384));
        gpRData.add((Print)new EmptyPrint(15, 15));
        gpRData.add((Print)new TextPrint(datumI, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoI, fdt, 16384));
        gpRData.add((Print)new TextPrint(datumP, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoP, fdt, 16384));
        gpRData.add((Print)new TextPrint(datumV, fdt, 16384));
        rData.add((Print)gpRData);
        rData.add((Print)new EmptyPrint());
        header.add((Print)rData);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 20), new GridColumn(0x1000000, -1, 240), new GridColumn(0x1000000, -1, 40)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 240)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint("     " + podaciOKupcu, fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        LinePrint lp = new LinePrint(256);
        gpBuyerData.add((Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getNazivKupca(), fdbtb, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getAdresaKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(pibL + hd.getPibKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(mbL + hd.getMbKupca(), fdbt, 0x1000000));
        gpBuyerData.add((Print)new EmptyPrint(10, 10));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        gpBuyerRight.add((Print)new EmptyPrint(10, 10));
        header.add((Print)gpBuyerRight);
        return header;
    }

    public static Print makeItems(InvoiceData id, RestoranServer server, List<StavkaRacuna> stavke, List<MeniPromet> meniji) {
        List<StavkaRacuna> temp = id.getRacun().getStavke();
        List<StavkaRacuna> items = stavke != null ? stavke : StavkeSumarno.getSumarnoF(id.getRacun().getStavke(), true);
        String rb = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_REDNI_BROJ_SKR");
        String naziv = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NAZIV");
        String jm = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_JEDINICA_MERE_SKR");
        String kolicina = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KOLICINA");
        String cena = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CENA");
        String popustPC = null;
        String cenaSaPop = null;
        if (server.getSetting(Option.FAKTURA_POPUST).booleanValue()) {
            popustPC = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POPUST");
            cenaSaPop = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CENA_SA_POPUSTOM");
        }
        String pdvPC = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PDV");
        String pdvIznos = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_PDV");
        String cenaBPDV = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_BEZ_PDV");
        String iznos = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS");
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(3, 1);
        GridPrint gpItems = null;
        gpItems = server.getSetting(Option.FAKTURA_POPUST).booleanValue() ? new GridPrint(new GridColumn[]{new GridColumn(131072, -1, 20), new GridColumn(16384, -1, 160), new GridColumn(0x1000000, -1, 25), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 65), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 60)}) : new GridPrint(new GridColumn[]{new GridColumn(131072, -1, 20), new GridColumn(16384, -1, 160), new GridColumn(0x1000000, -1, 25), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 60)});
        gpItems.setLook((GridLook)dgl);
        RGB lineCol = new RGB(64, 64, 64);
        LinePrint lp = new LinePrint(256, 1.0);
        lp.setRGB(lineCol);
        FontData fdt = new FontData(fontName, textSize, 0);
        gpItems.addHeader((Print)new EmptyPrint(10, 5), -1);
        gpItems.addHeader((Print)lp, -1);
        gpItems.addHeader(0x1000000, (Print)new TextPrint(rb, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(naziv, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(jm, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(kolicina, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cena, fdt, 0x1000000));
        if (server.getSetting(Option.FAKTURA_POPUST).booleanValue()) {
            gpItems.addHeader(0x1000000, (Print)new TextPrint(popustPC, fdt, 0x1000000));
            gpItems.addHeader(0x1000000, (Print)new TextPrint(cenaSaPop, fdt, 0x1000000));
        }
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvIznos, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cenaBPDV, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(iznos, fdt, 0x1000000));
        gpItems.addHeader((Print)lp, -1);
        int i = 0;
        if (id.getRacun().getMeniPromet() == null || meniji != null) {
            for (StavkaRacuna sr : items) {
                boolean mera;
                if (sr.getArtikal().getTip() == TipArtikla.DODA && (sr.getArtikal().getCena() == null || sr.getArtikal().getCena() == 0.0)) continue;
                ++i;
                double cenaPrava = sr.getCenaBezPopusta();
                boolean bl = id.getRacun().getMeniPromet() != null ? true : (mera = sr.getArtikal().getMera() != 1.0);
                double popust = cenaPrava != sr.getCena() ? 100.0 - 100.0 * sr.getCena() / cenaPrava : (sr.getRacun() != null ? sr.getRacun().getPopust() : id.getRacun().getPopust());
                double pdvStopa = Konstante.getPdvPoPG(sr.getArtikal().getPoreskaGrupa());
                double cenaStavka = sr.getPrice().doubleValue();
                double cenaPopust = sr.getArtikal().isDiscountable() != false ? cenaPrava - cenaPrava * popust / 100.0 : cenaStavka;
                double iznosBPdv = cenaPopust / (1.0 + pdvStopa);
                double iznosPdv = iznosBPdv * pdvStopa;
                try {
                    gpItems.add(131072, (Print)new TextPrint("" + i, fdt, 0x1000000));
                    gpItems.add(16384, (Print)new TextPrint(sr.getNaziv(), fdt, 0x1000000));
                    gpItems.add(16384, (Print)new TextPrint(mera ? "KOM" : sr.getArtikal().getJedinicaMere(), fdt, 0x1000000));
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber03(sr.getKolicina()), fdt, 0x1000000));
                    if (server.getSetting(Option.FAKTURA_POPUST).booleanValue()) {
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(cenaPrava), fdt, 0x1000000));
                        if (sr.getArtikal().getDozvoljenPopust().booleanValue()) {
                            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(popust == 0.0 ? 0.0 : popust) + "%", fdt, 0x1000000));
                        } else {
                            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(0.0) + "%", fdt, 0x1000000));
                        }
                    }
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(cenaPopust), fdt, 0x1000000));
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(pdvStopa * 100.0) + "%", fdt, 0x1000000));
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getKolicina() * iznosPdv), fdt, 0x1000000));
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getKolicina() * iznosBPdv), fdt, 0x1000000));
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getKolicina() * (iznosBPdv + iznosPdv)), fdt, 0x1000000));
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
            }
            if (meniji != null) {
                for (MeniPromet mp : meniji) {
                    meniPG = server.getSetting(Option.MENI_REDNI_BROJ_PG);
                    PoreskaGrupa pg = null;
                    try {
                        int pgIdx = 0;
                        pgIdx = meniPG.intValue();
                        pg = PoreskaGrupa.values()[pgIdx - 1];
                    }
                    catch (Exception pgIdx) {
                        // empty catch block
                    }
                    double cenaSaPopustom = mp.getCena();
                    double pdvStopa = Konstante.getPdvPoPG(pg);
                    double iznosBPdv = cenaSaPopustom / (1.0 + pdvStopa);
                    double iznosPdv = iznosBPdv * pdvStopa;
                    ++i;
                    try {
                        gpItems.add(131072, (Print)new TextPrint("" + i, fdt, 0x1000000));
                        gpItems.add(16384, (Print)new TextPrint(mp.getNaziv(), fdt, 0x1000000));
                        gpItems.add(16384, (Print)new TextPrint("KOM", fdt, 0x1000000));
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber03(mp.getKolicina()), fdt, 0x1000000));
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getCena()), fdt, 0x1000000));
                        if (server.getSetting(Option.FAKTURA_POPUST).booleanValue()) {
                            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(0.0) + "%", fdt, 0x1000000));
                            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(cenaSaPopustom), fdt, 0x1000000));
                        }
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(pdvStopa * 100.0) + "%", fdt, 0x1000000));
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getKolicina() * iznosPdv), fdt, 0x1000000));
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getKolicina() * iznosBPdv), fdt, 0x1000000));
                        gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getKolicina() * (iznosBPdv + iznosPdv)), fdt, 0x1000000));
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        } else {
            MeniPromet mp = id.getRacun().getMeniPromet();
            meniPG = server.getSetting(Option.MENI_REDNI_BROJ_PG);
            PoreskaGrupa pg = null;
            try {
                int pgIdx = 0;
                pgIdx = meniPG.intValue();
                pg = PoreskaGrupa.values()[pgIdx - 1];
            }
            catch (Exception pgIdx) {
                // empty catch block
            }
            double cenaSaPopustom = mp.getCena();
            double pdvStopa = Konstante.getPdvPoPG(pg);
            double iznosBPdv = cenaSaPopustom / (1.0 + pdvStopa);
            double iznosPdv = iznosBPdv * pdvStopa;
            ++i;
            try {
                gpItems.add(131072, (Print)new TextPrint("" + i, fdt, 0x1000000));
                gpItems.add(16384, (Print)new TextPrint(mp.getNaziv(), fdt, 0x1000000));
                gpItems.add(16384, (Print)new TextPrint("KOM", fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber03(mp.getKolicina()), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getCena()), fdt, 0x1000000));
                if (server.getSetting(Option.FAKTURA_POPUST).booleanValue()) {
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(0.0) + "%", fdt, 0x1000000));
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(cenaSaPopustom), fdt, 0x1000000));
                }
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(pdvStopa * 100.0) + "%", fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getKolicina() * iznosPdv), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getKolicina() * iznosBPdv), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(mp.getKolicina() * (iznosBPdv + iznosPdv)), fdt, 0x1000000));
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
        gpItems.add((Print)lp, -1);
        return gpItems;
    }

    public static Print makeItems(InvoiceData id) {
        List<StavkaRacuna> items = StavkeSumarno.getSumarnoF(id.getRacun().getStavke(), true);
        String rb = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_REDNI_BROJ_SKR");
        String naziv = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NAZIV");
        String jm = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_JEDINICA_MERE_SKR");
        String kolicina = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KOLICINA");
        String cena = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CENA");
        String popustPC = null;
        String cenaSaPop = null;
        if (server.getSetting(Option.FAKTURA_POPUST).booleanValue()) {
            popustPC = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POPUST");
            cenaSaPop = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CENA_SA_POPUSTOM");
        }
        String pdvPC = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PDV");
        String pdvIznos = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_PDV");
        String cenaBPDV = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_BEZ_PDV");
        String iznos = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS");
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(3, 1);
        GridPrint gpItems = new GridPrint(new GridColumn[]{new GridColumn(131072, -1, 20), new GridColumn(16384, -1, 160), new GridColumn(0x1000000, -1, 25), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 65), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 60)});
        gpItems.setLook((GridLook)dgl);
        RGB lineCol = new RGB(64, 64, 64);
        LinePrint lp = new LinePrint(256, 1.0);
        lp.setRGB(lineCol);
        FontData fdt = new FontData(fontName, textSize, 0);
        gpItems.addHeader((Print)new EmptyPrint(10, 5), -1);
        gpItems.addHeader((Print)lp, -1);
        gpItems.addHeader(0x1000000, (Print)new TextPrint(rb, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(naziv, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(jm, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(kolicina, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cena, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(popustPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cenaSaPop, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvIznos, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cenaBPDV, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(iznos, fdt, 0x1000000));
        gpItems.addHeader((Print)lp, -1);
        int i = 0;
        for (StavkaRacuna sr : items) {
            ++i;
            boolean mera = id.getRacun().getMeniPromet() != null ? true : sr.getArtikal().getMera() != 1.0;
            double popust = sr.getRacun() != null ? sr.getRacun().getPopust() : id.getRacun().getPopust();
            double cenaSaPopustom = sr.getCena();
            double pdvStopa = Konstante.getPdvPoPG(sr.getArtikal().getPoreskaGrupa());
            double iznosBPdv = cenaSaPopustom / (1.0 + pdvStopa);
            double iznosPdv = iznosBPdv * pdvStopa;
            try {
                gpItems.add(131072, (Print)new TextPrint("" + i, fdt, 0x1000000));
                gpItems.add(16384, (Print)new TextPrint(sr.getNaziv(), fdt, 0x1000000));
                gpItems.add(16384, (Print)new TextPrint(mera ? "KOM" : sr.getArtikal().getJedinicaMere(), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber03(sr.getKolicina()), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getCenaBezPopusta()), fdt, 0x1000000));
                if (sr.getArtikal().getDozvoljenPopust().booleanValue()) {
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(popust == 0.0 ? 0.0 : popust) + "%", fdt, 0x1000000));
                } else {
                    gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(0.0) + "%", fdt, 0x1000000));
                }
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(cenaSaPopustom), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(pdvStopa * 100.0) + "%", fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getKolicina() * iznosPdv), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getKolicina() * iznosBPdv), fdt, 0x1000000));
                gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getKolicina() * (iznosBPdv + iznosPdv)), fdt, 0x1000000));
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
        gpItems.add((Print)lp, -1);
        return gpItems;
    }

    public static Print makeInvoiceFooter(InvoiceData data) {
        String preduzece = data.getPreduzece();
        String kupacL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KUPAC");
        String mpL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_PECATA_SKR");
        String zaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZA");
        String BI = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BI");
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdc = new FontData(fontName, 5, 2);
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(1, 1);
        GridPrint gpValidation = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 25), new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 250), new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 25)});
        gpValidation.setLook((GridLook)dgl);
        GridPrint gpLeft = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 150)});
        gpLeft.setLook((GridLook)dgl);
        gpLeft.add((Print)new TextPrint(zaL + " " + preduzece + ":", fdtb, 0x1000000));
        gpLeft.add((Print)new EmptyPrint(20, 20));
        gpLeft.add((Print)new LinePrint(256, 1.0));
        GridPrint gpMiddle = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 250)});
        gpMiddle.setLook((GridLook)dgl);
        gpMiddle.add(0x1000000, 0x1000000, (Print)new TextPrint(mpL, fdt, 0x1000000));
        GridPrint gpRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 150)});
        gpRight.setLook((GridLook)dgl);
        gpRight.add((Print)new TextPrint(kupacL + ":", fdtb, 0x1000000));
        gpRight.add((Print)new EmptyPrint(20, 20));
        gpRight.add((Print)new LinePrint(256, 1.0));
        gpValidation.add((Print)new EmptyPrint(10, 25), 5);
        gpValidation.add((Print)new EmptyPrint(10, 25));
        gpValidation.add((Print)gpLeft);
        gpValidation.add((Print)gpMiddle);
        gpValidation.add((Print)gpRight);
        gpValidation.add((Print)new EmptyPrint(20, 25));
        gpValidation.add((Print)new EmptyPrint(20, 25));
        NoBreakPrint nbp = new NoBreakPrint((Print)gpValidation);
        return nbp;
    }

    public static Print makeInvoiceFooter1(InvoiceData data, String brojBi) {
        String BI = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BI");
        DefaultGridLook dg2 = new DefaultGridLook();
        dg2.setCellPadding(0, 1);
        FontData fdtb = new FontData(fontName, textSize, 0);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdc = new FontData(fontName, 5, 2);
        GridPrint gpValidation1 = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 25), new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 250), new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 25)});
        gpValidation1.setLook((GridLook)dg2);
        GridPrint gpLeft1 = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 150)});
        gpLeft1.setLook((GridLook)dg2);
        gpLeft1.add((Print)new TextPrint(brojBi.length() > 0 ? BI + ": " + brojBi : BI + ": __________________", fdtb, 0x1000000));
        gpLeft1.add((Print)new EmptyPrint(20, 10));
        gpValidation1.add((Print)new EmptyPrint(10, 25), 5);
        gpValidation1.add((Print)new EmptyPrint(10, 25));
        gpValidation1.add((Print)gpLeft1);
        NoBreakPrint nbp = new NoBreakPrint((Print)gpValidation1);
        return nbp;
    }

    public static Print makeInvoiceFooter1(InvoiceData data, RestoranServer server, String brojBI) {
        String BI = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BI");
        String TEXT1 = server.getSetting(Option.RACUN_FOOTER_1).stringValue();
        String TEXT2 = server.getSetting(Option.RACUN_FOOTER_2).stringValue();
        String TEXT3 = server.getSetting(Option.RACUN_FOOTER_3).stringValue();
        String TEXT4 = server.getSetting(Option.RACUN_FOOTER_4).stringValue();
        DefaultGridLook dg2 = new DefaultGridLook();
        dg2.setCellPadding(0, 1);
        FontData fdtb = new FontData(fontName, textSize, 0);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdc = new FontData(fontName, 5, 2);
        GridPrint gpValidation1 = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 25), new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 250), new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 25)});
        gpValidation1.setLook((GridLook)dg2);
        GridPrint gpLeft1 = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 150)});
        gpLeft1.setLook((GridLook)dg2);
        if (server.getSetting(Option.FAKTURA_BI_BROJ).booleanValue()) {
            gpLeft1.add((Print)new TextPrint(brojBI.length() > 0 ? BI + ": " + brojBI : BI + ": __________________", fdtb, 0x1000000));
        }
        gpLeft1.add((Print)new EmptyPrint(20, 10));
        gpLeft1.add((Print)new TextPrint(TEXT1, fdt, 0x1000000));
        gpLeft1.add((Print)new EmptyPrint(20, 10));
        gpLeft1.add((Print)new TextPrint(TEXT2, fdt, 0x1000000));
        gpLeft1.add((Print)new EmptyPrint(20, 10));
        gpLeft1.add((Print)new TextPrint(TEXT3, fdt, 0x1000000));
        gpLeft1.add((Print)new EmptyPrint(20, 10));
        gpLeft1.add((Print)new TextPrint(TEXT4, fdt, 0x1000000));
        gpValidation1.add((Print)new EmptyPrint(10, 25), 5);
        gpValidation1.add((Print)new EmptyPrint(10, 25));
        gpValidation1.add((Print)gpLeft1);
        NoBreakPrint nbp = new NoBreakPrint((Print)gpValidation1);
        return nbp;
    }

    public static Print makeInvoiceFooter12(InvoiceData data, RestoranServer server, Racun racun, String napomena) {
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 20), new GridColumn(0x1000000, -1, 240), new GridColumn(0x1000000, -1, 40)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 64, 240)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint(napomena.isEmpty() ? "     NAPOMENA: " : "     FAKTURE KOJE SU U ZBIRNOJ FAKTURI: ", fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        gpBuyerData.add((Print)new LinePrint(256));
        TextPrint napomenaText = new TextPrint(napomena.isEmpty() ? racun.getNapomena() : napomena.trim(), fdbt, 16384);
        napomenaText.setWordSplitting(true);
        gpBuyerData.add(16384, (Print)napomenaText);
        gpBuyerData.add((Print)new EmptyPrint(10, 10));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        gpBuyerRight.add((Print)new EmptyPrint(10, 10));
        NoBreakPrint nbp = new NoBreakPrint((Print)gpBuyerRight);
        return nbp;
    }

    public static GridPrint makePageFooter(InvoiceData data) {
        String preduzece = data.getPreduzece();
        String adresa = data.getAdresa();
        String pib = data.getPib();
        String matBroj = data.getMatBroj();
        String banka = data.getBanka();
        String racun = data.getRacunBroj();
        String uPDV = data.getuPDV();
        String delatnost = data.getDelatnost();
        String tel = data.getTel();
        String fax = data.getFax();
        String web = data.getWeb();
        String email = data.getEmail();
        String preduzeceL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PREDUZECE");
        String adresaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ADRESA");
        String pibL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PIB");
        String matBrojL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MATICNI_BROJ_SKR");
        String bankaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BANKA");
        String racunL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_RACUN");
        String uPDVL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_U_SISTEMU_PDV");
        String delatnostL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_SIFRA_DELATNOSTI");
        String telL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_TELEFON_SKR");
        String faxL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_FAX");
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdc = new FontData(fontName, 5, 2);
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(1, 1);
        String footerPath = data.getFooterPath();
        GridPrint gpCompany = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 175), new GridColumn(0x1000000, -1, 175), new GridColumn(0x1000000, -1, 250)});
        gpCompany.setLook((GridLook)dgl);
        File f = new File(footerPath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fis == null) {
            GridPrint gpLeft = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 175)});
            gpLeft.setLook((GridLook)dgl);
            gpLeft.add((Print)new TextPrint(preduzece, fdtb, 0x1000000));
            gpLeft.add((Print)new TextPrint(adresaL + ": " + adresa, fdt, 0x1000000));
            gpLeft.add((Print)new TextPrint(pibL + ": " + pib, fdt, 0x1000000));
            gpLeft.add((Print)new TextPrint(matBrojL + ": " + matBroj, fdt, 0x1000000));
            GridPrint gpMiddle = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 175)});
            gpMiddle.setLook((GridLook)dgl);
            gpMiddle.add((Print)new TextPrint(bankaL + ": " + banka, fdt, 0x1000000));
            gpMiddle.add((Print)new TextPrint(racunL + ": " + racun, fdt, 0x1000000));
            gpMiddle.add((Print)new TextPrint(uPDVL + ": " + uPDV, fdt, 0x1000000));
            gpMiddle.add((Print)new TextPrint(delatnostL + ": " + delatnost, fdt, 0x1000000));
            GridPrint gpRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 250)});
            gpRight.setLook((GridLook)dgl);
            gpRight.add((Print)new TextPrint(telL + ": " + tel, fdt, 0x1000000));
            gpRight.add((Print)new TextPrint(faxL + ": " + fax, fdt, 0x1000000));
            gpRight.add((Print)new TextPrint(web, fdt, 0x1000000));
            gpRight.add((Print)new TextPrint(email, fdt, 0x1000000));
            LinePrint lp = new LinePrint(256, 1.0);
            lp.setRGB(new RGB(64, 64, 64));
            gpCompany.add((Print)lp, -1);
            gpCompany.add((Print)gpLeft);
            gpCompany.add((Print)gpMiddle);
            gpCompany.add((Print)gpRight);
            gpCompany.add((Print)lp, -1);
            String comment = String.format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_DOKUMENT_STAMPAN"), new Date());
            gpCompany.add(16384, (Print)new TextPrint(comment, fdc), -1);
            return gpCompany;
        }
        ImageData id = new ImageData((InputStream)fis);
        id = id.scaledTo(Math.round(Float.valueOf(id.width).floatValue() / Float.valueOf(id.height).floatValue() * Float.valueOf(400.0f).floatValue()), 400);
        ImagePrint footer = new ImagePrint(id);
        footer.setDPI(300, 300);
        gpCompany.add(0x1000000, 0x1000000, (Print)footer, -1);
        gpCompany.add((Print)new EmptyPrint(20, 20));
        return gpCompany;
    }

    public static Print makeTaxes(InvoiceData id, List<StavkaRacuna> stavke, List<MeniPromet> meniji) {
        Double total;
        Double stopa;
        Double porez;
        Double osnovica;
        String rekapitulacijaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_REKAPITULACIJA_POREZA");
        String stopaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_STOPA");
        String osnovicaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OSNOVICA");
        String iznosPorezaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_POREZA");
        String ukupnoL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO");
        String ukupnoBezPDVL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO_BEZ_URACUNATOG_PDV");
        String ukupnoPDVL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPAN_IZNOS_PDV");
        String zaUplatuL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZA_UPLATU") + ":";
        List<StavkaRacuna> lsr = stavke == null ? id.getRacun().getStavke() : stavke;
        HashMap<Object, Double> mapaPoreza = new HashMap<Object, Double>();
        HashMap<Object, Double> mapaOsnovica = new HashMap<Object, Double>();
        Double porezUkupno = 0.0;
        Double osnovicaUkupno = 0.0;
        for (StavkaRacuna sr : lsr) {
            double cenaSaPopustom = sr.getCena();
            PoreskaGrupa[] pg = sr.getArtikal().getPoreskaGrupa();
            osnovica = 0.0;
            porez = 0.0;
            stopa = Konstante.getPdvPoPG((PoreskaGrupa)pg);
            osnovica = sr.getKolicina() * (cenaSaPopustom / (1.0 + stopa));
            porez = osnovica * stopa;
            if (mapaPoreza.containsKey(pg)) {
                total = (Double)mapaPoreza.get(pg);
                total = total + porez;
                mapaPoreza.put(pg, total);
            } else {
                mapaPoreza.put(pg, porez);
            }
            if (mapaOsnovica.containsKey(pg)) {
                total = (Double)mapaOsnovica.get(pg);
                total = total + osnovica;
                mapaOsnovica.put(pg, total);
            } else {
                mapaOsnovica.put(pg, osnovica);
            }
            porezUkupno = porezUkupno + porez;
            osnovicaUkupno = osnovicaUkupno + osnovica;
        }
        if (meniji != null) {
            PoreskaGrupa pg = null;
            try {
                int pgIdx = 0;
                pgIdx = meniPG.intValue();
                pg = PoreskaGrupa.values()[pgIdx - 1];
            }
            catch (Exception pgIdx) {
                // empty catch block
            }
            for (MeniPromet mp : meniji) {
                double cenaSaPopustom = mp.getCena();
                osnovica = 0.0;
                porez = 0.0;
                stopa = Konstante.getPdvPoPG(pg);
                osnovica = mp.getKolicina() * (cenaSaPopustom / (1.0 + stopa));
                porez = osnovica * stopa;
                if (mapaPoreza.containsKey(pg)) {
                    total = (Double)mapaPoreza.get(pg);
                    total = total + porez;
                    mapaPoreza.put(pg, total);
                } else {
                    mapaPoreza.put(pg, porez);
                }
                if (mapaOsnovica.containsKey(pg)) {
                    total = (Double)mapaOsnovica.get(pg);
                    total = total + osnovica;
                    mapaOsnovica.put(pg, total);
                } else {
                    mapaOsnovica.put(pg, osnovica);
                }
                porezUkupno = porezUkupno + porez;
                osnovicaUkupno = osnovicaUkupno + osnovica;
            }
        }
        GridPrint taxTotal = new GridPrint(new GridColumn[]{new GridColumn(16384, 25, 250), new GridColumn(0x1000000, 10, 100), new GridColumn(131072, 25, 250)});
        taxTotal.add((Print)new EmptyPrint(15, 15), -1);
        GridPrint tax = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 70), new GridColumn(0x1000000, -1, 90), new GridColumn(0x1000000, -1, 90)});
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        tax.addHeader(16384, (Print)new TextPrint(rekapitulacijaL, fdt, 0x1000000), -1);
        tax.addHeader((Print)new LinePrint(256, 1.0), -1);
        tax.addHeader((Print)new TextPrint(stopaL, fdt, 0x1000000));
        tax.addHeader((Print)new TextPrint(osnovicaL, fdt, 0x1000000));
        tax.addHeader((Print)new TextPrint(iznosPorezaL, fdt, 0x1000000));
        tax.addHeader((Print)new LinePrint(256, 1.0), -1);
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (!mapaPoreza.containsKey(pg)) continue;
            tax.add((Print)new TextPrint(StatLogic.getNumber02(Konstante.getPdvPoPG(pg) * 100.0) + "%", fdt, 0x1000000));
            tax.add((Print)new TextPrint(StatLogic.getNumber02((Double)mapaOsnovica.get(pg)), fdt, 0x1000000));
            tax.add((Print)new TextPrint(StatLogic.getNumber02((Double)mapaPoreza.get(pg)), fdt, 0x1000000));
        }
        tax.addFooter((Print)new LinePrint(256, 1.0), -1);
        tax.addFooter((Print)new EmptyPrint());
        tax.addFooter((Print)new TextPrint(ukupnoL + ": ", fdtb, 0x1000000));
        tax.addFooter((Print)new TextPrint(StatLogic.getNumber02(porezUkupno), fdtb, 0x1000000));
        taxTotal.add((Print)new NoBreakPrint((Print)tax));
        taxTotal.add((Print)new EmptyPrint(0, 0));
        GridPrint total2 = new GridPrint(new GridColumn[]{new GridColumn(131072, -1, 160), new GridColumn(131072, -1, 90)});
        FontData fdh = new FontData(fontName, headingSize, 0);
        FontData fdhPlus = new FontData(fontName, headingSize + 2, 1);
        total2.add((Print)new LinePrint(256, 1.0), -1);
        total2.add((Print)new TextPrint(ukupnoBezPDVL, fdh, 0x1000000));
        total2.add((Print)new TextPrint(StatLogic.getNumber02(osnovicaUkupno), fdh, 0x1000000));
        total2.add((Print)new TextPrint(ukupnoPDVL, fdh, 0x1000000));
        total2.add((Print)new TextPrint(StatLogic.getNumber02(porezUkupno), fdh, 0x1000000));
        total2.add((Print)new LinePrint(256, 1.0), -1);
        total2.add((Print)new TextPrint(zaUplatuL, fdhPlus, 0x1000000));
        total2.add((Print)new TextPrint(StatLogic.getNumber02(osnovicaUkupno + porezUkupno), fdhPlus, 0x1000000));
        taxTotal.add((Print)new NoBreakPrint((Print)total2));
        return taxTotal;
    }

    public static Print makeTaxes(InvoiceData id, List<StavkaRacuna> stavke) {
        String rekapitulacijaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_REKAPITULACIJA_POREZA");
        String stopaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_STOPA");
        String osnovicaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OSNOVICA");
        String iznosPorezaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_POREZA");
        String ukupnoL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO");
        String ukupnoBezPDVL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO_BEZ_URACUNATOG_PDV");
        String ukupnoPDVL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPAN_IZNOS_PDV");
        String zaUplatuL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZA_UPLATU") + ":";
        List<StavkaRacuna> lsr = stavke == null ? id.getRacun().getStavke() : stavke;
        HashMap<PoreskaGrupa[], Double> mapaPoreza = new HashMap<PoreskaGrupa[], Double>();
        HashMap<PoreskaGrupa[], Double> mapaOsnovica = new HashMap<PoreskaGrupa[], Double>();
        Double porezUkupno = 0.0;
        Double osnovicaUkupno = 0.0;
        for (StavkaRacuna sr : lsr) {
            Double total;
            double cenaSaPopustom = sr.getCena();
            PoreskaGrupa[] pg = sr.getArtikal().getPoreskaGrupa();
            Double osnovica = 0.0;
            Double porez = 0.0;
            Double stopa = Konstante.getPdvPoPG((PoreskaGrupa)pg);
            osnovica = sr.getKolicina() * (cenaSaPopustom / (1.0 + stopa));
            porez = osnovica * stopa;
            if (mapaPoreza.containsKey(pg)) {
                total = (Double)mapaPoreza.get(pg);
                total = total + porez;
                mapaPoreza.put(pg, total);
            } else {
                mapaPoreza.put(pg, porez);
            }
            if (mapaOsnovica.containsKey(pg)) {
                total = (Double)mapaOsnovica.get(pg);
                total = total + osnovica;
                mapaOsnovica.put(pg, total);
            } else {
                mapaOsnovica.put(pg, osnovica);
            }
            porezUkupno = porezUkupno + porez;
            osnovicaUkupno = osnovicaUkupno + osnovica;
        }
        GridPrint taxTotal = new GridPrint(new GridColumn[]{new GridColumn(16384, 25, 250), new GridColumn(0x1000000, 10, 100), new GridColumn(131072, 25, 250)});
        taxTotal.add((Print)new EmptyPrint(15, 15), -1);
        GridPrint tax = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 70), new GridColumn(0x1000000, -1, 90), new GridColumn(0x1000000, -1, 90)});
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        tax.addHeader(16384, (Print)new TextPrint(rekapitulacijaL, fdt, 0x1000000), -1);
        tax.addHeader((Print)new LinePrint(256, 1.0), -1);
        tax.addHeader((Print)new TextPrint(stopaL, fdt, 0x1000000));
        tax.addHeader((Print)new TextPrint(osnovicaL, fdt, 0x1000000));
        tax.addHeader((Print)new TextPrint(iznosPorezaL, fdt, 0x1000000));
        tax.addHeader((Print)new LinePrint(256, 1.0), -1);
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (!mapaPoreza.containsKey(pg)) continue;
            tax.add((Print)new TextPrint(StatLogic.getNumber02(Konstante.getPdvPoPG(pg) * 100.0) + "%", fdt, 0x1000000));
            tax.add((Print)new TextPrint(StatLogic.getNumber02((Double)mapaOsnovica.get(pg)), fdt, 0x1000000));
            tax.add((Print)new TextPrint(StatLogic.getNumber02((Double)mapaPoreza.get(pg)), fdt, 0x1000000));
        }
        tax.addFooter((Print)new LinePrint(256, 1.0), -1);
        tax.addFooter((Print)new EmptyPrint());
        tax.addFooter((Print)new TextPrint(ukupnoL + ": ", fdtb, 0x1000000));
        tax.addFooter((Print)new TextPrint(StatLogic.getNumber02(porezUkupno), fdtb, 0x1000000));
        taxTotal.add((Print)new NoBreakPrint((Print)tax));
        taxTotal.add((Print)new EmptyPrint(0, 0));
        GridPrint total = new GridPrint(new GridColumn[]{new GridColumn(131072, -1, 160), new GridColumn(131072, -1, 90)});
        FontData fdh = new FontData(fontName, headingSize, 0);
        FontData fdhPlus = new FontData(fontName, headingSize + 2, 1);
        total.add((Print)new LinePrint(256, 1.0), -1);
        total.add((Print)new TextPrint(ukupnoBezPDVL, fdh, 0x1000000));
        total.add((Print)new TextPrint(StatLogic.getNumber02(osnovicaUkupno), fdh, 0x1000000));
        total.add((Print)new TextPrint(ukupnoPDVL, fdh, 0x1000000));
        total.add((Print)new TextPrint(StatLogic.getNumber02(porezUkupno), fdh, 0x1000000));
        total.add((Print)new LinePrint(256, 1.0), -1);
        total.add((Print)new TextPrint(zaUplatuL, fdhPlus, 0x1000000));
        total.add((Print)new TextPrint(StatLogic.getNumber02(osnovicaUkupno + porezUkupno), fdhPlus, 0x1000000));
        taxTotal.add((Print)new NoBreakPrint((Print)total));
        return taxTotal;
    }

    public static Print makePayments(InvoiceData id) {
        String uplateL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UPLATE") + ":";
        String nacinPlacanjaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NACIN_PLACANJA");
        String iznosL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS");
        String ukupnoL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO") + ": ";
        List<Placanje> pList = id.getRacun().getPlacanja();
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        GridPrint payments = new GridPrint(new GridColumn[]{new GridColumn(16384, 25, 250), new GridColumn(0x1000000, 10, 100), new GridColumn(131072, 25, 250)});
        payments.add((Print)new EmptyPrint(15, 15), -1);
        payments.add((Print)new EmptyPrint(15, 15));
        payments.add((Print)new EmptyPrint(15, 15));
        GridPrint payment = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 150), new GridColumn(0x1000000, -1, 100)});
        payment.addHeader(16384, (Print)new TextPrint(uplateL, fdt, 0x1000000), -1);
        payment.addHeader((Print)new LinePrint(256, 1.0), -1);
        payment.addHeader((Print)new TextPrint(nacinPlacanjaL, fdt, 0x1000000));
        payment.addHeader((Print)new TextPrint(iznosL, fdt, 0x1000000));
        payment.addHeader((Print)new LinePrint(256, 1.0), -1);
        Double total = 0.0;
        for (Placanje p : pList) {
            total = total + p.getIznos();
            payment.add((Print)new TextPrint(p.getNacin().name(), fdt, 0x1000000));
            payment.add((Print)new TextPrint(StatLogic.getNumber02(p.getIznos()), fdt, 0x1000000));
        }
        payment.addFooter((Print)new LinePrint(256, 1.0), -1);
        payment.addFooter((Print)new TextPrint(ukupnoL, fdtb, 0x1000000));
        payment.addFooter((Print)new TextPrint(StatLogic.getNumber02(total), fdtb, 0x1000000));
        payments.add((Print)new NoBreakPrint((Print)payment));
        return payments;
    }

    private static void print(PrintJob pj, PrinterData pd) {
        try {
            PaperClips.print((PrintJob)pj, (PrinterData)pd);
        }
        catch (Throwable e) {
            LogUtils.warn(e, "Error printing paperclips document!", new Object[0]);
        }
    }

    static {
        fontName = "Arial";
        textSize = 7;
        titleTextSize = 36;
        headingSize = 9;
        printMargin = 10;
    }

    public static class InvoiceData {
        private RestoranServer server;
        private String preduzece;
        private String poslovnica;
        private String adresa;
        private String pib;
        private String matBroj;
        private String banka;
        private String racunBroj;
        private String uPDV;
        private String delatnost;
        private String tel;
        private String fax;
        private String web;
        private String email;
        private long brRacuna;
        private Date datumIzdavanja;
        private Date datumPrometa;
        private Date datumValute;
        private String mestoIzdavanja;
        private String mestoPrometa;
        private String nazivKupca;
        private String adresaKupca;
        private String pibKupca;
        private String mbKupca;
        private String logoPath;
        private String footerPath;
        private Racun racun;
        private boolean vp;
        private boolean otp;

        public InvoiceData() {
            this.server = null;
            this.vp = false;
            this.preduzece = "";
            this.poslovnica = "";
            this.adresa = "";
            this.pib = "";
            this.matBroj = "";
            this.banka = "";
            this.racunBroj = "";
            this.uPDV = "";
            this.delatnost = "";
            this.tel = "";
            this.fax = "";
            this.web = "";
            this.email = "";
            this.brRacuna = 0L;
            this.datumIzdavanja = new Date();
            this.datumPrometa = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.datumValute = cal.getTime();
            this.mestoIzdavanja = "";
            this.mestoPrometa = "";
            this.nazivKupca = "";
            this.adresaKupca = "";
            this.pibKupca = "";
            this.mbKupca = "";
            this.logoPath = "";
            this.footerPath = "";
            Racun r = new Racun();
            r.setStavke1(new LinkedList<StavkaRacuna>());
            r.setPlacanja(new LinkedList<Placanje>());
            this.racun = r;
        }

        public InvoiceData(boolean testData) {
            this.preduzece = "Monstrumanija k.a.o.";
            this.poslovnica = "Megalomanija - Monsteriozna kompanija";
            this.adresa = "Tri lipe 4, Krajolik Bo\u017eanstven";
            this.pib = "123456789";
            this.matBroj = "12345678";
            this.banka = "Dafiment banka";
            this.racunBroj = "d\u017eabe kad je prazan";
            this.uPDV = "DA";
            this.delatnost = "00000";
            this.tel = "0117654321";
            this.fax = "0111234567";
            this.web = "www.monstrumani.ja";
            this.email = "zalopoj@monstrumani.ja";
            this.brRacuna = 0L;
            this.datumIzdavanja = new Date();
            this.datumPrometa = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.datumValute = cal.getTime();
            this.mestoIzdavanja = "Beograd";
            this.mestoPrometa = "Beograd";
            this.nazivKupca = "Metaloglo\u0111a\u010dica d.o.o.";
            this.adresaKupca = "Kingdom of FarFarAway, FarFarAway u.p.m.";
            this.pibKupca = "123456789";
            this.mbKupca = "123456789";
            this.logoPath = "C:/barmaster/image/FakturaLogo.png";
            this.footerPath = "C:/barmaster/image/FakturaFooter.png";
            Racun r = new Racun();
            r.setPopust(0.0);
            LinkedList<StavkaRacuna> lsr = new LinkedList<StavkaRacuna>();
            Double zbir = 0.0;
            for (int i = 0; i < 20; ++i) {
                Artikal a = new Artikal();
                a.setName("Art" + i);
                a.setCena((double)(i % 4 + 1) * 100.0);
                a.setDozvoljenPopust(Boolean.TRUE);
                a.setJedinicaMere(JedMere.values()[i % JedMere.values().length].name());
                a.setPoreskaGrupa(PoreskaGrupa.GRUPA_DJ);
                StavkaRacuna sr = new StavkaRacuna();
                sr.setRacun(r);
                sr.setArtikal(a);
                sr.setCena(a.getCena());
                sr.setKolicina(Double.valueOf((i % 3 + 1) * 100));
                sr.setNaziv(a.getName());
                sr.setBrojStola(0);
                lsr.add(sr);
                zbir = zbir + sr.getCena();
            }
            r.setStavke1(lsr);
            Placanje p = new Placanje();
            p.setNacin(NacinPlacanja.FAKTURA);
            p.setVreme(new Date());
            p.setIznos(zbir);
            p.setRacun(r);
            LinkedList<Placanje> pList = new LinkedList<Placanje>();
            pList.add(p);
            r.setPlacanja(pList);
            this.racun = r;
        }

        public String getPreduzece() {
            return this.preduzece;
        }

        public void setPreduzece(String preduzece) {
            this.preduzece = preduzece;
        }

        public String getAdresa() {
            return this.adresa;
        }

        public void setAdresa(String adresa) {
            this.adresa = adresa;
        }

        public String getPib() {
            return this.pib;
        }

        public void setPib(String pib) {
            this.pib = pib;
        }

        public String getMatBroj() {
            return this.matBroj;
        }

        public void setMatBroj(String matBroj) {
            this.matBroj = matBroj;
        }

        public String getBanka() {
            return this.banka;
        }

        public void setBanka(String banka) {
            this.banka = banka;
        }

        public String getRacunBroj() {
            return this.racunBroj;
        }

        public void setRacunBroj(String racunBroj) {
            this.racunBroj = racunBroj;
        }

        public String getuPDV() {
            return this.uPDV;
        }

        public void setuPDV(String uPDV) {
            this.uPDV = uPDV;
        }

        public String getDelatnost() {
            return this.delatnost;
        }

        public void setDelatnost(String delatnost) {
            this.delatnost = delatnost;
        }

        public String getTel() {
            return this.tel;
        }

        public void setTel(String tel) {
            this.tel = tel;
        }

        public String getFax() {
            return this.fax;
        }

        public void setFax(String fax) {
            this.fax = fax;
        }

        public String getWeb() {
            return this.web;
        }

        public void setWeb(String web) {
            this.web = web;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public long getBrRacuna() {
            return this.brRacuna;
        }

        public void setBrRacuna(long brRacuna) {
            this.brRacuna = brRacuna;
        }

        public Date getDatumIzdavanja() {
            return this.datumIzdavanja;
        }

        public void setDatumIzdavanja(Date datumIzdavanja) {
            this.datumIzdavanja = datumIzdavanja;
        }

        public Date getDatumPrometa() {
            return this.datumPrometa;
        }

        public void setDatumPrometa(Date datumPrometa) {
            this.datumPrometa = datumPrometa;
        }

        public Date getDatumValute() {
            return this.datumValute;
        }

        public void setDatumValute(Date datumValute) {
            this.datumValute = datumValute;
        }

        public String getMestoIzdavanja() {
            return this.mestoIzdavanja;
        }

        public void setMestoIzdavanja(String mestoIzdavanja) {
            this.mestoIzdavanja = mestoIzdavanja;
        }

        public String getMestoPrometa() {
            return this.mestoPrometa;
        }

        public void setMestoPrometa(String mestoPrometa) {
            this.mestoPrometa = mestoPrometa;
        }

        public String getNazivKupca() {
            return this.nazivKupca;
        }

        public void setNazivKupca(String nazivKupca) {
            this.nazivKupca = nazivKupca;
        }

        public String getAdresaKupca() {
            return this.adresaKupca;
        }

        public void setAdresaKupca(String adresaKupca) {
            this.adresaKupca = adresaKupca;
        }

        public String getPibKupca() {
            return this.pibKupca;
        }

        public void setPibKupca(String pibKupca) {
            this.pibKupca = pibKupca;
        }

        public String getMbKupca() {
            return this.mbKupca;
        }

        public void setMbKupca(String mbKupca) {
            this.mbKupca = mbKupca;
        }

        public String getLogoPath() {
            return this.logoPath;
        }

        public void setLogoPath(String logoPath) {
            this.logoPath = logoPath;
        }

        public String getFooterPath() {
            return this.footerPath;
        }

        public void setFooterPath(String footerPath) {
            this.footerPath = footerPath;
        }

        public String getPoslovnica() {
            return this.poslovnica;
        }

        public void setPoslovnica(String poslovnica) {
            this.poslovnica = poslovnica;
        }

        public Racun getRacun() {
            return this.racun;
        }

        public void setRacun(Racun racun) {
            this.racun = racun;
        }

        public boolean isVp() {
            return this.vp;
        }

        public void setVp(boolean vp) {
            this.vp = vp;
        }

        public RestoranServer getServer() {
            return this.server;
        }

        public void setServer(RestoranServer server) {
            this.server = server;
        }

        public boolean isOtp() {
            return this.otp;
        }

        public void setOtp(boolean otp) {
            this.otp = otp;
        }
    }

    public static class FooterData {
        private String preduzece;
        private String adresa;
        private String pib;
        private String matBroj;
        private String banka;
        private String racunBroj;
        private String uPDV;
        private String delatnost;
        private String tel;
        private String fax;
        private String web;
        private String email;

        public FooterData() {
            this.preduzece = "";
            this.adresa = "";
            this.pib = "";
            this.matBroj = "";
            this.banka = "";
            this.racunBroj = "";
            this.uPDV = "";
            this.delatnost = "";
            this.tel = "";
            this.fax = "";
            this.web = "";
            this.email = "";
        }

        public FooterData(boolean testData) {
            this.preduzece = "Monstrumanija k.a.o.";
            this.adresa = "Tri lipe 4, Krajolik Bo\u017eanstven";
            this.pib = "123456789";
            this.matBroj = "12345678";
            this.banka = "Dafiment banka";
            this.racunBroj = "d\u017eabe kad je prazan";
            this.uPDV = "DA";
            this.delatnost = "00000";
            this.tel = "0117654321";
            this.fax = "0111234567";
            this.web = "www.monstrumani.ja";
            this.email = "zalopoj@monstrumani.ja";
        }

        public String getPreduzece() {
            return this.preduzece;
        }

        public void setPreduzece(String preduzece) {
            this.preduzece = preduzece;
        }

        public String getAdresa() {
            return this.adresa;
        }

        public void setAdresa(String adresa) {
            this.adresa = adresa;
        }

        public String getPib() {
            return this.pib;
        }

        public void setPib(String pib) {
            this.pib = pib;
        }

        public String getMatBroj() {
            return this.matBroj;
        }

        public void setMatBroj(String matBroj) {
            this.matBroj = matBroj;
        }

        public String getBanka() {
            return this.banka;
        }

        public void setBanka(String banka) {
            this.banka = banka;
        }

        public String getRacunBroj() {
            return this.racunBroj;
        }

        public void setRacunBroj(String racunBroj) {
            this.racunBroj = racunBroj;
        }

        public String getuPDV() {
            return this.uPDV;
        }

        public void setuPDV(String uPDV) {
            this.uPDV = uPDV;
        }

        public String getDelatnost() {
            return this.delatnost;
        }

        public void setDelatnost(String delatnost) {
            this.delatnost = delatnost;
        }

        public String getTel() {
            return this.tel;
        }

        public void setTel(String tel) {
            this.tel = tel;
        }

        public String getFax() {
            return this.fax;
        }

        public void setFax(String fax) {
            this.fax = fax;
        }

        public String getWeb() {
            return this.web;
        }

        public void setWeb(String web) {
            this.web = web;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    public static class HeaderData {
        private int brRacuna = 0;
        private Date datumIzdavanja = new Date();
        private Date datumPrometa = new Date();
        private Date datumValute;
        private String mestoIzdavanja;
        private String mestoPrometa;
        private String nazivKupca;
        private String adresaKupca;
        private String pibKupca;
        private String mbKupca;

        public HeaderData() {
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.datumValute = cal.getTime();
            this.mestoIzdavanja = "";
            this.mestoPrometa = "";
            this.nazivKupca = "";
            this.adresaKupca = "";
            this.pibKupca = "";
            this.mbKupca = "";
        }

        public HeaderData(boolean test) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.datumValute = cal.getTime();
            this.mestoIzdavanja = "Beograd";
            this.mestoPrometa = "Beograd";
            this.nazivKupca = "Metaloglo\u0111a\u010dica d.o.o.";
            this.adresaKupca = "Kingdom of FarFarAway, FarFarAway u.p.m.";
            this.pibKupca = "123456789";
            this.mbKupca = "123456789";
        }

        public int getBrRacuna() {
            return this.brRacuna;
        }

        public void setBrRacuna(int brRacuna) {
            this.brRacuna = brRacuna;
        }

        public Date getDatumIzdavanja() {
            return this.datumIzdavanja;
        }

        public void setDatumIzdavanja(Date datumIzdavanja) {
            this.datumIzdavanja = datumIzdavanja;
        }

        public Date getDatumPrometa() {
            return this.datumPrometa;
        }

        public void setDatumPrometa(Date datumPrometa) {
            this.datumPrometa = datumPrometa;
        }

        public Date getDatumValute() {
            return this.datumValute;
        }

        public void setDatumValute(Date datumValute) {
            this.datumValute = datumValute;
        }

        public String getMestoIzdavanja() {
            return this.mestoIzdavanja;
        }

        public void setMestoIzdavanja(String mestoIzdavanja) {
            this.mestoIzdavanja = mestoIzdavanja;
        }

        public String getMestoPrometa() {
            return this.mestoPrometa;
        }

        public void setMestoPrometa(String mestoPrometa) {
            this.mestoPrometa = mestoPrometa;
        }

        public String getNazivKupca() {
            return this.nazivKupca;
        }

        public void setNazivKupca(String nazivKupca) {
            this.nazivKupca = nazivKupca;
        }

        public String getAdresaKupca() {
            return this.adresaKupca;
        }

        public void setAdresaKupca(String adresaKupca) {
            this.adresaKupca = adresaKupca;
        }

        public String getPibKupca() {
            return this.pibKupca;
        }

        public void setPibKupca(String pibKupca) {
            this.pibKupca = pibKupca;
        }

        public String getMbKupca() {
            return this.mbKupca;
        }

        public void setMbKupca(String mbKupca) {
            this.mbKupca = mbKupca;
        }
    }
}

