/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.FiscalItem;
import com.dev63.fiscal.FiscalPrinter;
import com.dev63.fiscal.FiscalRecipet;
import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.RestoranServerBO;
import com.dev63.restoran.exceptions.MenuVATGroupUndefinedException;
import com.dev63.restoran.fiscalprint.einis.EINisWriter;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Country;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.sistem.fpProtocols.FLinkProtocol;
import com.dev63.restoran.sistem.fpProtocols.metalink.MetaLinkProtocol;
import com.dev63.restoran.sistem.fpProtocols.metalink.model.BMMLPayment;
import com.dev63.restoran.stampa.StampaRacunaAustrija;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SerializationUtils;

public class FiskalniRacun {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private FiscalPrinter fiscal;
    private RestoranServer server;
    private RestoranServerBO serverBO = new RestoranServerBO();

    public FiskalniRacun(Restoran rest) {
        this.fiscal = rest.getFiscal();
        this.server = rest.getServer();
    }

    public void printFiscal(Racun r, String imeKonobara) throws FiscalException, SQLException, SerialIOException, MenuVATGroupUndefinedException {
        if (Konstante.getTipStampaca() > 10) {
            LinkedList<StavkaRacuna> list = new LinkedList<StavkaRacuna>();
            for (StavkaRacuna sr : r.getStavke()) {
                if (!(Double.valueOf(Math.round(sr.getCenaBezPopusta() * (100.0 - r.getPopust()))) / 100.0 > 0.0)) continue;
                list.add(sr);
            }
            if (list.isEmpty()) {
                return;
            }
            r = (Racun)SerializationUtils.clone((Serializable)r);
            r.setStavke1(list);
            if (Konstante.getTipStampaca() == 11) {
                try {
                    Stampac stampac = this.server.readIzvestajiStampacObject();
                    if (stampac == null) {
                        JOptionPane.showMessageDialog(null, String.format(this.barmasterText.getString("PORUKA_STAMPAC_IZVESTAJA_NIJE_PRAVILNO_PODESEN"), new Object[0]), String.format(this.barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                        return;
                    }
                    Setting nazivPoslovnice = this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE);
                    Setting adresa = this.server.getSetting(Option.OBJEKAT_ADRESA);
                    Setting mesto = this.server.getSetting(Option.OBJEKAT_MESTO);
                    Setting telefon = this.server.getSetting(Option.OBJEKAT_TELEFON);
                    Setting setting = this.server.getSetting(Option.OBJEKAT_PIB_PREFIX);
                    Setting pib = this.server.getSetting(Option.OBJEKAT_PIB);
                    Setting header1 = this.server.getSetting(Option.RACUN_HEADER_1);
                    Setting header2 = this.server.getSetting(Option.RACUN_HEADER_2);
                    Setting header3 = this.server.getSetting(Option.RACUN_HEADER_3);
                    Setting header4 = this.server.getSetting(Option.RACUN_HEADER_4);
                    Setting footer1 = this.server.getSetting(Option.RACUN_FOOTER_1);
                    Setting footer2 = this.server.getSetting(Option.RACUN_FOOTER_2);
                    Setting footer3 = this.server.getSetting(Option.RACUN_FOOTER_3);
                    Setting footer4 = this.server.getSetting(Option.RACUN_FOOTER_4);
                    new StampaRacunaAustrija(r, stampac, nazivPoslovnice == null ? null : nazivPoslovnice.stringValue(), setting == null ? null : setting.stringValue(), pib == null ? null : pib.stringValue(), adresa == null ? null : adresa.stringValue(), mesto == null ? null : mesto.stringValue(), telefon == null ? null : telefon.stringValue(), header1 == null ? null : header1.stringValue(), header2 == null ? null : header2.stringValue(), header3 == null ? null : header3.stringValue(), header4 == null ? null : header4.stringValue(), footer1 == null ? null : footer1.stringValue(), footer2 == null ? null : footer2.stringValue(), footer3 == null ? null : footer3.stringValue(), footer4 == null ? null : footer4.stringValue());
                }
                catch (Exception ex) {
                    Logger.getLogger(FiskalniRacun.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (Konstante.getTipStampaca() == 21) {
                FLinkProtocol.getInstance().prodajaArtikala(r);
            } else if (Konstante.getTipStampaca() == 22) {
                Country currentCountry = this.server.getCurrentCountry();
                if (currentCountry == Country.SRBIJA) {
                    BMMLPayment.setTransferAsCheck(true);
                }
                try {
                    MetaLinkProtocol.getInstance().prodajaArtikala(r);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(FiskalniRacun.class.getName()).log(Level.SEVERE, "Greska kod instanciranja MetaLink protocola. Proverite da li imate potrebnu biblioteku!", ex);
                }
            }
        } else {
            FiscalRecipet fis = new FiscalRecipet();
            double razlika = 0.0;
            double iznosRacuna = 0.0;
            if (r.getMeniPromet() != null) {
                PoreskaGrupa poreskaGrupa;
                Setting meniPG = this.server.getSetting(Option.MENI_REDNI_BROJ_PG);
                try {
                    int pgIdx = 0;
                    pgIdx = meniPG.intValue();
                    poreskaGrupa = PoreskaGrupa.values()[pgIdx - 1];
                }
                catch (Exception ex) {
                    throw new MenuVATGroupUndefinedException();
                }
                r = Konstante.createStavkaFromMeniPromet(r.getMeniPromet(), r, this.server.getSledeciPLUMenija(), poreskaGrupa);
            }
            for (StavkaRacuna stavkaRacuna : r.getStavke()) {
                iznosRacuna += stavkaRacuna.getVrednostSaPopustom().doubleValue();
                if (Double.valueOf(Math.round(stavkaRacuna.getCenaBezPopusta() * (100.0 - r.getPopust()))) / 100.0 > 0.0) {
                    Artikal art = stavkaRacuna.getArtikal();
                    FiscalItem it = new FiscalItem();
                    if (art.getDozvoljenPopust().booleanValue()) {
                        it.setCena(stavkaRacuna.getCenaBezPopusta() * (100.0 - r.getPopust()) / 100.0);
                    } else {
                        it.setCena(stavkaRacuna.getCenaBezPopusta().doubleValue());
                    }
                    it.setKolicina(stavkaRacuna.getKolicina().doubleValue());
                    it.setNaziv(stavkaRacuna.getNaziv());
                    it.setPoreskaGrupa(art.getPoreskaGrupa());
                    if (Konstante.getTipStampaca() != 1) {
                        if (art.getCena() / 1.0 != stavkaRacuna.getCena() / 1.0) {
                            it.setPLU(16000 + art.getId().intValue());
                        } else {
                            it.setPLU(art.getId().intValue());
                        }
                    }
                    fis.addItem(it);
                    continue;
                }
                System.out.println("cena stavki nije veca od nula");
            }
            if (fis.getItems().size() == 0) {
                System.out.println("nema stavki");
                return;
            }
            HashMap<NacinPlacanja, Double> map = new HashMap<NacinPlacanja, Double>();
            for (Placanje rp : r.getPlacanja().isEmpty() ? this.server.getPlacanja(r) : r.getPlacanja()) {
                Double t = (Double)map.get((Object)rp.getNacin());
                t = t != null ? t : 0.0;
                t = t + rp.getIznos();
                map.put(rp.getNacin(), t);
            }
            block17: for (NacinPlacanja n : map.keySet()) {
                switch (n) {
                    case CEK: {
                        fis.setPlatiCekom(Double.valueOf(Math.round((Double)map.get((Object)n) * 100.0)) / 100.0);
                        continue block17;
                    }
                    case GOTOVINA: {
                        fis.setPlatiGotovinom(Double.valueOf(Math.round((Double)map.get((Object)n) * 100.0)) / 100.0);
                        continue block17;
                    }
                    case KARTICA: {
                        fis.setPlatiKarticom(Double.valueOf(Math.round((Double)map.get((Object)n) * 100.0)) / 100.0);
                        continue block17;
                    }
                    case FAKTURA: {
                        fis.setPlatiCekom(Double.valueOf(Math.round((Double)map.get((Object)n) * 100.0)) / 100.0);
                        continue block17;
                    }
                }
                throw new IllegalArgumentException(String.format(this.barmasterText.getString("TEXT_NEPOZNAT_NACIN_PLACANJA"), new Object[0]) + ": " + map.get((Object)n));
            }
            try {
                if (Konstante.getTipStampaca() == 1) {
                    XMLWriter.writeFiscalReciept(fis, imeKonobara);
                } else if (Konstante.getTipStampaca() == 2) {
                    XMLWriterHCP.dodavanjeArtikala(r.getStavke());
                    Thread.sleep(1000L);
                    XMLWriterHCP.writeFiscalReciept(fis, imeKonobara);
                } else if (Konstante.getTipStampaca() == 3) {
                    EINisWriter.printReceipt(r, this.server);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(FiskalniRacun.class.getName()).log(Level.SEVERE, null, exception);
            }
            r.setFiskalniOdstampan(Boolean.FALSE);
            int n = r.getBrojRacuna();
            String stalniGostNaziv = r.getStalniGost() == null ? "" : " ,Naziv gosta: " + r.getStalniGost().getNaziv();
            this.server.log(String.format(this.barmasterText.getString("LOG_FISKALNI_ODSTAMPAN_ZA_RACUN"), new Object[0]) + ": " + r + stalniGostNaziv + ", broj racuna: " + n + ", iznos: " + iznosRacuna);
        }
    }
}

