/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem.zdpregled;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.zdpregled.ZdKonflikt;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ZdPregledServer {
    RestoranServer server;
    private Connection connection;
    private ZdKonflikt konflikt;
    List<ZD> zdRedovi;

    public ZdPregledServer(RestoranServer server, java.util.Date datum) {
        this.server = server;
        this.connection = server.getConnection();
        this.zdRedovi = this.getZdRedovi(datum);
        this.konflikt = new ZdKonflikt();
    }

    private List<ZD> getZdRedovi(java.util.Date datum) {
        ArrayList<ZD> zdRedovi = new ArrayList<ZD>();
        String Query2 = "SELECT z.id,z.datum, z.pocetak, z.zakljucenje, z.zdBroj FROM zd z WHERE datum >=? ORDER BY id ";
        try {
            PreparedStatement ps = this.connection.prepareStatement(Query2);
            ps.setDate(1, new Date(datum.getTime()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ZD zd = new ZD();
                zd.setId(rs.getLong("id"));
                zd.setDatum(rs.getDate("Datum"));
                zd.setPocetak(rs.getBoolean("pocetak"));
                zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
                zd.setZdBroj(rs.getLong("zdBroj"));
                zdRedovi.add(zd);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return zdRedovi;
    }

    private List<ZdKonflikt> getKonfliktRedovi() {
        ArrayList<ZdKonflikt> konflikti = new ArrayList<ZdKonflikt>();
        if (this.zdRedovi.size() == 1) {
            ZdKonflikt konflikt = new ZdKonflikt(this.zdRedovi.get(0).getDatum(), "Pomerite datum pre izabranog kako bi proverili dali posotoje konflikti");
            konflikti.add(konflikt);
            return konflikti;
        }
        for (int i = 0; i < this.zdRedovi.size(); ++i) {
            ZdKonflikt zdBrojPre;
            ZD posle;
            ZD pre;
            ZD zd = this.zdRedovi.get(i);
            if (i == 0) {
                pre = null;
                posle = this.zdRedovi.get(i + 1);
            } else if (i == this.zdRedovi.size() - 1) {
                posle = null;
                pre = this.zdRedovi.get(i - 1);
            } else {
                pre = this.zdRedovi.get(i - 1);
                posle = this.zdRedovi.get(i + 1);
            }
            ZdKonflikt datumPre = this.konflikt.getDatumKonfliktPre(pre, zd);
            if (datumPre != null) {
                konflikti.add(datumPre);
                ++i;
                continue;
            }
            ZdKonflikt datumPosle = this.konflikt.getDatumKonfliktPosle(zd, posle);
            if (datumPosle != null) {
                konflikti.add(datumPosle);
                ++i;
                continue;
            }
            ZdKonflikt pocetakPre = this.konflikt.getPocetakKonfliktPre(pre, zd);
            if (pocetakPre != null) {
                konflikti.add(pocetakPre);
                ++i;
                continue;
            }
            ZdKonflikt pocetakPosle = this.konflikt.getPocetakKonfliktPosle(zd, posle);
            if (pocetakPosle != null) {
                konflikti.add(pocetakPosle);
                ++i;
                continue;
            }
            ZdKonflikt zakljucenjePre = this.konflikt.getZakljucenjeKonfliktPre(pre, zd);
            if (zakljucenjePre != null) {
                konflikti.add(zakljucenjePre);
            }
            if ((zdBrojPre = this.konflikt.getZdBrojKonfliktPre(pre, zd)) != null) {
                konflikti.add(zdBrojPre);
                ++i;
                continue;
            }
            ZdKonflikt zdBrojPosle = this.konflikt.getZdBrojKonfliktPosle(zd, posle);
            if (zdBrojPosle == null) continue;
            konflikti.add(zdBrojPosle);
            ++i;
        }
        return konflikti;
    }

    public String[] getLastZd() {
        String[] lastZD = new String[5];
        ZD z = this.zdRedovi.get(this.zdRedovi.size() - 1);
        lastZD[0] = String.valueOf(z.getId());
        lastZD[1] = String.valueOf(z.getDatum());
        lastZD[2] = String.valueOf(z.getPocetak() != false ? 1 : 0);
        lastZD[3] = String.valueOf(z.getZakljucenje());
        lastZD[4] = String.valueOf(z.getZdBroj());
        return lastZD;
    }

    public void popuniRedtext(String red, Text idTx, DateInput2 izmenaDatum, Combo pocetak, DateTime zakljucenjeDatum, DateTime zakljucenjeVreme, Text zdBrojTx) {
        System.out.println(red);
        String[] selRed = red.split(";");
        idTx.setText(selRed[0]);
        izmenaDatum.setResult(Konstante.getDatefromString("yyyy-MM-dd", selRed[1]));
        pocetak.select(Integer.parseInt(selRed[2]));
        Konstante.setDateOnDTWidget(zakljucenjeDatum, selRed[3].split(" ")[0], "-");
        Konstante.setTimeOnDTWidget(zakljucenjeVreme, selRed[3].split(" ")[1], ":");
        zdBrojTx.setText(selRed[4]);
    }

    public void popuniZdRedove(Table table) {
        String[] red = new String[5];
        if (table.getItemCount() != 0) {
            table.removeAll();
        }
        for (ZD z : this.zdRedovi) {
            red[0] = String.valueOf(z.getId());
            red[1] = String.valueOf(z.getDatum());
            red[2] = String.valueOf(z.getPocetak() != false ? 1 : 0);
            red[3] = String.valueOf(z.getZakljucenje()).replace(".0", "");
            red[4] = String.valueOf(z.getZdBroj());
            TableItem item = new TableItem(table, 0);
            item.setText(red);
        }
        table.setSelection(this.zdRedovi.size() - 1);
    }

    public void popuniKonfliktRedove(Table table) {
        String[] red = new String[2];
        if (table.getItemCount() != 0) {
            table.removeAll();
        }
        List<ZdKonflikt> konflikti = this.getKonfliktRedovi();
        for (ZdKonflikt k : konflikti) {
            red[0] = String.valueOf(k.getDatumKonflikta());
            red[1] = String.valueOf(k.getOpisKonflikta());
            TableItem item = new TableItem(table, 0);
            item.setText(red);
        }
    }

    public void refresh(java.util.Date datum, Table zdTable, Table konfliktTable) {
        this.zdRedovi = this.getZdRedovi(datum);
        this.popuniZdRedove(zdTable);
        this.popuniKonfliktRedove(konfliktTable);
    }

    public ZD makeZd(Text idTx, DateInput2 izmenaDatum, Combo pocetak, DateTime zakljucenjeDatum, DateTime zakljucenjeVreme, Text zdBrojTx) {
        ZD zd = new ZD();
        zd.setId(Long.parseLong(idTx.getText()));
        try {
            zd.setDatum(izmenaDatum.getResult());
        }
        catch (InputException e) {
            e.printStackTrace();
        }
        zd.setPocetak(pocetak.getSelectionIndex() != 0);
        zd.setZakljucenje(Konstante.readDatefromWidgets(zakljucenjeDatum, zakljucenjeVreme));
        zd.setZdBroj(Long.parseLong(zdBrojTx.getText()));
        return zd;
    }

    public void deleteZD(long id) {
        String query = "Delete from zd WHERE id =?";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, id);
            ps.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public void updateZD(ZD zd) {
        String query = "UPDATE zd z SET z.datum =?, z.pocetak=?, z.zakljucenje=?, z.zdBroj=? WHERE z.id =?";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, new Date(zd.getDatum().getTime()));
            ps.setBoolean(2, zd.getPocetak());
            ps.setTimestamp(3, new Timestamp(zd.getZakljucenje().getTime()));
            ps.setLong(4, zd.getZdBroj());
            ps.setLong(5, zd.getId());
            ps.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public void insertZD(ZD zd) {
        String query = "INSERT INTO zd (datum,pocetak,zakljucenje,zdBroj) VALUES (?,?, ?,?)";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, new Date(zd.getDatum().getTime()));
            ps.setBoolean(2, zd.getPocetak());
            ps.setTimestamp(3, new Timestamp(zd.getZakljucenje().getTime()));
            ps.setLong(4, zd.getZdBroj());
            ps.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }
}

