/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem.zdpregled;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.ZD;
import java.util.Date;

public class ZdKonflikt {
    private Date datumKonflikta;
    private String opisKonflikta;

    public ZdKonflikt() {
    }

    public ZdKonflikt(Date datumKonflikta, String opisKonflikta) {
        this.datumKonflikta = datumKonflikta;
        this.opisKonflikta = opisKonflikta;
    }

    public Date getDatumKonflikta() {
        return this.datumKonflikta;
    }

    public void setDatumKonflikta(Date datumKonflikta) {
        this.datumKonflikta = datumKonflikta;
    }

    public String getOpisKonflikta() {
        return this.opisKonflikta;
    }

    public void setOpisKonflikta(String opisKonflikta) {
        this.opisKonflikta = opisKonflikta;
    }

    public ZdKonflikt getDatumKonfliktPre(ZD pre, ZD zd) {
        if (pre != null) {
            Date datumPre = pre.getDatum();
            Date datum = zd.getDatum();
            Date juce = Konstante.getYesterdayDate(datum);
            switch (zd.getPocetak().toString()) {
                case "true": {
                    if (datumPre.equals(juce)) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan datum pri zatvaranju dana");
                }
                case "false": {
                    if (datumPre.equals(datum)) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan datum pri otvaranja dana");
                }
            }
        }
        return null;
    }

    public ZdKonflikt getDatumKonfliktPosle(ZD zd, ZD posle) {
        if (posle != null) {
            Date datum = zd.getDatum();
            Date datumPosle = posle.getDatum();
            Date sutra = Konstante.getTomorrowDate(datum);
            switch (zd.getPocetak().toString()) {
                case "true": {
                    if (datum.equals(datumPosle)) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan datum pri otvaranju dana");
                }
                case "false": {
                    if (datumPosle.equals(sutra)) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan datum pri zatvaranju dana");
                }
            }
        }
        return null;
    }

    public ZdKonflikt getPocetakKonfliktPre(ZD pre, ZD zd) {
        if (pre != null) {
            Date datum = zd.getDatum();
            boolean aktuelan = zd.getPocetak();
            boolean prethodni = pre.getPocetak();
            switch (zd.getPocetak().toString()) {
                case "true": {
                    if (!prethodni) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan  pocetak pri otvaranju dana");
                }
                case "false": {
                    if (prethodni) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan pocetak pri zatvranju dana");
                }
            }
        }
        return null;
    }

    public ZdKonflikt getPocetakKonfliktPosle(ZD zd, ZD posle) {
        if (posle != null) {
            Date datum = zd.getDatum();
            boolean aktuelan = zd.getPocetak();
            boolean sledeci = posle.getPocetak();
            switch (zd.getPocetak().toString()) {
                case "true": {
                    if (!sledeci) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan  pocetak pri otvaranju dana");
                }
                case "false": {
                    if (sledeci) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan pocetak pri zatvranju dana");
                }
            }
        }
        return null;
    }

    public ZdKonflikt getZakljucenjeKonfliktPre(ZD pre, ZD zd) {
        if (pre != null) {
            Date datum = zd.getDatum();
            Date zakljucenje = zd.getZakljucenje();
            Date zakljucenjePre = pre.getZakljucenje();
            if (zakljucenjePre.before(zakljucenje) || zakljucenjePre.equals(zakljucenje)) {
                return null;
            }
            return new ZdKonflikt(datum, "Neispravano zakljucenje pri zatvaranju dana");
        }
        return null;
    }

    public ZdKonflikt getZdBrojKonfliktPre(ZD pre, ZD zd) {
        if (pre != null) {
            Date datum = zd.getDatum();
            long zdBroj = zd.getZdBroj();
            long zdBrojPre = pre.getZdBroj();
            switch (zd.getPocetak().toString()) {
                case "true": {
                    if (zdBrojPre == zdBroj - 1L) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan zdBroj pri otvaranju dana");
                }
                case "false": {
                    if (zdBrojPre == zdBroj) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan zdBroj pri zatvaranju dana");
                }
            }
        }
        return null;
    }

    public ZdKonflikt getZdBrojKonfliktPosle(ZD zd, ZD posle) {
        if (posle != null) {
            Date datum = zd.getDatum();
            long zdBroj = zd.getZdBroj();
            long zdBrojPosle = posle.getZdBroj();
            switch (zd.getPocetak().toString()) {
                case "true": {
                    if (zdBrojPosle == zdBroj) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan zdBroj pri otvaranju dana");
                }
                case "false": {
                    if (zdBrojPosle == zdBroj + 1L) {
                        return null;
                    }
                    return new ZdKonflikt(datum, "Neispravan zdBroj pri zatvaranju dana");
                }
            }
        }
        return null;
    }
}

