/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem.parts.rastavljanje;

import com.dev63.restoran.comparators.MasterComparators;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.util.GenericMutableBuilder;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SplittingTableModel {
    private Map<Tura, Set<StavkaRacuna>> ordersLeft = new IdentityHashMap<Tura, Set<StavkaRacuna>>();
    private Map<Tura, Set<StavkaRacuna>> ordersRight = new IdentityHashMap<Tura, Set<StavkaRacuna>>();
    private Map<Tura, Set<StavkaRacuna>> initialOrders;
    private Sto table;
    private Tura newOrder;
    private int nextOrderNumber;

    private SplittingTableModel() {
    }

    public Sto getTable() {
        return this.table;
    }

    public Map<Tura, Set<StavkaRacuna>> getInitialOrders() {
        return this.initialOrders;
    }

    public Map<Tura, Set<StavkaRacuna>> getOrdersLeft() {
        return this.ordersLeft;
    }

    public Map<Tura, Set<StavkaRacuna>> getOrdersRight() {
        return this.ordersRight;
    }

    public void moveAllRight() {
        this.ordersLeft.clear();
        this.ordersRight.clear();
        Map<Tura, Set<StavkaRacuna>> collect = this.initialOrders.entrySet().parallelStream().peek(e -> this.resetAllToRight((Set)e.getValue())).collect(new SplittingTableCollector());
        this.ordersRight.putAll(collect);
    }

    public void moveAllLeft() {
        this.ordersLeft.clear();
        this.ordersRight.clear();
        Map<Tura, Set<StavkaRacuna>> collect = this.initialOrders.entrySet().parallelStream().peek(e -> ((Set)e.getValue()).stream().peek(s -> s.setKolicinaZaRastavljanjeLevo(s.getKolicina())).peek(s -> s.setKolicinaZaRastavljanjeDesnoPrikaz(null)).forEach(s -> s.setKolicinaZaRastavljanjeDesno(0.0))).collect(new SplittingTableCollector());
        this.ordersLeft.putAll(collect);
    }

    public void moveOrderRight(Tura t) {
        Set<StavkaRacuna> items = this.initialOrders.get(t);
        this.resetAllToRight(items);
        this.ordersLeft.remove(t);
        this.ordersRight.put(t, items);
        Set newOrderItems = Optional.ofNullable(this.newOrder).map(o -> this.ordersRight.getOrDefault(o, Collections.emptySet())).orElse(Collections.emptySet());
        Set filtered = newOrderItems.parallelStream().filter(s -> !items.contains(s)).collect(Util::newIdSet, (c, i) -> c.add(i), (a, b) -> a.addAll(b));
        if (!filtered.isEmpty()) {
            newOrderItems.clear();
            newOrderItems.addAll(filtered);
        } else {
            this.ordersRight.remove(this.newOrder);
        }
    }

    public void moveItemRight(StavkaRacuna item, double quantity) {
        if (item.getGlavnaStavka() != null) {
            return;
        }
        if (quantity <= 0.0) {
            return;
        }
        if (this.newOrder == null) {
            this.newOrder = new Tura();
            this.newOrder.setBrojTure(item.getTura().getBrojTure());
        }
        if (quantity >= item.getKolicinaZaRastavljanjeLevo()) {
            quantity = item.getKolicinaZaRastavljanjeLevo();
        }
        item.setKolicinaZaRastavljanjeLevo(item.getKolicinaZaRastavljanjeLevo() - quantity);
        item.setKolicinaZaRastavljanjeDesno(item.getKolicinaZaRastavljanjeDesno() + quantity);
        Optional.ofNullable(item.getPodStavke()).orElseGet(Collections::emptyList).parallelStream().peek(si -> si.setKolicinaZaRastavljanjeDesno(si.getKolicina() / si.getGlavnaStavka().getKolicina() * si.getGlavnaStavka().getKolicinaZaRastavljanjeDesno())).forEach(si -> si.setKolicinaZaRastavljanjeLevo(si.getKolicina() / si.getGlavnaStavka().getKolicina() * si.getGlavnaStavka().getKolicinaZaRastavljanjeLevo()));
        this.ordersRight.computeIfAbsent(this.newOrder, Util::newIdSet).add(item);
        if (0.0 == item.getKolicinaZaRastavljanjeLevo()) {
            this.ordersLeft.get(item.getTura()).remove(item);
        }
        if (this.ordersLeft.get(item.getTura()).isEmpty()) {
            this.moveOrderRight(item.getTura());
        }
    }

    public void moveRight(Object o, Double quantity) {
        if (o instanceof Tura) {
            Tura order = (Tura)o;
            this.moveOrderRight(order);
        } else if (o instanceof StavkaRacuna) {
            StavkaRacuna item = (StavkaRacuna)o;
            this.moveItemRight(item, quantity);
        }
    }

    public void groupTakenItems(List<StavkaRacuna> items) {
        Map grouped = items.parallelStream().collect(Collectors.groupingBy(StavkaRacuna::getArtikal, Collectors.groupingBy(StavkaRacuna::getCena, Collectors.groupingBy(s -> s.getPodStavke().stream().sorted(Comparator.comparing(StavkaRacuna::getArtikal, Comparator.comparingLong(BObject::getId))).map(ps -> ps.getArtikal().getId().toString().concat(",").concat(ps.getKolicinaPrikaz().toString())).collect(Collectors.joining(";")), Collectors.toList()))));
        items = grouped.values().parallelStream().flatMap(doubleMapMap -> doubleMapMap.values().stream()).flatMap(stringListMap -> stringListMap.values().stream()).map(l -> {
            StavkaRacuna a = (StavkaRacuna)l.stream().findFirst().get();
            a.setKolicinaZaRastavljanjeDesnoPrikaz(l.stream().mapToDouble(s -> s.getKolicinaZaRastavljanjeDesno()).sum());
            return a;
        }).sorted(MasterComparators.ITEM_ID_COMPARATOR).collect(Collectors.toList());
    }

    private void resetAllToRight(Set<StavkaRacuna> items) {
        items.parallelStream().peek(s -> s.setKolicinaZaRastavljanjeDesno(s.getKolicina())).peek(s -> s.setKolicinaZaRastavljanjeDesnoPrikaz(null)).peek(s -> s.setKolicinaZaRastavljanjeLevo(0.0)).flatMap(s -> Optional.ofNullable(s.getPodStavke()).orElseGet(Collections::emptyList).parallelStream()).peek(ps -> ps.setKolicinaZaRastavljanjeDesno(ps.getKolicina())).peek(ps -> ps.setKolicinaZaRastavljanjeDesnoPrikaz(null)).forEach(ps -> ps.setKolicinaZaRastavljanjeLevo(0.0));
    }

    public static List<StavkaRacuna> groupTakenItemsIntoNewItems(Collection<StavkaRacuna> items) {
        Map<Artikal, Map<Double, Map<String, List<StavkaRacuna>>>> grouped = SplittingTableModel.groupItemsByArticlePriceSubItems(items);
        return grouped.values().parallelStream().flatMap(doubleMapMap -> doubleMapMap.values().stream()).flatMap(stringListMap -> stringListMap.values().stream()).map(l -> {
            StavkaRacuna example = (StavkaRacuna)l.stream().findFirst().get();
            StavkaRacuna newItem = (StavkaRacuna)StavkaRacuna.builder().from(example).kolicina(BigDecimal.valueOf(l.stream().mapToDouble(s -> s.getKolicinaZaRastavljanjeDesno()).sum())).build();
            newItem.setPodStavke(example.getPodStavke().parallelStream().map(si -> (StavkaRacuna)StavkaRacuna.builder().from((StavkaRacuna)si).kolicina(si.getQuantity().multiply(newItem.getQuantity()).divide(si.getParentItem().getQuantity(), 3, 4)).glavnaStavka(newItem).build()).collect(Collectors.toList()));
            return newItem;
        }).sorted(MasterComparators.ITEM_ID_COMPARATOR).collect(Collectors.toList());
    }

    public static Map<Artikal, Map<Double, Map<String, List<StavkaRacuna>>>> groupItemsByArticlePriceSubItems(Collection<StavkaRacuna> items) {
        return items.parallelStream().collect(Collectors.groupingBy(StavkaRacuna::getArtikal, Collectors.groupingBy(StavkaRacuna::getCena, Collectors.groupingBy(s -> s.getPodStavke().stream().sorted(Comparator.comparing(StavkaRacuna::getArtikal, Comparator.comparingLong(BObject::getId))).map(ps -> ps.getArtikal().getId().toString().concat(",").concat(ps.getKolicinaPrikaz().toString())).collect(Collectors.joining(";")), Collectors.toList()))));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SplittingTableCollector
    implements Collector<Map.Entry<Tura, ? extends Collection<StavkaRacuna>>, Map<Tura, Set<StavkaRacuna>>, Map<Tura, Set<StavkaRacuna>>> {
        @Override
        public Supplier<Map<Tura, Set<StavkaRacuna>>> supplier() {
            return IdentityHashMap::new;
        }

        @Override
        public BiConsumer<Map<Tura, Set<StavkaRacuna>>, Map.Entry<Tura, ? extends Collection<StavkaRacuna>>> accumulator() {
            return (m, e) -> m.computeIfAbsent(e.getKey(), Util::newIdSet).addAll((Collection)e.getValue());
        }

        @Override
        public BinaryOperator<Map<Tura, Set<StavkaRacuna>>> combiner() {
            return (a, b) -> {
                Map<Tura, Set> combined = a.entrySet().stream().collect(Collectors.toMap(e -> (Tura)e.getKey(), e -> (Set)e.getValue()));
                b.entrySet().forEach(e -> combined.computeIfAbsent((Tura)e.getKey(), Util::newIdSet).addAll((Collection)e.getValue()));
                return combined;
            };
        }

        @Override
        public Function<Map<Tura, Set<StavkaRacuna>>, Map<Tura, Set<StavkaRacuna>>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
        }
    }

    public static class Util {
        public static void addEntryCloneToMap(Map<Tura, Set<StavkaRacuna>> r, Map.Entry<Tura, Set<StavkaRacuna>> e) {
            r.computeIfAbsent(e.getKey(), Util::newIdSet).addAll((Collection)e.getValue());
        }

        public static Set<StavkaRacuna> newIdSet() {
            return Collections.newSetFromMap(new IdentityHashMap());
        }

        public static Set<StavkaRacuna> newIdSet(Tura t) {
            return Util.newIdSet();
        }
    }

    public static class Builder
    extends GenericMutableBuilder<SplittingTableModel> {
        private Builder() {
            this.instance = new SplittingTableModel();
        }

        public Builder table(Sto table) {
            ((SplittingTableModel)this.instance).table = table;
            return this;
        }

        public Builder addOrder(Tura order, Collection<StavkaRacuna> items) {
            Set orderItems = ((SplittingTableModel)this.instance).ordersLeft.computeIfAbsent(order, Util::newIdSet);
            orderItems.addAll(items.parallelStream().filter(i -> i.getGlavnaStavka() == null).collect(Collectors.toList()));
            return this;
        }

        public Builder nextOrderNumber(int nextOrderNumber) {
            ((SplittingTableModel)this.instance).nextOrderNumber = nextOrderNumber;
            return this;
        }

        @Override
        public SplittingTableModel build() {
            ((SplittingTableModel)this.instance).ordersLeft.values().parallelStream().flatMap(l -> l.parallelStream()).peek(s -> s.getPodStavke().parallelStream().peek(i -> i.setKolicinaZaRastavljanjeLevo(i.getKolicina())).forEach(i -> i.setKolicinaZaRastavljanjeDesno(0.0))).peek(s -> s.setKolicinaZaRastavljanjeLevo(s.getKolicina())).forEach(s -> s.setKolicinaZaRastavljanjeDesno(0.0));
            if (((SplittingTableModel)this.instance).table == null) {
                throw new IllegalArgumentException("Table not set!");
            }
            ((SplittingTableModel)this.instance).initialOrders = ((SplittingTableModel)this.instance).ordersLeft.entrySet().parallelStream().collect(new SplittingTableCollector());
            ((SplittingTableModel)this.instance).initialOrders = ((SplittingTableModel)this.instance).initialOrders.entrySet().parallelStream().collect(Collectors.toMap(e -> (Tura)e.getKey(), e -> Collections.unmodifiableSet((Set)e.getValue())));
            ((SplittingTableModel)this.instance).initialOrders = Collections.unmodifiableMap(((SplittingTableModel)this.instance).initialOrders);
            return (SplittingTableModel)super.build();
        }
    }
}

