/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.model.Artikal;
import java.math.BigDecimal;
import java.util.Date;

public class Zaliha {
    private Date datumPrijema;
    private BigDecimal primljenaKolicina;
    private BigDecimal cena;
    private BigDecimal preostalaKolicina;
    private Artikal artikal;
    private boolean potroseno;

    public Zaliha(Date datumPrijema, BigDecimal primljenaKolicina, BigDecimal cena, Artikal artikal) {
        this.datumPrijema = datumPrijema;
        this.primljenaKolicina = primljenaKolicina;
        this.cena = cena;
        this.artikal = artikal;
        this.potroseno = false;
        this.preostalaKolicina = primljenaKolicina;
    }

    public BigDecimal utrosi(BigDecimal kolicina, Artikal artikal) {
        BigDecimal utroseno = BigDecimal.ZERO;
        if (artikal != null && this.artikal.equals(artikal)) {
            if (kolicina.compareTo(this.preostalaKolicina) <= 0) {
                this.preostalaKolicina = this.preostalaKolicina.subtract(kolicina);
                utroseno = BigDecimal.valueOf(kolicina.doubleValue());
            } else {
                utroseno = BigDecimal.valueOf(this.preostalaKolicina.doubleValue());
            }
        }
        if (this.preostalaKolicina.compareTo(BigDecimal.ZERO) == 0) {
            this.potroseno = true;
        }
        return utroseno;
    }

    public BigDecimal izracunajVrednost(BigDecimal kolicina) {
        return kolicina.multiply(this.cena);
    }

    public Date getDatumPrijema() {
        return this.datumPrijema;
    }

    public BigDecimal getPrimljenaKolicina() {
        return this.primljenaKolicina;
    }

    public BigDecimal getCena() {
        return this.cena;
    }

    public BigDecimal getPreostalaKolicina() {
        return this.preostalaKolicina;
    }

    public Artikal getArtikal() {
        return this.artikal;
    }

    public boolean isPotroseno() {
        return this.potroseno;
    }
}

