/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.NabavneCene;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.stampa.ReportPrintBuilder;
import com.dev63.restoran.izvestaji.stampa.StampaKalkulacijeNPC2;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Country;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.HacapMagacini;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.ObjectWrapper;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.ArtikalDialog;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.Dobavljaci;
import com.dev63.restoran.sistem.PoreskaStopa;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.stampa.StampaKalkulacijeBA;
import com.dev63.restoran.stampa.StampaKalkulacijeNPC;
import com.dev63.restoran.stampa.StampaTrebovanjaBA;
import com.dev63.restoran.stampa.StampaTrebovanjaNPC;
import com.dev63.restoran.stampa.StampaTrebovanjaUska;
import com.dev63.restoran.swt.resources.FontCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class UpravljanjeTrebovanjem {
    String fontName = "Arial";
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer server;
    private Restoran restoran;
    private Trebovanje input;
    private TipTrebovanja type;
    private Shell shell;
    private List<StalniGost> dobavljaci;
    private Combo dobavljac;
    private DateInput2 datum;
    private DateInput2 datum2;
    private DateInput2 valutaPlacanja;
    Button crno;
    private Table stavkeTable;
    private TableItem item;
    private TableItem previousItem;
    private TableEditor editor;
    private int indexOfSelected = 0;
    private boolean selection = false;
    private TableViewer stavkeTV;
    private Button plus;
    private Button minus;
    private Odeljenje magacin;
    private Odeljenje ulazno;
    private Odeljenje izlazno;
    private Combo secondDepC;
    private List<Odeljenje> odeljenja = new LinkedList<Odeljenje>();
    private String brTreb;
    private String brojPrijemnice;
    private List<TrebovanjeStavka> stavke = new ArrayList<TrebovanjeStavka>();
    private List<TrebovanjeStavka> stavkeZaUklanjanje = new ArrayList<TrebovanjeStavka>();
    private List<PrijemnicaStavka> stavkePrijemnice = new ArrayList<PrijemnicaStavka>();
    private Label total;
    private double ukupnaVred = 0.0;
    private Boolean poPoslednjimCenama;
    private Boolean poPoslednjimCenamaKombo;
    private Text pretraga;
    private Combo artikal;
    private DoubleInput2 cenaKomad;
    private DoubleInput2 cenaKomad2;
    private DoubleInput2 rabat;
    private DoubleInput2 cenarabat;
    private Label preostalaKol2;
    private Combo pdvC;
    private DoubleInput2 kolicina;
    private DoubleInput2 nabVrednost;
    private DoubleInput2 nabVrednost2;
    private DoubleInput2 prodCena;
    private DoubleInput2 marza;
    private Text opis;
    private Button stampa;
    private Button uskaStampa;
    private Button stampaKalkulacije;
    private Button stampaKalkulacijeMaterijala;
    private Artikal artikalI;
    private Label kolicinaLabel;
    private int vrednostStope;
    private List<Artikal> artikliSvi;
    private List<Artikal> artAll;
    private Map<GrupaArtikala, Set<PodgrupaArtikala>> mapaGrupa;
    private Map<PodgrupaArtikala, Set<Artikal>> mapaPodgrupa;
    private Map<String, Artikal> artikliC = new HashMap<String, Artikal>();
    private boolean pregled;
    private List<ObjectWrapper> stope;
    private int nextRB = 1;
    private Double prodajnaCena = 0.0;
    private TrebovanjeStavka inputStavka;
    private boolean isModified = false;
    private boolean inspektor;
    private Boolean hasap;
    private TextInput2 hasVreme;
    private TextInput2 hasReg;
    private TextInput2 hasKontr;
    private TextInput2 hasLicenca;
    public static final Comparator<TrebovanjeStavka> psComp = new Comparator<TrebovanjeStavka>(){

        @Override
        public int compare(TrebovanjeStavka o1, TrebovanjeStavka o2) {
            if (o1.getRedniBroj() != null && o1.getRedniBroj() != null && o1.getRedniBroj().compareTo(o2.getRedniBroj()) != 0) {
                return o1.getRedniBroj().compareTo(o2.getRedniBroj());
            }
            if (o1.getRedniBroj() != null) {
                return 1;
            }
            if (o2.getRedniBroj() != null) {
                return -1;
            }
            return o1.getId().compareTo(o2.getId());
        }
    };
    private Text oznakaDokumenta;

    public UpravljanjeTrebovanjem(final Shell parent, Restoran r, Trebovanje inputTR, Odeljenje u, Odeljenje iz, final TipTrebovanja tip, List<Artikal> sviArtikli, boolean review, boolean inspektor, boolean hasap) {
        if (tip == null) {
            MessageBox mb = new MessageBox(parent, 40);
            mb.setText(String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]));
            mb.setMessage(String.format(this.barmasterText.getString("PORUKA_NIJE_PREPOZNAT_TIP_TREBOVANJA"), new Object[0]));
            mb.open();
            return;
        }
        this.hasap = hasap;
        this.pregled = review;
        this.inspektor = inspektor;
        this.input = inputTR;
        this.type = tip;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shell = new Shell(parent.getDisplay(), 1264);
        this.shell.setBackgroundMode(1);
        this.shell.setText(tip.getInterName() + (this.input == null ? " - " + ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UNOS") : " - " + ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BROJ") + ": " + this.input.getBrTrebovanja()));
        this.ulazno = u;
        this.izlazno = iz;
        this.dobavljaci = this.server.allDobavljaci();
        this.magacin = this.server.returnMagacin();
        this.poPoslednjimCenama = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA).booleanValue();
        this.poPoslednjimCenamaKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO).booleanValue();
        this.stope = this.restoran.getStope();
        Composite depGroup = new Composite((Composite)this.shell, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        depGroup.setLayoutData((Object)data);
        depGroup.setLayout((Layout)new GridLayout(4, false));
        Label firstL = new Label(depGroup, 16384);
        firstL.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        firstL.setText(tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI ? String.format(this.barmasterText.getString("TEXT_ULAZNO_ODELJENJE"), new Object[0]) + ":" : String.format(this.barmasterText.getString("TEXT_IZLAZNO_ODELJENJE"), new Object[0]) + ":");
        if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.NARUDZ) {
            firstL.setText(String.format(this.barmasterText.getString("TEXT_NARUDZBENICA"), new Object[0]) + ":");
        }
        Label first = new Label(depGroup, 16384);
        if (!tip.equals((Object)TipTrebovanja.NARUDZBENICA)) {
            first.setText(tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI ? u.getNaziv() : iz.getNaziv());
        }
        first.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.NARUDZ) {
            System.out.println("OVO JE NARUDZBINA!!!");
        }
        if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI && tip.getOdeljenjeUlaz() == TipTrebovanja.OdeljenjeAtribut.MAGACIN || tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI && tip.getOdeljenjeIzlaz() == TipTrebovanja.OdeljenjeAtribut.MAGACIN) {
            if (tip.getOdeljenjeIzlaz() == TipTrebovanja.OdeljenjeAtribut.MAGACIN) {
                this.izlazno = this.magacin;
            }
            if (tip.getOdeljenjeUlaz() == TipTrebovanja.OdeljenjeAtribut.MAGACIN) {
                this.ulazno = this.magacin;
            }
            if (!this.pregled) {
                this.reloadArtikle(this.artikliSvi);
            }
        }
        if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI && tip.getOdeljenjeUlaz() == TipTrebovanja.OdeljenjeAtribut.OBAVEZNO || tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI && tip.getOdeljenjeIzlaz() == TipTrebovanja.OdeljenjeAtribut.OBAVEZNO) {
            Label secondL = new Label(depGroup, 16384);
            secondL.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            secondL.setText(tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI ? String.format(this.barmasterText.getString("TEXT_ULAZNO_ODELJENJE"), new Object[0]) + ":" : String.format(this.barmasterText.getString("TEXT_IZLAZNO_ODELJENJE"), new Object[0]) + ":");
            this.secondDepC = new Combo(depGroup, 12);
            this.secondDepC.setLayoutData((Object)new GridData(16384, 4, true, false));
            this.secondDepC.setEnabled(!this.pregled);
            this.odeljenja = this.server.readOdeljenjeBezMag();
            long idIn = -1L;
            long idFirst = -1L;
            if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.NARUDZ) {
                idFirst = 0L;
                idIn = 0L;
            } else if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                if (this.ulazno != null) {
                    idFirst = this.ulazno.getId();
                }
                if (this.izlazno != null) {
                    idIn = this.izlazno.getId();
                }
            } else if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI) {
                if (this.izlazno != null) {
                    idFirst = this.izlazno.getId();
                }
                if (this.ulazno != null) {
                    idIn = this.ulazno.getId();
                }
            }
            int idxOd = 0;
            LinkedList<Odeljenje> odList = new LinkedList<Odeljenje>();
            int ii = 0;
            for (int i = 0; i < this.odeljenja.size(); ++i) {
                Odeljenje od = this.odeljenja.get(i);
                if (idIn > 0L && od.getId() == idIn) {
                    idxOd = ii;
                }
                if (idFirst > 0L && od.getId() == idFirst) continue;
                odList.add(od);
                System.out.println(od.getNaziv() + od.getNaziv());
                this.secondDepC.add(od.getNaziv());
                ++ii;
            }
            this.secondDepC.setData(odList);
            if (!this.pregled) {
                this.secondDepC.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (UpravljanjeTrebovanjem.this.type.getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI) {
                            UpravljanjeTrebovanjem.this.ulazno = (Odeljenje)((List)UpravljanjeTrebovanjem.this.secondDepC.getData()).get(UpravljanjeTrebovanjem.this.secondDepC.getSelectionIndex());
                        } else if (UpravljanjeTrebovanjem.this.type.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                            UpravljanjeTrebovanjem.this.izlazno = (Odeljenje)((List)UpravljanjeTrebovanjem.this.secondDepC.getData()).get(UpravljanjeTrebovanjem.this.secondDepC.getSelectionIndex());
                        }
                        System.out.println("ulazno = " + UpravljanjeTrebovanjem.this.ulazno);
                        System.out.println("izlazno = " + UpravljanjeTrebovanjem.this.izlazno);
                        UpravljanjeTrebovanjem.this.reloadArtikle(null);
                    }
                });
            }
            if (!odList.isEmpty()) {
                this.secondDepC.select(idxOd);
                this.secondDepC.notifyListeners(13, new Event());
            } else {
                MessageDialog.openWarning((Shell)parent, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("PORUKA_NIJE_DEFINISANO_NIJEDNO_DODATNO_ODELJENJE"), new Object[0]));
                if (!this.shell.isDisposed()) {
                    this.shell.dispose();
                }
                return;
            }
        }
        if (!this.pregled) {
            this.artikliSvi = sviArtikli == null ? this.server.findAllArticlesNoComplexNoBlocked(this.ulazno, this.izlazno) : sviArtikli;
            this.artAll = new LinkedList<Artikal>(this.artikliSvi);
            this.fillInMap(this.artAll);
        }
        Composite grupa = new Composite((Composite)this.shell, 2048);
        SWTContainer grupaSWTC = new SWTContainer(grupa);
        data = new GridData(768);
        data.horizontalSpan = 3;
        grupa.setLayoutData((Object)data);
        grupa.setLayout((Layout)new GridLayout(4, false));
        Label dat = new Label(grupa, 131072);
        dat.setText(String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]) + ":");
        this.datum = new DateInput2(grupaSWTC, String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        this.datum.setEnabled(!this.pregled);
        Label dat2 = new Label(grupa, 131072);
        dat2.setText(String.format(this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]) + ":");
        this.datum2 = new DateInput2(grupaSWTC, String.format(this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum2.setEnabled(false);
        Label d = new Label(grupa, 131072);
        d.setText(String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ":");
        Composite dob = new Composite(grupa, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginBottom = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        dob.setLayout((Layout)gl);
        if (tip.isDobavljac()) {
            d.setVisible(true);
            this.dobavljac = new Combo(dob, 524);
            this.dobavljac.setEnabled(!this.pregled);
            data = new GridData(4, 0x1000000, true, true);
            this.dobavljac.setLayoutData((Object)data);
            if (this.pregled) {
                data.horizontalSpan = 2;
            } else {
                Button bNew = Dugmici.getPlusButton(dob);
                bNew.setText("");
                bNew.setVisible(!review);
                bNew.setEnabled(!review);
                bNew.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Shell shells = new Shell(UpravljanjeTrebovanjem.this.shell, 34912);
                        new Dobavljaci(SWTContainerClass.makeContainer(shells, UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_ADMINISTRACIJA_DOBAVLJACA")), UpravljanjeTrebovanjem.this.restoran);
                        SWTContainerClass.makeEnd(shells);
                        UpravljanjeTrebovanjem.this.dobavljaci = UpravljanjeTrebovanjem.this.server.allDobavljaci();
                        UpravljanjeTrebovanjem.this.loadDobavljace();
                    }
                });
                GridData gd = new GridData(0x1000000, 0x1000000, false, true);
                gd.heightHint = 30;
                gd.widthHint = 30;
                bNew.setLayoutData((Object)gd);
            }
        } else {
            d.setVisible(false);
        }
        Label c = null;
        c = new Label(grupa, 131072);
        c.setText(String.format(this.barmasterText.getString("TEXT_DODATNE_ZALIHE"), new Object[0]));
        c.setVisible(inspektor);
        this.crno = new Button(grupa, 32);
        this.crno.setEnabled(!this.pregled);
        this.crno.setVisible(inspektor);
        Label odL = null;
        if (this.type.isKnjizenje() || this.type == TipTrebovanja.OTPREM_BEZ_KNJIZ || this.type == TipTrebovanja.OTPREM_SA_KNJIZ) {
            odL = new Label(grupa, 131072);
            odL.setText(String.format(Konstante.getBundle().getString("TEXT_OZNAKA_DOKUMENTA"), new Object[0]) + ":");
            this.oznakaDokumenta = new Text(grupa, 2048);
            this.oznakaDokumenta.setEditable(!this.pregled);
        }
        Label opisL = new Label(grupa, 131072);
        opisL.setText(String.format(this.barmasterText.getString("TEXT_OPIS"), new Object[0]) + ":");
        this.opis = new Text(grupa, 2562);
        this.opis.setEditable(!this.pregled);
        Label valuta = new Label(grupa, 131072);
        valuta.setText(String.format(this.barmasterText.getString("TEXT_VALUTA_PLACANJA_DATUM"), new Object[0]) + ":");
        this.valutaPlacanja = new DateInput2(grupa, String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.valutaPlacanja.setValutaPlacanja(true);
        this.valutaPlacanja.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.valutaPlacanja, this.shell));
        this.valutaPlacanja.setEnabled(!this.pregled);
        Label lVreme = null;
        Label lReg = null;
        Label lKont = null;
        if (hasap) {
            Composite hasapGroup = new Composite((Composite)this.shell, 2048);
            GridData data1 = new GridData(768);
            data1.horizontalSpan = 4;
            hasapGroup.setLayoutData((Object)data1);
            hasapGroup.setLayout((Layout)new GridLayout(8, false));
            lVreme = new Label(hasapGroup, 131072);
            lVreme.setText(this.barmasterText.getString("TEXT_VREME_PRIJEMA") + ": ");
            this.hasVreme = new TextInput2(hasapGroup, this.barmasterText.getString("TEXT_VREME_PRIJEMA"));
            lReg = new Label(hasapGroup, 131072);
            lReg.setText(this.barmasterText.getString("TEXT_REGISTARSKA_TABLICA") + ": ");
            this.hasReg = new TextInput2(hasapGroup, this.barmasterText.getString("TEXT_REGISTARSKA_TABLICA"));
            lKont = new Label(hasapGroup, 131072);
            lKont.setText(this.barmasterText.getString("TEXT_KONTROLISAO") + ": ");
            this.hasKontr = new TextInput2(hasapGroup, this.barmasterText.getString("TEXT_KONTROLISAO"));
            this.hasLicenca = new TextInput2(hasapGroup, "");
            this.hasLicenca.setResult("HACCP licenca br: " + this.server.getSetting(Option.HACCP_LICENCE).stringValue());
            this.hasLicenca.setEditable(false);
        }
        Composite cTable = new Composite((Composite)this.shell, 2048);
        cTable.setLayout((Layout)new GridLayout());
        cTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.stavkeTV = new TableViewer(cTable, 68356);
        this.stavkeTable = this.stavkeTV.getTable();
        this.stavkeTable.setHeaderVisible(true);
        this.stavkeTable.setLinesVisible(true);
        this.stavkeTable.setFont(FontCache.getFont(this.fontName, 7, 0));
        this.indexOfSelected = 0;
        this.editor = new TableEditor(this.stavkeTable);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        TableColumn rbArtikla = new TableColumn(this.stavkeTable, 131072);
        rbArtikla.setText(String.format(this.barmasterText.getString("TEXT_REDNI_BROJ_SKR"), new Object[0]));
        rbArtikla.setWidth(40);
        TableViewerColumn tvcRB = new TableViewerColumn(this.stavkeTV, rbArtikla);
        tvcRB.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                String res = "";
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                if (ts.getRedniBroj() == null) {
                    if (UpravljanjeTrebovanjem.this.pregled) {
                        if (UpravljanjeTrebovanjem.this.stavke.indexOf(ts) == 0) {
                            UpravljanjeTrebovanjem.this.nextRB = 1;
                        }
                        res = "" + UpravljanjeTrebovanjem.this.nextRB;
                        UpravljanjeTrebovanjem.this.nextRB++;
                    }
                } else {
                    res = ts.getRedniBroj().toString();
                }
                vc.setText(res);
            }
        });
        TableColumn nazivArtikla = new TableColumn(this.stavkeTable, 16384);
        nazivArtikla.setText(String.format(this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
        nazivArtikla.setWidth(150);
        TableViewerColumn tvcNaziv = new TableViewerColumn(this.stavkeTV, nazivArtikla);
        tvcNaziv.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                vc.setText(ts.getArtikal().getName());
            }
        });
        TableColumn kolic = new TableColumn(this.stavkeTable, 131072);
        kolic.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        kolic.setWidth(80);
        TableViewerColumn tvcKolic = new TableViewerColumn(this.stavkeTV, kolic);
        tvcKolic.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                vc.setText(StatLogic.getNumber04(ts.getKolicina()));
            }
        });
        TableColumn jmere = new TableColumn(this.stavkeTable, 16384);
        jmere.setText(String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
        jmere.setWidth(50);
        TableViewerColumn tvcJM = new TableViewerColumn(this.stavkeTV, jmere);
        tvcJM.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                vc.setText(ts.getArtikal().getJedinicaMere());
            }
        });
        TableColumn cKomadBPDV = new TableColumn(this.stavkeTable, 131072);
        cKomadBPDV.setText(String.format(Konstante.getBundle().getString("TEXT_CENA_KOMAD_BEZ_PDV_SKR"), new Object[0]));
        cKomadBPDV.setWidth(80);
        TableViewerColumn tvcCenaBPDV = new TableViewerColumn(this.stavkeTV, cKomadBPDV);
        tvcCenaBPDV.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                Double cbpdv = ts.getKomadBPDV();
                Double pdv = ts.getPdv();
                if (cbpdv == null) {
                    if (pdv == null) {
                        try {
                            pdv = Konstante.getPGStopaProcenat(ts.getArtikal().getPoreskaGrupa());
                        }
                        catch (Exception ex) {
                            pdv = 0.0;
                            ex.printStackTrace(System.err);
                        }
                    }
                    pdv = 1.0 + pdv / 100.0;
                    cbpdv = ts.getKomad() / pdv;
                    ts.setKomadBPDV(StatLogic.round(cbpdv, 4));
                }
                vc.setText(StatLogic.getNumber04(cbpdv));
            }
        });
        TableColumn cKomad = new TableColumn(this.stavkeTable, 131072);
        cKomad.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        cKomad.setWidth(80);
        TableViewerColumn tvcCena = new TableViewerColumn(this.stavkeTV, cKomad);
        tvcCena.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                vc.setText(StatLogic.getNumber02(ts.getKomad()));
            }
        });
        TableColumn nv = new TableColumn(this.stavkeTable, 131072);
        nv.setText(String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(80);
        TableViewerColumn tvcNV = new TableViewerColumn(this.stavkeTV, nv);
        tvcNV.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                Double pBPDV = ts.getKomadBPDV();
                Double vBPDV = ts.getUkupnoBPDV();
                Double pdv = ts.getPdv();
                if (vBPDV == null) {
                    if (pdv == null) {
                        try {
                            pdv = Konstante.getPGStopaProcenat(ts.getArtikal().getPoreskaGrupa());
                        }
                        catch (Exception ex) {
                            pdv = 0.0;
                            ex.printStackTrace(System.err);
                        }
                    }
                    pdv = 1.0 + pdv / 100.0;
                    if (pBPDV == null) {
                        pBPDV = StatLogic.round(ts.getKomad() / pdv, 4);
                    }
                    vBPDV = ts.getKolicina() * pBPDV;
                    ts.setUkupnoBPDV(StatLogic.round(vBPDV, 2));
                }
                vc.setText(StatLogic.getNumber02(vBPDV));
            }
        });
        TableColumn nv2 = new TableColumn(this.stavkeTable, 131072);
        nv2.setText(String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]));
        nv2.setWidth(100);
        TableViewerColumn tvcNVPDV = new TableViewerColumn(this.stavkeTV, nv2);
        tvcNVPDV.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                Double vPDV = ts.getUkupno();
                Double pBPDV = ts.getKomadBPDV();
                Double vBPDV = ts.getUkupnoBPDV();
                Double pdv = ts.getPdv();
                if (vPDV == null) {
                    if (vBPDV == null) {
                        if (pdv == null) {
                            try {
                                pdv = Konstante.getPGStopaProcenat(ts.getArtikal().getPoreskaGrupa());
                            }
                            catch (Exception ex) {
                                pdv = 0.0;
                                ex.printStackTrace(System.err);
                            }
                            ts.setPdv(pdv);
                        }
                        pdv = 1.0 + pdv / 100.0;
                        if (pBPDV == null) {
                            pBPDV = StatLogic.round(ts.getKomad() / pdv, 4);
                        }
                        vBPDV = ts.getKolicina() * pBPDV;
                    }
                    vPDV = StatLogic.round(vBPDV, 2) + StatLogic.round(vBPDV * (ts.getPdv() / 100.0), 4);
                    ts.setUkupno(StatLogic.round(vPDV, 2));
                }
                vc.setText(StatLogic.getNumber02(vPDV));
            }
        });
        TableColumn rbt = new TableColumn(this.stavkeTable, 131072);
        rbt.setText(String.format(this.barmasterText.getString("TEXT_RABAT"), new Object[0]));
        rbt.setWidth(80);
        TableViewerColumn tvcRBT = new TableViewerColumn(this.stavkeTV, rbt);
        tvcRBT.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                try {
                    String pRb = StatLogic.getNumber02(ts.getRabat());
                    vc.setText(pRb);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        TableColumn vrbt = new TableColumn(this.stavkeTable, 131072);
        vrbt.setText(String.format(this.barmasterText.getString("TEXT_CENA_SA_RABATOM"), new Object[0]));
        vrbt.setWidth(80);
        TableViewerColumn tvccRBT = new TableViewerColumn(this.stavkeTV, vrbt);
        tvccRBT.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                TrebovanjeStavka ts = (TrebovanjeStavka)vc.getElement();
                try {
                    String csRb = StatLogic.getNumber02(ts.getKomBPDVsaRbt());
                    vc.setText(csRb);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        if (!this.pregled) {
            Composite itemControls = new Composite(cTable, 0);
            itemControls.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            itemControls.setLayout((Layout)new GridLayout(6, true));
            this.plus = Dugmici.getPlusButton(itemControls);
            this.plus.setVisible(!this.pregled);
            this.plus.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UpravljanjeTrebovanjem.this.unosStavkeTrebovanja(UpravljanjeTrebovanjem.this.shell, UpravljanjeTrebovanjem.this.stavkeTable, null, tip);
                }
            });
            this.minus = Dugmici.getMinusButton(itemControls);
            this.minus.setVisible(!this.pregled);
            this.minus.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjeTrebovanjem.this.stavkeTV.getSelection();
                    if (iss.isEmpty()) {
                        return;
                    }
                    if (UpravljanjeTrebovanjem.this.selection) {
                        UpravljanjeTrebovanjem.this.selection = false;
                        Control oldEditor = UpravljanjeTrebovanjem.this.editor.getEditor();
                        if (oldEditor != null) {
                            oldEditor.dispose();
                        }
                    }
                    UpravljanjeTrebovanjem.this.stavkeZaUklanjanje.add(UpravljanjeTrebovanjem.this.stavke.get(UpravljanjeTrebovanjem.this.stavkeTable.getSelectionIndex()));
                    UpravljanjeTrebovanjem.this.stavke.remove(UpravljanjeTrebovanjem.this.stavkeTable.getSelectionIndex());
                    Collections.sort(UpravljanjeTrebovanjem.this.stavke, psComp);
                    UpravljanjeTrebovanjem.this.nextRB = 1;
                    for (TrebovanjeStavka ps : UpravljanjeTrebovanjem.this.stavke) {
                        ps.setRedniBroj(UpravljanjeTrebovanjem.this.nextRB);
                        UpravljanjeTrebovanjem.this.nextRB++;
                    }
                    UpravljanjeTrebovanjem.this.stavkeTV.refresh(true, true);
                    UpravljanjeTrebovanjem.this.updateTotal();
                }
            });
            Button up = Dugmici.getPlusButton(itemControls);
            up.setVisible(!this.pregled);
            up.setText(String.format(Konstante.getBundle().getString("TEXT_GORE"), new Object[0]));
            up.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjeTrebovanjem.this.stavkeTV.getSelection();
                    if (iss.isEmpty() || !(iss.getFirstElement() instanceof TrebovanjeStavka)) {
                        return;
                    }
                    TrebovanjeStavka ps = (TrebovanjeStavka)iss.getFirstElement();
                    if (ps == null) {
                        return;
                    }
                    int idx = UpravljanjeTrebovanjem.this.stavke.indexOf(ps);
                    if (idx == 0) {
                        return;
                    }
                    Collections.rotate(UpravljanjeTrebovanjem.this.stavke.subList(idx - 1, idx + 1), 1);
                    UpravljanjeTrebovanjem.this.nextRB = 1;
                    for (TrebovanjeStavka pss : UpravljanjeTrebovanjem.this.stavke) {
                        pss.setRedniBroj(UpravljanjeTrebovanjem.this.nextRB);
                        UpravljanjeTrebovanjem.this.nextRB++;
                    }
                    Collections.sort(UpravljanjeTrebovanjem.this.stavke, psComp);
                    UpravljanjeTrebovanjem.this.stavkeTV.refresh();
                }
            });
            Button down = Dugmici.getMinusButton(itemControls);
            down.setVisible(!this.pregled);
            down.setText(String.format(Konstante.getBundle().getString("TEXT_DOLE"), new Object[0]));
            down.addListener(13, new Listener(){

                public void handleEvent(Event ev) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjeTrebovanjem.this.stavkeTV.getSelection();
                    if (iss.isEmpty() || !(iss.getFirstElement() instanceof TrebovanjeStavka)) {
                        return;
                    }
                    TrebovanjeStavka ps = (TrebovanjeStavka)iss.getFirstElement();
                    if (ps == null) {
                        return;
                    }
                    int idx = UpravljanjeTrebovanjem.this.stavke.indexOf(ps);
                    if (idx == UpravljanjeTrebovanjem.this.stavke.size() - 1) {
                        return;
                    }
                    Collections.rotate(UpravljanjeTrebovanjem.this.stavke.subList(idx, idx + 2), 1);
                    UpravljanjeTrebovanjem.this.nextRB = 1;
                    for (TrebovanjeStavka pss : UpravljanjeTrebovanjem.this.stavke) {
                        pss.setRedniBroj(UpravljanjeTrebovanjem.this.nextRB);
                        UpravljanjeTrebovanjem.this.nextRB++;
                    }
                    Collections.sort(UpravljanjeTrebovanjem.this.stavke, psComp);
                    UpravljanjeTrebovanjem.this.stavkeTV.refresh();
                }
            });
            Button addArtikal = Dugmici.getPlusButton(itemControls);
            addArtikal.setVisible(!this.pregled);
            addArtikal.setText(" " + String.format(this.barmasterText.getString("TEXT_NOVI_ARTIKAL"), new Object[0]) + " ");
            addArtikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    try {
                        UpravljanjeTrebovanjem.this.addArtikal();
                    }
                    catch (FiscalException ex) {
                        Logger.getLogger(UpravljanjeTrebovanjem.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SerialIOException ex) {
                        Logger.getLogger(UpravljanjeTrebovanjem.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            Button potvrdiIzmene = Dugmici.getIzmeniStavku(itemControls);
            potvrdiIzmene.setVisible(!this.pregled);
            potvrdiIzmene.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IStructuredSelection iss = (IStructuredSelection)UpravljanjeTrebovanjem.this.stavkeTV.getSelection();
                    if (iss.isEmpty()) {
                        return;
                    }
                    UpravljanjeTrebovanjem.this.inputStavka = (TrebovanjeStavka)UpravljanjeTrebovanjem.this.stavke.get(UpravljanjeTrebovanjem.this.stavkeTable.getSelectionIndex());
                    UpravljanjeTrebovanjem.this.unosStavkeTrebovanja(parent, UpravljanjeTrebovanjem.this.stavkeTable, UpravljanjeTrebovanjem.this.inputStavka, tip);
                    UpravljanjeTrebovanjem.this.stavkeTV.refresh(true, true);
                    UpravljanjeTrebovanjem.this.updateTotal();
                }
            });
        }
        Composite cTotal = new Composite((Composite)this.shell, 2048);
        cTotal.setLayout((Layout)new GridLayout(2, false));
        cTotal.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label t = new Label(cTotal, 131072);
        t.setText(String.format(this.barmasterText.getString("TEXT_UKUPNA_VREDNOST"), new Object[0]) + ":");
        this.total = new Label(cTotal, 16384);
        this.total.setText("");
        this.loadData();
        this.stavkeTV.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.stavkeTV.setInput(this.stavke);
        Composite cPrint = new Composite((Composite)this.shell, 2048);
        GridData pbData = new GridData(4, 0x1000000, true, true);
        pbData.heightHint = 30;
        this.stampa = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
        this.stampa.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        this.stampa.setLayoutData((Object)pbData);
        this.uskaStampa = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
        this.uskaStampa.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        this.uskaStampa.setLayoutData((Object)pbData);
        if (this.input != null && this.input.getPrijemnica() != null) {
            this.stampaKalkulacije = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
            this.stampaKalkulacije.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_KALKULACIJE"), new Object[0]));
            this.stampaKalkulacije.setLayoutData((Object)pbData);
            this.stampaKalkulacijeMaterijala = new Button(cPrint, (this.pregled ? 8 : 32) | 0x40);
            this.stampaKalkulacijeMaterijala.setText(String.format("\u0160tampa kalkulacije materijala", new Object[0]));
            this.stampaKalkulacijeMaterijala.setLayoutData((Object)pbData);
        }
        cPrint.setLayout((Layout)new GridLayout(cPrint.getChildren().length, true));
        if (this.pregled) {
            this.stampa.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int orientation;
                    PagePrint p;
                    String nazivObjekta = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue();
                    String maticniBroj = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ).stringValue();
                    String pib = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_PIB).stringValue();
                    String adresa = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_ADRESA).stringValue();
                    if (UpravljanjeTrebovanjem.this.restoran.getServer().getCurrentCountry() == Country.BIH) {
                        p = new StampaTrebovanjaBA(UpravljanjeTrebovanjem.this.input, UpravljanjeTrebovanjem.this.type, nazivObjekta, maticniBroj);
                        orientation = 512;
                    } else {
                        p = new StampaTrebovanjaNPC(UpravljanjeTrebovanjem.this.input, UpravljanjeTrebovanjem.this.type, nazivObjekta, maticniBroj, pib, adresa);
                        orientation = 256;
                    }
                    PrintJob pj = new PrintJob("Trebovanje", (Print)p);
                    pj.setOrientation(orientation);
                    ReportPrintBuilder.printPreview(UpravljanjeTrebovanjem.this.shell, pj);
                }
            });
            this.uskaStampa.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        new StampaTrebovanjaUska(UpravljanjeTrebovanjem.this.input, UpravljanjeTrebovanjem.this.server.readIzvestajiStampacObject(), 1);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(UpravljanjeTrebovanjem.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            if (this.stampaKalkulacije != null) {
                this.stampaKalkulacije.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        PrintJob pj = UpravljanjeTrebovanjem.this.pripremaStampeKalkulacije(false);
                        ReportPrintBuilder.printPreview(UpravljanjeTrebovanjem.this.shell, pj);
                    }
                });
            }
            if (this.stampaKalkulacijeMaterijala != null) {
                this.stampaKalkulacijeMaterijala.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        PrintJob pj = UpravljanjeTrebovanjem.this.pripremaStampeKalkulacije(true);
                        ReportPrintBuilder.printPreview(UpravljanjeTrebovanjem.this.shell, pj);
                    }
                });
            }
        }
        Composite cControl = new Composite((Composite)this.shell, 0);
        cControl.setLayout((Layout)new GridLayout(2, true));
        cControl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Button cancelButt = Dugmici.getCancelButton(cControl);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UpravljanjeTrebovanjem.this.shell.close();
            }
        });
        data = (GridData)cancelButt.getLayoutData();
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        Button okButt = Dugmici.getOkButton(cControl);
        data = (GridData)okButt.getLayoutData();
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        if (this.pregled) {
            cancelButt.setText(String.format(this.barmasterText.getString("TEXT_ZATVORI"), new Object[0]));
            okButt.setEnabled(false);
            okButt.setVisible(false);
        } else {
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Odeljenje odeljenje = tip == TipTrebovanja.POVRAT_BEZ_KNJIZ || tip == TipTrebovanja.POVRAT_SA_KNJIZ || tip == TipTrebovanja.POVRAT_U_MAGACIN || tip == TipTrebovanja.OTPREM_SA_KNJIZ || tip == TipTrebovanja.OTPIS ? UpravljanjeTrebovanjem.this.izlazno : UpravljanjeTrebovanjem.this.ulazno;
                    try {
                        PopisProvera provera = new PopisProvera(UpravljanjeTrebovanjem.this.server, UpravljanjeTrebovanjem.this.shell, UpravljanjeTrebovanjem.this.datum.getResult(), odeljenje, true);
                        if (provera.isPopis()) {
                            provera.setValidDate(UpravljanjeTrebovanjem.this.datum);
                            return;
                        }
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                    boolean ret = UpravljanjeTrebovanjem.this.saveData();
                    if (ret) {
                        boolean stkm;
                        boolean stk;
                        Thread t;
                        Runnable r;
                        boolean st = UpravljanjeTrebovanjem.this.stampa.getSelection();
                        boolean ust = UpravljanjeTrebovanjem.this.uskaStampa.getSelection();
                        if (st) {
                            r = new Runnable(){

                                @Override
                                public void run() {
                                    Display d = new Display();
                                    Shell shell2 = new Shell(d, 1264);
                                    String nazivObjekta = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue();
                                    String maticniBroj = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ).stringValue();
                                    String pib = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_PIB).stringValue();
                                    String adresa = UpravljanjeTrebovanjem.this.server.getSetting(Option.OBJEKAT_ADRESA).stringValue();
                                    StampaTrebovanjaNPC p = new StampaTrebovanjaNPC(UpravljanjeTrebovanjem.this.input, UpravljanjeTrebovanjem.this.type, nazivObjekta, maticniBroj, pib, adresa);
                                    PrintJob pj = new PrintJob(UpravljanjeTrebovanjem.this.type.getInterName(), (Print)p);
                                    pj.setOrientation(256);
                                    ReportPrintBuilder.printPreview(shell2, pj);
                                    shell2.setActive();
                                    while (!shell2.isDisposed()) {
                                        if (d.readAndDispatch()) continue;
                                        d.sleep();
                                    }
                                    d.dispose();
                                    SWTContainerClass.makeEnd(shell2);
                                }
                            };
                            t = new Thread(r);
                            t.start();
                        }
                        if (ust) {
                            r = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        new StampaTrebovanjaUska(UpravljanjeTrebovanjem.this.input, UpravljanjeTrebovanjem.this.server.readIzvestajiStampacObject(), 1);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(UpravljanjeTrebovanjem.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            };
                            t = new Thread(r);
                            t.start();
                        }
                        boolean bl = stk = UpravljanjeTrebovanjem.this.stampaKalkulacije != null && UpravljanjeTrebovanjem.this.stampaKalkulacije.getSelection();
                        if (stk) {
                            Runnable r2 = new Runnable(){

                                @Override
                                public void run() {
                                    Display d = new Display();
                                    Shell shell2 = new Shell(d, 1264);
                                    PrintJob pj = UpravljanjeTrebovanjem.this.pripremaStampeKalkulacije(false);
                                    ReportPrintBuilder.printPreview(shell2, pj);
                                    shell2.setActive();
                                    while (!shell2.isDisposed()) {
                                        if (d.readAndDispatch()) continue;
                                        d.sleep();
                                    }
                                    d.dispose();
                                }
                            };
                            Thread t2 = new Thread(r2);
                            t2.start();
                        }
                        boolean bl2 = stkm = UpravljanjeTrebovanjem.this.stampaKalkulacijeMaterijala != null && UpravljanjeTrebovanjem.this.stampaKalkulacijeMaterijala.getSelection();
                        if (stkm) {
                            Runnable r3 = new Runnable(){

                                @Override
                                public void run() {
                                    Display d = new Display();
                                    Shell shell2 = new Shell(d, 1264);
                                    PrintJob pj = UpravljanjeTrebovanjem.this.pripremaStampeKalkulacije(true);
                                    ReportPrintBuilder.printPreview(shell2, pj);
                                    shell2.setActive();
                                    while (!shell2.isDisposed()) {
                                        if (d.readAndDispatch()) continue;
                                        d.sleep();
                                    }
                                    d.dispose();
                                }
                            };
                            Thread t3 = new Thread(r3);
                            t3.start();
                        }
                        UpravljanjeTrebovanjem.this.shell.close();
                    } else {
                        UpravljanjeTrebovanjem.this.shell.close();
                    }
                }
            });
        }
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        this.shell.setLayout((Layout)layout);
        data = new GridData(131072, 0x1000000, false, true);
        data.widthHint = 150;
        d.setLayoutData((Object)data);
        dat.setLayoutData((Object)data);
        if (hasap) {
            lVreme.setLayoutData((Object)data);
        }
        valuta.setLayoutData((Object)data);
        dat2.setLayoutData((Object)data);
        c.setLayoutData((Object)data);
        if (odL != null) {
            odL.setLayoutData((Object)data);
        }
        opisL.setLayoutData((Object)data);
        t.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, true);
        data.heightHint = 25;
        dob.setLayoutData((Object)data);
        if (hasap) {
            this.hasVreme.getControl().setLayoutData((Object)data);
            this.hasReg.getControl().setLayoutData((Object)data);
            this.hasKontr.getControl().setLayoutData((Object)data);
            this.hasLicenca.getControl().setLayoutData((Object)data);
        }
        this.datum.getControl().setLayoutData((Object)data);
        this.datum2.getControl().setLayoutData((Object)data);
        this.crno.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, true);
        this.total.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, false, 3, 1);
        if (cPrint != null) {
            cPrint.setLayoutData((Object)data);
        }
        data = new GridData(4, 4, true, true, 3, 1);
        this.stavkeTable.setLayoutData((Object)data);
        if (this.oznakaDokumenta != null) {
            data = new GridData(4, 0x1000000, true, true, 3, 1);
            this.oznakaDokumenta.setLayoutData((Object)data);
        }
        data = new GridData(4, 0x1000000, true, true, 3, 1);
        data.heightHint = this.opis.getLineHeight() * 2;
        this.opis.setLayoutData((Object)data);
        SWTContainerClass.setDimension(this.shell);
        this.shell.open();
    }

    private PrintJob pripremaStampeKalkulacije(boolean materijal) {
        PagePrint p;
        String nazivObjekta = this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue();
        String maticniBroj = this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ).stringValue();
        String adresa = this.server.getSetting(Option.OBJEKAT_ADRESA).stringValue();
        String pib = this.server.getSetting(Option.OBJEKAT_PIB_PREFIX).stringValue() + this.server.getSetting(Option.OBJEKAT_PIB).stringValue();
        int orientation = 256;
        switch (this.restoran.getServer().getCurrentCountry()) {
            case BIH: {
                String nazivPredzeca = this.server.getSetting(Option.PREDUZECE_NAZIV).stringValue();
                String adresaPredzeca = this.server.getSetting(Option.PREDUZECE_ADRESA).stringValue();
                String mestoPredzeca = this.server.getSetting(Option.PREDUZECE_MESTO).stringValue();
                String mesto = this.server.getSetting(Option.OBJEKAT_MESTO).stringValue();
                p = new StampaKalkulacijeBA(this.input.getPrijemnica(), this.input.getPrijemnica().getTip(), nazivObjekta, maticniBroj, adresa, pib, mesto, nazivPredzeca, adresaPredzeca, mestoPredzeca, this.input.getU().getNaziv(), materijal);
                break;
            }
            case SRBIJA: {
                String obveznik = this.server.getSetting(Option.DOK_OBVEZNIK).stringValue();
                String firmaRadnje = this.server.getSetting(Option.DOK_FIRMA_RADNJE).stringValue();
                String sediste = this.server.getSetting(Option.DOK_SEDISTE).stringValue();
                String sifraPoreskogObveznika = this.server.getSetting(Option.DOK_SIFRA_PORESKOG_OBVEZNIKA).stringValue();
                String logoPath = this.server.getSetting(Option.DOK_LOGO).stringValue();
                String sifraDelatnosti = this.server.getSetting(Option.SIFRA_DELATNOSTI).stringValue();
                Setting fup = this.server.getSetting(Option.U_SISTEMU_PDV);
                boolean firmaUPDV = fup != null && fup.booleanValue();
                EnumMap<StampaKalkulacijeNPC2.DataKey, String> data = new EnumMap<StampaKalkulacijeNPC2.DataKey, String>(StampaKalkulacijeNPC2.DataKey.class);
                data.put(StampaKalkulacijeNPC2.DataKey.FIRMA_RADNJE, firmaRadnje);
                data.put(StampaKalkulacijeNPC2.DataKey.OBVEZNIK, obveznik);
                data.put(StampaKalkulacijeNPC2.DataKey.SEDISTE, sediste);
                data.put(StampaKalkulacijeNPC2.DataKey.SIFRA_DELATNOSTI, sifraDelatnosti);
                data.put(StampaKalkulacijeNPC2.DataKey.SIFRA_PORESKOG_OBVEZNIKA, sifraPoreskogObveznika);
                data.put(StampaKalkulacijeNPC2.DataKey.LOGO_PATH, logoPath);
                data.put(StampaKalkulacijeNPC2.DataKey.PIB, pib);
                p = new StampaKalkulacijeNPC2(this.input.getPrijemnica(), this.input.getPrijemnica().getTip(), firmaUPDV, data, this.restoran);
                break;
            }
            default: {
                p = new StampaKalkulacijeNPC(this.input.getPrijemnica(), this.input.getPrijemnica().getTip(), nazivObjekta, maticniBroj, adresa, pib);
            }
        }
        PrintJob pj = new PrintJob(this.type.getInterName(), (Print)p);
        pj.setOrientation(orientation);
        return pj;
    }

    private boolean saveData() {
        if (this.dobavljac != null && this.dobavljac.getSelectionIndex() < 0) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_MORATE_IZABRATI_DOBAVLJACA"), new Object[0]));
            return false;
        }
        if (this.stavke.size() < 1) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_MORATE_UNETI_PODATKE_ZA_BAR_JEDAN_ARTIKAL"), new Object[0]));
            return false;
        }
        try {
            boolean oldBlack = this.crno.getSelection();
            String oldDocument = null;
            String oldDocument2 = null;
            Date oldDate = this.datum.getResult();
            Date val = this.valutaPlacanja.getResult();
            LinkedList<TrebovanjeStavka> oldItems = new LinkedList<TrebovanjeStavka>(this.input.getStavke());
            if (this.input.getId() != null) {
                oldBlack = this.input.getCrno();
                val = this.input.getDatumValute() != null ? this.input.getDatumValute() : oldDate;
                String brTreb = this.input.getBrTrebovanja();
                if (this.input.getTip() == null || !brTreb.contains("-" + this.type.getDocMark())) {
                    brTreb = brTreb + " (tk)";
                }
                oldDocument = brTreb;
                if (this.input.getPrijemnica() != null) {
                    oldDocument2 = this.input.getPrijemnica().getBrPrijemnice();
                }
                oldDate = this.input.getDatumTrebovanja();
            }
            Calendar dc = Calendar.getInstance();
            if (this.datum.getResult().after(new Date())) {
                Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_UNETI_DATUM_NIJE_VALIDAN"), new Object[0]));
                return false;
            }
            boolean upozorenje = false;
            if (this.type.isKnjizenje()) {
                Prijemnica p;
                if (this.type == TipTrebovanja.OTPREM_SA_KNJIZ) {
                    p = null;
                    this.input.setPrijemnica(null);
                } else if (this.input.getId() == null) {
                    p = new Prijemnica();
                    this.input.setPrijemnica(p);
                } else {
                    p = this.input.getPrijemnica();
                    if (p == null) {
                        upozorenje = true;
                    }
                }
                if (p != null) {
                    if (this.input.getId() == null || this.input.getCrno().booleanValue() != this.crno.getSelection()) {
                        String brPrijemnice = this.server.selectNextPrijemnicaNumber(this.crno.getSelection(), this.type.getTipPrijemnice(), this.datum.getResult());
                        p.setBrPrijemnice(brPrijemnice);
                    }
                    if (p.getId() == null) {
                        dc.setTime(this.datum.getResult());
                    }
                    p.setTip(this.type.getTipPrijemnice());
                    p.setDobavljac(this.dobavljaci.get(this.dobavljac.getSelectionIndex()));
                    p.setDatumPrijemnice(this.datum.getResult());
                    p.setDatumUnosa(new Date());
                    p.setDatumValute(val);
                    p.setUname(this.server.getUser().getName());
                    if (this.hasap.booleanValue()) {
                        p.setOpis(this.opis.getText());
                        p.setHacapVreme(this.hasVreme.getResult());
                        p.setRegOznaka(this.hasReg.getResult());
                        p.setKontrolisao(this.hasKontr.getResult());
                    }
                    if (this.oznakaDokumenta != null) {
                        p.setOznakaDokumenta(this.oznakaDokumenta.getText());
                    }
                    p.setTotal(this.ukupnaVred);
                    p.setCrno(this.crno.getSelection());
                    p.setStavke(new LinkedList<PrijemnicaStavka>());
                }
            }
            Trebovanje t = this.input;
            if (this.input.getId() == null || this.input.getCrno().booleanValue() != this.crno.getSelection()) {
                String brTrebovanja = this.server.selectNextTrebovanjeNumber(this.crno.getSelection(), this.type, this.datum.getResult());
                t.setBrTrebovanja(brTrebovanja);
            }
            dc.setTime(this.datum.getResult());
            if (this.type.isDobavljac()) {
                if (this.dobavljaci.size() < 1) {
                    MessageDialog.openWarning((Shell)this.shell, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("PORUKA_ODABRANI_TIP_TREBOVANJA_PODRAZUMEVA_ODABIR_DOBAVLJACA"), new Object[0]));
                    return false;
                }
                t.setDobavljac(this.dobavljaci.get(this.dobavljac.getSelectionIndex()));
            }
            t.setDatumTrebovanja(this.datum.getResult());
            t.setDatumUnosa(this.datum2.getResult());
            t.setDatumValute(val);
            t.setUname("");
            t.setTip(this.type);
            t.setOpis(this.opis.getText());
            if (this.hasap.booleanValue()) {
                t.setHacapVreme(this.hasVreme.getResult());
                t.setRegOznaka(this.hasReg.getResult());
                t.setKontrolisao(this.hasKontr.getResult());
            }
            t.setU(this.ulazno);
            t.setIz(this.izlazno);
            t.setCrno(this.crno.getSelection());
            t.setStavke(this.stavke);
            double totalBPdv = 0.0;
            for (TrebovanjeStavka ts : this.input.getStavke()) {
                if (this.type.isKnjizenje() && this.input.getPrijemnica() != null) {
                    PrijemnicaStavka ps = ts.getStavkaPrijemnice() == null ? new PrijemnicaStavka() : ts.getStavkaPrijemnice();
                    ps.setArtikal(ts.getArtikal());
                    if (this.input.getPrijemnica().getTip() == null || this.input.getPrijemnica().getTip().getTip() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                        ps.setKolicina(ts.getKolicina());
                    } else {
                        ps.setKolicina(-ts.getKolicina().doubleValue());
                    }
                    Double pdv = ts.getPdv();
                    if (pdv == null) {
                        try {
                            pdv = Konstante.getPdvPoPG(ts.getArtikal().getPoreskaGrupa());
                        }
                        catch (Exception ex) {
                            pdv = 0.0;
                            ex.printStackTrace(System.err);
                        }
                    }
                    if (ts.getKomadBPDV() == null) {
                        ps.setKomad(StatLogic.round(ts.getKomad() / (1.0 + pdv / 100.0), 4));
                    } else {
                        ps.setKomad(ts.getKomadBPDV());
                    }
                    if (ts.getUkupnoBPDV() == null) {
                        ps.setVrednost(ps.getKomad() * ps.getKolicina());
                    } else {
                        ps.setVrednost(ps.getKolicina() < 0.0 ? -ts.getUkupnoBPDV().doubleValue() : ts.getUkupnoBPDV());
                    }
                    if (ts.getKomBPDVsaRbt() == null) {
                        ps.setKomBPDVsaRbt(ts.getVrednost());
                    } else {
                        ps.setKomBPDVsaRbt(ts.getKomBPDVsaRbt());
                    }
                    ps.setProdajnaCena(ts.getProdajnaVrednost() != null ? ts.getProdajnaVrednost() : ts.getArtikal().getCena());
                    if (ts.getRabat() == null) {
                        ps.setRabat(0.0);
                    } else {
                        ps.setRabat(ts.getRabat());
                    }
                    ps.setPdvStopa(ts.getPdvStopa());
                    ps.setRedniBroj(ts.getRedniBroj());
                    ps.setPrijemnica(this.input.getPrijemnica());
                    ps.setKomadSPDV(ts.getKomad());
                    ps.setVrednostSPDV(ps.getKolicina() < 0.0 && ts.getUkupno() != null ? -ts.getUkupno().doubleValue() : ts.getUkupno());
                    t.getPrijemnica().getStavke().add(ps);
                    ts.setStavkaPrijemnice(ps);
                    totalBPdv += ps.getVrednost().doubleValue();
                    if (this.hasap.booleanValue()) {
                        ps.setHacapTemp(ts.getHacapTemp());
                        ps.setUsaglaseno(ts.getUsaglaseno());
                        ps.setHacapMagacin(ts.getHacapMagacin());
                        ps.setKorektivnaMera(ts.getKorektivnaMera());
                    }
                }
                ts.setTrebovanje(t);
            }
            if (t.getPrijemnica() != null) {
                t.getPrijemnica().setTotal(StatLogic.round(totalBPdv, 2));
            }
            try {
                if (this.input.getId() == null) {
                    this.server.addTrebovanjeJPA(t);
                } else {
                    this.server.updateTrebovanje(t);
                }
                if (upozorenje) {
                    MessageDialog.openInformation((Shell)this.shell, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("TEXT_NEMOGUCE_PRONACI_PRIJEMNICU_VEZANU_ZA_TREBOVANJE"), new Object[0]));
                }
                return true;
            }
            catch (Exception e) {
                Logger.getLogger(UpravljanjeTrebovanjem.class.getName()).log(Level.WARNING, e.getMessage(), e);
                MessageDialog.openWarning((Shell)this.shell, (String)String.format(this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PAMCENJA_DOKUMENTA"), new Object[0]));
            }
        }
        catch (InputException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    private void loadData() {
        if (this.input != null) {
            if (this.ulazno == null) {
                this.ulazno = this.input.getU();
            }
            if (this.izlazno == null) {
                this.izlazno = this.input.getIz();
            }
            this.crno.setSelection(this.input.getCrno() != null && this.input.getCrno() != false);
            this.stavke = new LinkedList<TrebovanjeStavka>(this.input.getStavke());
            if (!this.pregled) {
                Collections.sort(this.stavke, psComp);
                boolean hasRBNull = false;
                for (TrebovanjeStavka ps : this.stavke) {
                    if (ps.getRedniBroj() == null) {
                        hasRBNull = true;
                        ps.setRedniBroj(Integer.MAX_VALUE);
                    }
                    if (hasRBNull) continue;
                    this.nextRB = ps.getRedniBroj() + 1;
                }
                if (hasRBNull) {
                    Collections.sort(this.stavke, psComp);
                    this.nextRB = 1;
                    for (TrebovanjeStavka ps : this.stavke) {
                        ps.setRedniBroj(this.nextRB);
                        ++this.nextRB;
                    }
                }
            } else {
                Collections.sort(this.stavke, psComp);
            }
            this.datum.setResult(this.input.getDatumTrebovanja());
            this.datum2.setResult(this.input.getDatumUnosa());
            this.valutaPlacanja.setResult(this.input.getDatumValute() != null ? this.input.getDatumValute() : this.input.getDatumTrebovanja());
            this.opis.setText(this.input.getOpis() == null ? "" : this.input.getOpis());
            if (this.oznakaDokumenta != null) {
                this.oznakaDokumenta.setText(this.input.getPrijemnica() == null || this.input.getPrijemnica().getOznakaDokumenta() == null ? "" : this.input.getPrijemnica().getOznakaDokumenta());
            }
            if (this.hasap.booleanValue()) {
                this.hasVreme.setResult(this.input.getHacapVreme() == null ? "" : this.input.getHacapVreme());
                this.hasReg.setResult(this.input.getRegOznaka() == null ? "" : this.input.getRegOznaka());
                this.hasKontr.setResult(this.input.getKontrolisao() == null ? "" : this.input.getKontrolisao());
            }
            this.updateTotal();
        } else {
            this.input = new Trebovanje();
            if (this.type.isKnjizenje()) {
                this.input.setPrijemnica(new Prijemnica());
            }
        }
        this.loadDobavljace();
    }

    private void loadDobavljace() {
        if (this.dobavljac != null) {
            this.dobavljac.removeAll();
            int idxDob = -1;
            for (int i = 0; i < this.dobavljaci.size(); ++i) {
                StalniGost sg = this.dobavljaci.get(i);
                this.dobavljac.add(sg.getSkrNaziv());
                System.out.println("sg = " + sg);
                if (this.input == null || this.input.getDobavljac() == null || this.input.getDobavljac().getId() != sg.getId()) continue;
                idxDob = i;
            }
            if (idxDob >= 0) {
                this.dobavljac.select(idxDob);
            } else if (!this.dobavljaci.isEmpty()) {
                this.dobavljac.select(0);
            }
            this.dobavljac.update();
        }
    }

    private void updateTotal() {
        this.ukupnaVred = 0.0;
        for (TrebovanjeStavka ts : this.stavke) {
            this.ukupnaVred += ts.getVrednost().doubleValue();
        }
        this.total.setText(StatLogic.getNumber02(this.ukupnaVred));
        this.total.update();
    }

    private void fillInMap(List<Artikal> artikli) {
        HashSet<BObject> set;
        this.mapaGrupa = new HashMap<GrupaArtikala, Set<PodgrupaArtikala>>();
        this.mapaPodgrupa = new HashMap<PodgrupaArtikala, Set<Artikal>>();
        for (Artikal a : artikli) {
            if (!a.getOdeljenja().contains(this.type.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI ? this.ulazno : this.izlazno)) continue;
            if (this.mapaPodgrupa.containsKey(a.getPodgrupa())) {
                this.mapaPodgrupa.get(a.getPodgrupa()).add(a);
                continue;
            }
            set = new HashSet();
            set.add(a);
            this.mapaPodgrupa.put(a.getPodgrupa(), set);
        }
        for (PodgrupaArtikala pg : this.mapaPodgrupa.keySet()) {
            if (this.mapaGrupa.containsKey(pg.getGrupa())) {
                this.mapaGrupa.get(pg.getGrupa()).add(pg);
                continue;
            }
            set = new HashSet<BObject>();
            set.add(pg);
            this.mapaGrupa.put(pg.getGrupa(), set);
        }
    }

    private StalniGost getDobavljac() {
        if (this.dobavljac != null && this.dobavljaci != null && this.dobavljac.getSelectionIndex() > -1 && this.dobavljac.getSelectionIndex() < this.dobavljaci.size()) {
            return this.dobavljaci.get(this.dobavljac.getSelectionIndex());
        }
        return null;
    }

    public void unosStavkeTrebovanja(Shell shell, Table table, TrebovanjeStavka ts, TipTrebovanja tip) {
        if (!this.checkDobavljac()) {
            return;
        }
        boolean isPoljogazdistvo = this.getDobavljac() != null ? (this.getDobavljac().getPoljoGazdinstvo() != null ? this.getDobavljac().getPoljoGazdinstvo() : false) : false;
        UnosStavkeTrebovanja ust = new UnosStavkeTrebovanja(this.type.getTipDokumenta() != TipTrebovanja.DokumentAtribut.ULAZNI || this.getDobavljac() == null ? null : this.getDobavljac().getPoreskiObveznik(), ts, isPoljogazdistvo, tip);
        if (ust.getResult() != null) {
            ust.getResult().getArtikal().setTrenutnaNV(BigDecimal.valueOf(ust.getResult().getKomad() / ((100.0 + ust.getResult().getPdvStopa()) / 100.0)).setScale(2, RoundingMode.HALF_EVEN).doubleValue());
            ust.getResult().setRedniBroj(this.nextRB);
            ++this.nextRB;
            this.stavke.add(ust.getResult());
            Collections.sort(this.stavke, psComp);
            this.stavkeTV.refresh();
            this.stavkeTV.setSelection((ISelection)new StructuredSelection((Object)ust.getResult()), true);
            this.updateTotal();
        }
    }

    private void addArtikal() throws FiscalException, SerialIOException {
        Odeljenje odeljenje = this.ulazno;
        Shell shell2 = new Shell(this.shell);
        ArtikalDialog ad = new ArtikalDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVOG_ARTIKLA"), new Object[0])), this.restoran, null, odeljenje, true);
        if (ad.getResult() != null) {
            Artikal a = ad.getResult();
            try {
                a = this.server.addArtikal2JPAMerge(a);
            }
            catch (Exception e) {
                SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)"Do\u0161lo je do gre\u0161ke prilikom kreiranja artikla ");
                return;
            }
            for (Odeljenje o : a.getOdeljenja()) {
                if (!o.containsArtikal(a)) {
                    o.getArtikli().add(a);
                }
                try {
                    this.server.updateOdeljenje(o);
                }
                catch (Exception e) {
                    SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)"Do\u0161lo je do gre\u0161ke prilikom kreiranja artikla ");
                    return;
                }
            }
            if (ad.getResult2() != null) {
                for (Normativ norm : ad.getResult2()) {
                    norm.setArtikal(a);
                    try {
                        this.server.addNormativJPAPersist(norm);
                    }
                    catch (Exception e) {
                        SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)"Do\u0161lo je do gre\u0161ke prilikom kreiranja artikla ");
                        return;
                    }
                }
            }
            this.reloadArtikle(null);
        }
    }

    private void reloadArtikle(List<Artikal> sviArtikli) {
        if (sviArtikli == null) {
            this.artikliSvi = this.server.findAllArticlesNoComplexNoBlocked(this.ulazno, this.izlazno);
            this.artAll = new LinkedList<Artikal>(this.artikliSvi);
        } else {
            this.artikliSvi = sviArtikli;
            this.artAll = new LinkedList<Artikal>();
            for (Artikal art : this.artikliSvi) {
                if (this.ulazno != null && !art.getOdeljenja().contains(this.ulazno) || this.izlazno != null && !art.getOdeljenja().contains(this.izlazno)) continue;
                this.artAll.add(art);
            }
        }
        this.fillInMap(this.artAll);
    }

    private boolean checkDobavljac() {
        if (this.dobavljac != null && this.dobavljac.getSelectionIndex() < 0) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_MORATE_IZABRATI_DOBAVLJACA"), new Object[0]));
            return false;
        }
        return true;
    }

    public void addEditor2(final Table table) {
        table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                System.out.println("Cena");
                UpravljanjeTrebovanjem.this.item = (TableItem)event.item;
                UpravljanjeTrebovanjem.this.indexOfSelected = table.indexOf(UpravljanjeTrebovanjem.this.item);
                UpravljanjeTrebovanjem.this.selectNextRowCena(UpravljanjeTrebovanjem.this.item, table);
                UpravljanjeTrebovanjem.this.selection = true;
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                System.out.println("selection");
                UpravljanjeTrebovanjem.this.item = (TableItem)e.item;
                UpravljanjeTrebovanjem.this.indexOfSelected = table.indexOf(UpravljanjeTrebovanjem.this.item);
                UpravljanjeTrebovanjem.this.selectNextRow(UpravljanjeTrebovanjem.this.item, table);
                UpravljanjeTrebovanjem.this.selection = true;
            }
        });
    }

    protected void selectNextRowCena(TableItem ti, final Table table) {
        if (ti != null) {
            table.setSelection(ti);
        } else {
            table.setSelection(-1);
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.previousItem = this.editor.getItem();
        }
        if (this.item == null) {
            return;
        }
        Text newEditor = new Text((Composite)table, 0);
        newEditor.setText(this.item.getText(4));
        final Double oldCena = StatLogic.parseNumber04Suppress(this.item.getText(4)).doubleValue();
        System.out.println("CENA je " + this.item.getText(4));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text text = (Text)UpravljanjeTrebovanjem.this.editor.getEditor();
                if (!text.getText().isEmpty()) {
                    UpravljanjeTrebovanjem.this.editor.getItem().setText(4, StatLogic.getNumber04NG(StatLogic.parseDouble04Suppress(text.getText())));
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, this.item, 4);
        Listener list = new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 0x1000002 && e.type == 2) {
                    table.showSelection();
                    UpravljanjeTrebovanjem.this.indexOfSelected++;
                    double razlika = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(4)).doubleValue();
                    UpravljanjeTrebovanjem.this.item.setText(4, StatLogic.getNumber04NG(razlika));
                    e.widget.dispose();
                    UpravljanjeTrebovanjem.this.item = UpravljanjeTrebovanjem.this.item.getParent().getItem(UpravljanjeTrebovanjem.this.indexOfSelected);
                    UpravljanjeTrebovanjem.this.item.getParent().select(UpravljanjeTrebovanjem.this.indexOfSelected);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (UpravljanjeTrebovanjem.this.selection) {
                        UpravljanjeTrebovanjem.this.selection = false;
                        return;
                    }
                    if (e.type == 31) {
                        return;
                    }
                    if (e.type != 2) {
                        return;
                    }
                    System.out.println("enter brate");
                    Control oldEditor = UpravljanjeTrebovanjem.this.editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    Double kolicina = (double)StatLogic.parseDouble04Suppress(UpravljanjeTrebovanjem.this.item.getText(2));
                    Double novaCENA = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(4)).doubleValue();
                    Double CPJsPDV = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(5)).doubleValue();
                    Double CUbezPDV = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(6)).doubleValue();
                    Double CUsPDV = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(7)).doubleValue();
                    Double CsaRab = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(9)).doubleValue();
                    Double novasPDV = CPJsPDV / oldCena * novaCENA;
                    Double novaCbezPDV = kolicina * novaCENA;
                    Double novaCsaPDV = novasPDV * kolicina;
                    Double novaCsaRab = CsaRab / oldCena * novaCENA;
                    UpravljanjeTrebovanjem.this.item.setText(5, StatLogic.getNumber04NG(novasPDV));
                    UpravljanjeTrebovanjem.this.item.setText(6, StatLogic.getNumber04NG(novaCbezPDV));
                    UpravljanjeTrebovanjem.this.item.setText(7, StatLogic.getNumber04(novaCsaPDV));
                    UpravljanjeTrebovanjem.this.item.setText(9, StatLogic.getNumber04(novaCsaRab));
                    UpravljanjeTrebovanjem.this.inputStavka = (TrebovanjeStavka)UpravljanjeTrebovanjem.this.stavke.get(UpravljanjeTrebovanjem.this.stavkeTable.getSelectionIndex());
                    UpravljanjeTrebovanjem.this.inputStavka.setKomadBPDV(novaCENA);
                    UpravljanjeTrebovanjem.this.inputStavka.setKomad(novasPDV);
                    UpravljanjeTrebovanjem.this.inputStavka.setUkupnoBPDV(novaCbezPDV);
                    UpravljanjeTrebovanjem.this.inputStavka.setUkupno(novaCsaPDV);
                    UpravljanjeTrebovanjem.this.inputStavka.setKomBPDVsaRbt(novaCsaRab);
                    if (UpravljanjeTrebovanjem.this.input.getId() != null) {
                        UpravljanjeTrebovanjem.this.server.updateStavka(UpravljanjeTrebovanjem.this.inputStavka);
                    }
                    UpravljanjeTrebovanjem.this.stavkeTV.refresh(true, true);
                    UpravljanjeTrebovanjem.this.updateTotal();
                } else if (e.keyCode == 0x1000001 && e.type == 2) {
                    table.showSelection();
                    double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(4)).doubleValue();
                    UpravljanjeTrebovanjem.this.item.setText(4, StatLogic.getNumber04NG(novaKolicina));
                    e.widget.dispose();
                    UpravljanjeTrebovanjem.this.item = UpravljanjeTrebovanjem.this.item.getParent().getItem(UpravljanjeTrebovanjem.this.indexOfSelected);
                    UpravljanjeTrebovanjem.this.item.getParent().select(UpravljanjeTrebovanjem.this.indexOfSelected);
                } else {
                    if (e.keyCode == 9 && e.type == 31 && (e.stateMask & 0x10000) != 0) {
                        return;
                    }
                    if (e.keyCode == 9 && e.type == 31) {
                        System.out.println("tab brate");
                        table.showSelection();
                        double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(4)).doubleValue();
                        UpravljanjeTrebovanjem.this.item.setText(4, StatLogic.getNumber04NG(novaKolicina));
                    } else {
                        if (e.type == 31 && e.keyCode == 27) {
                            if (UpravljanjeTrebovanjem.this.item != null && !UpravljanjeTrebovanjem.this.editor.getEditor().isDisposed()) {
                                table.showSelection();
                                double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(4)).doubleValue();
                                UpravljanjeTrebovanjem.this.item.setText(4, StatLogic.getNumber04NG(novaKolicina));
                                e.widget.dispose();
                                UpravljanjeTrebovanjem.this.item = null;
                            }
                            e.doit = false;
                            return;
                        }
                        if (e.type == 31) {
                            e.doit = false;
                            return;
                        }
                    }
                }
            }
        };
        newEditor.addListener(2, list);
        newEditor.addListener(31, list);
    }

    private void selectNextRow(TableItem ti, final Table table) {
        if (ti != null) {
            table.setSelection(ti);
        } else {
            table.setSelection(-1);
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.previousItem = this.editor.getItem();
        }
        if (this.item == null) {
            return;
        }
        Text newEditor = new Text((Composite)table, 0);
        newEditor.setText(this.item.getText(2));
        final Double oldKolicina = StatLogic.parseNumber04Suppress(this.item.getText(2)).doubleValue();
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text text = (Text)UpravljanjeTrebovanjem.this.editor.getEditor();
                if (!text.getText().isEmpty()) {
                    UpravljanjeTrebovanjem.this.editor.getItem().setText(2, StatLogic.getNumber04NG(StatLogic.parseDouble04Suppress(text.getText())));
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, this.item, 2);
        Listener list = new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 0x1000002 && e.type == 2) {
                    table.showSelection();
                    UpravljanjeTrebovanjem.this.indexOfSelected++;
                    double razlika = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(2)).doubleValue();
                    UpravljanjeTrebovanjem.this.item.setText(2, StatLogic.getNumber04NG(razlika));
                    e.widget.dispose();
                    if (UpravljanjeTrebovanjem.this.indexOfSelected < UpravljanjeTrebovanjem.this.item.getParent().getItemCount()) {
                        UpravljanjeTrebovanjem.this.item = UpravljanjeTrebovanjem.this.item.getParent().getItem(UpravljanjeTrebovanjem.this.indexOfSelected);
                        UpravljanjeTrebovanjem.this.item.getParent().select(UpravljanjeTrebovanjem.this.indexOfSelected);
                    }
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (UpravljanjeTrebovanjem.this.selection) {
                        UpravljanjeTrebovanjem.this.selection = false;
                        return;
                    }
                    if (e.type == 31) {
                        return;
                    }
                    if (e.type != 2) {
                        return;
                    }
                    System.out.println("enter brate");
                    Control oldEditor = UpravljanjeTrebovanjem.this.editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    Double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(2)).doubleValue();
                    Double CbPDV = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(6)).doubleValue();
                    Double CsPDV = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(7)).doubleValue();
                    Double CsaRab = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(9)).doubleValue();
                    Double novaCbezPDV = CbPDV / oldKolicina * novaKolicina;
                    Double novaCsaPDV = CsPDV / oldKolicina * novaKolicina;
                    Double novaCsaRab = CsaRab / oldKolicina * novaKolicina;
                    UpravljanjeTrebovanjem.this.item.setText(2, StatLogic.getNumber04NG(novaKolicina));
                    UpravljanjeTrebovanjem.this.item.setText(6, StatLogic.getNumber04NG(novaCbezPDV));
                    UpravljanjeTrebovanjem.this.item.setText(7, StatLogic.getNumber04(novaCsaPDV));
                    UpravljanjeTrebovanjem.this.item.setText(9, StatLogic.getNumber04(novaCsaRab));
                    UpravljanjeTrebovanjem.this.inputStavka = (TrebovanjeStavka)UpravljanjeTrebovanjem.this.stavke.get(UpravljanjeTrebovanjem.this.stavkeTable.getSelectionIndex());
                    UpravljanjeTrebovanjem.this.inputStavka.setKolicina(novaKolicina);
                    UpravljanjeTrebovanjem.this.inputStavka.setUkupnoBPDV(novaCbezPDV);
                    UpravljanjeTrebovanjem.this.inputStavka.setUkupno(novaCsaPDV);
                    UpravljanjeTrebovanjem.this.inputStavka.setKomBPDVsaRbt(novaCsaRab);
                    if (UpravljanjeTrebovanjem.this.input.getId() != null) {
                        UpravljanjeTrebovanjem.this.server.updateStavka(UpravljanjeTrebovanjem.this.inputStavka);
                    }
                    UpravljanjeTrebovanjem.this.stavkeTV.refresh(true, true);
                    UpravljanjeTrebovanjem.this.updateTotal();
                } else if (e.keyCode == 0x1000001 && e.type == 2) {
                    table.showSelection();
                    double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(2)).doubleValue();
                    UpravljanjeTrebovanjem.this.item.setText(2, StatLogic.getNumber04NG(novaKolicina));
                    e.widget.dispose();
                    UpravljanjeTrebovanjem.this.item = UpravljanjeTrebovanjem.this.item.getParent().getItem(UpravljanjeTrebovanjem.this.indexOfSelected);
                    UpravljanjeTrebovanjem.this.item.getParent().select(UpravljanjeTrebovanjem.this.indexOfSelected);
                } else {
                    if (e.keyCode == 9 && e.type == 31 && (e.stateMask & 0x10000) != 0) {
                        return;
                    }
                    if (e.keyCode == 9 && e.type == 31) {
                        System.out.println("tab brate");
                        table.showSelection();
                        double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(2)).doubleValue();
                        UpravljanjeTrebovanjem.this.item.setText(2, StatLogic.getNumber04NG(novaKolicina));
                    } else {
                        if (e.type == 31 && e.keyCode == 27) {
                            if (UpravljanjeTrebovanjem.this.item != null && !UpravljanjeTrebovanjem.this.editor.getEditor().isDisposed()) {
                                table.showSelection();
                                double novaKolicina = StatLogic.parseNumber04Suppress(UpravljanjeTrebovanjem.this.item.getText(2)).doubleValue();
                                UpravljanjeTrebovanjem.this.item.setText(2, StatLogic.getNumber04NG(novaKolicina));
                                e.widget.dispose();
                                UpravljanjeTrebovanjem.this.item = null;
                            }
                            e.doit = false;
                            return;
                        }
                        if (e.type == 31) {
                            e.doit = false;
                            return;
                        }
                    }
                }
            }
        };
        newEditor.addListener(2, list);
        newEditor.addListener(31, list);
    }

    private class UnosStavkeTrebovanja {
        private TipTrebovanja tip;
        private TrebovanjeStavka result = null;
        private Double priceWoVAT = 0.0;
        private Double raba = 0.0;
        private Double vrednosSaRabatom = 0.0;
        private Double unitVAT = 0.0;
        private Double priceWVAT = 0.0;
        private Double valueWoVAT = 0.0;
        private Double totalVAT = 0.0;
        private Double valueWVAT = 0.0;
        private Double quantity = 0.0;
        private List<ObjectWrapper> stope;
        private boolean osam;
        private TextInput2 hasTemp;
        private Button hasUsagl;
        private Combo hasMagacini;
        private TextInput2 hasKorekt;
        private List<HacapMagacini> hMagacini;
        private Boolean nabavnaCenaUSirovini;

        public UnosStavkeTrebovanja(Boolean dobavljacUPDV, final TrebovanjeStavka trs, boolean osam, TipTrebovanja tip) {
            this.osam = osam;
            this.tip = tip;
            final Shell shell2 = new Shell(UpravljanjeTrebovanjem.this.shell, 34912);
            shell2.setBackgroundMode(1);
            shell2.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_NOVA_STAVKA"), new Object[0]));
            shell2.setLayout((Layout)new GridLayout(UpravljanjeTrebovanjem.this.hasap != false ? 3 : 2, false));
            this.nabavnaCenaUSirovini = UpravljanjeTrebovanjem.this.server.getSetting(Option.NAB_CENA_KALKULACIJA_SIROVINA).booleanValue();
            Composite c1 = new Composite((Composite)shell2, 0);
            c1.setLayout((Layout)new FillLayout());
            GridData data = new GridData(1040);
            data.widthHint = 250;
            c1.setLayoutData((Object)data);
            Composite c2 = new Composite((Composite)shell2, 0);
            c2.setLayout((Layout)new GridLayout(2, false));
            data = new GridData(1040);
            data.widthHint = 360;
            c2.setLayoutData((Object)data);
            Composite c3 = null;
            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                c3 = new Composite((Composite)shell2, 2048);
                c3.setLayout((Layout)new GridLayout(1, false));
                data = new GridData(1040);
                data.widthHint = 180;
                c3.setLayoutData((Object)data);
                this.hMagacini = new ArrayList<HacapMagacini>();
                this.hMagacini = UpravljanjeTrebovanjem.this.server.readHacapMagacine();
            }
            final Tree tree = new Tree(c1, 2562);
            tree.setFont(Konstante.getFont(UpravljanjeTrebovanjem.this.shell.getDisplay(), 8, 0));
            for (GrupaArtikala ga : UpravljanjeTrebovanjem.this.mapaGrupa.keySet()) {
                TreeItem item0 = new TreeItem(tree, 0);
                item0.setText(ga.getNaziv());
                for (PodgrupaArtikala pa : (Set)UpravljanjeTrebovanjem.this.mapaGrupa.get(ga)) {
                    TreeItem item1 = new TreeItem(item0, 0);
                    item1.setText(pa.getNaziv());
                    for (Object a : (Set)UpravljanjeTrebovanjem.this.mapaPodgrupa.get(pa)) {
                        TreeItem item2 = new TreeItem(item1, 0);
                        item2.setText(((Artikal)a).getName());
                    }
                }
            }
            tree.setBounds(0, 0, 100, 100);
            tree.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String string = "";
                    int index = -1;
                    TreeItem[] selection = tree.getSelection();
                    for (int i = 0; i < selection.length; ++i) {
                        string = string + selection[i].getText();
                        if (selection[i].getItems().length != 0) continue;
                        UpravljanjeTrebovanjem.this.pretraga.setText("");
                        UpravljanjeTrebovanjem.this.artikal.removeAll();
                        UpravljanjeTrebovanjem.this.artikliC.clear();
                        for (Set set : UpravljanjeTrebovanjem.this.mapaPodgrupa.values()) {
                            for (Artikal a : set) {
                                UpravljanjeTrebovanjem.this.artikal.add(a.getName());
                                UpravljanjeTrebovanjem.this.artikliC.put(a.getName(), a);
                                if (!a.getName().equalsIgnoreCase(string)) continue;
                                index = UpravljanjeTrebovanjem.this.artikal.getItemCount() - 1;
                            }
                        }
                        break;
                    }
                    if (index > -1) {
                        UpravljanjeTrebovanjem.this.artikal.select(index);
                        UpravljanjeTrebovanjem.this.artikalI = (Artikal)UpravljanjeTrebovanjem.this.artikliC.get(UpravljanjeTrebovanjem.this.artikal.getItem(UpravljanjeTrebovanjem.this.artikal.getSelectionIndex()));
                        UnosStavkeTrebovanja.this.insertDataArtikal();
                    }
                }
            });
            final SWTContainer parent2 = new SWTContainer(c2);
            Font font = FontCache.getFont(UpravljanjeTrebovanjem.this.fontName, 7, 0);
            Label pk2 = new Label(c2, 0);
            pk2.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_STANJE"), new Object[0]) + " (" + (UpravljanjeTrebovanjem.this.type.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI ? UpravljanjeTrebovanjem.this.ulazno.getNaziv().toLowerCase() : UpravljanjeTrebovanjem.this.izlazno.getNaziv()) + ")");
            UpravljanjeTrebovanjem.this.preostalaKol2 = new Label(c2, 0);
            pk2.setFont(font);
            UpravljanjeTrebovanjem.this.preostalaKol2.setFont(font);
            Label p = new Label(c2, 0);
            p.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_PRETRAGA"), new Object[0]) + ":");
            p.setFont(font);
            UpravljanjeTrebovanjem.this.pretraga = new Text(c2, 2048);
            UpravljanjeTrebovanjem.this.pretraga.forceFocus();
            UpravljanjeTrebovanjem.this.pretraga.addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    if (e.keyCode != 13 && e.keyCode != 0x1000050) {
                        return;
                    }
                    String str = UpravljanjeTrebovanjem.this.pretraga.getText();
                    UpravljanjeTrebovanjem.this.artikal.removeAll();
                    UpravljanjeTrebovanjem.this.artikliC.clear();
                    for (Set set : UpravljanjeTrebovanjem.this.mapaPodgrupa.values()) {
                        for (Artikal a : set) {
                            if ((a.getName() == null || !a.getName().toLowerCase().contains(str.toLowerCase())) && (a.getBarCode() == null || !a.getBarCode().toLowerCase().contains(str.toLowerCase()))) continue;
                            UpravljanjeTrebovanjem.this.artikal.add(a.getName());
                            UpravljanjeTrebovanjem.this.artikliC.put(a.getName(), a);
                        }
                    }
                    if (UpravljanjeTrebovanjem.this.artikal.getItemCount() > 0) {
                        UpravljanjeTrebovanjem.this.artikal.select(0);
                        UpravljanjeTrebovanjem.this.artikalI = (Artikal)UpravljanjeTrebovanjem.this.artikliC.get(UpravljanjeTrebovanjem.this.artikal.getItem(UpravljanjeTrebovanjem.this.artikal.getSelectionIndex()));
                        UnosStavkeTrebovanja.this.insertDataArtikal();
                    }
                }
            });
            Label a = new Label(c2, 0);
            a.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
            a.setFont(font);
            UpravljanjeTrebovanjem.this.artikal = new Combo(c2, 2572);
            for (Set set : UpravljanjeTrebovanjem.this.mapaPodgrupa.values()) {
                for (Artikal art : set) {
                    UpravljanjeTrebovanjem.this.artikal.add(art.getName());
                    UpravljanjeTrebovanjem.this.artikliC.put(art.getName(), art);
                }
            }
            if (UpravljanjeTrebovanjem.this.artikal.getItemCount() > 0) {
                UpravljanjeTrebovanjem.this.artikal.select(0);
            }
            UpravljanjeTrebovanjem.this.artikal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    UpravljanjeTrebovanjem.this.artikalI = (Artikal)UpravljanjeTrebovanjem.this.artikliC.get(UpravljanjeTrebovanjem.this.artikal.getItem(UpravljanjeTrebovanjem.this.artikal.getSelectionIndex()));
                    UnosStavkeTrebovanja.this.insertDataArtikal();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    UpravljanjeTrebovanjem.this.artikalI = (Artikal)UpravljanjeTrebovanjem.this.artikliC.get(UpravljanjeTrebovanjem.this.artikal.getItem(UpravljanjeTrebovanjem.this.artikal.getSelectionIndex()));
                    UnosStavkeTrebovanja.this.insertDataArtikal();
                }
            });
            UpravljanjeTrebovanjem.this.kolicinaLabel = new Label(c2, 0);
            UpravljanjeTrebovanjem.this.kolicinaLabel.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + ":");
            UpravljanjeTrebovanjem.this.kolicinaLabel.setFont(font);
            Label pd = new Label(c2, 0);
            pd.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_PORESKA_STOPA"), new Object[0]) + ":");
            pd.setFont(font);
            UpravljanjeTrebovanjem.this.kolicina = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]), false, 3);
            UpravljanjeTrebovanjem.this.kolicina.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            UpravljanjeTrebovanjem.this.pdvC = new Combo(c2, 2572);
            if (!osam && dobavljacUPDV != null && !dobavljacUPDV.booleanValue()) {
                this.stope = new LinkedList<ObjectWrapper>();
                PoreskaStopa ps = PoreskeStope.getDefaultNonVatStopa();
                this.stope.add(new ObjectWrapper(ps.getPg(), ps.getNaziv(), (int)Math.round(ps.getStopa())));
                UpravljanjeTrebovanjem.this.pdvC.setEnabled(false);
            } else if (osam) {
                UpravljanjeTrebovanjem.this.pdvC.add("8%");
                UpravljanjeTrebovanjem.this.pdvC.setEnabled(false);
            } else {
                this.stope = new LinkedList<ObjectWrapper>(UpravljanjeTrebovanjem.this.stope);
            }
            if (!osam) {
                for (ObjectWrapper stopa : this.stope) {
                    UpravljanjeTrebovanjem.this.pdvC.add(stopa.getPercent() + "%");
                }
            }
            UpravljanjeTrebovanjem.this.pdvC.select(0);
            UpravljanjeTrebovanjem.this.pdvC.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            Label ck = new Label(c2, 0);
            ck.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_CENA_BEZ_PDVA"), new Object[0]) + ":");
            ck.setFont(font);
            Label ck2 = new Label(c2, 0);
            ck2.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_CENA_SA_PDVOM"), new Object[0]) + ":");
            ck2.setFont(font);
            UpravljanjeTrebovanjem.this.cenaKomad = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_CENA_BEZ_PDVA"), new Object[0]), false, 4);
            UpravljanjeTrebovanjem.this.cenaKomad.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            UpravljanjeTrebovanjem.this.cenaKomad2 = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_CENA_SA_PDVOM"), new Object[0]), false, 4);
            UpravljanjeTrebovanjem.this.cenaKomad2.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            Label rab = new Label(c2, 0);
            rab.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_RABAT"), new Object[0]) + ":");
            rab.setFont(font);
            Label csr = new Label(c2, 0);
            csr.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_CENA_SA_RABATOM"), new Object[0]) + ":");
            csr.setFont(font);
            UpravljanjeTrebovanjem.this.rabat = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_RABAT"), new Object[0]), (Double)0.0);
            UpravljanjeTrebovanjem.this.rabat.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            UpravljanjeTrebovanjem.this.cenarabat = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_CENA_SA_RABATOM"), new Object[0]), (Double)0.0);
            UpravljanjeTrebovanjem.this.cenarabat.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            Label nv = new Label(c2, 0);
            nv.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_UKUPNO_BEZ_PDVA"), new Object[0]) + ":");
            nv.setFont(font);
            Label nv2 = new Label(c2, 0);
            nv2.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_UKUPNO_SA_PDVOM"), new Object[0]) + ":");
            nv2.setFont(font);
            UpravljanjeTrebovanjem.this.nabVrednost = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_UKUPNO_BEZ_PDVA"), new Object[0]), false, 4);
            UpravljanjeTrebovanjem.this.nabVrednost.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjeTrebovanjem.this.nabVrednost.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjeTrebovanjem.this.nabVrednost.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            UpravljanjeTrebovanjem.this.nabVrednost2 = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_UKUPNO_SA_PDVOM"), new Object[0]), false, 4);
            UpravljanjeTrebovanjem.this.nabVrednost2.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjeTrebovanjem.this.nabVrednost2.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjeTrebovanjem.this.nabVrednost2.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.updatePriceFields(e.widget);
                }
            });
            Label nca = new Label(c2, 0);
            nca.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_PRODAJNA_CENA"), new Object[0]) + ":");
            nca.setFont(font);
            Label nma = new Label(c2, 0);
            nma.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_MARZA"), new Object[0]) + "%:");
            nma.setFont(font);
            UpravljanjeTrebovanjem.this.prodCena = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_PRODAJNA_CENA"), new Object[0]), false);
            UpravljanjeTrebovanjem.this.prodCena.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjeTrebovanjem.this.prodCena.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjeTrebovanjem.this.prodCena.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.insertPrice();
                }
            });
            UpravljanjeTrebovanjem.this.marza = new DoubleInput2(parent2, String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_MARZA"), new Object[0]), (Double)0.0);
            UpravljanjeTrebovanjem.this.marza.getControl().setForeground(shell2.getDisplay().getSystemColor(3));
            UpravljanjeTrebovanjem.this.marza.getControl().setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
            UpravljanjeTrebovanjem.this.marza.getControl().addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    Pattern p = Pattern.compile("[0-9\\.\b\\s]{1,1}");
                    if (!p.matcher("" + e.character).matches()) {
                        return;
                    }
                    UnosStavkeTrebovanja.this.insertMargin();
                }
            });
            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                SWTContainer parent3 = new SWTContainer(c3);
                data = new GridData();
                data.widthHint = 130;
                data.heightHint = 20;
                data.horizontalAlignment = 16384;
                data.verticalIndent = 10;
                Label lTemp = new Label(c3, 0);
                lTemp.setText(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_TEMPERATURA_NA_PRIJEMU") + ":");
                lTemp.setLayoutData((Object)data);
                this.hasTemp = new TextInput2(parent3, UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_TEMPERATURA_NA_PRIJEMU"));
                Label laznjak = new Label(c3, 0);
                laznjak.setLayoutData((Object)data);
                laznjak.setVisible(false);
                Label lUsagl = new Label(c3, 0);
                lUsagl.setText(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_USAGLASENO") + ":");
                lUsagl.setLayoutData((Object)data);
                this.hasUsagl = new Button(parent3.getComposite(), 32);
                this.hasUsagl.setSelection(true);
                Label lMag = new Label(c3, 0);
                lMag.setText(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_IZBOR_MAGACINA") + ":");
                lMag.setLayoutData((Object)data);
                this.hasMagacini = new Combo(parent3.getComposite(), 4);
                for (HacapMagacini hm : this.hMagacini) {
                    this.hasMagacini.add(hm.getNaziv());
                }
                this.hasMagacini.select(0);
                Label lKor = new Label(c3, 0);
                lKor.setText(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_KOREKTIVNA_MERA") + ":");
                lKor.setLayoutData((Object)data);
                this.hasKorekt = new TextInput2(parent3, UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_KOREKTIVNA_MERA"));
            }
            if (trs != null) {
                UpravljanjeTrebovanjem.this.pretraga.setText(trs.getArtikal().getName());
                UpravljanjeTrebovanjem.this.kolicina.setResult(trs.getKolicina());
                UpravljanjeTrebovanjem.this.pdvC.setText(Konstante.getNumber02(trs.getPdv()) + "%");
                this.priceWoVAT = trs.getKomadBPDV();
                UpravljanjeTrebovanjem.this.cenaKomad.setResult(trs.getKomadBPDV());
                UpravljanjeTrebovanjem.this.cenaKomad2.setResult(trs.getKomad());
                UpravljanjeTrebovanjem.this.rabat.setResult(trs.getRabat());
                UpravljanjeTrebovanjem.this.cenarabat.setResult(trs.getKomBPDVsaRbt());
                UpravljanjeTrebovanjem.this.nabVrednost.setResult(trs.getUkupnoBPDV());
                UpravljanjeTrebovanjem.this.nabVrednost2.setResult(trs.getUkupno());
                UpravljanjeTrebovanjem.this.prodCena.setResult(trs.getProdajnaVrednost());
                double margin = trs.getProdajnaVrednost() != null ? (trs.getProdajnaVrednost() / trs.getKomad() - 1.0) * 100.0 : 0.0;
                UpravljanjeTrebovanjem.this.marza.setResult(margin);
                String str = UpravljanjeTrebovanjem.this.pretraga.getText();
                UpravljanjeTrebovanjem.this.artikal.removeAll();
                UpravljanjeTrebovanjem.this.artikliC.clear();
                for (Set set : UpravljanjeTrebovanjem.this.mapaPodgrupa.values()) {
                    for (Artikal ar : set) {
                        if ((ar.getName() == null || !ar.getName().toLowerCase().contains(str.toLowerCase())) && (ar.getBarCode() == null || !ar.getBarCode().toLowerCase().contains(str.toLowerCase()))) continue;
                        UpravljanjeTrebovanjem.this.artikal.add(ar.getName());
                        UpravljanjeTrebovanjem.this.artikliC.put(ar.getName(), ar);
                    }
                }
                if (UpravljanjeTrebovanjem.this.artikal.getItemCount() > 0) {
                    UpravljanjeTrebovanjem.this.artikal.select(0);
                    UpravljanjeTrebovanjem.this.artikalI = (Artikal)UpravljanjeTrebovanjem.this.artikliC.get(UpravljanjeTrebovanjem.this.artikal.getItem(UpravljanjeTrebovanjem.this.artikal.getSelectionIndex()));
                }
                if (trs.getHacapTemp() != null && !trs.getHacapTemp().equals("") && trs.getHacapMagacin() != null) {
                    HacapMagacini hm = trs.getHacapMagacin();
                    UpravljanjeTrebovanjem.this.hasap = true;
                    this.hasTemp.setResult(trs.getHacapTemp());
                    this.hasUsagl.setSelection(trs.getUsaglaseno().booleanValue());
                    this.hasMagacini.select(this.hMagacini.indexOf(hm));
                    this.hasKorekt.setResult(trs.getKorektivnaMera());
                }
            }
            Button cancelButt = Dugmici.getCancelButton(c2);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    parent2.getControl().getShell().close();
                }
            });
            Button okButt = Dugmici.getOkButton(c2);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        if (trs != null) {
                            trs.setKolicina(UpravljanjeTrebovanjem.this.kolicina.getResult());
                            trs.setPdvStopa(UnosStavkeTrebovanja.this.getStopa());
                            trs.setKomad(UpravljanjeTrebovanjem.this.cenaKomad2.getResult());
                            trs.setKomadBPDV(UpravljanjeTrebovanjem.this.cenaKomad.getResult());
                            trs.setRabat(UpravljanjeTrebovanjem.this.rabat.getResult());
                            trs.setKomBPDVsaRbt(UpravljanjeTrebovanjem.this.cenarabat.getResult());
                            trs.setUkupno(UpravljanjeTrebovanjem.this.nabVrednost2.getResult());
                            trs.setUkupnoBPDV(UpravljanjeTrebovanjem.this.nabVrednost.getResult());
                            trs.setProdajnaVrednost(UpravljanjeTrebovanjem.this.prodCena.getResult());
                            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                                trs.setHacapTemp(UnosStavkeTrebovanja.this.hasTemp.getResult());
                                trs.setUsaglaseno(UnosStavkeTrebovanja.this.hasUsagl.getSelection());
                                trs.setHacapMagacin((HacapMagacini)UnosStavkeTrebovanja.this.hMagacini.get(UnosStavkeTrebovanja.this.hasMagacini.getSelectionIndex()));
                                trs.setKorektivnaMera(UnosStavkeTrebovanja.this.hasKorekt.getResult());
                            }
                            UpravljanjeTrebovanjem.this.prodajnaCena = UpravljanjeTrebovanjem.this.prodCena.getResult();
                            shell2.close();
                        } else {
                            UpravljanjeTrebovanjem.this.prodajnaCena = UpravljanjeTrebovanjem.this.prodCena.getResult();
                            Artikal art = (Artikal)UpravljanjeTrebovanjem.this.artikliC.get(UpravljanjeTrebovanjem.this.artikal.getItem(UpravljanjeTrebovanjem.this.artikal.getSelectionIndex()));
                            TrebovanjeStavka ts = new TrebovanjeStavka();
                            if (!UpravljanjeTrebovanjem.this.prodCena.getResult().equals(art.getCena())) {
                                art.setCena(UpravljanjeTrebovanjem.this.prodCena.getResult());
                                art = UpravljanjeTrebovanjem.this.server.updateArtikal(art);
                                UpravljanjeTrebovanjem.this.server.log("Azuriranje artikla, Artikal: " + art.getName() + ", kreirao/azurirao: " + UpravljanjeTrebovanjem.this.server.getUser().getName());
                            }
                            ts.setArtikalId(art);
                            ts.setKolicina(UpravljanjeTrebovanjem.this.kolicina.getResult());
                            ts.setPdvStopa(UnosStavkeTrebovanja.this.getStopa());
                            ts.setKomad(UpravljanjeTrebovanjem.this.cenaKomad2.getResult());
                            ts.setKomadBPDV(UpravljanjeTrebovanjem.this.cenaKomad.getResult());
                            ts.setRabat(UpravljanjeTrebovanjem.this.rabat.getResult());
                            ts.setKomBPDVsaRbt(UpravljanjeTrebovanjem.this.cenarabat.getResult());
                            ts.setUkupno(UpravljanjeTrebovanjem.this.nabVrednost2.getResult());
                            ts.setUkupnoBPDV(UpravljanjeTrebovanjem.this.nabVrednost.getResult());
                            ts.setProdajnaVrednost(UpravljanjeTrebovanjem.this.prodCena.getResult());
                            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                                if (UnosStavkeTrebovanja.this.hasMagacini.getSelectionIndex() < 0) {
                                    Konstante.getPoruka(shell2, "Niste uneli ni jedan HACCP magacin!");
                                    return;
                                }
                                ts.setHacapTemp(UnosStavkeTrebovanja.this.hasTemp.getResult());
                                ts.setUsaglaseno(UnosStavkeTrebovanja.this.hasUsagl.getSelection());
                                ts.setHacapMagacin((HacapMagacini)UnosStavkeTrebovanja.this.hMagacini.get(UnosStavkeTrebovanja.this.hasMagacini.getSelectionIndex()));
                                ts.setKorektivnaMera(UnosStavkeTrebovanja.this.hasKorekt.getResult());
                            }
                            UnosStavkeTrebovanja.this.result = ts;
                            shell2.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Konstante.getPoruka(shell2, ex.getMessage());
                    }
                }
            });
            GridLayout layout = new GridLayout(UpravljanjeTrebovanjem.this.hasap != false ? 3 : 2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell2.setLayout((Layout)layout);
            data = new GridData();
            data.widthHint = 120;
            data.heightHint = 20;
            data.horizontalAlignment = 16384;
            data.verticalIndent = 10;
            pk2.setLayoutData((Object)data);
            a.setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.kolicinaLabel.setLayoutData((Object)data);
            nv.setLayoutData((Object)data);
            nca.setLayoutData((Object)data);
            nma.setLayoutData((Object)data);
            nv2.setLayoutData((Object)data);
            rab.setLayoutData((Object)data);
            csr.setLayoutData((Object)data);
            ck.setLayoutData((Object)data);
            ck2.setLayoutData((Object)data);
            p.setLayoutData((Object)data);
            pd.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 120;
            data.heightHint = 25;
            data.horizontalAlignment = 16384;
            data.verticalIndent = 0;
            UpravljanjeTrebovanjem.this.kolicina.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.pretraga.setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.nabVrednost.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.nabVrednost2.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.rabat.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.cenarabat.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.prodCena.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.marza.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.cenaKomad.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.cenaKomad2.getControl().setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.artikal.setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.preostalaKol2.setLayoutData((Object)data);
            UpravljanjeTrebovanjem.this.pdvC.setLayoutData((Object)data);
            data.widthHint = 130;
            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                this.hasTemp.getControl().setLayoutData((Object)data);
            }
            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                this.hasUsagl.setLayoutData((Object)data);
            }
            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                this.hasMagacini.setLayoutData((Object)data);
            }
            if (UpravljanjeTrebovanjem.this.hasap.booleanValue()) {
                this.hasKorekt.getControl().setLayoutData((Object)data);
            }
            data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            okButt.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            cancelButt.setLayoutData((Object)data);
            shell2.pack();
            UpravljanjeTrebovanjem.this.pretraga.forceFocus();
            shell2.open();
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }

        public TrebovanjeStavka getResult() {
            return this.result;
        }

        private void updatePriceFields(Widget originatingControl) {
            this.reloadQuantity();
            if (UpravljanjeTrebovanjem.this.cenaKomad.getControl().equals(originatingControl)) {
                this.reloadPriceWoVat();
            } else if (UpravljanjeTrebovanjem.this.cenaKomad2.getControl().equals(originatingControl)) {
                this.reloadPriceWVat();
                this.priceWoVAT = this.priceWVAT / this.getVatCoeff();
            } else if (UpravljanjeTrebovanjem.this.nabVrednost.getControl().equals(originatingControl)) {
                this.reloadValueWoVat();
                this.priceWoVAT = this.quantity == null || this.quantity == 0.0 ? Double.valueOf(0.0) : Double.valueOf(this.valueWoVAT / this.quantity);
            } else if (UpravljanjeTrebovanjem.this.nabVrednost2.getControl().equals(originatingControl)) {
                this.reloadValueWVat();
                this.priceWoVAT = this.quantity == null || this.quantity == 0.0 ? Double.valueOf(0.0) : Double.valueOf(this.valueWVAT / this.getVatCoeff() / this.quantity);
            } else if (UpravljanjeTrebovanjem.this.nabVrednost.getControl().equals(originatingControl)) {
                this.reloadValueWoVat();
                this.reloadRabat();
                this.vrednosSaRabatom = this.quantity == null || this.quantity == 0.0 ? Double.valueOf(0.0) : Double.valueOf(this.valueWoVAT - this.valueWoVAT * this.raba / 100.0);
            }
            this.unitVAT = StatLogic.round(this.priceWoVAT * this.getVatValue(), 4);
            this.priceWVAT = StatLogic.round(this.priceWoVAT, 4) + this.unitVAT;
            this.valueWoVAT = this.priceWoVAT * this.quantity;
            this.totalVAT = StatLogic.round(this.valueWoVAT * this.getVatValue(), 4);
            this.valueWVAT = StatLogic.round(this.valueWoVAT, 4) + this.totalVAT;
            this.reloadRabat();
            this.vrednosSaRabatom = this.quantity == null || this.quantity == 0.0 ? Double.valueOf(0.0) : Double.valueOf(this.valueWoVAT - this.valueWoVAT * this.raba / 100.0);
            if (!UpravljanjeTrebovanjem.this.cenaKomad.getControl().equals(originatingControl)) {
                this.updatePriceWoVAT();
            }
            if (!UpravljanjeTrebovanjem.this.cenaKomad2.getControl().equals(originatingControl)) {
                this.updatePriceWVat();
            }
            if (!UpravljanjeTrebovanjem.this.nabVrednost.getControl().equals(originatingControl)) {
                this.updateValueWoVAT();
                this.updateValueSaRabatom();
            }
            if (!UpravljanjeTrebovanjem.this.nabVrednost2.getControl().equals(originatingControl)) {
                this.updateValueWVAT();
            }
            if (UpravljanjeTrebovanjem.this.artikalI.getTip() == TipArtikla.SIRO && this.nabavnaCenaUSirovini.booleanValue()) {
                UpravljanjeTrebovanjem.this.prodCena.setResult(this.priceWVAT);
            }
            this.updateMargin();
        }

        private void updatePriceWoVAT() {
            try {
                UpravljanjeTrebovanjem.this.cenaKomad.setResult(StatLogic.round(this.priceWoVAT == null ? 0.0 : this.priceWoVAT - this.priceWoVAT * this.raba / 100.0, 4));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void updatePriceWVat() {
            try {
                UpravljanjeTrebovanjem.this.cenaKomad2.setResult(StatLogic.round(this.priceWVAT - this.priceWVAT * this.raba / 100.0, 4));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void updateValueWoVAT() {
            try {
                UpravljanjeTrebovanjem.this.nabVrednost.setResult(StatLogic.round(this.vrednosSaRabatom, 4));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void updateValueSaRabatom() {
            try {
                UpravljanjeTrebovanjem.this.cenarabat.setResult(StatLogic.round(this.vrednosSaRabatom, 4));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void updateValueWVAT() {
            try {
                UpravljanjeTrebovanjem.this.nabVrednost2.setResult(StatLogic.round(this.vrednosSaRabatom * (100.0 + this.getStopa()) / 100.0, 4));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void reloadQuantity() {
            this.quantity = 0.0;
            try {
                this.quantity = UpravljanjeTrebovanjem.this.kolicina.getResult();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }

        private void reloadRabat() {
            this.raba = 0.0;
            try {
                this.raba = UpravljanjeTrebovanjem.this.rabat.getResult();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }

        private void reloadPriceWoVat() {
            this.priceWoVAT = 0.0;
            try {
                this.priceWoVAT = UpravljanjeTrebovanjem.this.cenaKomad.getResult();
            }
            catch (InputException ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void reloadPriceWVat() {
            this.priceWVAT = 0.0;
            try {
                this.priceWVAT = UpravljanjeTrebovanjem.this.cenaKomad2.getResult();
            }
            catch (InputException ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void reloadValueWoVat() {
            this.valueWoVAT = 0.0;
            try {
                this.valueWoVAT = UpravljanjeTrebovanjem.this.nabVrednost.getResult();
            }
            catch (InputException ex) {
                ex.printStackTrace(System.err);
            }
        }

        private void reloadValueWVat() {
            this.valueWVAT = 0.0;
            try {
                this.valueWVAT = UpravljanjeTrebovanjem.this.nabVrednost2.getResult();
            }
            catch (InputException ex) {
                ex.printStackTrace(System.err);
            }
        }

        public void insertDataArtikal() {
            try {
                Map<String, Double> nabavneCene = this.tip == TipTrebovanja.IZ_MAGACINA || this.tip == TipTrebovanja.POVRAT_U_MAGACIN ? (UpravljanjeTrebovanjem.this.crno.getSelection() ? NabavneCene.getPosednjaNabavna(UpravljanjeTrebovanjem.this.artikalI, new Date(), UpravljanjeTrebovanjem.this.magacin, UpravljanjeTrebovanjem.this.crno.getSelection(), 1, -1, UpravljanjeTrebovanjem.this.server) : NabavneCene.getPosednjaNabavna(UpravljanjeTrebovanjem.this.artikalI, new Date(), UpravljanjeTrebovanjem.this.magacin, UpravljanjeTrebovanjem.this.crno.getSelection(), 0, -1, UpravljanjeTrebovanjem.this.server)) : (UpravljanjeTrebovanjem.this.crno.getSelection() ? NabavneCene.getPosednjaNabavna(UpravljanjeTrebovanjem.this.artikalI, new Date(), UpravljanjeTrebovanjem.this.artikalI.getOdeljenje(), UpravljanjeTrebovanjem.this.crno.getSelection(), 1, -1, UpravljanjeTrebovanjem.this.server) : NabavneCene.getPosednjaNabavna(UpravljanjeTrebovanjem.this.artikalI, new Date(), UpravljanjeTrebovanjem.this.artikalI.getOdeljenje(), UpravljanjeTrebovanjem.this.crno.getSelection(), 0, -1, UpravljanjeTrebovanjem.this.server));
                double ncBezPdv = nabavneCene.get("NCpoJMbezPDV");
                if (UpravljanjeTrebovanjem.this.poPoslednjimCenama.booleanValue()) {
                    this.priceWoVAT = ncBezPdv;
                }
                if (UpravljanjeTrebovanjem.this.poPoslednjimCenamaKombo.booleanValue()) {
                    this.priceWoVAT = UpravljanjeTrebovanjem.this.server.getLastNabavnaCenaKombo(UpravljanjeTrebovanjem.this.artikalI);
                }
                UpravljanjeTrebovanjem.this.kolicinaLabel.setText(String.format(UpravljanjeTrebovanjem.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + "( " + UpravljanjeTrebovanjem.this.artikalI.getJedinicaMere() + " ):");
                if (!this.osam) {
                    for (int i = 0; i < this.stope.size(); ++i) {
                        ObjectWrapper stopa = this.stope.get(i);
                        if (stopa.getData() != UpravljanjeTrebovanjem.this.artikalI.getPoreskaGrupa()) continue;
                        UpravljanjeTrebovanjem.this.pdvC.select(i);
                    }
                }
                double pdv = this.osam ? 8.0 : this.getStopa();
                this.priceWVAT = this.vrednosSaRabatom * (100.0 + pdv) / 100.0;
                this.valueWoVAT = this.quantity * this.priceWoVAT;
                this.valueWVAT = this.quantity * this.priceWVAT;
                double preostalaKol = 0.0;
                if (UpravljanjeTrebovanjem.this.artikalI.getTip() == TipArtikla.SIRO && this.nabavnaCenaUSirovini.booleanValue()) {
                    UpravljanjeTrebovanjem.this.prodCena.setResult(this.priceWVAT);
                } else {
                    UpravljanjeTrebovanjem.this.prodCena.setResult(StatLogic.round(UpravljanjeTrebovanjem.this.artikalI.getCena(), 2));
                }
                this.updatePriceFields((Widget)UpravljanjeTrebovanjem.this.kolicina.getControl());
                preostalaKol = UpravljanjeTrebovanjem.this.server.getLagerZaArtikal(UpravljanjeTrebovanjem.this.artikalI, UpravljanjeTrebovanjem.this.crno.getSelection(), UpravljanjeTrebovanjem.this.ulazno != null ? UpravljanjeTrebovanjem.this.ulazno : UpravljanjeTrebovanjem.this.izlazno, UpravljanjeTrebovanjem.this.datum.getResult());
                UpravljanjeTrebovanjem.this.preostalaKol2.setText(String.valueOf(preostalaKol));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        private void updateMargin() {
            double margin = 0.0;
            try {
                if (UpravljanjeTrebovanjem.this.artikalI != null && this.priceWoVAT != null && UpravljanjeTrebovanjem.this.prodCena.getResult() != null) {
                    margin = this.priceWoVAT == 0.0 || UpravljanjeTrebovanjem.this.artikalI.getMera() == 0.0 ? 0.0 : (UpravljanjeTrebovanjem.this.prodCena.getResult() / (UpravljanjeTrebovanjem.this.artikalI.getMera() != null ? UpravljanjeTrebovanjem.this.artikalI.getMera() : 1.0) / this.getVatCoeff() / this.priceWoVAT - 1.0) * 100.0;
                }
            }
            catch (InputException ex) {
                ex.printStackTrace(System.err);
            }
            UpravljanjeTrebovanjem.this.marza.setResult(StatLogic.round(margin, 2));
        }

        public void insertMargin() {
            try {
                this.reloadPriceWoVat();
                UpravljanjeTrebovanjem.this.prodCena.setResult(StatLogic.round(this.priceWoVAT * (UpravljanjeTrebovanjem.this.artikalI.getMera() != null ? UpravljanjeTrebovanjem.this.artikalI.getMera() : 1.0) * (1.0 + UpravljanjeTrebovanjem.this.marza.getResult() / 100.0) * this.getVatCoeff(), 2));
            }
            catch (InputException ex) {
                ex.printStackTrace(System.out);
            }
        }

        public void insertPrice() {
            this.reloadPriceWoVat();
            this.updateMargin();
        }

        public double getStopa() {
            double rez = 0.0;
            if (this.osam) {
                rez = 8.0;
            } else {
                ObjectWrapper stopa = this.stope.get(UpravljanjeTrebovanjem.this.pdvC.getSelectionIndex());
                rez = stopa.getPercent();
            }
            return rez;
        }

        public double getVatCoeff() {
            return (100.0 + this.getStopa()) / 100.0;
        }

        public double getVatValue() {
            return this.getStopa() / 100.0;
        }
    }
}

