/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Otpis;
import com.dev63.restoran.model.OtpisStavka;
import com.dev63.restoran.model.OtpisUtrosak;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.components.SWTMessage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UnosOtpisa {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    RestoranServer server;
    SWTContainer parent;
    DateInput2 datum;
    final Table table;
    Button plus;
    Button minus;
    Odeljenje odeljenje;
    List<OtpisStavka> stavke = new ArrayList<OtpisStavka>();
    Shell shell;
    Text pretraga;
    Combo artikal;
    DoubleInput2 cenaKomad;
    Button crno;
    Restoran restoran;
    Map<Long, Artikal> artikli;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    Map<Long, Double> mapaPocetnoB;
    Map<Long, Double> mapaUlazB;
    Map<Long, Double> mapaIzlazB;
    Map<Long, Double> mapaPocetnoC;
    Map<Long, Double> mapaUlazC;
    Map<Long, Double> mapaIzlazC;
    boolean sifre;
    List<DnevnoStanje> stanjaDanas = null;
    double totalNab;
    double totalProd;
    TableItem total;
    boolean inspektor = false;
    boolean crn = false;
    boolean poPosUnetCenama = false;
    boolean poPosCenamaKombo = false;
    Otpis aktivanOtpis;

    public UnosOtpisa(SWTContainer owner, Restoran r, Odeljenje o, boolean inspektor, Otpis otpis) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.odeljenje = o;
        this.inspektor = inspektor;
        this.aktivanOtpis = otpis;
        if (this.aktivanOtpis != null) {
            for (OtpisStavka os : this.server.readStavkeOtpisa(this.aktivanOtpis)) {
                this.stavke.add(os);
            }
        }
        Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
        this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        Label dat = new Label((Composite)this.shell, 0);
        dat.setText("Datum otpisa:");
        dat.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum = new DateInput2(this.parent, "Datum otpisa", this.aktivanOtpis != null ? new Date(this.aktivanOtpis.getDatum().getTime()) : new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        this.datum.setEnabled(true);
        Label cr = null;
        if (inspektor) {
            cr = new Label((Composite)this.shell, 0);
            cr.setText("Otpis dodatnih zaliha:");
            cr.setBackground(this.shell.getDisplay().getSystemColor(22));
            this.crno = new Button((Composite)this.shell, 32);
        }
        Label opisL = new Label((Composite)this.shell, 0);
        opisL.setText("Opis:");
        opisL.setBackground(this.shell.getDisplay().getSystemColor(22));
        final Text opis = new Text((Composite)this.shell, 2560);
        Label separator1 = new Label((Composite)this.shell, 258);
        this.table = new Table((Composite)this.shell, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
        nazivArtikla.setText("Naziv artikla");
        nazivArtikla.setWidth(150);
        TableColumn kolicina = new TableColumn(this.table, 0x1000000);
        kolicina.setText("Kolicina");
        kolicina.setWidth(65);
        TableColumn jmere = new TableColumn(this.table, 0x1000000);
        jmere.setText("J.M");
        jmere.setWidth(65);
        TableColumn nabavnaCena = new TableColumn(this.table, 0x1000000);
        nabavnaCena.setText("Nab. vrednost");
        nabavnaCena.setWidth(90);
        TableColumn nabavnaCenaPDV = new TableColumn(this.table, 0x1000000);
        nabavnaCenaPDV.setText("N. vred.PDV");
        nabavnaCenaPDV.setWidth(90);
        TableColumn prodajnaCena = new TableColumn(this.table, 0x1000000);
        prodajnaCena.setText("Prod. vrednost");
        prodajnaCena.setWidth(90);
        this.total = new TableItem(this.table, 0);
        if (!this.stavke.isEmpty()) {
            this.reloadTable(this.stavke);
        }
        this.plus = Dugmici.getPlusButton((Composite)this.shell);
        this.plus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosOtpisa.this.unosStavkeOtpisa(UnosOtpisa.this.shell, UnosOtpisa.this.table);
            }
        });
        this.minus = Dugmici.getMinusButton((Composite)this.shell);
        this.minus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = UnosOtpisa.this.table.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                UnosOtpisa.this.table.remove(i);
                UnosOtpisa.this.stavke.remove(i);
            }
        });
        Label separator2 = new Label((Composite)this.shell, 258);
        Button cancelButt = Dugmici.getCancelButton(this.shell);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UnosOtpisa.this.parent.getControl().getShell().close();
            }
        });
        Button helpButt = Dugmici.getHelpButton(this.shell);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(this.shell);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PopisProvera provera = new PopisProvera(UnosOtpisa.this.server, UnosOtpisa.this.shell, UnosOtpisa.this.datum.getResult(), UnosOtpisa.this.odeljenje, true);
                    if (provera.isPopis()) {
                        provera.setValidDate(UnosOtpisa.this.datum);
                        return;
                    }
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                if (UnosOtpisa.this.stavke.size() < 1) {
                    Konstante.getPoruka(UnosOtpisa.this.shell, String.format(UnosOtpisa.this.barmasterText.getString("PORUKA_MORATE_UNETI_PODATKE_ZA_BAR_JEDAN_ARTIKAL"), new Object[0]));
                    return;
                }
                try {
                    if (UnosOtpisa.this.datum.getResult().after(new Date())) {
                        Konstante.getPoruka(UnosOtpisa.this.shell, String.format(UnosOtpisa.this.barmasterText.getString("PORUKA_UNETI_DATUM_JE_NEPRIHVATLJIV"), new Object[0]));
                        return;
                    }
                    UnosOtpisa.this.server.refresh();
                    if (UnosOtpisa.this.aktivanOtpis == null) {
                        int broj;
                        UnosOtpisa.this.aktivanOtpis = new Otpis();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            Date datumTrenutni = sdf.parse(sdf.format(new Date()));
                            Date datumOtpisa = sdf.parse(sdf.format(UnosOtpisa.this.datum.getResult()));
                            if (datumOtpisa.before(datumTrenutni)) {
                                ZD zd = UnosOtpisa.this.server.getZDbyDatum(datumOtpisa);
                                UnosOtpisa.this.aktivanOtpis.setDatum(zd.getDatum());
                            } else {
                                UnosOtpisa.this.aktivanOtpis.setDatum(new Date());
                            }
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                        UnosOtpisa.this.aktivanOtpis.setCrno(UnosOtpisa.this.crno.getSelection());
                        UnosOtpisa.this.aktivanOtpis.setOdeljenje(UnosOtpisa.this.odeljenje);
                        UnosOtpisa.this.aktivanOtpis.setOpis(opis.getText());
                        UnosOtpisa.this.aktivanOtpis.setUname(UnosOtpisa.this.server.getUser().getName());
                        if (UnosOtpisa.this.crn) {
                            broj = UnosOtpisa.this.server.sledeciBrojOtpisa2();
                            UnosOtpisa.this.aktivanOtpis.setBroj(++broj + "/2");
                            UnosOtpisa.this.server.incrementBrojOtpisa2(String.valueOf(broj));
                        } else {
                            broj = UnosOtpisa.this.server.sledeciBrojOtpisa();
                            Calendar dc = Calendar.getInstance();
                            UnosOtpisa.this.aktivanOtpis.setBroj(++broj + "/" + dc.get(1));
                            UnosOtpisa.this.server.incrementBrojOtpisa(String.valueOf(broj));
                        }
                        UnosOtpisa.this.server.addOtpisJPA(UnosOtpisa.this.aktivanOtpis);
                    } else {
                        for (OtpisStavka os : UnosOtpisa.this.server.readStavkeOtpisa(UnosOtpisa.this.aktivanOtpis)) {
                            UnosOtpisa.this.server.deleteOtpisStavka(os);
                        }
                        for (OtpisUtrosak ou : UnosOtpisa.this.server.readOtpisUtrosak(UnosOtpisa.this.aktivanOtpis)) {
                            UnosOtpisa.this.server.deleteOtpisUtrosak(ou);
                        }
                    }
                    for (OtpisStavka ts : UnosOtpisa.this.stavke) {
                        ts.setOtpis(UnosOtpisa.this.aktivanOtpis);
                        ts.setId(null);
                        double nabavnaCena = 0.0;
                        try {
                            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(ts.getArtikal(), new HashMap<Artikal, Double>(), 1.0, UnosOtpisa.this.server, null, null);
                            for (Artikal a : mapa.keySet()) {
                                nabavnaCena += ts.getArtikal().getTip() != TipArtikla.POLU ? UnosOtpisa.this.server.getLastNabavnaCenaBelaBezPDV(a, UnosOtpisa.this.aktivanOtpis != null ? UnosOtpisa.this.aktivanOtpis.getDatum() : UnosOtpisa.this.datum.getResult()) * mapa.get(a) : UnosOtpisa.this.server.getLastNabavnaCenaBelaBezPDV(a, UnosOtpisa.this.aktivanOtpis != null ? UnosOtpisa.this.aktivanOtpis.getDatum() : UnosOtpisa.this.datum.getResult()) * a.getMera();
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        ts.setVrednost(nabavnaCena);
                        UnosOtpisa.this.sacuvajStavkuOtpisa(ts);
                    }
                    if (!UnosOtpisa.this.unosUtrosakaOtpisa(UnosOtpisa.this.aktivanOtpis, UnosOtpisa.this.stavke)) {
                        SWTMessage.showMessageDialog(UnosOtpisa.this.shell, "Neuspesan upis utrosaka u tabeli otpisutrosak", String.format(UnosOtpisa.this.barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                        return;
                    }
                    UnosOtpisa.this.shell.close();
                }
                catch (InputException inputException) {
                    // empty catch block
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        this.shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 3;
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 2;
        dat.setLayoutData((Object)data);
        if (inspektor) {
            cr.setLayoutData((Object)data);
        }
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        this.datum.getControl().setLayoutData((Object)data);
        if (inspektor) {
            this.crno.setLayoutData((Object)data);
        }
        data = new GridData();
        data.horizontalSpan = 3;
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator1.setLayoutData((Object)data);
        separator2.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 250;
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 60;
        opis.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.heightHint = 250;
        this.table.setLayoutData((Object)data);
        this.shell.open();
    }

    public void unosStavkeOtpisa(Shell shell, Table table) {
        final Shell shell2 = new Shell(shell.getDisplay());
        shell2.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        SortedMap<String, Long> artikli3 = this.server.getArtikliZaOtpisSlozenih(this.odeljenje.getId());
        final SWTContainer parent2 = new SWTContainer((Composite)shell2);
        Label p = new Label((Composite)shell2, 0);
        p.setText("Pretraga:");
        p.setBackground(shell.getDisplay().getSystemColor(22));
        this.pretraga = new Text((Composite)shell2, 0);
        this.pretraga.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        String str = UnosOtpisa.this.pretraga.getText();
                        UnosOtpisa.this.artikal.removeAll();
                        SortedMap<Object, Object> sMapa = new TreeMap();
                        if (str == null || str.length() <= 0) {
                            return;
                        }
                        sMapa = UnosOtpisa.this.server.getArtikliByNameOrBarcode(UnosOtpisa.this.odeljenje.getId(), str);
                        for (String string : sMapa.keySet()) {
                            UnosOtpisa.this.artikal.add(string);
                        }
                        UnosOtpisa.this.artikal.select(0);
                    }
                }
            }
        });
        Label a = new Label((Composite)shell2, 0);
        a.setText("Artikal:");
        a.setBackground(shell2.getDisplay().getSystemColor(22));
        this.artikal = new Combo((Composite)shell2, 2572);
        for (String s : artikli3.keySet()) {
            this.artikal.add(s);
        }
        this.artikal.select(0);
        this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label k = new Label((Composite)shell2, 0);
        k.setText("Kolicina :");
        k.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 kolicina = new DoubleInput2(parent2, "Kolicina", false);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                parent2.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    if (UnosOtpisa.this.artikal.getSelectionIndex() == -1 || kolicina.getText().length() == 0) {
                        return;
                    }
                    Artikal art = UnosOtpisa.this.server.getArtikal(UnosOtpisa.this.artikal.getItem(UnosOtpisa.this.artikal.getSelectionIndex()));
                    OtpisStavka os = new OtpisStavka();
                    os.setArtikal(art);
                    os.setKolicina(kolicina.getResult());
                    UnosOtpisa.this.stavke.add(os);
                    UnosOtpisa.this.reloadTable(UnosOtpisa.this.stavke);
                    shell2.close();
                }
                catch (InputException ex) {
                    Konstante.getPoruka(shell2, ex.getMessage());
                }
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        this.artikal.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        data.horizontalAlignment = 16384;
        a.setLayoutData((Object)data);
        k.setLayoutData((Object)data);
        this.pretraga.setLayoutData((Object)data);
        kolicina.getControl().setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        shell2.pack();
        shell2.open();
    }

    public void sacuvajStavkuOtpisa(OtpisStavka os) throws InputException {
        this.server.refresh();
        this.server.addOtpisStavkaJPA(os);
    }

    public double izracunajPocetno(Artikal a, boolean belo) {
        double pocetno = 0.0;
        if (belo && this.mapaPocetnoB.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoB.get(a.getId()).doubleValue();
        }
        if (!belo && this.mapaPocetnoC.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoC.get(a.getId()).doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a, boolean belo) {
        double ulaz = 0.0;
        if (belo) {
            if (this.mapaUlazB.get(a.getId()) != null) {
                ulaz += this.mapaUlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getBeloUlaz().doubleValue();
            }
        }
        if (!belo) {
            if (this.mapaUlazC.get(a.getId()) != null) {
                ulaz += this.mapaUlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getCrnoUlaz().doubleValue();
            }
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a, boolean belo) {
        double izlaz = 0.0;
        if (belo) {
            if (this.mapaIzlazB.get(a.getId()) != null) {
                izlaz += this.mapaIzlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getBeloIzlaz().doubleValue();
            }
        }
        if (!belo) {
            if (this.mapaIzlazC.get(a.getId()) != null) {
                izlaz += this.mapaIzlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getCrnoIzlaz().doubleValue();
            }
        }
        return izlaz;
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    public double izracunajNabVrednost(Artikal input) {
        double nv = 0.0;
        try {
            for (Normativ n : this.server.getNormativiByLastNormativiArtikal(input.getId())) {
                nv += n.getSastojak().getTrenutnaNV() * n.getKolicina();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return nv;
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                System.out.println("Nabavne cene sa PDCom: " + a.getId() + ": " + a + " - " + this.server.getLastNabavnaCenaBela(a, new Date()) * mapa.get(a));
                try {
                    trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, this.datum.getResult())) : this.server.getLastNabavnaCenaBela(a, new Date())) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : this.server.getLastNabavnaCenaBela(art, this.datum.getResult())) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
            }
            catch (InputException e) {
                e.printStackTrace();
            }
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    public double getNabavnaCenaBezPDV(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date())) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date())) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBelaBezPDV(art, new Date())) : this.server.getLastNabavnaCenaBelaBezPDV(art, new Date())) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
        }
        return trNv;
    }

    DnevnoStanje getDS(Artikal a) {
        if (this.stanjaDanas == null) {
            return null;
        }
        for (DnevnoStanje ds : this.stanjaDanas) {
            if (!ds.getArtikalID().equals(a.getId())) continue;
            return ds;
        }
        return null;
    }

    protected synchronized boolean unosUtrosakaOtpisa(Otpis aktivanOtpis, List<OtpisStavka> stavke) {
        System.out.println("ovde kreiram utroske otpisa");
        boolean upis = false;
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
            HashMap konacnaLista = new HashMap();
            boolean prolazi = false;
            for (OtpisStavka os : stavke) {
                artikal_kolicina.put(os.getArtikal(), os.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    if (!prolazi && this.odeljenje.equals(o)) {
                        prolazi = true;
                    }
                    if (!prolazi || artikal.getTip() != TipArtikla.SLOZ && artikal.getTip() != TipArtikla.DODA) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), this.server, artikal.getOdeljenje(), aktivanOtpis.getDatum()), this.server, o, aktivanOtpis.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                    normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Artikal artikal : normativ_kolicina.keySet()) {
                    konacnaLista.put(artikal, normativ_kolicina.get(artikal));
                }
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.POLU) continue;
                    if (!konacnaLista.containsKey(artikal)) {
                        konacnaLista.put(artikal, (Double)artikal_kolicina.get(artikal) * 1.0);
                        continue;
                    }
                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal) * 1.0);
                }
                for (Artikal artikal : konacnaLista.keySet()) {
                    OtpisUtrosak oUtrosak = new OtpisUtrosak();
                    oUtrosak.setOtpis(aktivanOtpis);
                    oUtrosak.setArtikal(artikal);
                    oUtrosak.setOdeljenje(artikal.getOdeljenje());
                    oUtrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    oUtrosak.setNabavnaCena(artikal.getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV(artikal, aktivanOtpis.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV(artikal, 1.0));
                    this.server.insertOtpisUtrosak(oUtrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }

    private void reloadTable(List<OtpisStavka> stavke) {
        this.table.removeAll();
        if (!stavke.isEmpty()) {
            for (OtpisStavka ps : stavke) {
                TableItem item = new TableItem(this.table, 0);
                String n = ps.getArtikal().getName();
                double nabavnaCena = this.getNabavnaCenaBezPDV(ps.getArtikal(), ps.getKolicina());
                double nabavnaCenaPDV = this.getNabavnaCena(ps.getArtikal(), ps.getKolicina());
                item.setText(new String[]{n, Konstante.getNumber4(ps.getKolicina()), ps.getArtikal().getJedinicaMere(), Konstante.getNumber2(nabavnaCena), Konstante.getNumber2(nabavnaCenaPDV), Konstante.getNumber2(ps.getArtikal().getCena())});
            }
        }
    }
}

