/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaTroskova;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Trosak;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class Troskovi {
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Trosak active;
    ToolItem item3;
    Composite dugmici;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd. MM. yyyy.");

    public Troskovi(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        Shell shell = this.parent.getControl().getShell();
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/noviV.gif"));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_TROSKA"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        Button uputstvo = new Button(panel1, 8);
        uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_NOVI_TROSAK"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Troskovi.this.addTrosak();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_IZMENA_TROSKA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Troskovi.this.updateTrosak();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_TROSKA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Troskovi.this.deleteTrosak();
            }
        });
        SWTContainerClass.setDimension(shell);
    }

    private void reload() {
        this.listModel.clear();
        List<Trosak> troskovi = this.restoran.getServer().getTroskove();
        for (Trosak l : troskovi) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addTrosak() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        TrosakDialog od = new TrosakDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_NOVI_TROSAK"), new Object[0])), false);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_UNOS_TROSKA"), new Object[0]) + ":   " + od.getResult());
            this.restoran.getServer().addTrosak(od.getResult());
        }
    }

    private void updateTrosak() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        TrosakDialog od = new TrosakDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_IZMENA_TROSKA"), new Object[0])), true);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_IZMENA_TROSKA"), new Object[0]) + ": " + od.getResult());
            this.restoran.getServer().updateTrosak(od.getResult());
        }
    }

    private void deleteTrosak() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        TrosakDialog od = new TrosakDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_IZMENA_TROSKA"), new Object[0])), true);
        SWTContainerClass.makeEnd(shell2);
        this.active = od.getResult();
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKONITE_TROSAK_IZ_SISTEMA"), this.active.getNaziv()));
        if (ok == 0) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_TROSKA"), new Object[0]) + ": " + this.active);
            this.restoran.getServer().deleteTrosak(this.active);
            this.active = null;
        }
    }

    private class TrosakDialog {
        private TextInput2 name;
        private DateInput2 datum;
        private DateInput2 datumPlacanja;
        private DateInput2 valuta;
        private DoubleInput2 iznos;
        private List<GrupaTroskova> grupeComboList;
        final Combo nacinPlacanja;
        final Combo grupe;
        final Combo cbTroskovi;
        List<String> placanja = new ArrayList<String>();
        List<String> troskoviImena = new ArrayList<String>();
        List<GrupaTroskova> grupeTroskova = new ArrayList<GrupaTroskova>();
        private Trosak input;
        private Trosak result;
        boolean n;

        public TrosakDialog(SWTContainer parent, boolean novi) {
            this.n = novi;
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            this.grupeComboList = new LinkedList<GrupaTroskova>();
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 250;
            Label label11 = new Label((Composite)shell3, 0);
            label11.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_TROSKA"), new Object[0]) + ":");
            label11.setBackground(shell3.getDisplay().getSystemColor(22));
            label11.setVisible(this.n);
            this.cbTroskovi = new Combo((Composite)shell3, 2572);
            this.cbTroskovi.setLayoutData((Object)gd);
            this.cbTroskovi.setVisible(this.n);
            this.cbTroskovi.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TrosakDialog.this.input = Troskovi.this.server.getTroskove().get(TrosakDialog.this.cbTroskovi.getSelectionIndex());
                    TrosakDialog.this.name.setResult(TrosakDialog.this.input.getNaziv());
                    TrosakDialog.this.datum.setResult(TrosakDialog.this.input.getDan());
                    TrosakDialog.this.nacinPlacanja.select(TrosakDialog.this.placanja.indexOf(TrosakDialog.this.input.getNacinPlacanja()));
                    TrosakDialog.this.valuta.setResult(TrosakDialog.this.input.getValutaPlacanja());
                    TrosakDialog.this.iznos.setResult(TrosakDialog.this.input.getIznos());
                    TrosakDialog.this.grupe.select(TrosakDialog.this.grupeTroskova.indexOf(TrosakDialog.this.input.getGrupa()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label label0 = new Label((Composite)shell3, 0);
            label0.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_GRUPE_TROSKOVA"), new Object[0]) + ":");
            label0.setBackground(shell3.getDisplay().getSystemColor(22));
            this.grupe = new Combo((Composite)shell3, 2572);
            this.grupe.setLayoutData((Object)gd);
            Label n = new Label((Composite)shell3, 0);
            n.setBackground(shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]) + ":");
            this.name = new TextInput2(parent, String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]), false);
            this.name.getControl().setLayoutData((Object)gd);
            Label d1 = new Label((Composite)shell3, 0);
            d1.setBackground(shell3.getDisplay().getSystemColor(22));
            d1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM_UNOSA"), new Object[0]) + ":");
            this.datum = new DateInput2(parent, String.format(Konstante.getBundle().getString("TEXT_DATUM_UNOSA"), new Object[0]), false, Troskovi.this.server);
            this.datum.setResult(new Date(Troskovi.this.server.getLastDateZD().getTime()));
            this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, parent.getControl().getShell()));
            this.datum.getControl().setLayoutData((Object)gd);
            Label i1 = new Label((Composite)shell3, 0);
            i1.setBackground(shell3.getDisplay().getSystemColor(22));
            i1.setText(String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0]) + ":");
            this.iznos = new DoubleInput2(parent, String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0]), false);
            this.iznos.getControl().setLayoutData((Object)gd);
            Label label1 = new Label((Composite)shell3, 0);
            label1.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_NACINA_PLACANJA"), new Object[0]) + ":");
            label1.setBackground(shell3.getDisplay().getSystemColor(22));
            this.nacinPlacanja = new Combo((Composite)shell3, 2572);
            this.nacinPlacanja.setLayoutData((Object)gd);
            Label d3 = new Label((Composite)shell3, 0);
            d3.setBackground(shell3.getDisplay().getSystemColor(22));
            d3.setText(String.format(Konstante.getBundle().getString("TEXT_VALUTA_PLACANJA"), new Object[0]) + ":");
            this.valuta = new DateInput2(parent, String.format(Konstante.getBundle().getString("TEXT_VALUTA_PLACANJA"), new Object[0]), false, Troskovi.this.server);
            this.valuta.setValutaPlacanja(true);
            this.valuta.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.valuta, parent.getControl().getShell()));
            this.valuta.getControl().setLayoutData((Object)gd);
            Label sa = new Label((Composite)shell3, 0);
            sa.setBackground(shell3.getDisplay().getSystemColor(22));
            sa.setText("");
            Label ss = new Label((Composite)shell3, 0);
            ss.setBackground(shell3.getDisplay().getSystemColor(22));
            ss.setText("");
            for (Trosak s : Troskovi.this.server.getTroskove()) {
                this.cbTroskovi.add(s.getNaziv());
            }
            this.cbTroskovi.select(0);
            for (NacinPlacanja np : NacinPlacanja.values()) {
                this.placanja.add(np.getOpis());
            }
            for (CrnoPlacanje cp : Troskovi.this.server.readSvaCrnaPlacanja()) {
                this.placanja.add(cp.getNaziv());
            }
            for (String s : this.placanja) {
                this.nacinPlacanja.add(s);
            }
            this.nacinPlacanja.select(0);
            this.grupeTroskova = Troskovi.this.server.getGrupeTroskovaFirstLevel();
            this.fillInCombo(this.grupeTroskova, 1);
            this.grupe.select(0);
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TrosakDialog.this.cancel(parent2);
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TrosakDialog.this.ok(parent2);
                }
            });
            if (this.input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            shell3.pack();
        }

        private void fillInCombo(List<GrupaTroskova> gtList, int level) {
            String prefix = "";
            for (int i = 2; i < level; ++i) {
                prefix = prefix + "   |";
            }
            if (level > 1) {
                prefix = prefix + "   ";
            }
            for (GrupaTroskova gt : gtList) {
                this.grupe.add(prefix + gt.getNaziv());
                this.grupeComboList.add(gt);
                if (gt.getPodGrupe() == null || gt.getPodGrupe().isEmpty()) continue;
                int newLevel = level + 1;
                this.fillInCombo(gt.getPodGrupe(), newLevel);
            }
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            if (this.grupeComboList.isEmpty()) {
                Konstante.getPoruka3(parent.getControl().getShell(), "Morate prvo napraviti grupu troskova!");
                return;
            }
            Trosak o = this.input != null ? this.input : new Trosak();
            try {
                o.setNaziv(this.name.getResult());
                o.setDan(this.datum.getResult());
                o.setGrupa(this.grupeComboList.get(this.grupe.getSelectionIndex()));
                o.setIznos(this.iznos.getResult());
                o.setNacinPlacanja(this.nacinPlacanja.getItem(this.nacinPlacanja.getSelectionIndex()));
                o.setValutaPlacanja(this.valuta.getResult());
                this.result = o;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        public Trosak getResult() {
            return this.result;
        }

        private void loadData() {
            this.name.setResult(this.input.getNaziv());
            this.datum.setResult(this.input.getDan());
            this.datumPlacanja.setResult(this.input.getDatumPlacanja());
            this.nacinPlacanja.select(this.placanja.indexOf(this.input.getNacinPlacanja()));
            this.valuta.setResult(this.input.getValutaPlacanja());
            this.iznos.setResult(this.input.getIznos());
            this.grupe.select(this.grupeTroskova.indexOf(this.input.getGrupa()));
        }
    }
}

