/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.swt.components.SWTMessage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import swt.proba.VNCProba;

public class TehPod {
    private static final String SUPPORT_SERVER_ADDRESS = "uvnc.petcom.rs";
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());

    public static int runSupportSoftware() {
        File uvnc = new File("C:\\BarMaster\\Support\\winvnc.exe");
        if (!uvnc.exists()) {
            System.out.println("Program za tehnicku podrsku nije instaliran");
            return -1;
        }
        if (!TehPod.isTehPodServerReachable()) {
            return -2;
        }
        double rndm = Math.random();
        final int id = (int)Math.round(rndm * 8999.0) + 1000;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("id = " + id);
                    Process p1 = Runtime.getRuntime().exec("taskkill /F /IM winvnc.exe");
                    p1.waitFor();
                    Runtime.getRuntime().exec("C:\\BarMaster\\Support\\winvnc -sc_prompt -sc_exit -autoreconnect -id:" + Integer.toString(id) + " -connect uvnc.petcom.rs -run");
                }
                catch (IOException ex) {
                    Logger.getLogger(VNCProba.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(VNCProba.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        t.start();
        return id;
    }

    public static void showSupportInfo(Shell parent) {
        int id = TehPod.runSupportSoftware();
        if (id == -1) {
            MessageDialog.openInformation((Shell)parent, (String)String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(barmasterText.getString("PORUKA_PROGRAM_ZA_TEHNICKU_PODRSKU_NIJE_INSTALIRAN"), new Object[0]));
        } else if (id == -2) {
            SWTMessage.showLocalizedMessageDialog(parent, String.format(Konstante.getBundle().getString("PORUKA_NIJE_MOGUCE_PRISTUPITI_SERVERU_TEHNICKE_PODRSKE"), new Object[0]), String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]), 2);
        } else {
            MessageDialog.openInformation((Shell)parent, (String)String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]), (String)String.format(barmasterText.getString("TEXT_VAS_ID_JE_IZDIKTIRAJTE_GA_NA_ZAHTEV_OPERATERA"), Integer.toString(id)));
        }
    }

    public static boolean isTehPodServerReachable() {
        boolean ret = false;
        try {
            String ipAddress = SUPPORT_SERVER_ADDRESS;
            InetAddress inet = InetAddress.getByName(ipAddress);
            ret = inet.isReachable(5000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

