/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.sistem.Stock;
import java.util.ArrayList;
import java.util.List;

public class StockValue {
    private List<Stock> stocks = new ArrayList<Stock>();
    private int head;

    public StockValue() {
        this.stocks.add(new Stock(0.0, 0.0));
        this.head = 0;
    }

    public void add(double quantity, double pricePerUnit) {
        this.stocks.add(new Stock(quantity, pricePerUnit));
        if (!this.stocks.get(this.head).isSane()) {
            ++this.head;
        }
    }

    public void remove(double quantity) {
        Stock stock;
        if (this.head == this.stocks.size()) {
            stock = this.stocks.get(--this.head);
            try {
                stock.becomeInsane();
            }
            catch (IllegalStateException e) {
                System.out.println(e.getMessage());
            }
        } else {
            stock = this.stocks.get(this.head);
        }
        double rest = stock.use(quantity);
        if (stock.isSane() && rest < 0.0) {
            ++this.head;
            this.remove(-rest);
        }
    }

    public double getValue() {
        double ret = 0.0;
        for (Stock stock : this.stocks) {
            ret += stock.getValue();
        }
        return ret;
    }
}

