/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.logs.ButtonLogger;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StalniGostiStolovi {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Shell shell5;
    Table tableRacuni2;
    List<StalniGost> gosti;
    Restoran restoran;
    RestoranServer server;
    StalniGost gost = null;
    Color pozadina;
    Color svCrno;
    Color tamnoSivo;
    Color sivo;
    Color belo;
    Text text;
    ButtonLogger buttonLogger;

    public StalniGostiStolovi(Display display, final Shell parent, Restoran r, final Konobar konobarSto, final ButtonLogger buttonLogger) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.buttonLogger = buttonLogger;
        this.shell5 = new Shell(parent, 32768);
        this.shell5.setLayout((Layout)new GridLayout(1, false));
        Display device = this.shell5.getDisplay();
        this.pozadina = new Color((Device)device, 115, 119, 128);
        this.svCrno = new Color((Device)device, 34, 37, 46);
        this.tamnoSivo = new Color((Device)device, 49, 53, 64);
        this.sivo = new Color((Device)device, 80, 84, 96);
        this.belo = display.getSystemColor(1);
        this.shell5.setBackground(this.svCrno);
        this.shell5.setForeground(this.belo);
        GridData data = new GridData(768);
        data.widthHint = 60;
        Composite c1 = new Composite((Composite)this.shell5, 0);
        c1.setBackground(this.svCrno);
        c1.setLayoutData((Object)new GridData(4, 4, true, false));
        c1.setLayout((Layout)new GridLayout());
        data = new GridData(4, 4, true, false);
        this.text = new Text(c1, 0x400800);
        this.text.setBackground(this.svCrno);
        this.text.setForeground(this.belo);
        this.text.setLayoutData((Object)data);
        this.text.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (!(event.keyCode != 13 && event.keyCode != 0x1000050 || StalniGostiStolovi.this.text.getText().isEmpty())) {
                    StalniGost sg = StalniGostiStolovi.this.server.getSTGost(StalniGostiStolovi.this.text.getText());
                    Konobar k = StalniGostiStolovi.this.server.konobarBySifra(StalniGostiStolovi.this.text.getText());
                    if (sg != null) {
                        buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", provucena kartica stalnog gosta: " + sg.getNaziv());
                    } else {
                        buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", provucena neaktivna kartica stalnog gosta");
                    }
                    boolean popustNaPopust = Boolean.parseBoolean(StalniGostiStolovi.this.server.getSetting(Option.POPUST_NA_POPUST).getActual());
                    if (popustNaPopust && k != null && konobarSto != null && k.getId() != konobarSto.getId()) {
                        Konstante.prikaziMessageBox(parent, "Izabrani gost je evidentiran kao operater. Izaberite drugog gosta");
                        StalniGostiStolovi.this.text.setFocus();
                        return;
                    }
                    if (sg != null) {
                        StalniGostiStolovi.this.gost = sg;
                        StalniGostiStolovi.this.shell5.close();
                    } else {
                        Konstante.getPoruka(StalniGostiStolovi.this.shell5, "Stalni gost sa unetom sifrom ne postoji,\n ili postoji vise gostiju sa unetom sifrom!");
                    }
                }
            }
        });
        data = new GridData(1808);
        Composite c2 = new Composite((Composite)this.shell5, 0);
        c2.setLayout((Layout)new GridLayout(2, false));
        c2.setBackground(this.svCrno);
        c2.setForeground(this.belo);
        c2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite c3 = new Composite(c2, 0);
        c3.setBackground(this.svCrno);
        c3.setForeground(this.belo);
        TableColumnLayout tcl = new TableColumnLayout();
        c3.setLayout((Layout)tcl);
        data = new GridData(4, 4, true, true, 1, 2);
        c3.setLayoutData((Object)data);
        Composite c4 = new Composite(c2, 0);
        c4.setLayout((Layout)new GridLayout());
        c4.setBackground(this.svCrno);
        c4.setForeground(this.belo);
        c4.setLayoutData((Object)new GridData(4, 4, false, true));
        Composite c5 = new Composite(c2, 0);
        c5.setLayout((Layout)new GridLayout());
        c5.setLayoutData((Object)new GridData(4, 4, false, false));
        c5.setBackground(this.svCrno);
        c5.setForeground(this.belo);
        this.tableRacuni2 = new Table(c3, 68356);
        this.tableRacuni2.setFont(FontCache.getFont("Arial", 16, 0));
        this.tableRacuni2.setBackground(this.svCrno);
        this.tableRacuni2.setForeground(this.belo);
        this.tableRacuni2.setLinesVisible(false);
        this.tableRacuni2.setHeaderVisible(true);
        TableColumn k = new TableColumn(this.tableRacuni2, 0x1000000);
        k.setText(String.format(this.barmasterText.getString("TEXT_NAZIV_STALNOG_GOSTA"), new Object[0]));
        tcl.setColumnData((Widget)k, (ColumnLayoutData)new ColumnWeightData(100, 400));
        List<StalniGostiGrupa> sggl = this.server.readGrupeStGosti();
        int hght = 300 / sggl.size();
        if (hght > 80) {
            hght = 80;
        }
        for (final StalniGostiGrupa sgg : sggl) {
            if (sgg.getNaziv().toUpperCase().equals("PREDUZECE")) continue;
            final Label btn = new Label(c4, 0x1000800);
            btn.setFont(FontCache.getFont("Arial", 12, 1));
            btn.setBackground(this.svCrno);
            btn.setForeground(display.getSystemColor(1));
            btn.setText("\r\n" + sgg.getNaziv());
            btn.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", pritisnuto dugme:grupa gostiju -  " + btn.getText());
                    StalniGostiStolovi.this.popuniTabelu(sgg);
                }
            });
            GridData gd = new GridData();
            gd.widthHint = 164;
            gd.heightHint = hght;
            btn.setLayoutData((Object)gd);
        }
        this.popuniTabelu(sggl.get(0));
        Label potvrda = new Label(c5, 0x1000800);
        potvrda.setFont(FontCache.getFont("Arial", 18, 1));
        potvrda.setBackground(this.svCrno);
        potvrda.setForeground(this.belo);
        potvrda.setText("\r\n" + String.format(this.barmasterText.getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (!StalniGostiStolovi.this.text.getText().isEmpty()) {
                    StalniGost sg = StalniGostiStolovi.this.server.getSTGost(StalniGostiStolovi.this.text.getText());
                    Konobar k = StalniGostiStolovi.this.server.konobarBySifra(StalniGostiStolovi.this.text.getText());
                    if (sg != null) {
                        buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", provucena kartica stalnog gosta: " + sg.getNaziv());
                    } else {
                        buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", provucena neaktivna kartica stalnog gosta");
                    }
                    boolean popustNaPopust = Boolean.parseBoolean(StalniGostiStolovi.this.server.getSetting(Option.POPUST_NA_POPUST).getActual());
                    if (popustNaPopust && k != null && konobarSto != null && k.getId() != konobarSto.getId()) {
                        Konstante.prikaziMessageBox(parent, "Izabrani gost je evidentiran kao operater. Izaberite drugog gosta");
                        StalniGostiStolovi.this.text.setFocus();
                        return;
                    }
                    if (sg != null) {
                        StalniGostiStolovi.this.gost = sg;
                        buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", pritisnuto dugme potvrda, izabran stalni gost : " + StalniGostiStolovi.this.gost.getNaziv());
                        StalniGostiStolovi.this.shell5.close();
                        StalniGostiStolovi.this.shell5.close();
                    } else {
                        Konstante.getPoruka(StalniGostiStolovi.this.shell5, "Stalni gost sa unetom sifrom ne postoji,\n ili postoji vise gostiju sa unetom sifrom!");
                    }
                } else {
                    if (StalniGostiStolovi.this.tableRacuni2.getSelectionIndex() < 0) {
                        return;
                    }
                    StalniGostiStolovi.this.gost = StalniGostiStolovi.this.gosti.get(StalniGostiStolovi.this.tableRacuni2.getSelectionIndex());
                    StalniGostiStolovi.this.shell5.close();
                }
            }
        });
        Label gore = new Label(c5, 0x1000800);
        gore.setBackground(this.svCrno);
        gore.setForeground(this.belo);
        gore.setText("\r\n\u02c4");
        gore.setFont(FontCache.getFont("Arial", 18, 1));
        gore.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", pritisnuto dugme: strelica gore ");
                int index = StalniGostiStolovi.this.tableRacuni2.getSelectionIndex();
                if (index == -1) {
                    if (StalniGostiStolovi.this.tableRacuni2.getItemCount() != 0) {
                        StalniGostiStolovi.this.tableRacuni2.setSelection(0);
                    }
                } else if (index != 0) {
                    StalniGostiStolovi.this.tableRacuni2.setSelection(--index);
                }
            }
        });
        Label dole = new Label(c5, 0x1000800);
        dole.setBackground(this.svCrno);
        dole.setForeground(this.belo);
        dole.setText("\r\n\u02c5");
        dole.setFont(FontCache.getFont("Arial", 18, 1));
        dole.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", pritisnuto dugme: strelica dole ");
                int index = StalniGostiStolovi.this.tableRacuni2.getSelectionIndex();
                if (index == -1) {
                    StalniGostiStolovi.this.tableRacuni2.setSelection(StalniGostiStolovi.this.tableRacuni2.getItemCount() - 1);
                } else if (index != StalniGostiStolovi.this.tableRacuni2.getItemCount() - 1) {
                    StalniGostiStolovi.this.tableRacuni2.setSelection(++index);
                }
            }
        });
        Label button = new Label(c5, 0x1000800);
        button.setFont(FontCache.getFont("Arial", 18, 1));
        button.setBackground(this.svCrno);
        button.setForeground(this.belo);
        button.setText("\r\n" + String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        button.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                buttonLogger.info("konobar: " + konobarSto.getPunoime() + ", pritisnuto dugme: izlaz (iz stalnog gosta) ");
                StalniGostiStolovi.this.shell5.close();
                StalniGostiStolovi.this.gost = null;
            }
        });
        data = new GridData();
        data.widthHint = 164;
        data.heightHint = 80;
        data = new GridData(8);
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData((Object)data);
        button.setLayoutData((Object)data);
        gore.setLayoutData((Object)data);
        dole.setLayoutData((Object)data);
        this.text.forceFocus();
        this.shell5.setMaximized(true);
        this.shell5.open();
        while (!this.shell5.isDisposed()) {
            if (this.shell5.getDisplay().readAndDispatch()) continue;
            this.shell5.getDisplay().sleep();
        }
    }

    public StalniGost getGost() {
        return this.gost;
    }

    public void popuniTabelu(StalniGostiGrupa sgg) {
        this.tableRacuni2.removeAll();
        this.gosti = this.server.readStalneGosteBezSifre(sgg);
        for (StalniGost sg : this.gosti) {
            TableItem item = new TableItem(this.tableRacuni2, 0);
            item.setText(0, sg.getNaziv());
        }
    }
}

