/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class StalniGostiGrupe {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    private StalniGostiGrupa active;
    private int rb = 0;
    Composite dugmici;

    public StalniGostiGrupe(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/stalniGostiGrupeV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(this.barmasterText.getString("TEXT_GRUPE_STALNIH_GOSTIJU"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(this.barmasterText.getString("TEXT_SPISAK_GRUPA_STALNIH_GOSTIJU"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(this.barmasterText.getString("TEXT_ATRIBUTI_GRUPE_STALNIH_GOSTIJU"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_NOVA_GRUPA_STALNIH_GOSTIJU"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                StalniGostiGrupe.this.addGrupa();
            }
        });
        label1.setEnabled(true);
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_IZMENA_GRUPE_STALNIH_GOSTIJU"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                StalniGostiGrupe.this.updateGrupa();
            }
        });
        label1.setEnabled(true);
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE_GRUPE_STALNIH_GOSTIJU"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                StalniGostiGrupe.this.deleteGrupa();
            }
        });
        label1.setEnabled(true);
        data = new GridData(1808);
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = StalniGostiGrupe.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                StalniGostiGrupe.this.setActiveGrupa((StalniGostiGrupa)StalniGostiGrupe.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(this.shell);
    }

    private void reload() {
        this.listModel.clear();
        List<StalniGostiGrupa> grupe = this.restoran.getServer().readGrupeStGosti();
        this.rb = grupe.size() + 1;
        for (StalniGostiGrupa l : grupe) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addGrupa() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        StalniGostiDialog gd = new StalniGostiDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVE_GRUPE"), new Object[0])), null);
        SWTContainerClass.makeEnd(shell2);
        if (gd.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_UNOS_GRUPE_STALNIH_GOSTIJU"), new Object[0]) + ":   " + gd.getResult());
            this.restoran.getServer().addGrupaStGostiju(gd.getResult());
            this.reload();
        }
    }

    private void updateGrupa() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        StalniGostiDialog sd = new StalniGostiDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_IZMENA_GRUPE_STALNIH_GOSTIJU"), new Object[0])), this.active);
        SWTContainerClass.makeEnd(shell2);
        StalniGostiGrupa ga = sd.getResult();
        if (ga != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_GRUPE_STALNIH_GOSTIJU"), new Object[0]) + ": " + ga);
            this.restoran.getServer().updateGrupaStGosti(ga);
            this.reload();
        }
    }

    private void deleteGrupa() {
        if (this.active == null) {
            return;
        }
        if (this.server.readStalneGoste(this.active).size() >= 1) {
            int style = 65600;
            MessageBox messageBox = new MessageBox(this.shell, style);
            messageBox.setText(String.format(this.barmasterText.getString("TEXT_INFO"), new Object[0]));
            messageBox.setMessage(String.format(this.barmasterText.getString("PORUKA_MORATE_OBRISATI_SVE_GOSTE_KOJI_PRIPADAJU_IZABRANOJ_GRUPI"), new Object[0]));
            messageBox.open();
        } else {
            int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_GRUPU_IZ_SISTEMA"), this.active.getNaziv()));
            if (ok == 0) {
                this.server.log(String.format(this.barmasterText.getString("LOG_BRISANJE_GRUPE_STALNIH_GOSTIJU"), new Object[0]) + ": " + this.active);
                this.server.deleteGrupaStGosti(this.active);
                this.active = null;
                this.display.setText("");
                this.reload();
            }
        }
    }

    private void setActiveGrupa(StalniGostiGrupa o) {
        this.active = o;
        List<StalniGost> podgrupe = this.server.readStalneGoste(o);
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_STALNI_GOSTI"), new Object[0]) + ": ").append("\n");
        for (int i = 0; i < podgrupe.size(); ++i) {
            bld.append("- ").append(podgrupe.get(i).getNaziv()).append("\n");
        }
        this.display.setText(bld.toString());
    }

    private class StalniGostiDialog {
        private TextInput2 naziv;
        private Button prikaz;
        private StalniGostiGrupa input;
        private StalniGostiGrupa result;

        public StalniGostiDialog(SWTContainer parent, StalniGostiGrupa input) {
            this.input = input;
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            shell3.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            StalniGostiDialog.this.ok(parent2);
                        }
                    }
                }
            });
            Label n = new Label((Composite)shell3, 0);
            n.setBackground(shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(StalniGostiGrupe.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
            this.naziv = new TextInput2(parent, String.format(StalniGostiGrupe.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]), false);
            this.prikaz = new Button((Composite)shell3, 32);
            this.prikaz.setText("Aktivna: ");
            this.prikaz.setSelection(false);
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    StalniGostiDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    StalniGostiDialog.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            data.horizontalSpan = 2;
            n.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalSpan = 3;
            this.prikaz.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            this.naziv.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell3);
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            StalniGostiGrupa ga = this.input != null ? this.input : new StalniGostiGrupa();
            try {
                ga.setNaziv(this.naziv.getResult());
                ga.setAktivan(this.prikaz.getSelection());
                this.result = ga;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(StalniGostiGrupe.this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        public StalniGostiGrupa getResult() {
            return this.result;
        }

        private void loadData() {
            this.naziv.setResult(this.input.getNaziv());
            this.prikaz.setSelection(this.input.isAktivan());
        }
    }
}

