/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TreeWrapper;
import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PregledSvihNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.sistem.ArtikalDialog;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class Sastavnica {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
    RestoranServer server;
    Tree table;
    Shell shell;
    Restoran r;
    Artikal ar;
    Artikal artikalUnormativu;
    List<Normativ> sastL;
    List<Normativ> poslednjiNormativ;
    Map<String, Normativ> sastM = new HashMap<String, Normativ>();
    Boolean sadrziSastojak;

    public Sastavnica(final Artikal ar, Restoran restoran, RestoranServer s, final Display di) {
        this.r = restoran;
        this.server = s;
        this.ar = ar;
        this.shell = new Shell(di, 64);
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_SASTAVNICA_ZA_ARTIKAL"), new Object[0]) + ": " + ar.getName());
        this.shell.setLayout((Layout)new GridLayout());
        this.table = new Tree((Composite)this.shell, 66308);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.makeHeaders();
        this.initTable();
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Normativ n = null;
                if (Sastavnica.this.table.getSelection().length > 0 && Sastavnica.this.sastM.containsKey(Sastavnica.this.table.getSelection()[0].getText(0))) {
                    n = Sastavnica.this.sastM.get(Sastavnica.this.table.getSelection()[0].getText(0));
                }
                if (n != null) {
                    try {
                        Shell s = new Shell(Sastavnica.this.shell.getDisplay());
                        ArtikalDialog ad = new ArtikalDialog(SWTContainerClass.makeContainer(s, String.format(Sastavnica.this.barmasterText.getString("TEXT_IZMENA_ARTIKLA"), new Object[0])), Sastavnica.this.r, n.getArtikal(), n.getOdeljenje(), true);
                        if (ad.getResult() != null) {
                            Artikal a = Sastavnica.this.server.updateArtikal(ad.getResult());
                            for (Odeljenje o : Sastavnica.this.server.readOdeljenje()) {
                                if (o.containsArtikal(a) && !a.getOdeljenja().contains(o)) {
                                    o.removeArtikal(a);
                                    Sastavnica.this.server.updateOdeljenje(o);
                                }
                                if (o.containsArtikal(a) || !a.getOdeljenja().contains(o)) continue;
                                o.setArtikal(a);
                                Sastavnica.this.server.updateOdeljenje(o);
                            }
                        }
                        Sastavnica.this.initTable();
                        Sastavnica.this.stretchCols();
                    }
                    catch (FiscalException ex) {
                        Logger.getLogger(Sastavnica.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SerialIOException ex) {
                        Logger.getLogger(Sastavnica.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        GridData data = new GridData(1808);
        this.table.setLayoutData((Object)data);
        Button printButton = new Button((Composite)this.shell, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Shell shell2 = new Shell(di, 64);
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TreeWrapper(Sastavnica.this.table), false, true, String.format(Sastavnica.this.barmasterText.getString("TEXT_SASTAVNICA_ZA_ARTIKAL"), new Object[0]) + ": " + ar.getName(), shell2, Sastavnica.this.server);
            }
        });
        Button printNormButton = new Button((Composite)this.shell, 8);
        try {
            printNormButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printNormButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_NORMATIVA"), new Object[0]));
        printNormButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LinkedList<Artikal> listaArtikala = new LinkedList<Artikal>();
                for (Normativ normativ : Sastavnica.this.sastM.values()) {
                    listaArtikala.add(normativ.getArtikal());
                }
                Shell s = new Shell(Sastavnica.this.shell);
                new PregledSvihNormativa(Sastavnica.this.server, s, Sastavnica.this.r, ar.getOdeljenje(), listaArtikala, true);
                while (!s.isDisposed()) {
                    if (s.getDisplay().readAndDispatch()) continue;
                    s.getDisplay().sleep();
                }
                s.dispose();
            }
        });
        this.shell.setMaximized(true);
        this.shell.open();
        this.stretchCols();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TreeColumn tc1 = new TreeColumn(this.table, 0);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
        tc1.setWidth(200);
        TreeColumn tc2 = new TreeColumn(this.table, 0);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE"), new Object[0]));
        tc2.setWidth(200);
        TreeColumn tc3 = new TreeColumn(this.table, 0);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc3.setWidth(200);
        TreeColumn tc4 = new TreeColumn(this.table, 0);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]));
        tc4.setWidth(200);
    }

    private void initTable() {
        this.table.removeAll();
        this.sastL = new LinkedList<Normativ>();
        System.out.println("sad sam ovde");
        List<Normativ> artikli = this.server.readArtikleZaSastojak(this.ar);
        System.out.println(this.ar.getName());
        for (Normativ n : artikli) {
            this.sadrziSastojak = false;
            this.poslednjiNormativ = this.server.getPoslednjiNormativ(n.getArtikal());
            if (this.server.najveciNormativArtikalId(n.getArtikal()) <= n.getNormativArtikal().getId()) {
                for (Normativ n1 : this.poslednjiNormativ) {
                    System.out.println(n1.getArtikal().getName() + " " + n1.getSastojak().getName());
                    System.out.println("Za sastojak " + n.getSastojak().getName());
                    if (n1.getSastojak().getId() != n.getSastojak().getId()) continue;
                    this.sadrziSastojak = true;
                    break;
                }
            }
            this.poslednjiNormativ.clear();
            System.out.println(this.sadrziSastojak);
            if (!this.sadrziSastojak.booleanValue()) continue;
            double d = n.getKolicina();
            int i = 0;
            TreeItem ti0 = new TreeItem(this.table, 16384);
            ti0.setText(new String[]{n.getArtikal().getName(), n.getArtikal().getJedinicaMere(), Konstante.getNumber4(n.getKolicina()), n.getOdeljenje().getNaziv()});
            ++i;
            this.sastM.put(ti0.getText(0), n);
            List<Normativ> artikli2 = this.server.readArtikleZaSastojak(n.getArtikal());
            if (artikli2.size() > 0) {
                for (Normativ n2 : artikli2) {
                    double d2 = n2.getKolicina();
                    List<Normativ> poslednjiNormativ = this.server.getPoslednjiNormativ(n2.getArtikal());
                    if (!this.isSastojak(n.getArtikal(), poslednjiNormativ)) continue;
                    TreeItem ti1 = new TreeItem(ti0, 16384);
                    ti1.setText(new String[]{n2.getArtikal().getName(), n2.getArtikal().getJedinicaMere(), Konstante.getNumber4(d * d2), n2.getOdeljenje().getNaziv()});
                    ++i;
                    this.sastM.put(ti1.getText(0), n2);
                    List<Normativ> artikli3 = this.server.readArtikleZaSastojak(n2.getArtikal());
                    if (artikli3.size() <= 0) continue;
                    for (Normativ n3 : artikli3) {
                        double d3 = n3.getKolicina();
                        TreeItem ti2 = new TreeItem(ti1, 16384);
                        ti2.setText(new String[]{n3.getArtikal().getName(), n3.getArtikal().getJedinicaMere(), Konstante.getNumber4(d * d2 * d3), n3.getOdeljenje().getNaziv()});
                        ++i;
                        this.sastM.put(ti2.getText(0), n3);
                        List<Normativ> artikli4 = this.server.readArtikleZaSastojak(n3.getArtikal());
                        if (artikli4.size() <= 0) continue;
                        for (Normativ n4 : artikli4) {
                            double d4 = n4.getKolicina();
                            TreeItem ti3 = new TreeItem(ti2, 16384);
                            ti3.setText(new String[]{n4.getArtikal().getName(), n4.getArtikal().getJedinicaMere(), Konstante.getNumber4(d * d2 * d3 * d4), n4.getOdeljenje().getNaziv()});
                            ++i;
                            this.sastM.put(ti3.getText(0), n4);
                        }
                    }
                }
            }
            TreeItem treeItem = new TreeItem(this.table, 16384);
        }
    }

    private void stretchCols() {
        int zbirno = 0;
        for (TreeColumn tc : this.table.getColumns()) {
            zbirno += tc.getWidth();
        }
        for (TreeColumn tc : this.table.getColumns()) {
            float w = tc.getWidth();
            float z = zbirno;
            float fw = this.table.getBounds().width;
            System.out.println("w ");
            float nwd = w / z * fw;
            int nw = Math.round(nwd);
            tc.setWidth(nw);
        }
    }

    public String getPrefix(int lvl) {
        String pfx = "";
        while (lvl > 0) {
            pfx = pfx + "   |";
            if (--lvl != 0) continue;
            pfx = pfx + "   ";
        }
        return pfx;
    }

    private boolean isSastojak(Artikal a, List<Normativ> lista) {
        for (Normativ normativ : lista) {
            if (normativ.getSastojak().getId() != a.getId()) continue;
            return true;
        }
        return false;
    }
}

