/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.sistem.LayoutExample;
import com.dev63.restoran.sistem.Tab;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class RowLayoutTab
extends Tab {
    Button horizontal;
    Button vertical;
    Button wrap;
    Button pack;
    Button justify;
    Combo marginRight;
    Combo marginLeft;
    Combo marginTop;
    Combo marginBottom;
    Combo spacing;
    RowLayout rowLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    CCombo combo;
    Text widthText;
    Text heightText;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int TOTAL_COLS = 4;

    RowLayoutTab(LayoutExample instance) {
        super(instance);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                RowLayoutTab.this.resetEditors();
                RowLayoutTab.this.index = RowLayoutTab.this.table.getSelectionIndex();
                Point pt = new Point(e.x, e.y);
                RowLayoutTab.this.newItem = RowLayoutTab.this.table.getItem(pt);
                if (RowLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem oldItem = RowLayoutTab.this.comboEditor.getItem();
                if (RowLayoutTab.this.newItem == oldItem || RowLayoutTab.this.newItem != RowLayoutTab.this.lastSelected) {
                    RowLayoutTab.this.lastSelected = RowLayoutTab.this.newItem;
                    return;
                }
                RowLayoutTab.this.table.showSelection();
                RowLayoutTab.this.combo = new CCombo((Composite)RowLayoutTab.this.table, 8);
                RowLayoutTab.this.createComboEditor(RowLayoutTab.this.combo, RowLayoutTab.this.comboEditor);
                RowLayoutTab.this.widthText = new Text((Composite)RowLayoutTab.this.table, 4);
                RowLayoutTab.this.widthText.setText(((String[])RowLayoutTab.this.data.elementAt(RowLayoutTab.this.index))[2]);
                RowLayoutTab.this.createTextEditor(RowLayoutTab.this.widthText, RowLayoutTab.this.widthEditor, 2);
                RowLayoutTab.this.heightText = new Text((Composite)RowLayoutTab.this.table, 4);
                RowLayoutTab.this.heightText.setText(((String[])RowLayoutTab.this.data.elementAt(RowLayoutTab.this.index))[3]);
                RowLayoutTab.this.createTextEditor(RowLayoutTab.this.heightText, RowLayoutTab.this.heightEditor, 3);
                block5: for (int i = 0; i < RowLayoutTab.this.table.getColumnCount(); ++i) {
                    Rectangle rect = RowLayoutTab.this.newItem.getBounds(i);
                    if (!rect.contains(pt)) continue;
                    switch (i) {
                        case 1: {
                            RowLayoutTab.this.combo.setFocus();
                            continue block5;
                        }
                        case 2: {
                            RowLayoutTab.this.widthText.setFocus();
                            continue block5;
                        }
                        case 3: {
                            RowLayoutTab.this.heightText.setFocus();
                            continue block5;
                        }
                        default: {
                            RowLayoutTab.this.resetEditors();
                        }
                    }
                }
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(RowLayoutTab.this.table, 0);
                String[] insert = new String[]{String.valueOf(RowLayoutTab.this.table.indexOf(item)), "Button", "-1", "-1"};
                item.setText(insert);
                RowLayoutTab.this.data.addElement(insert);
                RowLayoutTab.this.resetEditors();
            }
        });
    }

    @Override
    void createControlWidgets() {
        Group typeGroup = new Group((Composite)this.controlGroup, 0);
        typeGroup.setText(LayoutExample.getResourceString("Type"));
        typeGroup.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        typeGroup.setLayoutData((Object)data);
        this.horizontal = new Button((Composite)typeGroup, 16);
        this.horizontal.setText("SWT.HORIZONTAL");
        this.horizontal.setLayoutData((Object)new GridData(768));
        this.horizontal.setSelection(true);
        this.horizontal.addSelectionListener(this.selectionListener);
        this.vertical = new Button((Composite)typeGroup, 16);
        this.vertical.setText("SWT.VERTICAL");
        this.vertical.setLayoutData((Object)new GridData(768));
        this.vertical.addSelectionListener(this.selectionListener);
        String[] marginValues = new String[]{"0", "3", "5", "10"};
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins_Spacing"));
        data = new GridData(770);
        data.verticalSpan = 2;
        marginGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        marginGroup.setLayout((Layout)layout);
        new Label((Composite)marginGroup, 0).setText("marginRight");
        this.marginRight = new Combo((Composite)marginGroup, 0);
        this.marginRight.setItems(marginValues);
        this.marginRight.select(1);
        this.marginRight.setLayoutData((Object)new GridData(768));
        this.marginRight.addSelectionListener(this.selectionListener);
        this.marginRight.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("marginLeft");
        this.marginLeft = new Combo((Composite)marginGroup, 0);
        this.marginLeft.setItems(marginValues);
        this.marginLeft.select(1);
        this.marginLeft.setLayoutData((Object)new GridData(768));
        this.marginLeft.addSelectionListener(this.selectionListener);
        this.marginLeft.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("marginTop");
        this.marginTop = new Combo((Composite)marginGroup, 0);
        this.marginTop.setItems(marginValues);
        this.marginTop.select(1);
        this.marginTop.setLayoutData((Object)new GridData(768));
        this.marginTop.addSelectionListener(this.selectionListener);
        this.marginTop.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("marginBottom");
        this.marginBottom = new Combo((Composite)marginGroup, 0);
        this.marginBottom.setItems(marginValues);
        this.marginBottom.select(1);
        this.marginBottom.setLayoutData((Object)new GridData(768));
        this.marginBottom.addSelectionListener(this.selectionListener);
        this.marginBottom.addTraverseListener(this.traverseListener);
        new Label((Composite)marginGroup, 0).setText("spacing");
        this.spacing = new Combo((Composite)marginGroup, 0);
        this.spacing.setItems(marginValues);
        this.spacing.select(1);
        this.spacing.setLayoutData((Object)new GridData(768));
        this.spacing.addSelectionListener(this.selectionListener);
        this.spacing.addTraverseListener(this.traverseListener);
        Group specGroup = new Group((Composite)this.controlGroup, 0);
        specGroup.setText(LayoutExample.getResourceString("Properties"));
        specGroup.setLayoutData((Object)new GridData(768));
        specGroup.setLayout((Layout)new GridLayout());
        this.wrap = new Button((Composite)specGroup, 32);
        this.wrap.setText("wrap");
        this.wrap.setSelection(true);
        this.wrap.setLayoutData((Object)new GridData(768));
        this.wrap.addSelectionListener(this.selectionListener);
        this.pack = new Button((Composite)specGroup, 32);
        this.pack.setText("pack");
        this.pack.setLayoutData((Object)new GridData(768));
        this.pack.setSelection(true);
        this.pack.addSelectionListener(this.selectionListener);
        this.justify = new Button((Composite)specGroup, 32);
        this.justify.setText("justify");
        this.justify.setLayoutData((Object)new GridData(768));
        this.justify.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
        this.sash.setWeights(new int[]{6, 5});
    }

    @Override
    void createLayout() {
        this.rowLayout = new RowLayout();
        this.layoutComposite.setLayout((Layout)this.rowLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
    }

    @Override
    StringBuffer generateLayoutCode() {
        StringBuffer code = new StringBuffer();
        code.append("\t\tRowLayout rowLayout = new RowLayout ();\n");
        if (this.rowLayout.type == 512) {
            code.append("\t\trowLayout.type = SWT.VERTICAL;\n");
        }
        if (!this.rowLayout.wrap) {
            code.append("\t\trowLayout.wrap = false;\n");
        }
        if (!this.rowLayout.pack) {
            code.append("\t\trowLayout.pack = false;\n");
        }
        if (this.rowLayout.justify) {
            code.append("\t\trowLayout.justify = true;\n");
        }
        if (this.rowLayout.marginLeft != 3) {
            code.append("\t\trowLayout.marginLeft = " + this.rowLayout.marginLeft + ";\n");
        }
        if (this.rowLayout.marginRight != 3) {
            code.append("\t\trowLayout.marginRight = " + this.rowLayout.marginRight + ";\n");
        }
        if (this.rowLayout.marginTop != 3) {
            code.append("\t\trowLayout.marginTop = " + this.rowLayout.marginTop + ";\n");
        }
        if (this.rowLayout.marginBottom != 3) {
            code.append("\t\trowLayout.marginBottom = " + this.rowLayout.marginBottom + ";\n");
        }
        if (this.rowLayout.spacing != 3) {
            code.append("\t\trowLayout.spacing = " + this.rowLayout.spacing + ";\n");
        }
        code.append("\t\tshell.setLayout (rowLayout);\n");
        boolean first = true;
        for (int i = 0; i < this.children.length; ++i) {
            Control control = this.children[i];
            code.append(this.getChildCode(control, i));
            RowData data = (RowData)control.getLayoutData();
            if (data == null || data.width == -1 && data.height == -1) continue;
            code.append("\t\t");
            if (first) {
                code.append("RowData ");
                first = false;
            }
            if (data.width == -1) {
                code.append("data = new RowData (SWT.DEFAULT, " + data.height + ");\n");
            } else if (data.height == -1) {
                code.append("data = new RowData (" + data.width + ", SWT.DEFAULT);\n");
            } else {
                code.append("data = new RowData (" + data.width + ", " + data.height + ");\n");
            }
            code.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
        }
        return code;
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control", "width", "height"};
    }

    @Override
    String getTabText() {
        return "RowLayout";
    }

    @Override
    void resetEditors() {
        this.resetEditors(false);
    }

    @Override
    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new Integer(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException e) {
                this.widthText.setText(oldItem.getText(2));
            }
            try {
                new Integer(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException e) {
                this.heightText.setText(oldItem.getText(3));
            }
            String[] insert = new String[]{String.valueOf(row), this.combo.getText(), this.widthText.getText(), this.heightText.getText()};
            this.data.setElementAt(insert, row);
            for (int i = 0; i < 4; ++i) {
                oldItem.setText(i, ((String[])this.data.elementAt(row))[i]);
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    @Override
    void setLayoutData() {
        Control[] children = this.layoutComposite.getChildren();
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < children.length; ++i) {
            int width = new Integer(items[i].getText(2));
            int height = new Integer(items[i].getText(3));
            RowData data = new RowData(width, height);
            children[i].setLayoutData((Object)data);
        }
    }

    @Override
    void setLayoutState() {
        this.rowLayout.type = this.vertical.getSelection() ? 512 : 256;
        try {
            this.rowLayout.marginRight = new Integer(this.marginRight.getText());
        }
        catch (NumberFormatException e) {
            this.rowLayout.marginRight = 3;
            this.marginRight.select(1);
        }
        try {
            this.rowLayout.marginLeft = new Integer(this.marginLeft.getText());
        }
        catch (NumberFormatException e) {
            this.rowLayout.marginLeft = 3;
            this.marginLeft.select(1);
        }
        try {
            this.rowLayout.marginTop = new Integer(this.marginTop.getText());
        }
        catch (NumberFormatException e) {
            this.rowLayout.marginTop = 3;
            this.marginTop.select(1);
        }
        try {
            this.rowLayout.marginBottom = new Integer(this.marginBottom.getText());
        }
        catch (NumberFormatException e) {
            this.rowLayout.marginBottom = 3;
            this.marginBottom.select(1);
        }
        try {
            this.rowLayout.spacing = new Integer(this.spacing.getText());
        }
        catch (NumberFormatException e) {
            this.rowLayout.spacing = 3;
            this.spacing.select(1);
        }
        this.rowLayout.wrap = this.wrap.getSelection();
        this.rowLayout.pack = this.pack.getSelection();
        this.rowLayout.justify = this.justify.getSelection();
    }
}

