/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.Zalihe2;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PreostalaKolicina {
    public static double izracunajPocetno(Artikal a, Date day1, boolean isBelo, boolean isCrno, RestoranServer server, Odeljenje o) {
        double pocetno = 0.0;
        if (isBelo) {
            pocetno += server.getDnevnoStanjeBelo(a, Konstante.getOnlyDate(day1), o);
        }
        if (isCrno) {
            pocetno += server.getDnevnoStanjeCrno(a, Konstante.getOnlyDate(day1), o);
        }
        return pocetno;
    }

    public static double izracunajPocetnoMag(Artikal a, Date day1, boolean isBelo, boolean isCrno, RestoranServer server, Odeljenje o) {
        double pocetno = 0.0;
        if (isBelo) {
            pocetno += server.getDnevnoStanjeMagBelo(a, Konstante.getPocetniDatum(day1, server), o);
        }
        if (isCrno) {
            pocetno += server.getDnevnoStanjeMagCrno(a, Konstante.getPocetniDatum(day1, server), o);
        }
        return pocetno;
    }

    public static double izracunajZalihe(Artikal a, Odeljenje o, RestoranServer server) {
        System.out.println(a + ", id: " + a.getId());
        List<Kartica> kartice = server.readKartice(a, o);
        double zalihe = 0.0;
        for (Kartica k : kartice) {
            zalihe += k.getKolicina().doubleValue();
        }
        return zalihe;
    }

    public static double izracunajZaliheBele(Artikal a, Odeljenje o, RestoranServer server) {
        List<Kartica> kartice = server.readKarticeBele(a, o);
        double zalihe = 0.0;
        for (Kartica k : kartice) {
            zalihe += k.getKolicina().doubleValue();
        }
        return zalihe;
    }

    public static double izracunajZaliheCrne(Artikal a, Odeljenje o, RestoranServer server) {
        List<Kartica> kartice = server.readKarticeCrne(a, o);
        double zalihe = 0.0;
        for (Kartica k : kartice) {
            zalihe += k.getKolicina().doubleValue();
        }
        return zalihe;
    }

    public static double izracunajZaliheB(Artikal a, Odeljenje o, RestoranServer server) {
        List<Kartica> kartice = server.readKartice(a, o);
        double zalihe = 0.0;
        for (Kartica k : kartice) {
            if (k.getCrno() != null && k.getCrno().booleanValue()) continue;
            zalihe += k.getKolicina().doubleValue();
        }
        return zalihe;
    }

    public static double izracunajZaliheC(Artikal a, Odeljenje o, RestoranServer server) {
        List<Kartica> kartice = server.readKartice(a, o);
        double zalihe = 0.0;
        for (Kartica k : kartice) {
            if (k.getCrno() == null || !k.getCrno().booleanValue()) continue;
            zalihe += k.getKolicina().doubleValue();
        }
        return zalihe;
    }

    public static List<Zalihe2> getZalihe(Odeljenje o, RestoranServer server) {
        ArrayList<Zalihe2> zalihe = new ArrayList<Zalihe2>();
        List<Artikal> artikli = server.getOdeljenje(o.getNaziv()).getArtikli();
        for (Artikal a : artikli) {
            List<Kartica> kartice = server.readKartice(a, o);
            double z = 0.0;
            for (Kartica k : kartice) {
                z += k.getKolicina().doubleValue();
            }
            zalihe.add(new Zalihe2(a, z, o));
        }
        return zalihe;
    }

    public static List<Artikal> getArtikli(Odeljenje o1, Odeljenje o2, RestoranServer server) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        List<Artikal> artikli1 = server.getOdeljenje(o1.getNaziv()).getArtikli();
        List<Artikal> artikli2 = server.getOdeljenje(o2.getNaziv()).getArtikli();
        for (Artikal a1 : artikli1) {
            for (Artikal a2 : artikli2) {
                if (!a1.equals(a2) || a1.getBlokiran().booleanValue()) continue;
                artikli.add(a1);
            }
        }
        return artikli;
    }

    public static boolean hasCommonArticles(Odeljenje o1, Odeljenje o2, RestoranServer server) {
        return server.hasCommonArticles(o1, o2);
    }

    public static List<Artikal> getArtikliBezSlozenihISirovina(Odeljenje o1, RestoranServer server) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        List<Artikal> artikli1 = server.getOdeljenje(o1.getNaziv()).getArtikli();
        for (Artikal a1 : artikli1) {
            if (a1.getBlokiran().booleanValue() || a1.getTip().equals((Object)TipArtikla.SLOZ) || a1.getTip().equals((Object)TipArtikla.SIRO)) continue;
            artikli.add(a1);
        }
        return artikli;
    }

    public static List<Artikal> getSirovine(Odeljenje o1, RestoranServer server) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        List<Artikal> artikli1 = server.getOdeljenje(o1.getNaziv()).getArtikli();
        for (Artikal a1 : artikli1) {
            if (!a1.getTip().equals((Object)TipArtikla.SIRO) || a1.getBlokiran().booleanValue()) continue;
            artikli.add(a1);
        }
        return artikli;
    }
}

