/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.sistem.PoreskaStopa;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoreskeStope {
    private static final Logger logger;
    private static final Properties aktuelneStope;
    private static final Map<Date, Properties> stopeSaPromenama;
    private static final String oldStopeFilePath = "config/stope.conf";
    private static final String ratePrefix = "rates";
    private static final String stopeFilePath = "config/rates.conf";
    private static final String stopePromeneFolderPath = "config/rateChanges";
    private static final SimpleDateFormat rateDateFormat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadRatesFromFile(File file) {
        Properties props = null;
        FileInputStream is = null;
        InputStreamReader isr = null;
        try {
            is = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)is, Charset.forName("utf8"));
            props = new Properties();
            props.load(isr);
            props.list(System.out);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
            try {
                isr.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
        return props;
    }

    private static boolean setStopa(String key, String value) {
        String oldValue = aktuelneStope.getProperty(key);
        aktuelneStope.setProperty(key, value);
        if (!PoreskeStope.saveSettings()) {
            System.out.println("save failed");
            aktuelneStope.setProperty(key, oldValue);
            return false;
        }
        return true;
    }

    public static boolean saveRateChange(Date dateOfChange) {
        boolean ret = false;
        try {
            Properties newProp = new Properties();
            Properties props = aktuelneStope;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String val;
                String key = (String)en.nextElement();
                String unicodeVal = val = props.getProperty(key);
                newProp.put(key, unicodeVal);
            }
            String fileName = "rates_" + rateDateFormat.format(new Date()) + ".conf";
            File ff = new File(stopePromeneFolderPath, fileName);
            if (ff.exists() && !ff.delete()) {
                return false;
            }
            if (PoreskeStope.saveRatesToFile(newProp, ff)) {
                stopeSaPromenama.put(Konstante.getOnlyDate(dateOfChange), newProp);
                ret = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return ret;
    }

    public static boolean setChangedRates(List<PoreskaStopa> rates, Date dateOfChange) {
        if (rates == null || rates.isEmpty() || rates.size() != PoreskaGrupa.values().length) {
            return false;
        }
        if (PoreskeStope.saveRateChange(dateOfChange)) {
            aktuelneStope.clear();
            List<PoreskaStopa> oldList = PoreskeStope.getAllRates();
            for (PoreskaStopa ps : rates) {
                if (PoreskeStope.setStopa(ps)) continue;
                for (PoreskaStopa pss : oldList) {
                    PoreskeStope.setStopa(pss);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean setStopa(PoreskaStopa ps) {
        if (ps.getNaziv() == null || ps.getPg() == null) {
            return false;
        }
        String oldValue = aktuelneStope.getProperty(ps.getPg().name());
        aktuelneStope.setProperty(ps.getPg().name(), ps.getPersistValue());
        if (!PoreskeStope.saveSettings()) {
            System.out.println("save failed");
            aktuelneStope.setProperty(ps.getPg().name(), oldValue);
            return false;
        }
        return true;
    }

    public static PoreskaStopa getPoreskaStopa(PoreskaGrupa pg) {
        PoreskaStopa ps = null;
        try {
            String stopaV = PoreskeStope.getStopa(pg.name());
            if (stopaV == null) {
                return null;
            }
            ps = new PoreskaStopa(pg, stopaV);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return ps;
    }

    public static PoreskaStopa getPoreskaStopa(PoreskaGrupa pg, Date date) {
        PoreskaStopa ps = null;
        try {
            String stopaV = PoreskeStope.getStopa(pg.name(), date);
            if (stopaV == null) {
                return null;
            }
            ps = new PoreskaStopa(pg, stopaV);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return ps;
    }

    private static String getStopa(String key) {
        return aktuelneStope.getProperty(key);
    }

    private static String getStopa(String key, Date date) {
        LinkedList<Date> list = new LinkedList<Date>(stopeSaPromenama.keySet());
        Collections.sort(list);
        Properties prop = null;
        prop = aktuelneStope;
        for (Date date1 : list) {
            if (date.compareTo(date1) >= 0) continue;
            prop = stopeSaPromenama.get(date1);
            break;
        }
        return prop.getProperty(key);
    }

    public static boolean saveSettings() {
        try {
            File f = new File(stopeFilePath);
            return PoreskeStope.saveRatesToFile(aktuelneStope, f);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveRatesToFile(Properties rates, File f) {
        boolean ret = false;
        FileOutputStream fos = null;
        OutputStreamWriter fw = null;
        try {
            fos = new FileOutputStream(f);
            fw = new OutputStreamWriter((OutputStream)fos, Charset.forName("utf8"));
            rates.store(fw, null);
            fw.flush();
            ret = true;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            try {
                fos.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return ret;
    }

    public static Map<PoreskaGrupa, PoreskaStopa> getRates() {
        EnumMap<PoreskaGrupa, PoreskaStopa> map = new EnumMap<PoreskaGrupa, PoreskaStopa>(PoreskaGrupa.class);
        Enumeration<?> keys = aktuelneStope.propertyNames();
        while (keys.hasMoreElements()) {
            Object object = keys.nextElement();
            String s = object.toString();
            PoreskaGrupa pg = null;
            for (PoreskaGrupa pgt : PoreskaGrupa.values()) {
                if (!pgt.name().equals(s)) continue;
                pg = pgt;
                break;
            }
            if (pg == null) continue;
            PoreskaStopa ps = PoreskeStope.getPoreskaStopa(pg);
            map.put(pg, ps);
        }
        return map;
    }

    public static List<PoreskaStopa> getUsedRates() {
        LinkedList<PoreskaStopa> list = new LinkedList<PoreskaStopa>();
        Enumeration<?> keys = aktuelneStope.propertyNames();
        while (keys.hasMoreElements()) {
            PoreskaStopa ps;
            Object object = keys.nextElement();
            String s = object.toString();
            PoreskaGrupa pg = null;
            for (PoreskaGrupa pgt : PoreskaGrupa.values()) {
                if (!pgt.name().equals(s)) continue;
                pg = pgt;
                break;
            }
            if (pg == null || !(ps = PoreskeStope.getPoreskaStopa(pg)).isUsed()) continue;
            list.add(ps);
        }
        return list;
    }

    public static List<PoreskaStopa> getAllRates() {
        LinkedList<PoreskaStopa> list = new LinkedList<PoreskaStopa>();
        Enumeration<?> keys = aktuelneStope.propertyNames();
        while (keys.hasMoreElements()) {
            Object object = keys.nextElement();
            String s = object.toString();
            PoreskaGrupa pg = null;
            for (PoreskaGrupa pgt : PoreskaGrupa.values()) {
                if (!pgt.name().equals(s)) continue;
                pg = pgt;
                break;
            }
            if (pg == null) continue;
            PoreskaStopa ps = PoreskeStope.getPoreskaStopa(pg);
            list.add(ps);
        }
        return list;
    }

    public static PoreskaStopa getDefaultStopa() {
        List<PoreskaStopa> list = PoreskeStope.getUsedRates();
        PoreskaStopa ps = null;
        for (PoreskaStopa pss : list) {
            if (ps == null) {
                ps = pss;
            }
            if (!pss.isUsed() || !pss.isMostUsedRate()) continue;
            ps = pss;
        }
        return ps;
    }

    public static PoreskaStopa getDefaultNonVatStopa() {
        List<PoreskaStopa> list = PoreskeStope.getAllRates();
        PoreskaStopa ps = null;
        for (PoreskaStopa pss : list) {
            if (!pss.isNonVatRate()) continue;
            ps = pss;
        }
        if (ps == null) {
            logger.info("Podrazumevana poreska stopa za poreznike van PDV nije pronadjena, uzeta je prva definisana stopa");
            ps = list.get(0);
        }
        return ps;
    }

    private static void saveDefaultValues() {
        NumberFormat nf = NumberFormat.getInstance(Locale.UK);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setRoundingMode(RoundingMode.HALF_EVEN);
        aktuelneStope.clear();
        for (DefaultStope ds : DefaultStope.values()) {
            String value = ds.getStopa().getPersistValue();
            aktuelneStope.put(ds.getStopa().getPg().name(), value);
        }
        PoreskeStope.saveSettings();
    }

    public static void main(String[] args) {
        for (Map.Entry<Date, Properties> entry : stopeSaPromenama.entrySet()) {
            Date date = entry.getKey();
            Properties properties = entry.getValue();
            System.out.println("date = " + date);
            for (Map.Entry<Object, Object> entry1 : properties.entrySet()) {
                String key = (String)entry1.getKey();
                String value = (String)entry1.getValue();
                System.out.println("key = " + key);
                System.out.println("value = " + value);
            }
            System.out.println("");
        }
        System.out.println("");
        System.out.println("");
        System.out.println("");
        Calendar cal = Calendar.getInstance();
        cal.set(2, 7);
        cal.set(5, 15);
        System.out.println("cal.getTime() = " + cal.getTime());
        System.out.println(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_G, cal.getTime()).getStopa());
        cal.set(2, 8);
        cal.set(5, 15);
        System.out.println("cal.getTime() = " + cal.getTime());
        System.out.println(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_G, cal.getTime()).getStopa());
        cal.set(2, 9);
        cal.set(5, 15);
        System.out.println("cal.getTime() = " + cal.getTime());
        System.out.println(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_G, cal.getTime()).getStopa());
    }

    static {
        File[] rcChildren;
        logger = Logger.getLogger(PoreskeStope.class.getName());
        stopeSaPromenama = new HashMap<Date, Properties>();
        rateDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        File rateChangeDir = new File(stopePromeneFolderPath);
        if (!rateChangeDir.exists()) {
            rateChangeDir.mkdirs();
        } else if (!rateChangeDir.isDirectory()) {
            rateChangeDir.delete();
            rateChangeDir.mkdir();
        }
        FileFilter rateFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name;
                boolean ret = false;
                if (pathname.isFile() && (name = pathname.getName()).startsWith(PoreskeStope.ratePrefix) && name.endsWith(".conf")) {
                    String[] parts;
                    String nameOnly = name.substring(0, name.length() - 5);
                    System.out.println("nameOnly = " + nameOnly);
                    if (nameOnly.contains("_") && (parts = nameOnly.split("_")).length == 2) {
                        String dateExt = parts[1];
                        System.out.println("dateExt = " + dateExt);
                        Date d = null;
                        try {
                            d = rateDateFormat.parse(dateExt);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (d != null) {
                            ret = true;
                        }
                    }
                }
                return ret;
            }
        };
        for (File file : rcChildren = rateChangeDir.listFiles(rateFileFilter)) {
            String name = file.getName();
            String nameOnly = name.substring(0, name.length() - 5);
            String[] parts = nameOnly.split("_");
            String dateExt = parts[1];
            try {
                Date d = rateDateFormat.parse(dateExt);
                Properties prop = PoreskeStope.loadRatesFromFile(file);
                stopeSaPromenama.put(d, prop);
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        File f = new File(stopeFilePath);
        File oldStope = new File(oldStopeFilePath);
        if (oldStope.exists()) {
            oldStope.renameTo(f);
        }
        if (oldStope.exists()) {
            oldStope.delete();
        }
        aktuelneStope = new Properties();
        if (!f.exists()) {
            PoreskeStope.saveDefaultValues();
        } else {
            if (f.isDirectory()) {
                f.delete();
                PoreskeStope.saveDefaultValues();
            }
            Properties props = PoreskeStope.loadRatesFromFile(f);
            Enumeration<?> en = props.propertyNames();
            aktuelneStope.clear();
            while (en.hasMoreElements()) {
                String val;
                String key = (String)en.nextElement();
                String unicodeVal = val = props.getProperty(key);
                aktuelneStope.put(key, unicodeVal);
            }
        }
    }

    private static enum DefaultStope {
        STOPA_1(new PoreskaStopa(0.0, 'A', "GRUPA_A", PoreskaGrupa.GRUPA_A, false, true, false)),
        STOPA_2(new PoreskaStopa(0.0, 'G', "GRUPA_G", PoreskaGrupa.GRUPA_G, true, false, false)),
        STOPA_3(new PoreskaStopa(0.0, 'D', "GRUPA_D", PoreskaGrupa.GRUPA_D, false, false, false)),
        STOPA_4(new PoreskaStopa(20.0, '\u0110', "GRUPA_\u0110", PoreskaGrupa.GRUPA_DJ, true, false, true)),
        STOPA_5(new PoreskaStopa(10.0, 'E', "GRUPA_E", PoreskaGrupa.GRUPA_E, true, false, false)),
        STOPA_6(new PoreskaStopa(0.0, '\u017d', "GRUPA_\u017d", PoreskaGrupa.GRUPA_ZJ, false, false, false)),
        STOPA_7(new PoreskaStopa(0.0, 'I', "GRUPA_I", PoreskaGrupa.GRUPA_I, false, false, false)),
        STOPA_8(new PoreskaStopa(0.0, 'J', "GRUPA_J", PoreskaGrupa.GRUPA_J, false, false, false)),
        STOPA_9(new PoreskaStopa(0.0, 'K', "GRUPA_K", PoreskaGrupa.GRUPA_K, false, false, false));

        private PoreskaStopa stopa;

        private DefaultStope(PoreskaStopa stopa) {
            this.stopa = stopa;
        }

        public PoreskaStopa getStopa() {
            return this.stopa;
        }
    }
}

