/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoreskaStopa {
    private double stopa;
    private char oznaka;
    private String naziv;
    private PoreskaGrupa pg;
    private boolean used;
    private boolean nonVatRate;
    private boolean mostUsedRate;

    public PoreskaStopa(double stopa, char oznaka, String naziv, PoreskaGrupa pg, boolean used, boolean nonVatRate, boolean mostUsedRate) {
        this.stopa = stopa;
        this.oznaka = oznaka;
        this.naziv = naziv;
        this.pg = pg;
        this.used = used;
        this.nonVatRate = nonVatRate;
        this.mostUsedRate = mostUsedRate;
    }

    public PoreskaStopa(PoreskaGrupa pg, String value) {
        this.parsePersistValue(pg, value);
    }

    public double getStopa() {
        return this.stopa;
    }

    public BigDecimal getStopaBD() {
        return BigDecimal.valueOf(this.stopa);
    }

    public char getOznaka() {
        return this.oznaka;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public PoreskaGrupa getPg() {
        return this.pg;
    }

    public boolean isUsed() {
        return this.used;
    }

    public String getPersistValue() {
        String value = "";
        value = value + this.getStopaFormat().format(this.getStopa());
        value = value + "~";
        value = value + this.getOznaka();
        value = value + "~";
        value = value + this.getNaziv();
        value = value + "~";
        value = value + Boolean.toString(this.isUsed());
        value = value + "~";
        value = value + Boolean.toString(this.isNonVatRate());
        value = value + "~";
        value = value + Boolean.toString(this.isMostUsedRate());
        return value;
    }

    private void parsePersistValue(PoreskaGrupa pg, String persistValue) {
        try {
            String[] persStrings = persistValue.split("~");
            this.setStopa(this.getStopaFormat().parse(persStrings[0]).doubleValue());
            this.setOznaka(persStrings[1].charAt(0));
            this.setNaziv(persStrings[2]);
            this.setUsed(Boolean.parseBoolean(persStrings[3]));
            this.setNonVatRate(Boolean.parseBoolean(persStrings[4]));
            this.setMostUsedRate(Boolean.parseBoolean(persStrings.length > 5 ? persStrings[5] : "false"));
            this.setPg(pg);
        }
        catch (ParseException ex) {
            Logger.getLogger(PoreskaStopa.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private NumberFormat getStopaFormat() {
        NumberFormat nf = NumberFormat.getInstance(Locale.UK);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setRoundingMode(RoundingMode.HALF_EVEN);
        return nf;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public void setOznaka(char oznaka) {
        this.oznaka = oznaka;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public void setPg(PoreskaGrupa pg) {
        this.pg = pg;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isNonVatRate() {
        return this.nonVatRate;
    }

    public void setNonVatRate(boolean nonVatRate) {
        this.nonVatRate = nonVatRate;
    }

    public boolean isMostUsedRate() {
        return this.mostUsedRate;
    }

    public void setMostUsedRate(boolean mostUsedRate) {
        this.mostUsedRate = mostUsedRate;
    }
}

