/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.StavkaPopisa;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class Popis {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Shell shell;
    Restoran restoran;
    RestoranServer server;
    com.dev63.restoran.model.Popis popis;
    EntityManager base;
    Odeljenje odeljenje;
    Button sravnjenjeB;
    boolean crno;
    boolean belo;
    List<Artikal> artList;
    Map<Long, TwoTypeWrapper<Double, Double>> mapaStanjaKartica;
    Map<Long, TwoTypeWrapper<Double, Double>> pocetnaMapa;
    Map<String, Double> mapa = new HashMap<String, Double>();
    Map<Integer, String> mapaTabele = new HashMap<Integer, String>();
    Map<String, Integer> mapaTabele2 = new HashMap<String, Integer>();
    SortedMap<String, Long> artikli;
    boolean sifre;
    Table table;
    Date day;
    private TableEditor editor;
    private TableItem item;
    private int indexOfSelected = 0;
    private int itemCount = 0;
    private Text tSearch;
    private boolean action = false;
    private boolean selection = false;
    private TableItem previousItem;
    private boolean izmena = false;
    private long izmenaId;

    public Popis(Shell shell2, Restoran r, final Date day1, final Odeljenje o, boolean c, boolean b, final com.dev63.restoran.model.Popis popis2, final boolean saPretragom) {
        this.shell = shell2;
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_UNOS_POPISA_ZA_ODELJENJE"), new Object[0]) + " " + o.getNaziv());
        this.day = Konstante.dateBefore(day1);
        this.belo = b;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.odeljenje = o;
        this.crno = c;
        this.base = this.server.getBase();
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Popis.this.sifre = Popis.this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
                }
                catch (Exception e) {
                    Popis.this.sifre = false;
                }
                List<StavkaPopisa> stavke = null;
                if (popis2 != null) {
                    stavke = popis2.getStavke();
                    Popis.this.izmena = true;
                    Popis.this.izmenaId = popis2.getId();
                    Popis.this.shell.setText(String.format(Popis.this.barmasterText.getString("TEXT_IZMENA_POPISA_ZA_ODELJENJE"), new Object[0]) + " " + o.getNaziv());
                }
                Popis.this.artikli = Popis.this.server.getArtikliBezSloz(Popis.this.odeljenje.getId());
                Map<Long, Artikal> artMap = Popis.this.server.getArtikliBezSlozOdeljenjeOrderedByNameJPA(Popis.this.odeljenje.getId());
                Popis.this.artList = new LinkedList<Artikal>(artMap.values());
                Popis.this.popis = new com.dev63.restoran.model.Popis();
                Popis.this.popis.setOdeljenje(Popis.this.odeljenje);
                Popis.this.popis.setDatum(day1);
                Popis.this.popis.setCrno(Popis.this.crno);
                Popis.this.popis.setObaStanja(Popis.this.belo && Popis.this.crno);
                Popis.this.popis.setUser(Popis.this.server.getUser().getName());
                if (Popis.this.crno && !Popis.this.belo) {
                    Popis.this.popis.setBroj(Popis.this.server.sledeciBrojPopisa2());
                } else if (Popis.this.belo && !Popis.this.crno) {
                    Popis.this.popis.setBroj(Popis.this.server.sledeciBrojPopisa());
                } else if (Popis.this.belo && Popis.this.crno) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Integer broj = Integer.parseInt(sdf.format(Popis.this.popis.getDatum()));
                    Popis.this.popis.setBroj(broj);
                }
                Popis.this.popis.setSravnjenje(Boolean.FALSE);
                Button bSearch = null;
                Popis.this.tSearch = null;
                if (saPretragom) {
                    Group gSearch = new Group((Composite)Popis.this.shell, 0);
                    gSearch.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                    gSearch.setLayout((Layout)new GridLayout(3, false));
                    gSearch.setText(String.format(Konstante.getBundle().getString("TEXT_PRETRAGA"), new Object[0]));
                    Label lSearch = new Label((Composite)gSearch, 131072);
                    lSearch.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
                    lSearch.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
                    Popis.this.tSearch = new Text((Composite)gSearch, 2048);
                    Popis.this.tSearch.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
                    ((GridData)((Popis)Popis.this).tSearch.getLayoutData()).widthHint = 300;
                    bSearch = new Button((Composite)gSearch, 72);
                    bSearch.setText(String.format(Konstante.getBundle().getString("TEXT_PRETRAZI"), new Object[0]));
                    bSearch.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
                    ((GridData)bSearch.getLayoutData()).widthHint = 80;
                    ((GridData)bSearch.getLayoutData()).heightHint = 40;
                }
                Popis.this.table = new Table((Composite)Popis.this.shell, 65536);
                Popis.this.table.setLinesVisible(true);
                if (bSearch != null && Popis.this.tSearch != null) {
                    SearchListener sl = new SearchListener(Popis.this.tSearch, Popis.this.table);
                    Popis.this.tSearch.addListener(2, (Listener)sl);
                    bSearch.addListener(13, (Listener)sl);
                }
                Popis.this.indexOfSelected = 0;
                Popis.this.editor = new TableEditor(Popis.this.table);
                ((Popis)Popis.this).editor.horizontalAlignment = 16384;
                ((Popis)Popis.this).editor.grabHorizontal = true;
                ((Popis)Popis.this).editor.minimumWidth = 50;
                Popis.this.pocetnaMapa = Popis.this.server.getArtikliStanjeZaDatumJPA(Popis.this.artList, Popis.this.odeljenje, day1);
                TableColumn column1 = new TableColumn(Popis.this.table, 16384);
                column1.setText(String.format(Popis.this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
                TableColumn column2 = new TableColumn(Popis.this.table, 0x1000000);
                column2.setText(String.format(Popis.this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
                TableColumn column3 = new TableColumn(Popis.this.table, 0x1000000);
                column3.setText(String.format(Popis.this.barmasterText.getString("TEXT_STANJE"), new Object[0]));
                TableColumn column4 = new TableColumn(Popis.this.table, 0x1000000);
                column4.setText(String.format(Popis.this.barmasterText.getString("TEXT_POPIS"), new Object[0]));
                TableColumn column5 = new TableColumn(Popis.this.table, 0x1000000);
                column5.setText(String.format(Popis.this.barmasterText.getString("TEXT_RAZLIKA"), new Object[0]));
                int i = -1;
                for (Map.Entry<Long, Artikal> entry : artMap.entrySet()) {
                    String n;
                    Artikal artikal = entry.getValue();
                    ++i;
                    String jm = artikal.getJedinicaMere();
                    if (Popis.this.sifre) {
                        String s = artikal.getBarCode() != null ? artikal.getBarCode() : "";
                        n = s + " (" + artikal.getName() + ")";
                    } else {
                        n = artikal.getName();
                    }
                    TwoTypeWrapper<Double, Double> stanje = Popis.this.pocetnaMapa.get(artikal.getId());
                    Double pocetno = Popis.this.getPocetnoStanje(Popis.this.crno, Popis.this.belo, day1, Popis.this.odeljenje, artikal);
                    Popis.this.mapa.put(artikal.getName(), pocetno);
                    Popis.this.mapaTabele.put(i, artikal.getName());
                    Popis.this.mapaTabele2.put(artikal.getName(), i);
                    TableItem item4 = null;
                    if (popis2 == null) {
                        item4 = new TableItem(Popis.this.table, 131072);
                        item4.setText(new String[]{n, jm, StatLogic.getNumber04NG(pocetno), StatLogic.getNumber04NG(pocetno), StatLogic.getNumber04NG(0.0)});
                    } else {
                        boolean nesto = true;
                        for (StavkaPopisa str : stavke) {
                            if (!str.getArtikal().equals(artikal)) continue;
                            nesto = false;
                            item4 = new TableItem(Popis.this.table, 131072);
                            item4.setText(new String[]{n, jm, StatLogic.getNumber04NG(pocetno), StatLogic.getNumber04NG(str.getStanje1()), StatLogic.getNumber04NG(pocetno - str.getStanje1()).equals("-0" + StatLogic.getDecimalSeparatorFromLocale(Konstante.getCurLocale()) + "0000") ? StatLogic.getNumber04NG(0.0) : StatLogic.getNumber04NG(pocetno - str.getStanje1())});
                        }
                        if (nesto) {
                            item4 = new TableItem(Popis.this.table, 131072);
                            item4.setText(new String[]{n, StatLogic.getNumber04NG(pocetno), StatLogic.getNumber04NG(pocetno), StatLogic.getNumber04NG(0.0)});
                        }
                    }
                    if (item4 == null) continue;
                    item4.setData("artikal", (Object)artikal);
                    item4.setData("pocetno", (Object)pocetno);
                }
                column1.setWidth(200);
                column2.setWidth(50);
                column3.setWidth(120);
                column4.setWidth(120);
                column5.setWidth(120);
                Popis.this.itemCount = Popis.this.table.getItemCount();
                Popis.this.addEditor2(Popis.this.table);
                Popis.this.table.setHeaderVisible(true);
                Popis.this.table.setLinesVisible(true);
                GridData data = new GridData(4, 4, true, true);
                data.horizontalSpan = 3;
                Popis.this.table.setLayoutData((Object)data);
                final Button printButton = new Button((Composite)Popis.this.shell, 8);
                try {
                    printButton.setImage(ImageCache.getImage("print.gif"));
                }
                catch (Exception artikal) {
                    // empty catch block
                }
                printButton.setText(String.format(Popis.this.barmasterText.getString("TEXT_SACUVAJ"), new Object[0]));
                printButton.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        printButton.setEnabled(false);
                        BusyIndicator.showWhile((Display)Popis.this.shell.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (Popis.this.izmena) {
                                    Popis.this.izmenaPopisa();
                                } else {
                                    Popis.this.sacuvajPopis();
                                }
                            }
                        });
                    }
                });
                data = new GridData();
                data.heightHint = 40;
                data.widthHint = 140;
                printButton.setLayoutData((Object)data);
                Button izlaz = new Button((Composite)Popis.this.shell, 8);
                izlaz.setText(String.format(Popis.this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
                izlaz.setLayoutData((Object)data);
                izlaz.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Popis.this.shell.close();
                    }
                });
                Popis.this.sravnjenjeB = new Button((Composite)Popis.this.shell, 8);
                data = new GridData(131072);
                data.horizontalAlignment = 16384;
                data.heightHint = 40;
                data.widthHint = 140;
                Popis.this.sravnjenjeB.setLayoutData((Object)data);
                Popis.this.sravnjenjeB.setText(String.format(Popis.this.barmasterText.getString("TEXT_SRAVNJENJE"), new Object[0]));
                Popis.this.sravnjenjeB.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Popis.this.sravnjenjeB.setEnabled(false);
                        BusyIndicator.showWhile((Display)Popis.this.shell.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Popis.this.sravnjenjePopisa();
                            }
                        });
                    }
                });
                Popis.this.sravnjenjeB.setEnabled(false);
                Popis.this.shell.setMaximized(true);
            }
        });
        SWTContainerClass.makeEnd(this.shell);
    }

    public void addEditor2(final Table table) {
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        table.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                System.out.println("selection");
                Popis.this.item = (TableItem)e.item;
                Popis.this.indexOfSelected = table.indexOf(Popis.this.item);
                Popis.this.selectNextRow(Popis.this.item);
                Popis.this.selection = true;
            }
        });
    }

    private void selectNextRow(TableItem ti) {
        if (ti != null) {
            this.table.setSelection(ti);
        } else {
            this.table.setSelection(-1);
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.previousItem = this.editor.getItem();
        }
        if (this.item == null) {
            return;
        }
        Text newEditor = new Text((Composite)this.table, 0);
        newEditor.setText(this.item.getText(2));
        System.out.println("tekst je " + this.item.getText(3));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text text = (Text)Popis.this.editor.getEditor();
                if (!text.getText().isEmpty()) {
                    Popis.this.editor.getItem().setText(3, StatLogic.getNumber04NG(StatLogic.parseDouble04Suppress(text.getText())));
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, this.item, 3);
        Listener list = new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 0x1000002 && e.type == 2) {
                    Popis.this.table.showSelection();
                    Popis.this.indexOfSelected++;
                    if (Popis.this.indexOfSelected >= Popis.this.itemCount) {
                        Popis.this.indexOfSelected = 0;
                    }
                    double razlika = StatLogic.parseNumber04Suppress(Popis.this.item.getText(2)).doubleValue() - StatLogic.parseNumber04Suppress(Popis.this.item.getText(3)).doubleValue();
                    Popis.this.item.setText(4, StatLogic.getNumber04NG(razlika));
                    e.widget.dispose();
                    Popis.this.item = Popis.this.item.getParent().getItem(Popis.this.indexOfSelected);
                    Popis.this.item.getParent().select(Popis.this.indexOfSelected);
                    Popis.this.selectNextRow(Popis.this.item);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (Popis.this.selection) {
                        Popis.this.selection = false;
                        return;
                    }
                    if (e.type == 31) {
                        return;
                    }
                    if (e.type != 2) {
                        return;
                    }
                    System.out.println("enter brate");
                    Control oldEditor = Popis.this.editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    double razlika = StatLogic.parseNumber04Suppress(Popis.this.item.getText(2)).doubleValue() - StatLogic.parseNumber04Suppress(Popis.this.item.getText(3)).doubleValue();
                    Popis.this.item.setText(4, StatLogic.getNumber04NG(razlika));
                    if (Popis.this.tSearch != null) {
                        Popis.this.tSearch.setFocus();
                    } else {
                        Popis.this.indexOfSelected++;
                        if (Popis.this.indexOfSelected >= Popis.this.itemCount) {
                            Popis.this.indexOfSelected = 0;
                        }
                        e.widget.dispose();
                        Popis.this.item = Popis.this.item.getParent().getItem(Popis.this.indexOfSelected);
                        Popis.this.item.getParent().select(Popis.this.indexOfSelected);
                        Popis.this.selectNextRow(Popis.this.item);
                    }
                } else if (e.keyCode == 0x1000001 && e.type == 2) {
                    Popis.this.table.showSelection();
                    Popis.this.indexOfSelected--;
                    if (Popis.this.indexOfSelected < 0) {
                        Popis.this.indexOfSelected = Popis.this.itemCount - 1;
                    }
                    double razlika = StatLogic.parseNumber04Suppress(Popis.this.item.getText(2)).doubleValue() - StatLogic.parseNumber04Suppress(Popis.this.item.getText(3)).doubleValue();
                    Popis.this.item.setText(4, StatLogic.getNumber04NG(razlika));
                    e.widget.dispose();
                    Popis.this.item = Popis.this.item.getParent().getItem(Popis.this.indexOfSelected);
                    Popis.this.item.getParent().select(Popis.this.indexOfSelected);
                    Popis.this.selectNextRow(Popis.this.item);
                } else {
                    if (e.keyCode == 9 && e.type == 31 && (e.stateMask & 0x10000) != 0) {
                        return;
                    }
                    if (e.keyCode == 9 && e.type == 31) {
                        System.out.println("tab brate");
                        Popis.this.table.showSelection();
                        double razlika = StatLogic.parseNumber04Suppress(Popis.this.item.getText(2)).doubleValue() - StatLogic.parseNumber04Suppress(Popis.this.item.getText(3)).doubleValue();
                        Popis.this.item.setText(4, StatLogic.getNumber04NG(razlika));
                        if (Popis.this.tSearch != null) {
                            if (Popis.this.tSearch.getText().length() > 0) {
                                Popis.this.item = null;
                                Popis.this.indexOfSelected = -1;
                                Popis.this.selectNextRow(null);
                                Event ev = new Event();
                                ev.type = 2;
                                ev.keyCode = 13;
                                ev.widget = Popis.this.tSearch;
                                Popis.this.tSearch.notifyListeners(2, ev);
                            }
                        } else {
                            Popis.this.indexOfSelected++;
                            if (Popis.this.indexOfSelected >= Popis.this.itemCount) {
                                Popis.this.indexOfSelected = 0;
                            }
                            e.widget.dispose();
                            Popis.this.item = Popis.this.item.getParent().getItem(Popis.this.indexOfSelected);
                            Popis.this.item.getParent().select(Popis.this.indexOfSelected);
                            Popis.this.selectNextRow(Popis.this.item);
                        }
                    } else {
                        if (e.type == 31 && e.keyCode == 27) {
                            if (Popis.this.item != null && !Popis.this.editor.getEditor().isDisposed()) {
                                Popis.this.table.showSelection();
                                double razlika = StatLogic.parseNumber04Suppress(Popis.this.item.getText(2)).doubleValue() - StatLogic.parseNumber04Suppress(Popis.this.item.getText(3)).doubleValue();
                                Popis.this.item.setText(4, StatLogic.getNumber04NG(razlika));
                                e.widget.dispose();
                                Popis.this.item = null;
                                Popis.this.selectNextRow(Popis.this.item);
                            }
                            e.doit = false;
                            return;
                        }
                        if (e.type == 31) {
                            e.doit = false;
                            return;
                        }
                    }
                }
            }
        };
        newEditor.addListener(2, list);
        newEditor.addListener(31, list);
    }

    public void addEditor(final Table table) {
        final TableCursor cursor = new TableCursor(table, 0);
        final ControlEditor editor = new ControlEditor((Composite)cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                table.setSelection(new TableItem[]{cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem row = cursor.getRow();
                cursor.setSelection(row, 2);
                final Text text = new Text((Composite)cursor, 0);
                row.setText(3, row.getText(3));
                text.setText(row.getText(3));
                text.selectAll();
                text.setFocus();
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\r') {
                            TableItem row = cursor.getRow();
                            double d2 = 0.0;
                            if (!text.getText().isEmpty()) {
                                try {
                                    d2 = Double.valueOf(text.getText());
                                    double d1 = Popis.this.mapa.get(Popis.this.mapaTabele.get(table.indexOf(row)));
                                    String s = Konstante.getNumber4(d2 - d1).replace(',', '.');
                                    row.setText(3, text.getText());
                                    row.setText(4, s);
                                }
                                catch (Exception ex) {
                                    Konstante.getPoruka(Popis.this.shell, String.format(Popis.this.barmasterText.getString("PORUKA_POGRESAN_UNOS_VREDNOSTI"), new Object[0]));
                                    return;
                                }
                            }
                            text.dispose();
                        }
                        if (e.character == '\u001b') {
                            text.dispose();
                        }
                    }
                });
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        text.dispose();
                    }
                });
                editor.setEditor((Control)text);
                text.setFocus();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                cursor.setSelection(row, 3);
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
    }

    public void sacuvajPopis() {
        Text text = (Text)this.editor.getEditor();
        if (text != null && !text.isDisposed()) {
            double d2 = StatLogic.parseDouble04NGSuppress(text.getText());
            double d1 = StatLogic.parseDouble04NGSuppress(this.table.getItem(this.indexOfSelected).getText(2));
            String s = Konstante.getNumber4(d1 - d2).replace(',', '.');
            this.table.getItem(this.indexOfSelected).setText(4, s);
        }
        if (this.crno && !this.belo) {
            this.server.incrementBrojPopisa2(String.valueOf(this.popis.getBroj() + 1));
        } else if (this.belo && !this.crno) {
            this.server.incrementBrojPopisa(String.valueOf(this.popis.getBroj() + 1));
        }
        Logger.getLogger(Popis.class.getName()).log(Level.SEVERE, String.format(this.barmasterText.getString("LOG_UPDATE_POPISA"), new Object[0]));
        int x = 0;
        for (TableItem it : this.table.getItems()) {
            Artikal artikal = (Artikal)it.getData("artikal");
            String a = artikal.getName();
            if (++x > 400) {
                Logger.getLogger(Popis.class.getName()).log(Level.SEVERE, String.format(this.barmasterText.getString("LOG_SNIMANJE_STAVKI_400X"), new Object[0]));
                x = 0;
            }
            StavkaPopisa sp = new StavkaPopisa();
            sp.setArtikal(artikal);
            sp.setStanje0(this.mapa.get(a));
            try {
                sp.setStanje1(StatLogic.parseNumber04(this.table.getItem(this.mapaTabele2.get(a).intValue()).getText(3)).doubleValue());
            }
            catch (Exception ex) {
                System.out.println(ex);
                Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_PROVERITE_SVA_POLJA"), new Object[0]));
                return;
            }
            if (BigDecimal.valueOf(sp.getStanje0() - sp.getStanje1()).setScale(4, RoundingMode.HALF_EVEN).compareTo(BigDecimal.ZERO) == 0) {
                sp.setStanje1(sp.getStanje0());
            }
            sp.setPopis(this.popis);
            this.popis.getStavke().add(sp);
        }
        Comparator<StavkaPopisa> c = new Comparator<StavkaPopisa>(){

            @Override
            public int compare(StavkaPopisa o1, StavkaPopisa o2) {
                if (o1.getArtikal().getTip().compareTo(o2.getArtikal().getTip()) == 0) {
                    return o1.getArtikal().getName().compareTo(o2.getArtikal().getName());
                }
                return o1.getArtikal().getTip().compareTo(o2.getArtikal().getTip());
            }
        };
        Logger.getLogger(Popis.class.getName()).log(Level.SEVERE, String.format(this.barmasterText.getString("LOG_DODAVANJE_POPISA"), new Object[0]));
        this.server.addPopis(this.popis);
        Logger.getLogger(Popis.class.getName()).log(Level.SEVERE, String.format(this.barmasterText.getString("LOG_DODAVANJE_POPISA_ZAVRSENO"), new Object[0]));
        GridPrinter gp = new GridPrinter(new PrintHandler());
        gp.printTable(new TableWrapper(this.table), false, true, this.odeljenje.getNaziv() + ", " + this.server.getSetting(Option.OBJEKAT_NAZIV) + "\n" + String.format(this.barmasterText.getString("TEXT_POPIS_ZA_DAN"), new Object[0]) + " " + Konstante.getDate(this.popis.getDatum()) + ", " + this.popis.getUser(), this.shell, this.server);
        this.sravnjenjeB.setEnabled(this.popis.getObaStanja() == false);
    }

    public void sravnjenjePopisa() {
        this.popis.setSravnjenje(Boolean.TRUE);
        this.popis = this.server.updatePopis(this.popis);
        Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_SRAVNJENJE_POPISA_URADJENO"), new Object[0]));
    }

    public void izmenaPopisa() {
        System.out.println("u izmeni sam");
        this.popis = (com.dev63.restoran.model.Popis)this.base.find(com.dev63.restoran.model.Popis.class, (Object)this.izmenaId);
        System.out.println(this.popis.getBroj());
        ArrayList<StavkaPopisa> stavkePopisa = new ArrayList<StavkaPopisa>();
        for (TableItem it : this.table.getItems()) {
            Artikal artikal = (Artikal)it.getData("artikal");
            String a = artikal.getName();
            StavkaPopisa sp = new StavkaPopisa();
            sp.setArtikal(artikal);
            sp.setStanje0(this.mapa.get(a));
            try {
                sp.setStanje1(StatLogic.parseNumber04(this.table.getItem(this.mapaTabele2.get(a).intValue()).getText(3)).doubleValue());
            }
            catch (Exception ex) {
                System.out.println(ex);
                Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_PROVERITE_SVA_POLJA"), new Object[0]));
                return;
            }
            if (BigDecimal.valueOf(sp.getStanje0() - sp.getStanje1()).setScale(4, RoundingMode.HALF_EVEN).compareTo(BigDecimal.ZERO) == 0) {
                sp.setStanje1(sp.getStanje0());
            }
            sp.setPopis(this.popis);
            stavkePopisa.add(sp);
        }
        for (StavkaPopisa sPopisa : this.popis.getStavke()) {
            this.base.remove((Object)sPopisa);
        }
        this.popis.setStavke(stavkePopisa);
        this.server.updatePopis(this.popis);
        GridPrinter gp = new GridPrinter(new PrintHandler());
        gp.printTable(new TableWrapper(this.table), false, true, this.odeljenje.getNaziv() + ", " + this.server.getSetting(Option.OBJEKAT_NAZIV) + "\n" + String.format(this.barmasterText.getString("TEXT_POPIS_ZA_DAN"), new Object[0]) + " " + Konstante.getDate(this.popis.getDatum()) + ", " + this.popis.getUser(), this.shell, this.server);
        if (!this.popis.getSravnjenje().booleanValue() && !this.popis.getObaStanja().booleanValue()) {
            this.sravnjenjeB.setEnabled(true);
        }
    }

    private double getPocetnoStanje(boolean isCrno, boolean isBelo, Date datum, Odeljenje o, Artikal artikal) {
        double pocetnoOsnovno = 0.0;
        double pocetnoDodatno = 0.0;
        if (isBelo) {
            pocetnoOsnovno = this.server.getSumBelo(Konstante.getYesterdayDate(datum), o, artikal, false, true);
        }
        if (isCrno) {
            pocetnoDodatno = this.server.getSumBelo(Konstante.getYesterdayDate(datum), o, artikal, true, true);
        }
        return pocetnoOsnovno + pocetnoDodatno;
    }

    private class SearchListener
    implements Listener {
        private Text text;
        private Table table;
        private final String nextStartIndexKey = "nextStartIndex";

        public SearchListener(Text text, Table table) {
            this.text = text;
            this.table = table;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 2: {
                    if (!event.widget.equals(this.text)) break;
                    if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                        int i;
                        if (this.text.getText().length() == 0) {
                            return;
                        }
                        Integer nextIndex = (Integer)this.table.getData("nextStartIndex");
                        String filter = this.text.getText();
                        filter = ".*" + filter.replaceAll("\\s+", ".*") + ".*";
                        Pattern pattern = Pattern.compile(filter, 2);
                        TableItem ti = null;
                        int n = i = nextIndex == null ? 0 : nextIndex;
                        while (i < this.table.getItems().length) {
                            ti = this.table.getItem(i);
                            Matcher matcher = pattern.matcher(ti.getText(0));
                            if (matcher.matches()) {
                                Popis.this.indexOfSelected = this.table.indexOf(ti);
                                Popis.this.item = ti;
                                this.table.setData("nextStartIndex", (Object)(Popis.this.indexOfSelected + 1));
                                break;
                            }
                            if (i == this.table.getItems().length - 1) {
                                Popis.this.indexOfSelected = -1;
                                ti = null;
                                Popis.this.item = null;
                                this.table.setData("nextStartIndex", null);
                            }
                            ++i;
                        }
                        Popis.this.selectNextRow(ti);
                        if (ti != null) break;
                        SWTMessage.showLocalizedInfoDialog(Popis.this.shell, String.format(Konstante.getBundle().getString("PORUKA_NIJE_PRONADJEN_ARTIKAL_KOJI_ODGOVARA_FILTERU"), new Object[0]));
                        this.text.setFocus();
                        break;
                    }
                    this.table.setData("nextStartIndex", null);
                    break;
                }
                case 13: {
                    if (!(event.widget instanceof Button)) break;
                    Event ev = new Event();
                    ev.type = 2;
                    ev.widget = this.text;
                    ev.keyCode = 13;
                    this.text.notifyListeners(2, ev);
                }
            }
        }
    }

    public static class PopisInput {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private DateInput2 odDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Odeljenje o;
        SWTContainer parent;
        Button crno;
        Button belo;
        Shell shell;
        Button saPretragom;
        boolean inspektor = false;
        boolean crn = false;

        public PopisInput(SWTContainer owner, Restoran r, Odeljenje ode, final boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.o = ode;
            this.inspektor = inspektor;
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image dpuV = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif");
            slika.setImage(dpuV);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)dpuV));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 540;
            data.horizontalSpan = 2;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_POPIS"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 30;
            Group grupa4 = new Group(panel2, 0);
            grupa4.setLayout((Layout)new GridLayout(2, false));
            grupa4.setText("");
            grupa4.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_ZA_DAN"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_ZA_DAN"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            this.odDatuma.setEnabled(true);
            Label osn = new Label((Composite)grupa1, 0);
            osn.setText(String.format(this.barmasterText.getString("TEXT_POPIS_OSNOVNOG_STANJA"), new Object[0]) + ":");
            this.belo = new Button((Composite)grupa1, 32);
            this.belo.setSelection(true);
            this.belo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!crn && !belo.getSelection() && inspektor) {
                        crno.setSelection(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (inspektor) {
                Label cr = new Label((Composite)grupa1, 0);
                cr.setText(String.format(this.barmasterText.getString("TEXT_POPIS_DODATNOG_STANJA"), new Object[0]) + ":");
                this.crno = new Button((Composite)grupa1, 32);
                this.crn = this.crno.getSelection();
                this.crno.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!crno.getSelection() && !belo.getSelection()) {
                            belo.setSelection(true);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            Label srch = new Label((Composite)grupa4, 0);
            srch.setText(String.format(Konstante.getBundle().getString("TEXT_SA_PRETRAGOM"), new Object[0]) + ":");
            this.saPretragom = new Button((Composite)grupa4, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            osn.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            if (inspektor) {
                this.crno.setLayoutData((Object)data);
            }
            this.belo.setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                PopisProvera provera = new PopisProvera(this.server, this.shell, this.day1, this.o, true);
                if (provera.isPopis()) {
                    provera.setValidDate(this.odDatuma);
                    return;
                }
                this.server.log(String.format(this.barmasterText.getString("TEXT_POPIS_ZA_DAN"), new Object[0]) + "->" + this.day1);
                Shell shell2 = new Shell();
                boolean c = false;
                if (this.crno != null) {
                    c = this.crno.getSelection();
                }
                new Popis(shell2, this.restoran, this.day1, this.o, c, this.belo.getSelection(), null, this.saPretragom.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

