/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.ObjectWrapper;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OtpremnicaRacun {
    private RestoranServer server;
    private double popust;
    private double ukupno;
    private double popustUkupno;
    private double bezPDV;
    private double PDV;

    public OtpremnicaRacun(Display display, Restoran restoran, Racun r, List<ObjectWrapper> stope) {
        this.server = restoran.getServer();
        this.popust = r.getPopust();
        Shell shell = new Shell(display);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Otpremnica");
        shell.setMaximized(true);
        Document doc = new Document(false);
        doc.addElement((Element)this.makeLogoHeader());
        doc.addElement((Element)this.makeHotelHeader());
        doc.addElement((Element)this.makeInvoiceHeader(r));
        this.makeMainTable(doc, r, stope);
        this.makePlacanjeTable(doc, r);
        doc.addElement((Element)this.makeFooter(r.getKonobar()));
        doc.addElement((Element)this.makePotpisFooter());
        doc.setDefaultFooter();
        Composite composite = new Composite((Composite)shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        frame.add((Component)Print.printPreview((Document)doc));
        Konstante.endShell(shell);
    }

    private Block makeHotelHeader() {
        Setting adresa = this.server.getSetting(Option.OBJEKAT_ADRESA);
        Setting obveznikPDV = this.server.getSetting(Option.U_SISTEMU_PDV);
        Setting banka = this.server.getSetting(Option.BANKA);
        Setting mesto = this.server.getSetting(Option.OBJEKAT_MESTO);
        Setting pib = this.server.getSetting(Option.OBJEKAT_PIB);
        Setting racun = this.server.getSetting(Option.RACUN_OBJEKTA);
        Setting telefon = this.server.getSetting(Option.OBJEKAT_TELEFON);
        Setting maticni = this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ);
        Setting web = this.server.getSetting(Option.WEB_ADRESA);
        Setting fax = this.server.getSetting(Option.FAX);
        Setting sifraDelatnosti = this.server.getSetting(Option.SIFRA_DELATNOSTI);
        Setting email = this.server.getSetting(Option.EMAIL);
        Block b = new Block("Arial", 8, false, false);
        Split s = new Split();
        Block a = new Block(adresa != null ? "Adresa: " + adresa.stringValue() : "");
        a.setBold(true);
        Block opdv = new Block(obveznikPDV != null ? (obveznikPDV.booleanValue() ? "Obveznik PDV-a: DA" : "Obveznik PDV-a: NE") : "");
        opdv.setBold(true);
        Block ba = new Block(banka != null ? "Banka: " + banka.stringValue() : "");
        ba.setBold(true);
        s = new Split((Element)a, (Element)opdv, (Element)ba);
        b.addElement((Element)s);
        Block m = new Block(mesto != null ? "Mesto: " + mesto.stringValue() : "");
        m.setBold(true);
        Block p = new Block(pib != null ? "PIB: " + pib.stringValue() : "");
        p.setBold(true);
        Block rac = new Block(racun != null ? "Racun RSD: " + racun.stringValue() : "");
        rac.setBold(true);
        s = new Split((Element)m, (Element)p, (Element)rac);
        b.addElement((Element)s);
        Block t = new Block(telefon != null ? "Tel: " + telefon.stringValue() : "");
        t.setBold(true);
        Block mb = new Block(maticni != null ? "Maticni broj: " + maticni.stringValue() : "");
        mb.setBold(true);
        Block w = new Block(web != null ? "web: " + web.stringValue() : "");
        w.setBold(true);
        s = new Split((Element)t, (Element)mb, (Element)w);
        b.addElement((Element)s);
        Block f = new Block(fax != null ? "Fax: " + fax.stringValue() : "");
        f.setBold(true);
        Block sd = new Block(sifraDelatnosti != null ? "Sifra delatnosti: " + sifraDelatnosti.stringValue() : "");
        sd.setBold(true);
        Block em = new Block(email != null ? "email: " + email.stringValue() : "");
        em.setBold(true);
        s = new Split((Element)f, (Element)sd, (Element)em);
        b.addElement((Element)s);
        b.setPaddingTop(1);
        b.setPaddingBottom(1);
        b.setBox(true);
        return b;
    }

    private Block makeLogoHeader() {
        Block b = new Block("Arial", 12, false, true);
        this.addlogoElement(b, Option.OBJEKAT_NAZIV, null);
        b.setPaddingBottom(2);
        return b;
    }

    private void addlogoElement(Block b, Option option, String right) {
        Setting s = this.server.getSetting(option);
        if (s != null) {
            Split sl = new Split();
            Block c = new Block((Element)new Text(s.stringValue()));
            c.setSize(14);
            sl.setLeft((Element)c);
            Block d = new Block(right != null ? right : "");
            sl.setRight((Element)d);
            b.addElement((Element)sl);
        }
    }

    private Block makeInvoiceHeader(Racun r) {
        Block b = new Block("Arial", 8, false, false);
        Block vp = new Block("");
        Block b1 = new Block(r.getStalniGost() != null ? "Kupac: " + r.getStalniGost().getNaziv() : "Kupac: ");
        Block b2 = new Block(r.getStalniGost() != null ? "Adresa: " + r.getStalniGost().getAdersa() : "Adresa: ");
        Block b3 = new Block(r.getStalniGost() != null ? "PIB: " + r.getStalniGost().getPib() : "PIB: ");
        Block date = new Block("Datum izdavanja: " + Konstante.getFullFormat(new Date()));
        Block no = new Block("");
        Split s = new Split((Element)date, (Element)no, (Element)b1);
        b.addElement((Element)s);
        Block time = new Block("Datum prometa: " + Konstante.getFullFormat(r.getDatum()));
        Block soba = new Block("");
        s = new Split((Element)time, (Element)soba, (Element)b2);
        b.addElement((Element)s);
        Setting ms = this.server.getSetting(Option.OBJEKAT_MESTO);
        String mesto = "";
        if (ms != null) {
            mesto = ms.stringValue();
        }
        Block mp = new Block("Mesto prometa: " + mesto);
        s = new Split((Element)mp, (Element)vp, (Element)b3);
        b.addElement((Element)s);
        b.setPaddingTop(10);
        b.setPaddingBottom(15);
        return b;
    }

    private void makeMainTable(Document doc, Racun r, List<ObjectWrapper> stope) {
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"usluga", "jm", "kol", "cena", "rabat%", "pdv%", "cena bez pdv", "iznos"};
        model.setColumnIdentifiers(columns);
        for (StavkaRacuna st : r.getStavke1()) {
            double pop;
            Object[] row = new String[columns.length];
            int pos = 0;
            row[pos++] = st.getNaziv();
            row[pos++] = st.getArtikal().getJedinicaMere();
            row[pos++] = Konstante.getNumber1(st.getKolicina());
            double cspdv = st.getVrednost();
            int pr = 0;
            if (this.server.getSetting(Option.U_SISTEMU_PDV).booleanValue()) {
                for (ObjectWrapper ow : stope) {
                    if (!((PoreskaGrupa)ow.getData()).equals((Object)st.getArtikal().getPoreskaGrupa())) continue;
                    pr = ow.getPercent();
                }
            }
            this.ukupno += cspdv;
            row[pos++] = Konstante.getNumber2(cspdv);
            if (st.getArtikal().getDozvoljenPopust().booleanValue()) {
                pop = this.popust;
                row[pos++] = Konstante.getNumber2(this.popust);
            } else {
                pop = 0.0;
                row[pos++] = "0";
            }
            row[pos++] = String.valueOf(pr);
            double cspop = cspdv * (100.0 - pop) / 100.0;
            this.popustUkupno += cspdv - cspop;
            double cbpdv = cspop * 100.0 / (double)(100 + pr);
            this.bezPDV += cbpdv;
            row[pos++] = Konstante.getNumber2(cspop);
            this.PDV += cspop - cbpdv;
            row[pos++] = Konstante.getNumber2(cspdv);
            model.addRow(row);
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("usluga", "Naziv", 35));
        list.add(new TableColumn("jm", "JM", 15));
        list.add(new TableColumn("kol", "Kolicina", 15));
        list.add(new TableColumn("cena", "Cena sa PDV-om", 25));
        list.add(new TableColumn("rabat%", "Popust%", 15));
        list.add(new TableColumn("pdv%", "PDV%", 15));
        list.add(new TableColumn("cena bez pdv", "Cena sa popustom", 25, "right"));
        list.add(new TableColumn("iznos", "Iznos", 25, "right"));
        Table table = new Table((TableModel)model, list);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        doc.addElement((Element)table);
        Block total = new Block("Ukupno: " + Konstante.getNumber2(this.ukupno));
        total.setTextAlign("right");
        total.setBold(true);
        total.setBorderTop(true);
        Split s = new Split((Element)new Block(""), (Element)total);
        doc.addElement((Element)s);
        Block rab = new Block("Popust: " + Konstante.getNumber2(this.popustUkupno));
        rab.setTextAlign("right");
        rab.setBold(false);
        rab.setBorderTop(false);
        Split s2 = new Split((Element)new Block(""), (Element)rab);
        doc.addElement((Element)s2);
        Block total2 = new Block("Iznos bezPDV-a: " + Konstante.getNumber2(this.bezPDV));
        total2.setTextAlign("right");
        total2.setBold(true);
        total2.setBorderTop(true);
        Split s3 = new Split((Element)new Block(""), (Element)total2);
        doc.addElement((Element)s3);
        Block rab2 = new Block("PDV: " + Konstante.getNumber2(this.PDV));
        rab2.setTextAlign("right");
        rab2.setBold(false);
        rab2.setBorderTop(false);
        Split s4 = new Split((Element)new Block(""), (Element)rab2);
        doc.addElement((Element)s4);
        Block total3 = new Block("SVEGA: " + Konstante.getNumber2(this.bezPDV + this.PDV));
        total3.setTextAlign("right");
        total3.setBold(true);
        total3.setBorderTop(true);
        Split s5 = new Split((Element)new Block(""), (Element)total3);
        doc.addElement((Element)s5);
    }

    private void makePDVTable(Document doc, Racun r, List<ObjectWrapper> stope) {
        Block pdvNaslov = new Block("Obracun PDV:");
        pdvNaslov.setPaddingTop(5);
        pdvNaslov.setPaddingBottom(2);
        pdvNaslov.setBold(true);
        doc.addElement((Element)pdvNaslov);
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"grupa", "stopa", "osnova", "iznos"};
        model.setColumnIdentifiers(columns);
        HashMap<PoreskaGrupa, Double> taxMap = new HashMap<PoreskaGrupa, Double>();
        HashMap<PoreskaGrupa, Double> baseMap = new HashMap<PoreskaGrupa, Double>();
        double porez = 0.0;
        for (StavkaRacuna st : r.getStavke()) {
            Double t;
            int stopa = 0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(st.getArtikal().getPoreskaGrupa())) continue;
                stopa = ow.getPercent();
                break;
            }
            t = (t = (Double)taxMap.get(st.getArtikal().getPoreskaGrupa())) != null ? t : 0.0;
            Double b = (Double)baseMap.get(st.getArtikal().getPoreskaGrupa());
            b = b != null ? b : 0.0;
            t = t + st.getVrednost() / (double)(100 + stopa) * (double)stopa;
            b = b + st.getVrednost() / (double)(100 + stopa) * 100.0;
            taxMap.put(st.getArtikal().getPoreskaGrupa(), t);
            baseMap.put(st.getArtikal().getPoreskaGrupa(), b);
            porez += t.doubleValue();
        }
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (taxMap.get(pg) == null) continue;
            int stopa = 0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(pg)) continue;
                stopa = ow.getPercent();
            }
            Object[] row = new String[columns.length];
            Double base = (Double)baseMap.get(pg);
            Double tax = (Double)taxMap.get(pg);
            int pos = 0;
            row[pos++] = pg.toString();
            row[pos++] = String.valueOf(stopa);
            row[pos++] = Konstante.getNumber2(base);
            row[pos++] = Konstante.getNumber2(tax);
            model.addRow(row);
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("grupa", "Poreska grupa"));
        list.add(new TableColumn("stopa", "Poreska stopa", "right"));
        list.add(new TableColumn("osnova", "Osnovica", "right"));
        list.add(new TableColumn("iznos", "Porez", "right"));
        Table table = new Table((TableModel)model, list);
        doc.addElement((Element)table);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        Block total = new Block("Ukupno porez: " + Konstante.getNumber2(porez));
        total.setBold(true);
        total.setTextAlign("right");
        total.setBorderTop(true);
        Split s = new Split((Element)new Block(""), (Element)total);
        doc.addElement((Element)s);
    }

    private void makePlacanjeTable(Document doc, Racun r) {
        Block pdvNaslov = new Block("");
        pdvNaslov.setPaddingTop(15);
        doc.addElement((Element)pdvNaslov);
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"datum", "vreme", "nacin", "br. fisk. isecka"};
        model.setColumnIdentifiers(columns);
        model.addRow(new String[]{Konstante.getFullFormat(r.getDatum()), "", "", ""});
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("vreme", "Vreme"));
        list.add(new TableColumn("nacin", ""));
        list.add(new TableColumn("br. fisk. odsecka", "", "right"));
        list.add(new TableColumn("", "", "right"));
        Table table = new Table((TableModel)model, list);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        doc.addElement((Element)table);
    }

    private Block makeFooter(Konobar k) {
        Block b = new Block("Arial", 12, false, false);
        String ui = k.getSkrIme() != null ? "Uslugu izvrsio: " + k.getSkrIme() : "Uslugu izvrsio: " + k.getPunoime();
        Split s = new Split((Element)new Block(ui), (Element)new Block(""), (Element)new Block(""));
        b.addElement((Element)s);
        b.setPaddingTop(12);
        return b;
    }

    private void addCenterElement(Block b, Option option, String prefix) {
        Setting s = this.server.getSetting(option);
        if (s != null) {
            Block c = new Block((Element)new Text(prefix + s.stringValue()));
            c.setTextAlign("center");
            Center center = new Center((Element)c);
            center.setContentHeight(6);
            center.setContentWidth(150);
            b.addElement((Element)center);
        }
    }

    public Block makePotpisFooter() {
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block();
        b3.setTextAlign("left");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        Block b4 = new Block("");
        b4.setTextAlign("center");
        Block b5 = new Block("                      ");
        Block b6 = new Block();
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b = new Block("Arial", 12, false, false);
        b1 = new Block("______________________________");
        b1.setTextAlign("center");
        b2 = new Block("");
        b3 = new Block("______________________________");
        b3.setTextAlign("center");
        Split s3 = new Split((Element)b1, (Element)b2, (Element)b3);
        b1.setPaddingTop(12);
        b2.setPaddingTop(12);
        b3.setPaddingTop(12);
        b4 = new Block("Ovlasceno lice firme");
        b4.setTextAlign("center");
        b5 = new Block("                      ");
        b6 = new Block("Potpis korisnika usluga");
        b6.setTextAlign("center");
        Split s4 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        b.addElement((Element)s3);
        b.addElement((Element)s4);
        b.setPaddingTop(32);
        return b;
    }
}

