/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.frontoffice.MeniIzbor;
import com.dev63.restoran.logs.ButtonLogger;
import com.dev63.restoran.model.AdministracijaPopusta;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Komitent;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Login;
import com.dev63.restoran.model.Meni;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostPretplata;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.KomitentiBela;
import com.dev63.restoran.sistem.StalniGostiStoloviBela;
import com.dev63.restoran.swt.components.DiscountController;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.NumericLogin;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class Naplata
extends Window {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Logger log;
    SWTContainer container;
    private Label totalLabel;
    private Label restLabel;
    private Label kusurLabel;
    private DoubleInput2 naplaceno;
    private DoubleInput2 gotovina;
    private DoubleInput2 cek;
    private DoubleInput2 kartica;
    private DoubleInput2 faktura;
    private double total = 0.0;
    private double popust = 0.0;
    double tempPopust = 0.0;
    private Login l;
    private String broj = "";
    private boolean isText1 = false;
    private boolean isText2 = false;
    private boolean isText3 = false;
    private boolean isText4 = false;
    private boolean isText5 = true;
    private boolean gotovinskiB = false;
    private boolean gotovinskiUskaStampa = false;
    public Komitent komitent;
    public static Konobar konobar;
    ImageButton gotovinski;
    ImageButton dodatniT;
    ImageButton gotovinskiUska;
    Restoran restoran;
    RestoranServer server;
    String crno;
    private StalniGost sg;
    private StalniGostPretplata sgp;
    Composite mainComposite;
    private double kusur = 0.0;
    private Color buttCol;
    private Font numFont;
    private Font buttFont;
    List<Placanje> placanja;
    String brojBI = "";
    private MeniPromet meniPromet;
    boolean dodatniText;
    boolean dozvoliDodatniText = true;
    private List<StavkaRacuna> srHlist;
    private AdministracijaPopusta apopust;
    boolean poPosUnetCenama = false;
    boolean poPosCenamaKombo = false;
    double nadTotal = 0.0;
    ButtonLogger buttonLogger;

    public Naplata(Shell parent, Restoran r, double suma, List<StavkaRacuna> srHlist, Konobar konobar, ButtonLogger buttonLogger) {
        super(parent);
        this.restoran = r;
        this.total = suma;
        this.nadTotal = suma;
        this.srHlist = srHlist;
        Naplata.konobar = konobar;
        this.buttonLogger = buttonLogger;
        this.reset();
        this.setBlockOnOpen(true);
        this.server = this.restoran.getServer();
        this.dodatniText = BMTerminalSettings.getSetting(OptionBO.DODATNI_TEXT).booleanValue();
        Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
        this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        this.getShell().setMaximized(true);
        this.getShell().setFullScreen(true);
    }

    protected int getShellStyle() {
        return 8;
    }

    protected Layout getLayout() {
        return new GridLayout();
    }

    protected Control createContents(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(1604));
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        Composite shell = new Composite(this.mainComposite, 2048);
        this.container = new SWTContainer(shell);
        this.buttCol = new Color((Device)this.container.getControl().getDisplay(), BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.container.getControl().getShell().addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)this.buttCol));
        this.numFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getNumButtonFont());
        this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        Label naplacenoL = new Label(shell, 16384);
        naplacenoL.setText("Naplaceno:");
        this.naplaceno = new DoubleInput2(this.container, "Naplaceno", true);
        this.naplaceno.getControl().setEnabled(this.total > 0.0);
        this.naplaceno.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.naplaceno.getControl().addKeyListener((KeyListener)new KusurAdapter());
        this.naplaceno.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    Naplata.this.ok2();
                }
            }
        });
        this.addListener(this.naplaceno);
        Font font = FontCache.getFont("Arial", 12, 1);
        Label totalL = new Label(shell, 16384);
        totalL.setText("Ukupno za uplatu:");
        totalL.setFont(font);
        this.totalLabel = new Label(shell, 16384);
        this.totalLabel.setText(Konstante.getNumber2(this.total));
        this.totalLabel.setFont(font);
        Label gotovinaL = new Label(shell, 16384);
        gotovinaL.setText("Gotovina:");
        this.gotovina = new DoubleInput2(this.container, "Gotovina", true);
        this.gotovina.getControl().setEnabled(this.total > 0.0);
        this.gotovina.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.gotovina.getControl().addMouseListener((MouseListener)new FillInAdapter(this.gotovina));
        this.addListener(this.gotovina);
        Label cekL = new Label(shell, 16384);
        cekL.setText("Cek:");
        this.cek = new DoubleInput2(this.container, "Cek", true);
        this.cek.getControl().setEnabled(this.total > 0.0);
        this.cek.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.cek.getControl().addMouseListener((MouseListener)new FillInAdapter(this.cek));
        this.addListener(this.cek);
        Label karticaL = new Label(shell, 16384);
        karticaL.setText("Kartica:");
        this.kartica = new DoubleInput2(this.container, "Kartica", true);
        this.kartica.getControl().setEnabled(this.total > 0.0);
        this.kartica.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.kartica.getControl().addMouseListener((MouseListener)new FillInAdapter(this.kartica));
        this.addListener(this.kartica);
        Label fakturaL = new Label(shell, 16384);
        fakturaL.setText("Faktura:");
        this.faktura = new DoubleInput2(this.container, "Faktura", true);
        this.faktura.getControl().setEnabled(this.total > 0.0);
        this.faktura.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.faktura.getControl().addMouseListener((MouseListener)new FillInAdapter(this.faktura));
        this.addListener(this.faktura);
        Label restL = new Label(shell, 16384);
        restL.setText("Ostatak:");
        this.restLabel = new Label(shell, 16384);
        this.restLabel.setText(Konstante.getNumber2(this.total));
        Label kusurL = new Label(shell, 16384);
        kusurL.setText("Kusur:");
        kusurL.setFont(font);
        this.kusurLabel = new Label(shell, 16384);
        this.kusurLabel.setFont(font);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 40;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.heightHint = 40;
        totalL.setLayoutData((Object)data);
        restL.setLayoutData((Object)data);
        gotovinaL.setLayoutData((Object)data);
        fakturaL.setLayoutData((Object)data);
        naplacenoL.setLayoutData((Object)data);
        kusurL.setLayoutData((Object)data);
        cekL.setLayoutData((Object)data);
        karticaL.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 40;
        this.totalLabel.setLayoutData((Object)data);
        this.gotovina.getControl().setLayoutData((Object)data);
        this.cek.getControl().setLayoutData((Object)data);
        this.kartica.getControl().setLayoutData((Object)data);
        this.restLabel.setLayoutData((Object)data);
        this.faktura.getControl().setLayoutData((Object)data);
        this.kusurLabel.setLayoutData((Object)data);
        this.naplaceno.getControl().setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 150;
        GridData data2 = new GridData(256);
        data2.horizontalSpan = 3;
        Composite numericka = new Composite(this.mainComposite, 2048);
        numericka.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData();
        gridData.heightHint = 80;
        gridData.widthHint = 80;
        gridData.verticalIndent = 20;
        gridData.horizontalIndent = 20;
        GridData gridData2 = new GridData();
        gridData2.heightHint = 80;
        gridData2.widthHint = 80;
        GridData gridData3 = new GridData();
        gridData3.heightHint = 80;
        gridData3.widthHint = 80;
        gridData3.horizontalIndent = 20;
        GridData gridData4 = new GridData();
        gridData4.heightHint = 80;
        gridData4.widthHint = 80;
        gridData4.verticalIndent = 20;
        ImageButton b7 = new ImageButton(numericka, 0);
        b7.setFont(this.numFont);
        b7.setForeground(this.buttCol);
        b7.setText("7");
        b7.setLayoutData(gridData2);
        b7.setEnabled(this.total > 0.0);
        this.addListenerNumeric("7", (Control)b7);
        ImageButton b8 = new ImageButton(numericka, 0);
        b8.setFont(this.numFont);
        b8.setForeground(this.buttCol);
        b8.setText("8");
        b8.setLayoutData(gridData3);
        b8.setEnabled(this.total > 0.0);
        this.addListenerNumeric("8", (Control)b8);
        ImageButton b9 = new ImageButton(numericka, 0);
        b9.setFont(this.numFont);
        b9.setForeground(this.buttCol);
        b9.setText("9");
        b9.setLayoutData(gridData3);
        b9.setEnabled(this.total > 0.0);
        this.addListenerNumeric("9", (Control)b9);
        ImageButton b4 = new ImageButton(numericka, 0);
        b4.setFont(this.numFont);
        b4.setForeground(this.buttCol);
        b4.setText("4");
        b4.setLayoutData(gridData4);
        b4.setEnabled(this.total > 0.0);
        this.addListenerNumeric("4", (Control)b4);
        ImageButton b5 = new ImageButton(numericka, 0);
        b5.setFont(this.numFont);
        b5.setForeground(this.buttCol);
        b5.setText("5");
        b5.setLayoutData(gridData);
        b5.setEnabled(this.total > 0.0);
        this.addListenerNumeric("5", (Control)b5);
        ImageButton b6 = new ImageButton(numericka, 0);
        b6.setFont(this.numFont);
        b6.setForeground(this.buttCol);
        b6.setText("6");
        b6.setLayoutData(gridData);
        b6.setEnabled(this.total > 0.0);
        this.addListenerNumeric("6", (Control)b6);
        ImageButton b1 = new ImageButton(numericka, 0);
        b1.setFont(this.numFont);
        b1.setForeground(this.buttCol);
        b1.setText("1");
        b1.setLayoutData(gridData4);
        b1.setEnabled(this.total > 0.0);
        this.addListenerNumeric("1", (Control)b1);
        ImageButton b2 = new ImageButton(numericka, 0);
        b2.setFont(this.numFont);
        b2.setForeground(this.buttCol);
        b2.setText("2");
        b2.setLayoutData(gridData);
        b2.setEnabled(this.total > 0.0);
        this.addListenerNumeric("2", (Control)b2);
        ImageButton b3 = new ImageButton(numericka, 0);
        b3.setFont(this.numFont);
        b3.setForeground(this.buttCol);
        b3.setText("3");
        b3.setLayoutData(gridData);
        b3.setEnabled(this.total > 0.0);
        this.addListenerNumeric("3", (Control)b3);
        ImageButton b0 = new ImageButton(numericka, 0);
        b0.setFont(this.numFont);
        b0.setForeground(this.buttCol);
        b0.setText("0");
        b0.setLayoutData(gridData4);
        b0.setEnabled(this.total > 0.0);
        this.addListenerNumeric("0", (Control)b0);
        data = new GridData();
        data.horizontalSpan = 4;
        data.widthHint = 164;
        data.heightHint = 80;
        data.horizontalAlignment = 0x1000000;
        ImageButton bZarez = new ImageButton(numericka, 0);
        bZarez.setFont(this.numFont);
        bZarez.setForeground(this.buttCol);
        bZarez.setText("" + StatLogic.getDecSepForCurLocale());
        bZarez.setLayoutData(gridData);
        bZarez.setEnabled(this.total > 0.0);
        bZarez.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: ZAREZ na numeriku u naplati");
                Naplata.this.broj = Naplata.this.broj + StatLogic.getDecSepForCurLocale();
                Naplata.this.a();
                try {
                    Naplata.this.calcRest();
                    Naplata.this.calcKusur();
                }
                catch (InputException ex) {
                    SWTOptionPane.showMessageDialog(Naplata.this.container, (Object)ex.getMessage(), "Greska", 2);
                    Naplata.this.placanja = new ArrayList<Placanje>();
                }
            }
        });
        ImageButton nazad = new ImageButton(numericka, 16388);
        nazad.setPadding(8);
        nazad.setLayoutData(gridData);
        nazad.setEnabled(this.total > 0.0);
        nazad.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: STRELICA NAZAD na numeriku u naplati");
                if (!Naplata.this.broj.equals("")) {
                    Naplata.this.broj = Naplata.this.broj.substring(0, Naplata.this.broj.length() - 1);
                    Naplata.this.a();
                }
            }
        });
        data = new GridData(1040);
        data.verticalAlignment = 128;
        shell.setLayoutData((Object)data);
        data = new GridData(1040);
        data.horizontalIndent = 0;
        numericka.setLayoutData((Object)data);
        numericka.pack();
        shell.pack();
        this.mainComposite.pack();
        this.napraviDugmice();
        this.napraviDugmicePlacanje();
        return this.mainComposite;
    }

    public void addListenerNumeric(final String s, Control b) {
        b.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: " + s + " iz naplate");
                Naplata.this.broj = Naplata.this.broj + s;
                Naplata.this.a();
                try {
                    Naplata.this.calcRest();
                    Naplata.this.calcKusur();
                }
                catch (InputException ex) {
                    SWTOptionPane.showMessageDialog(Naplata.this.container, (Object)ex.getMessage(), "Greska", 2);
                    Naplata.this.placanja = new ArrayList<Placanje>();
                }
            }
        });
    }

    private boolean ok() {
        try {
            if (this.total == 0.0) {
                Konstante.getPoruka(this.getShell(), "Iznos racuna ne moze biti 0!");
                this.placanja = null;
                return false;
            }
            if (this.calcRest() != 0.0) {
                Konstante.getPoruka(this.getShell(), "Morate uneti iznos koji pokriva celokupnu vrednost racuna!");
                this.placanja = null;
                return false;
            }
            this.addPlacanje();
            return true;
        }
        catch (InputException ex) {
            SWTOptionPane.showMessageDialog(this.container, (Object)ex.getMessage(), "Greska", 2);
            this.placanja = null;
            return false;
        }
    }

    private void addPlacanje() {
        this.placanja = new ArrayList<Placanje>();
        try {
            Placanje gp;
            Placanje fp;
            if (this.kartica.getResult() > 0.0) {
                Placanje kp = new Placanje();
                kp.setIznos(this.kartica.getResult());
                kp.setNacin(NacinPlacanja.KARTICA);
                kp.setVreme(new Date());
                this.placanja.add(kp);
            }
            if (this.cek.getResult() > 0.0) {
                fp = new Placanje();
                fp.setIznos(this.cek.getResult());
                fp.setNacin(NacinPlacanja.CEK);
                fp.setVreme(new Date());
                this.placanja.add(fp);
            }
            if (this.gotovina.getResult() > 0.0) {
                gp = new Placanje();
                gp.setIznos(this.gotovina.getResult());
                gp.setNacin(NacinPlacanja.GOTOVINA);
                gp.setVreme(new Date());
                this.placanja.add(gp);
            }
            if (this.faktura.getResult() > 0.0) {
                fp = new Placanje();
                fp.setIznos(this.faktura.getResult());
                fp.setNacin(NacinPlacanja.FAKTURA);
                fp.setVreme(new Date());
                this.placanja.add(fp);
            }
            if (this.placanja.size() == 0) {
                gp = new Placanje();
                double temp = this.naplaceno.getResult();
                gp.setIznos(temp);
                gp.setNacin(NacinPlacanja.GOTOVINA);
                gp.setVreme(new Date());
                this.placanja.add(gp);
            }
        }
        catch (InputException ex) {
            SWTOptionPane.showMessageDialog(this.container, (Object)ex.getMessage(), "Greska", 2);
        }
    }

    private void reset() {
        this.placanja = new ArrayList<Placanje>();
        this.sg = null;
        this.crno = "";
    }

    private void cancel() {
        this.close(1);
    }

    public boolean close(int returnCode) {
        this.setReturnCode(returnCode);
        return this.close();
    }

    public List<Placanje> getPlacanja() {
        return this.placanja;
    }

    public boolean getGotovinski() {
        return this.gotovinskiB;
    }

    public String getCrno() {
        return this.crno;
    }

    private double calcRest() throws InputException {
        double rest = this.meniPromet == null ? this.total : this.meniPromet.getTotal();
        rest -= this.gotovina.getResult().doubleValue();
        rest -= this.cek.getResult().doubleValue();
        rest -= this.kartica.getResult().doubleValue();
        rest -= this.faktura.getResult().doubleValue();
        if ((rest = new Double(new DecimalFormat("###0.00").format((double)Math.round(rest * 100.0) / 100.0)).doubleValue()) >= 0.0) {
            this.restLabel.setText(Konstante.getNumber2(rest));
        } else {
            this.restLabel.setText("");
        }
        return rest;
    }

    private double calcKusur() throws InputException {
        double rest = this.naplaceno.getResult();
        rest = this.meniPromet == null ? (rest -= this.total) : (rest -= this.meniPromet.getTotal());
        rest = (double)Math.round(rest * 100.0) / 100.0;
        if (rest >= 0.0) {
            this.kusur = rest;
            this.kusurLabel.setText(Konstante.getNumber2(rest));
        } else {
            this.kusurLabel.setText("");
        }
        return rest;
    }

    public StalniGostPretplata getSgp() {
        return this.sgp;
    }

    public StalniGost getSg() {
        return this.sg;
    }

    public void setSg(StalniGost sg) {
        this.sg = sg;
    }

    public MeniPromet getMeniPromet() {
        return this.meniPromet;
    }

    public void setMeniPromet(MeniPromet meniPromet) {
        this.meniPromet = meniPromet;
    }

    public double getKusur() {
        return this.kusur;
    }

    public boolean getGotovinskiUskaStampa() {
        return this.gotovinskiUskaStampa;
    }

    public boolean dozvoliStampuDodatnogTexta() {
        return this.dozvoliDodatniText;
    }

    public void setGotovinskiUskaStampa(boolean gotovinskiUskaStampa) {
        this.gotovinskiUskaStampa = gotovinskiUskaStampa;
    }

    private void napraviDugmice() {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Setting uskaGot = this.restoran.getServer().getSetting(Option.GOTOVINSKI_RACUN_USKA_STAMPA);
        boolean uskaGotovina = uskaGot != null && uskaGot.booleanValue();
        Setting a4Got = this.restoran.getServer().getSetting(Option.GOTOVINSKI_RACUN_A4_STAMPA);
        boolean a4Gotovina = a4Got != null && a4Got.booleanValue();
        Setting meni = this.restoran.getServer().getSetting(Option.MENI);
        boolean meniUkljucen = meni != null && meni.booleanValue();
        final Composite c = new Composite(this.mainComposite, 2048);
        c.setLayout((Layout)new GridLayout(uskaGotovina && a4Gotovina ? 5 : (uskaGotovina || a4Gotovina ? 4 : 3), true));
        c.setLayoutData((Object)data);
        GridData gridData2 = new GridData(576);
        gridData2.widthHint = 130;
        gridData2.heightHint = 80;
        ImageButton otkazi = new ImageButton(c, 0x1000040);
        otkazi.setLayoutData(gridData2);
        otkazi.setFont(this.buttFont);
        otkazi.setForeground(this.buttCol);
        otkazi.setText(String.format(Konstante.getBundle().getString("TEXT_OTKAZI"), new Object[0]));
        otkazi.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: OTKAZI u naplati");
                Naplata.this.cancel();
            }
        });
        gridData2 = new GridData(576);
        gridData2.widthHint = 130;
        gridData2.heightHint = 80;
        if (uskaGotovina) {
            this.gotovinskiUska = new ImageButton(c, 2);
            this.gotovinskiUska.setFont(this.buttFont);
            this.gotovinskiUska.setForeground(this.buttCol);
            this.gotovinskiUska.setText(String.format(Konstante.getBundle().getString("TEXT_GOTOVINSKI_USKA_STAMPA"), new Object[0]));
            this.gotovinskiUska.setLayoutData(gridData2);
            this.gotovinskiUska.setEnabled(this.total > 0.0);
            this.gotovinskiUska.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
        }
        if (a4Gotovina) {
            this.gotovinski = new ImageButton(c, this.total > 0.0 ? 2 : 8);
            this.gotovinski.setFont(this.buttFont);
            this.gotovinski.setForeground(this.buttCol);
            this.gotovinski.setText(String.format(Konstante.getBundle().getString("TEXT_GOTOVINSKI_RACUN"), new Object[0]));
            this.gotovinski.setLayoutData(gridData2);
            if (this.total == 0.0) {
                this.gotovinski.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: GOTOVINSKI RACUN u naplati");
                        Naplata.this.gotovinskiRacun(Naplata.this.getShell());
                    }
                });
            }
        }
        if (this.dodatniText) {
            this.dodatniT = new ImageButton(c, 2);
            this.dodatniT.setFont(this.buttFont);
            this.dodatniT.setForeground(this.buttCol);
            this.dodatniT.setSelection(this.dozvoliDodatniText);
            this.dodatniT.setText(String.format(Konstante.getBundle().getString("TEXT_DODATNI_TEKST"), new Object[0]));
            this.dodatniT.setLayoutData(gridData2);
            this.dodatniT.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: DODATNI TEKST u naplati");
                    Naplata.this.dozvoliDodatniText = Naplata.this.dodatniT.getSelection();
                }
            });
        }
        gridData2 = new GridData(576);
        gridData2.widthHint = 130;
        gridData2.heightHint = 80;
        ImageButton stPorudz = new ImageButton(c, 0x1000040);
        stPorudz.setFont(this.buttFont);
        stPorudz.setForeground(this.buttCol);
        stPorudz.setLayoutData(gridData2);
        stPorudz.setEnabled(this.total > 0.0);
        stPorudz.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
        stPorudz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: POTVRDI u naplati");
                try {
                    if (Naplata.this.faktura.getResult() > 0.0 && Naplata.this.faktura.getResult() < Naplata.this.total) {
                        Konstante.getPoruka3(c.getShell(), "Placanje fakturom ne moze biti deo kombinovanog placanja!!!");
                        c.getShell().close();
                    }
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                Naplata.this.ok2();
            }
        });
        if (meniUkljucen) {
            ImageButton meniButt = new ImageButton(c, 0x1000040);
            meniButt.setFont(this.buttFont);
            meniButt.setForeground(this.buttCol);
            meniButt.setLayoutData(gridData2);
            meniButt.setEnabled(this.total > 0.0);
            meniButt.setText(String.format(Konstante.getBundle().getString("TEXT_MENI"), new Object[0]));
            meniButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: MENI u naplati");
                    List<Meni> meniList = Naplata.this.server.getAllMenus();
                    double ukupnoNabavno = 0.0;
                    for (StavkaRacuna sr : Naplata.this.srHlist) {
                        sr = (StavkaRacuna)Naplata.this.server.getBase().find(StavkaRacuna.class, (Object)sr.getId());
                        Artikal a = sr.getArtikal();
                        double cena = this.getNabavnaCena(a, sr.getKolicina());
                        ukupnoNabavno += cena;
                        System.out.println(a + " = " + cena);
                    }
                    System.out.println("Ukupno nabavno: " + ukupnoNabavno);
                    MeniIzbor mi = new MeniIzbor(Naplata.this.getShell(), meniList, konobar, ukupnoNabavno, Naplata.this.restoran);
                    if (mi.getOutput() != null) {
                        Naplata.this.meniPromet = mi.getOutput();
                        if (mi != null) {
                            Naplata.this.totalLabel.setText(Konstante.getNumber2(Naplata.this.meniPromet.getTotal()));
                        }
                    }
                }

                private double getNabavnaCena(Artikal art, Double kolicina) {
                    double trNv = 0.0;
                    if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
                        Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, Naplata.this.server, null, null);
                        for (Artikal a : mapa.keySet()) {
                            trNv += (Naplata.this.poPosUnetCenama ? a.getTrenutnaNV() : (Naplata.this.poPosCenamaKombo ? Naplata.this.server.getLastNabavnaCenaKombo(a) : Naplata.this.server.getLastNabavnaCenaBela(a, new Date()))) / (1.0 + (Naplata.this.poPosCenamaKombo || Naplata.this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
                        }
                    } else {
                        trNv = (Naplata.this.poPosUnetCenama ? art.getTrenutnaNV() : (Naplata.this.poPosCenamaKombo ? Naplata.this.server.getLastNabavnaCenaKombo(art) : Naplata.this.server.getLastNabavnaCenaBela(art, new Date()))) / (1.0 + (Naplata.this.poPosCenamaKombo || Naplata.this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * art.getMera() * kolicina;
                    }
                    return trNv;
                }
            });
        }
    }

    public void gotovinskiRacun(Shell parent) {
        if (parent == null || parent.isDisposed()) {
            return;
        }
        Calendar from = Calendar.getInstance();
        from.add(11, -1);
        final List<Racun> racuni = this.restoran.getServer().getRacuniGotovinski(from.getTime(), new Date());
        if (racuni.isEmpty()) {
            Konstante.getPoruka(this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_NEMA_RACUNA_ZAKLJUCENIH_GOTOVINOM_ILI_KARTICOM"), new Object[0]));
            return;
        }
        final Shell shell5 = new Shell(parent, 0);
        shell5.setLayout((Layout)new GridLayout(2, false));
        shell5.setBackground(parent.getDisplay().getSystemColor(1));
        Composite c = new Composite((Composite)shell5, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tcl = new TableColumnLayout();
        c.setLayout((Layout)tcl);
        final Table tableRacuni = new Table(c, 66308);
        tableRacuni.setFont(Konstante.getFont(parent.getDisplay(), 16, 0));
        tableRacuni.setLayoutData((Object)new GridData(1808));
        tableRacuni.setLinesVisible(true);
        tableRacuni.setHeaderVisible(true);
        TableColumn k = new TableColumn(tableRacuni, 0x1000000);
        k.setText(String.format(Konstante.getBundle().getString("TEXT_KONOBAR"), new Object[0]));
        tcl.setColumnData((Widget)k, (ColumnLayoutData)new ColumnWeightData(260, 260));
        TableColumn s = new TableColumn(tableRacuni, 0x1000000);
        s.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_STOLA_SKR"), new Object[0]));
        tcl.setColumnData((Widget)s, (ColumnLayoutData)new ColumnWeightData(80, 80));
        TableColumn t = new TableColumn(tableRacuni, 0x1000000);
        t.setText(String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]));
        tcl.setColumnData((Widget)t, (ColumnLayoutData)new ColumnWeightData(180, 180));
        TableColumn p = new TableColumn(tableRacuni, 0x1000000);
        p.setText(String.format(Konstante.getBundle().getString("TEXT_NACIN_SKR"), new Object[0]));
        tcl.setColumnData((Widget)p, (ColumnLayoutData)new ColumnWeightData(100, 100));
        TableColumn v = new TableColumn(tableRacuni, 0x1000000);
        v.setText(String.format(Konstante.getBundle().getString("TEXT_VREME"), new Object[0]));
        tcl.setColumnData((Widget)v, (ColumnLayoutData)new ColumnWeightData(140, 140));
        for (Racun r : racuni) {
            new TableItem(tableRacuni, 0).setText(new String[]{r.getKonobar().getPunoime(), String.valueOf(r.getBrojStola()), Konstante.getNumber2(r.total()), r.getPlacanja().get(0).getNacin().getOpis(), Konstante.getTime(r.getDatum())});
        }
        final Display display = shell5.getDisplay();
        ImageButton potvrda = new ImageButton((Composite)shell5, 8);
        potvrda.setFont(this.buttFont);
        potvrda.setForeground(this.buttCol);
        potvrda.setText(String.format(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]), new Object[0]));
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.dozvoliDodatniText = Naplata.this.dodatniText && Naplata.this.dodatniT.getSelection();
                if (tableRacuni.getSelectionIndex() < 0) {
                    Konstante.getPoruka3(shell5, "Morate odabrati racun");
                    return;
                }
                Racun racun = (Racun)racuni.get(tableRacuni.getSelectionIndex());
                KomitentiBela kb = new KomitentiBela(display, shell5, Naplata.this.restoran, racun, racun.getKonobar());
                Naplata.this.komitent = kb.getKomitent();
            }
        });
        ImageButton gore = new ImageButton((Composite)shell5, 132);
        gore.setPadding(8);
        gore.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = tableRacuni.getSelectionIndex();
                if (index == -1) {
                    if (tableRacuni.getItemCount() != 0) {
                        tableRacuni.setSelection(0);
                    }
                } else if (index != 0) {
                    tableRacuni.setSelection(--index);
                }
            }
        });
        ImageButton dole = new ImageButton((Composite)shell5, 1028);
        dole.setPadding(8);
        dole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = tableRacuni.getSelectionIndex();
                if (index == -1) {
                    tableRacuni.setSelection(tableRacuni.getItemCount() - 1);
                } else if (index != tableRacuni.getItemCount() - 1) {
                    tableRacuni.setSelection(++index);
                }
            }
        });
        ImageButton button = new ImageButton((Composite)shell5, 8);
        button.setFont(this.buttFont);
        button.setForeground(this.buttCol);
        button.setText(String.format(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]), new Object[0]));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell5.close();
            }
        });
        tableRacuni.pack();
        GridData data = new GridData(4, 4, true, true);
        data.verticalSpan = 5;
        c.setLayoutData((Object)data);
        data = new GridData();
        data.verticalIndent = 320;
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData(data);
        data = new GridData();
        data.widthHint = 164;
        data.heightHint = 80;
        gore.setLayoutData(data);
        dole.setLayoutData(data);
        button.setLayoutData(data);
        shell5.setMaximized(true);
        Konstante.endShell(shell5);
    }

    private void ok2() {
        try {
            if (this.naplaceno.getResult() >= 1.0E7) {
                int result = SWTMessage.showLocalizedYesNoDialog(this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UNSESETE_NAPLACENI_IZNOS"), StatLogic.getNumber02NG(this.naplaceno.getResult())), String.format(Konstante.getBundle().getString("TEXT_POTVRDA_NAPLACENOG_IZNOSA"), new Object[0]));
                switch (result) {
                    case 128: 
                    case 256: 
                    case 512: {
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            Double totalRound = (double)new Double(new DecimalFormat("###0.00").format((double)Math.round(this.total * 100.0) / 100.0));
            if (this.faktura.getResult() > 0.0) {
                // empty if block
            }
            if (this.faktura.getResult() != 0.0 && this.calcRest() != 0.0) {
                Konstante.getPoruka(this.getShell(), "Faktura mora pokriti ceo iznos racuna!");
                return;
            }
            if (this.calcRest() < 0.0) {
                Konstante.getPoruka(this.getShell(), "Proverite unesene iznose!");
                return;
            }
            if (this.calcRest() != 0.0 && (this.cek.getResult() != 0.0 || this.kartica.getResult() != 0.0 || this.faktura.getResult() != 0.0)) {
                Konstante.getPoruka(this.getShell(), "Proverite unesene iznose!");
                return;
            }
            if (this.calcRest() > 0.0 && this.calcRest() < totalRound) {
                System.out.println("calcRest() = " + this.calcRest());
                System.out.println("total = " + this.total);
                Konstante.getPoruka(this.getShell(), "Naplaceni iznos mora pokriti ceo racun!");
                return;
            }
        }
        catch (InputException ex) {
            Logger.getLogger(Naplata.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.addPlacanje();
        this.gotovinskiB = this.gotovinski != null && this.gotovinski.getSelection();
        this.gotovinskiUskaStampa = this.gotovinskiUska != null && this.gotovinskiUska.getSelection();
        this.close(0);
    }

    private void napraviDugmicePlacanje() {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        final Composite c = new Composite(this.mainComposite, 2048);
        c.setLayout((Layout)new GridLayout(3, true));
        c.setLayoutData((Object)data);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 120;
        gridData2.heightHint = 75;
        gridData2.horizontalIndent = 100;
        if (this.server.readAdministracijaPopusti().size() > 0) {
            ImageButton popus = new ImageButton(c, 8);
            popus.setText(String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0]));
            popus.setFont(this.buttFont);
            popus.setForeground(this.buttCol);
            popus.setLayoutData(gridData2);
            popus.setEnabled(this.total > 0.0);
            popus.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    boolean potvrda = false;
                    if (konobar.getAdministracijaPopusta().booleanValue()) {
                        potvrda = true;
                    } else {
                        NumericLogin nl = new NumericLogin();
                        String sif = nl.vratiSifru();
                        System.out.println("sif " + sif);
                        Naplata.this.l = Naplata.this.server.getLogin(sif);
                        try {
                            boolean bl = potvrda = Naplata.this.l != null && Naplata.this.l.getAdmin() != false && Naplata.this.l.getService() != false;
                            if (Naplata.this.l == null) {
                                Konstante.getPoruka3(c.getShell(), "Pogresan pass. Nepostojeci korisnik");
                            }
                        }
                        catch (NullPointerException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (potvrda) {
                        DiscountController dc = new DiscountController(Naplata.this.server);
                        if (dc.jePopust() != null) {
                            Naplata.this.apopust = dc.jePopust();
                        }
                        if (Naplata.this.apopust != null && Naplata.this.sg == null) {
                            double zbir = 0.0;
                            zbir = Naplata.this.nadTotal == Naplata.this.total ? Naplata.this.total : Naplata.this.nadTotal;
                            for (StavkaRacuna sr : Naplata.this.srHlist) {
                                if (!sr.getArtikal().getDozvoljenPopust().booleanValue()) continue;
                                zbir -= sr.getArtikal().getDozvoljenPopust() != false ? sr.getArtikal().getCena() * sr.getKolicina() * (Naplata.this.apopust.getPopust() / 100.0) : 0.0;
                            }
                            Naplata.this.totalLabel.setText(Konstante.getNumber2(zbir));
                            Naplata.this.restLabel.setText(Konstante.getNumber2(zbir));
                            Naplata.this.total = zbir;
                        } else {
                            Naplata.this.totalLabel.setText(Konstante.getNumber2(Naplata.this.total));
                            Naplata.this.restLabel.setText(Konstante.getNumber2(Naplata.this.total));
                            double zbir = 0.0;
                            for (StavkaRacuna sr : Naplata.this.srHlist) {
                                zbir += sr.getArtikal().getCena() * sr.getKolicina();
                            }
                            Naplata.this.totalLabel.setText(Konstante.getNumber2(zbir));
                            Naplata.this.restLabel.setText(Konstante.getNumber2(zbir));
                            Naplata.this.total = zbir;
                        }
                    }
                }
            });
        }
        for (final CrnoPlacanje cp : this.restoran.getServer().readCrnaPlacanjaEkran()) {
            ImageButton crnoD = new ImageButton(c, 8);
            crnoD.setFont(this.buttFont);
            crnoD.setForeground(this.buttCol);
            crnoD.setText(cp.getNaziv());
            crnoD.setLayoutData(gridData2);
            crnoD.setEnabled(this.total > 0.0);
            crnoD.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Naplata.this.placanja = new ArrayList<Placanje>();
                    Naplata.this.crno = cp.getNaziv();
                    Naplata.this.close(0);
                }
            });
        }
        ImageButton stalniGosti = new ImageButton(c, 0);
        stalniGosti.setFont(this.buttFont);
        stalniGosti.setForeground(this.buttCol);
        stalniGosti.setLayoutData(gridData2);
        stalniGosti.setText(String.format(Konstante.getBundle().getString("TEXT_STALNI_GOSTI"), new Object[0]));
        stalniGosti.setEnabled(this.total > 0.0);
        stalniGosti.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Naplata.this.buttonLogger.info("konobar: " + konobar.getPunoime() + ", pritisnuto dugme: STALNI GOST u naplati");
                Naplata.this.stalniGostNaplata(c);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public void stalniGostNaplata(Composite c) {
        block19: {
            block20: {
                block18: {
                    s = new StalniGostiStoloviBela(c.getDisplay(), c.getShell(), this.restoran, Naplata.konobar, this.buttonLogger);
                    if (s.getGost() == null) {
                        return;
                    }
                    this.setSg(s.getGost());
                    sgnp = null;
                    this.sgp = this.server.getSGpretplata(this.sg);
                    v0 = this.sgp == null ? this.sg.getNacinPlacanja() : (sgnp = this.sgp.isUkljuceno() != false ? this.sgp.getNacin() : this.sg.getNacinPlacanja());
                    if (this.apopust != null) {
                        this.popust = this.apopust.getPopust();
                    }
                    if (Konstante.getNacin(sgnp) == null) break block18;
                    this.ok2();
                    break block19;
                }
                if (sgnp != null) break block20;
                zbir = this.total;
                zadatiLimit = this.sg.getZadatiLimit() != null ? this.sg.getZadatiLimit() : 0.0;
                zbirRacuna = this.sg.getZbirRacuna() != null ? this.sg.getZbirRacuna() : 0.0;
                popustPoLimitu = this.sg.getPopustPoLimitu() != null ? this.sg.getPopustPoLimitu() : 0.0;
                v1 = prc = this.sg.getZbirRacuna() != null ? this.sg.getZbirRacuna() : 0.0;
                if (this.sg.getZbirRacuna() == null) ** GOTO lbl-1000
                v2 = this.popust > 0.0 ? zbirRacuna + (zbir - zbir * (this.popust / 100.0)) : zbir;
                if (zbirRacuna + v2 > zadatiLimit && zadatiLimit > 0.0) {
                    Konstante.getPoruka3(this.getShell(), "Stalni gost: " + this.sg.getNaziv() + ", redovan popust: " + this.sg.getPopust() + "%\nCilj: " + this.sg.getZadatiLimit() + ", trenutno sakupljeno: " + this.sg.getZbirRacuna() + "\nPri sledecoj kupovini, kupac je u mogucnosti da ostvari popust u vrednosti od " + this.sg.getPopustPoLimitu() + "%");
                } else if (this.sg != null) {
                    Konstante.getPoruka3(this.getShell(), "Stalni gost: " + this.sg.getNaziv() + ", redovan popust: " + this.sg.getPopust() + "%");
                }
                if (zadatiLimit != 0.0 && popustPoLimitu != 0.0) {
                    if (zbirRacuna < zadatiLimit) {
                        this.popust = this.sg.getPopust();
                        if (this.apopust != null) {
                            this.popust = this.apopust.getPopust();
                        }
                        this.sg.setZbirRacuna(this.popust > 0.0 ? zbirRacuna + (zbir - zbir * (this.popust / 100.0)) : zbirRacuna + zbir);
                    } else {
                        pozitivanOdgovor = Konstante.getPorukaDaNe(this.getShell(), "Dostigli ste limit u potrosnji od " + zadatiLimit + "(" + Konstante.getNumber02(zbirRacuna) + "), da li zelite sada da iskoristite popust u vrednosti od " + popustPoLimitu + "% ?").isOdgovorPozitivan();
                        if (!pozitivanOdgovor) {
                            this.popust = this.sg.getPopust();
                            if (this.apopust != null) {
                                this.popust = this.apopust.getPopust();
                            }
                            this.sg.setZbirRacuna(this.popust > 0.0 ? zbirRacuna + (zbir - zbir * (this.popust / 100.0)) : zbirRacuna + zbir);
                        } else if (popustPoLimitu == 100.0) {
                            this.popust = 100.0;
                            this.sg.setZbirRacuna(zbirRacuna - zadatiLimit);
                            this.tempPopust = 100.0;
                        } else {
                            this.popust = popustPoLimitu;
                            this.sg.setZbirRacuna(zbirRacuna - zadatiLimit);
                            this.tempPopust = this.popust;
                        }
                    }
                } else {
                    this.popust = this.sg.getPopust();
                    if (this.apopust != null) {
                        this.popust = this.apopust.getPopust();
                    }
                }
                if (this.apopust == null) {
                    for (StavkaRacuna sr : this.srHlist) {
                        if (!sr.getArtikal().getDozvoljenPopust().booleanValue()) continue;
                        zbir -= sr.getArtikal().getCena() * sr.getKolicina() * (this.popust / 100.0);
                    }
                    this.totalLabel.setText(Konstante.getNumber2(zbir));
                    this.restLabel.setText(Konstante.getNumber2(zbir));
                    this.total = zbir;
                }
                break block19;
            }
            this.placanja = new ArrayList<Placanje>();
            this.crno = sgnp;
            this.close(0);
        }
    }

    public void addListener(final DoubleInput2 t) {
        t.getControl().addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (t.equals(Naplata.this.gotovina)) {
                    Naplata.this.gotovina.getControl().forceFocus();
                    Naplata.this.isText1 = true;
                    Naplata.this.isText2 = false;
                    Naplata.this.isText3 = false;
                    Naplata.this.isText4 = false;
                    Naplata.this.isText5 = false;
                    try {
                        if (t.getResult() < Naplata.this.total) {
                            Naplata.this.faktura.setEnabled(false);
                        }
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                    Naplata.this.broj = Naplata.this.gotovina.getText();
                    return;
                }
                if (t.equals(Naplata.this.cek)) {
                    Naplata.this.cek.getControl().forceFocus();
                    Naplata.this.isText1 = false;
                    Naplata.this.isText2 = true;
                    Naplata.this.isText3 = false;
                    Naplata.this.isText4 = false;
                    Naplata.this.isText5 = false;
                    try {
                        if (t.getResult() < Naplata.this.total) {
                            Naplata.this.faktura.setEnabled(false);
                        }
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                    Naplata.this.broj = Naplata.this.cek.getText();
                    return;
                }
                if (t.equals(Naplata.this.faktura)) {
                    Naplata.this.faktura.getControl().forceFocus();
                    Naplata.this.isText1 = false;
                    Naplata.this.isText2 = false;
                    Naplata.this.isText3 = true;
                    Naplata.this.isText4 = false;
                    Naplata.this.isText5 = false;
                    Naplata.this.broj = Naplata.this.faktura.getText();
                    return;
                }
                if (t.equals(Naplata.this.kartica)) {
                    Naplata.this.kartica.getControl().forceFocus();
                    Naplata.this.isText1 = false;
                    Naplata.this.isText2 = false;
                    Naplata.this.isText3 = false;
                    Naplata.this.isText4 = true;
                    Naplata.this.isText5 = false;
                    try {
                        if (t.getResult() < Naplata.this.total) {
                            Naplata.this.faktura.setEnabled(false);
                        }
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                    Naplata.this.broj = Naplata.this.kartica.getText();
                    return;
                }
                if (t.equals(Naplata.this.naplaceno)) {
                    Naplata.this.naplaceno.getControl().forceFocus();
                    Naplata.this.isText1 = false;
                    Naplata.this.isText2 = false;
                    Naplata.this.isText3 = false;
                    Naplata.this.isText4 = false;
                    Naplata.this.isText5 = true;
                    Naplata.this.broj = Naplata.this.naplaceno.getText();
                    return;
                }
            }
        });
    }

    public void a() {
        if (this.broj.length() > 0) {
            if (this.isText1) {
                this.gotovina.setResult(Double.valueOf(this.broj));
                return;
            }
            if (this.isText2) {
                this.cek.setResult(Double.valueOf(this.broj));
                return;
            }
            if (this.isText3) {
                this.faktura.setResult(Double.valueOf(this.broj));
                return;
            }
            if (this.isText4) {
                this.kartica.setResult(Double.valueOf(this.broj));
                return;
            }
            if (this.isText5) {
                this.naplaceno.setResult(Double.valueOf(this.broj.replace(',', '.')));
                return;
            }
        } else {
            if (this.isText1) {
                this.gotovina.clear();
                return;
            }
            if (this.isText2) {
                this.cek.clear();
                return;
            }
            if (this.isText3) {
                this.faktura.clear();
                return;
            }
            if (this.isText4) {
                this.kartica.clear();
                return;
            }
            if (this.isText5) {
                this.naplaceno.clear();
                return;
            }
        }
    }

    public AdministracijaPopusta getApopoust() {
        return this.apopust;
    }

    public double getDodatniPopust() {
        return this.tempPopust;
    }

    private class FillInAdapter
    extends MouseAdapter {
        private DoubleInput2 input;

        public FillInAdapter(DoubleInput2 input) {
            this.input = input;
        }

        public void mouseUp(MouseEvent e) {
            try {
                double rest = Naplata.this.calcRest();
                if (rest <= 0.0) {
                    return;
                }
                if (this.input.getResult() != 0.0) {
                    return;
                }
                this.input.setResult(rest);
                Naplata.this.calcRest();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }

    private class KusurAdapter
    extends KeyAdapter {
        private KusurAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            try {
                Naplata.this.calcKusur();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }

    private class RestAdapter
    extends KeyAdapter {
        private RestAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            try {
                Naplata.this.calcRest();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }
}

