/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.JediniceMere;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.parts.ObjectWrapper;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.ArtikalDialog;
import com.dev63.restoran.sistem.KarticaPregled;
import com.dev63.restoran.sistem.Sastavnica;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class MagacinArtikal {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Shell shell3;
    RestoranServer server;
    Restoran rest;
    Odeljenje odeljenje;
    private TextInput2 name;
    final Combo podgrupa;
    final Combo tipArtikla;
    final Combo poreskaGrupa;
    final Combo jedMere;
    private DoubleInput2 minZalihe;
    private DoubleInput2 mera;
    private TextInput2 barcode;
    private DoubleInput2 cena1;
    private Label c1;
    private TextInput2 skrNaziv;
    private IntInput2 prioritet;
    List<Button> odChek = new ArrayList<Button>();
    List<PodgrupaArtikala> podgrupe;
    boolean inpdv;
    List<ObjectWrapper> stope = new ArrayList<ObjectWrapper>();
    List<Normativ> normativi = new ArrayList<Normativ>();
    List<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
    JedMere[] jedinice = JedMere.values();
    List<JediniceMere> jedinice2;
    List<TipArtikla> tipovi = new ArrayList<TipArtikla>();
    Label cnv;
    Label slika;
    String putanjaSlike;
    private Artikal input;
    private Artikal result;
    private List<Normativ> result2 = new ArrayList<Normativ>();
    Normativ result4;
    private Button jelo;
    private Button pice;
    private Boolean izmenaArtikla;
    private Button blokiran;
    private Button popust;

    public MagacinArtikal(Shell parent, Restoran restoran, Artikal inp, Odeljenje odelj) throws FiscalException, SerialIOException {
        this.input = inp;
        this.shell3 = new Shell(parent, 34912);
        this.shell3.setText(inp == null ? "Novi artikal, odeljenje " + odelj.getNaziv() : "Artikal " + inp.getName() + ", odeljenje " + odelj.getNaziv());
        this.shell3.setBackground(this.shell3.getDisplay().getSystemColor(22));
        this.server = restoran.getServer();
        this.rest = restoran;
        this.odeljenje = odelj;
        this.podgrupe = this.server.readPodgrupeArtikala();
        this.inpdv = this.server.getSetting(Option.U_SISTEMU_PDV).booleanValue();
        this.jedinice2 = this.server.readJedMere();
        this.izmenaArtikla = this.server.getSetting(Option.IZMENA_ARTIKLA).booleanValue();
        for (TipArtikla ta : TipArtikla.values()) {
            this.tipovi.add(ta);
        }
        Font font = Konstante.getFont(this.shell3.getDisplay(), 9, 1);
        CTabFolder folder = new CTabFolder((Composite)this.shell3, 2048);
        CTabItem item1 = new CTabItem(folder, 0);
        item1.setText("  Osnovni podaci o artiklu  ");
        CTabItem item3 = new CTabItem(folder, 0);
        item3.setText("  Robna kartica artikla  ");
        CTabItem item4 = new CTabItem(folder, 0);
        item4.setText("  Osnovne robne kartice  ");
        CTabItem item5 = new CTabItem(folder, 0);
        item5.setText("  Dodatne robne kartice  ");
        Composite composite1 = new Composite((Composite)folder, 0);
        Composite composite3 = new Composite((Composite)folder, 0);
        Composite composite4 = new Composite((Composite)folder, 0);
        Composite composite5 = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout(3, false);
        composite1.setLayout((Layout)layout);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite4.setLayout((Layout)new GridLayout(1, false));
        composite5.setLayout((Layout)new GridLayout(1, false));
        this.shell3.setLayout((Layout)new FillLayout());
        item1.setControl((Control)composite1);
        item3.setControl((Control)composite3);
        item4.setControl((Control)composite4);
        item5.setControl((Control)composite5);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 650;
        layout = new GridLayout(4, false);
        Group grupa1 = new Group(composite1, 0);
        grupa1.setLayout((Layout)layout);
        grupa1.setText("Osnovni podaci o artiklu:");
        grupa1.setLayoutData((Object)data);
        grupa1.setFont(font);
        GridData data6 = new GridData();
        data6.horizontalSpan = 3;
        data6.heightHint = 70;
        data6.widthHint = 650;
        layout = new GridLayout(5, false);
        final Group grupa2 = new Group(composite1, 0x1000000);
        grupa2.setLayout((Layout)layout);
        grupa2.setText("Proizvodna mesta:");
        grupa2.setLayoutData((Object)data6);
        grupa2.setFont(font);
        GridData data0 = new GridData();
        data0.widthHint = 310;
        data0.heightHint = 125;
        layout = new GridLayout(1, false);
        Group grupa5 = new Group(composite1, 0x1000000);
        grupa5.setLayout((Layout)layout);
        grupa5.setText("Graficki prikaz artikla:");
        grupa5.setLayoutData((Object)data0);
        grupa5.setFont(font);
        data0 = new GridData();
        data0.widthHint = 330;
        data0.heightHint = 125;
        layout = new GridLayout(2, false);
        Group grupa7 = new Group(composite1, 0x1000000);
        grupa7.setLayout((Layout)layout);
        grupa7.setText("Prodajna cena:");
        grupa7.setLayoutData((Object)data0);
        grupa7.setFont(font);
        data0 = new GridData();
        data0.horizontalSpan = 2;
        data0.heightHint = 47;
        data0.widthHint = 650;
        layout = new GridLayout(3, false);
        Group grupa6 = new Group(composite1, 0x1000000);
        grupa6.setLayout((Layout)layout);
        grupa6.setLayoutData((Object)data0);
        grupa6.setFont(font);
        Group grupa16 = null;
        if (this.input != null) {
            data0 = new GridData();
            data0.horizontalSpan = 2;
            data0.heightHint = 47;
            data0.widthHint = 650;
            layout = new GridLayout(3, false);
            grupa16 = new Group(composite1, 0x1000000);
            grupa16.setLayout((Layout)layout);
            grupa16.setLayoutData((Object)data0);
            grupa16.setFont(font);
        }
        final SWTContainer parent2 = new SWTContainer((Composite)grupa1);
        SWTContainer parent4 = new SWTContainer((Composite)grupa7);
        if (this.inpdv) {
            this.stope.add(new ObjectWrapper(PoreskaGrupa.GRUPA_DJ, "GRUPA_DJ (20%)", 20));
            this.stope.add(new ObjectWrapper(PoreskaGrupa.GRUPA_G, "GRUPA_G (0%)", 0));
            this.stope.add(new ObjectWrapper(PoreskaGrupa.GRUPA_E, "GRUPA_E (10%)", 10));
        } else {
            this.stope.add(new ObjectWrapper(PoreskaGrupa.GRUPA_A, "GRUPA_A (0%)", 0));
        }
        GridData data1 = new GridData();
        data1.widthHint = 120;
        data1.heightHint = 20;
        data1.horizontalIndent = 5;
        GridData data2 = new GridData();
        data2.widthHint = 130;
        data2.heightHint = 20;
        data2.horizontalIndent = 5;
        GridData data3 = new GridData();
        data3.widthHint = 150;
        data3.heightHint = 20;
        data3.horizontalIndent = 5;
        Label n = new Label((Composite)grupa1, 0);
        n.setBackground(this.shell3.getDisplay().getSystemColor(22));
        n.setText("Naziv artikla:");
        n.setLayoutData((Object)data1);
        this.name = new TextInput2(parent2, "Naziv artikla", false);
        this.name.getControl().setLayoutData((Object)data3);
        if (this.input == null) {
            this.name.getControl().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent fe) {
                }

                public void focusLost(FocusEvent fe) {
                    try {
                        MagacinArtikal.this.skrNaziv.setResult(MagacinArtikal.this.name.getResult());
                    }
                    catch (InputException ex) {
                        Logger.getLogger(ArtikalDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        Label bc = new Label((Composite)grupa1, 0);
        bc.setText("Sifra:");
        bc.setBackground(this.shell3.getDisplay().getSystemColor(22));
        bc.setLayoutData((Object)data2);
        this.barcode = new TextInput2(parent2, "Sifra");
        this.barcode.getControl().setLayoutData((Object)data3);
        Label sn = new Label((Composite)grupa1, 0);
        sn.setText("Skraceni naziv:");
        sn.setBackground(this.shell3.getDisplay().getSystemColor(22));
        sn.setLayoutData((Object)data1);
        this.skrNaziv = new TextInput2(parent2, "Skraceni naziv", false);
        this.skrNaziv.getControl().setLayoutData((Object)data3);
        Label jm = new Label((Composite)grupa1, 0);
        jm.setText(" Jedinica mere:");
        jm.setBackground(this.shell3.getDisplay().getSystemColor(22));
        sn.setLayoutData((Object)data2);
        this.jedMere = new Combo((Composite)grupa1, 2572);
        for (int i = 0; i < this.jedinice.length; ++i) {
            this.jedMere.add(this.jedinice[i].getInterName());
        }
        for (JediniceMere j : this.jedinice2) {
            this.jedMere.add(j.getNaziv());
        }
        this.jedMere.select(0);
        this.jedMere.setLayoutData((Object)data3);
        Label t = new Label((Composite)grupa1, 0);
        t.setText("Tip artikla:");
        t.setBackground(this.shell3.getDisplay().getSystemColor(22));
        t.setLayoutData((Object)data1);
        this.tipArtikla = new Combo((Composite)grupa1, 2572);
        for (int i = 0; i < this.tipovi.size(); ++i) {
            this.tipArtikla.add(this.tipovi.get(i).getNaziv());
        }
        this.tipArtikla.select(0);
        this.tipArtikla.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Button mag = new Button((Composite)grupa2, 32);
                for (Button b : MagacinArtikal.this.odChek) {
                    if (!b.getText().equals("MAGACIN")) continue;
                    mag = b;
                    b.setEnabled(false);
                }
                if (MagacinArtikal.this.tipArtikla.getSelectionIndex() > -1 && (MagacinArtikal.this.tipovi.get(MagacinArtikal.this.tipArtikla.getSelectionIndex()) == TipArtikla.SIRO || MagacinArtikal.this.tipovi.get(MagacinArtikal.this.tipArtikla.getSelectionIndex()) == TipArtikla.POTR)) {
                    MagacinArtikal.this.cena1.setEnabled(false);
                } else {
                    MagacinArtikal.this.cena1.setEnabled(true);
                }
            }
        });
        this.tipArtikla.setLayoutData((Object)data3);
        Label mz = new Label((Composite)grupa1, 0);
        mz.setText("Minimalna zaliha:");
        mz.setBackground(this.shell3.getDisplay().getSystemColor(22));
        mz.setLayoutData((Object)data2);
        this.minZalihe = new DoubleInput2(parent2, "Minimalne zalihe", (Double)0.0, false);
        this.minZalihe.getControl().setLayoutData((Object)data3);
        Label p = new Label((Composite)grupa1, 0);
        p.setText("Podgrupa:");
        p.setBackground(this.shell3.getDisplay().getSystemColor(22));
        p.setLayoutData((Object)data1);
        this.podgrupa = new Combo((Composite)grupa1, 2572);
        for (PodgrupaArtikala pga : this.podgrupe) {
            this.podgrupa.add(pga.toString());
        }
        this.podgrupa.select(0);
        this.podgrupa.setLayoutData((Object)data3);
        Label pg = new Label((Composite)grupa1, 0);
        pg.setText("Poreska stopa:");
        pg.setBackground(this.shell3.getDisplay().getSystemColor(22));
        pg.setLayoutData((Object)data2);
        this.poreskaGrupa = new Combo((Composite)grupa1, 2572);
        for (int i = 0; i < this.stope.size(); ++i) {
            this.poreskaGrupa.add(this.stope.get(i).toString());
        }
        this.poreskaGrupa.select(0);
        this.poreskaGrupa.setLayoutData((Object)data3);
        Label m = new Label((Composite)grupa1, 0);
        m.setText("Normativ (mera):");
        m.setBackground(this.shell3.getDisplay().getSystemColor(22));
        m.setLayoutData((Object)data1);
        this.mera = new DoubleInput2(parent2, "Normativ", (Double)1.0, false);
        this.mera.getControl().setLayoutData((Object)data3);
        this.jelo = new Button((Composite)grupa1, 32);
        this.jelo.setText("DPU prikaz: jelo");
        this.jelo.setLayoutData((Object)data2);
        this.pice = new Button((Composite)grupa1, 32);
        this.pice.setText("DPU prikaz: pice");
        this.pice.setLayoutData((Object)data2);
        Label pr = new Label((Composite)grupa1, 0);
        pr.setText("Prioritet:");
        pr.setBackground(this.shell3.getDisplay().getSystemColor(22));
        pr.setLayoutData((Object)data1);
        this.prioritet = new IntInput2(parent2, "Prioritet", (Integer)1, false);
        this.prioritet.getControl().setLayoutData((Object)data3);
        this.blokiran = new Button((Composite)grupa1, 32);
        this.blokiran.setText("Blokiran");
        this.blokiran.setLayoutData((Object)data2);
        this.popust = new Button((Composite)grupa1, 32);
        this.popust.setText("Dozvoljen popust");
        this.popust.setLayoutData((Object)data2);
        this.popust.setSelection(true);
        data1 = new GridData();
        data1.widthHint = 120;
        for (Odeljenje od : this.server.readOdeljenje()) {
            Button odeljenjeCheck = new Button((Composite)grupa2, 32);
            odeljenjeCheck.setText(od.getNaziv());
            odeljenjeCheck.setBackground(this.shell3.getDisplay().getSystemColor(22));
            this.odChek.add(odeljenjeCheck);
            if (od.equals(this.odeljenje)) {
                odeljenjeCheck.setSelection(true);
            }
            odeljenjeCheck.setLayoutData((Object)data1);
        }
        data1 = new GridData();
        data1.widthHint = 130;
        data1.heightHint = 25;
        data2 = new GridData();
        data2.widthHint = 110;
        data2.heightHint = 25;
        data2 = new GridData();
        data2.widthHint = 140;
        data2.heightHint = 25;
        data2.verticalIndent = 20;
        this.c1 = new Label((Composite)grupa7, 0);
        this.c1.setText("Prodajna cena:");
        this.c1.setBackground(this.shell3.getDisplay().getSystemColor(22));
        this.c1.setLayoutData((Object)data2);
        this.cena1 = new DoubleInput2(parent4, "Prodajna cena", true);
        this.cena1.getControl().setLayoutData((Object)data2);
        data2 = new GridData();
        data2.widthHint = 170;
        data2.heightHint = 25;
        data2.verticalIndent = 20;
        data1 = new GridData();
        data1.widthHint = 100;
        data1.heightHint = 25;
        data1.verticalIndent = 20;
        data1 = new GridData();
        data1.widthHint = 130;
        data1.heightHint = 30;
        data1.horizontalAlignment = 0x1000000;
        Button button = new Button((Composite)grupa5, 8);
        button.setText(" Izbor slike");
        button.setImage(new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/izborSlike.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MagacinArtikal.this.shell3, 4100);
                File file = new File(".");
                dialog.setFilterPath(ImagePath.getPath() + "\\artikli");
                String path = dialog.open();
                if (path != null) {
                    file = new File(path);
                    if (file.isFile()) {
                        MagacinArtikal.this.putanjaSlike = file.toString();
                    }
                    MagacinArtikal.this.slika.setImage(new Image((Device)MagacinArtikal.this.shell3.getDisplay(), MagacinArtikal.this.putanjaSlike));
                }
            }
        });
        button.setLayoutData((Object)data1);
        data1 = new GridData();
        data1.widthHint = 170;
        data1.horizontalAlignment = 0x1000000;
        data1.heightHint = 70;
        this.slika = new Label((Composite)grupa5, 0x1000000);
        this.slika.setBackground(this.shell3.getDisplay().getSystemColor(22));
        this.slika.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MagacinArtikal.this.slika.setText("");
            }
        });
        this.slika.setLayoutData((Object)data1);
        if (this.input != null) {
            this.loadData();
        }
        data1 = new GridData();
        data1.horizontalAlignment = 16384;
        data1.widthHint = 120;
        data1.heightHint = 40;
        Button cancelButt = new Button((Composite)grupa6, 8);
        cancelButt.setText(" Otkazi");
        cancelButt.setImage(new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/ponisti3.gif"));
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MagacinArtikal.this.cancel(parent2);
            }
        });
        Button helpButt = new Button((Composite)grupa6, 8);
        helpButt.setText(" Pomoc");
        helpButt.setImage(new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/pomoc.gif"));
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = new Button((Composite)grupa6, 8);
        okButt.setText(" Potvrdi");
        okButt.setImage(new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/potvrda2.gif"));
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MagacinArtikal.this.ok(parent2);
            }
        });
        Button sastavnica = null;
        if (this.input != null) {
            sastavnica = new Button((Composite)grupa16, 8);
            sastavnica.setText(" Sastavnica");
            sastavnica.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new Sastavnica(MagacinArtikal.this.input, MagacinArtikal.this.rest, MagacinArtikal.this.server, MagacinArtikal.this.shell3.getDisplay());
                }
            });
        }
        cancelButt.setLayoutData((Object)data1);
        if (this.input != null) {
            sastavnica.setLayoutData((Object)data1);
        }
        data1 = new GridData();
        data1.horizontalAlignment = 0x1000000;
        data1.horizontalIndent = 135;
        data1.widthHint = 120;
        data1.heightHint = 40;
        helpButt.setLayoutData((Object)data1);
        data1 = new GridData();
        data1.horizontalAlignment = 131072;
        data1.horizontalIndent = 135;
        data1.widthHint = 120;
        data1.heightHint = 40;
        okButt.setLayoutData((Object)data1);
        if (this.input != null && !this.input.getTip().equals((Object)TipArtikla.SLOZ)) {
            Table table1 = KarticaPregled.getKarticaTable(composite3, this.odeljenje, this.input, this.server, this.shell3);
            table1.addListener(8, (Listener)new KarticaPregled.DocumentListener(this.shell3, this.rest));
            Table table2 = KarticaPregled.getKarticaTableBele(composite4, this.odeljenje, this.input, this.server, this.shell3);
            table2.addListener(8, (Listener)new KarticaPregled.DocumentListener(this.shell3, this.rest));
            Table table3 = KarticaPregled.getKarticaTableCrne(composite5, this.odeljenje, this.input, this.server, this.shell3);
            table3.addListener(8, (Listener)new KarticaPregled.DocumentListener(this.shell3, this.rest));
        }
        this.shell3.open();
        while (!this.shell3.isDisposed()) {
            if (this.shell3.getDisplay().readAndDispatch()) continue;
            this.shell3.getDisplay().sleep();
        }
    }

    private void ok(SWTContainer parent) {
        Artikal a = this.input != null ? this.input : new Artikal();
        try {
            String n = this.name.getResult();
            if (this.input == null && this.server.proveriNazivArtikal(n)) {
                int style = 65600;
                MessageBox messageBox = new MessageBox(this.shell3, style);
                messageBox.setText("Upozorenje");
                messageBox.setMessage("Artikal za zadatim imenom vec postoji u bazi!\n Promenite naziv!");
                int response = messageBox.open();
                if (response == 64) {
                    this.shell3.setFocus();
                }
                return;
            }
            if (this.barcode.getResult() != null && !this.barcode.getResult().equals("") && this.input == null && this.server.proveriNazivBarcode(this.barcode.getResult())) {
                int style = 65600;
                MessageBox messageBox = new MessageBox(this.shell3, style);
                messageBox.setText("Upozorenje");
                messageBox.setMessage("Artikal za zadatim barkodom vec postoji u bazi!\n Promenite barkod!");
                int response = messageBox.open();
                if (response == 64) {
                    this.shell3.setFocus();
                }
                return;
            }
            if (n.length() > 29) {
                Konstante.getPoruka(this.shell3, "Naziv artikla moze imati najvise 29 karaktera!");
                return;
            }
            if (n.contains("'") || n.contains("\"") || n.contains("\\") || n.contains("&")) {
                Konstante.getPoruka(this.shell3, "Naziv artikla ne sme sadrzati artikle [ ' \" \\ && ]");
                return;
            }
            a.setName(n);
            a.setPodgrupa(this.podgrupe.get(this.podgrupa.getSelectionIndex()));
            a.setTip(this.tipovi.get(this.tipArtikla.getSelectionIndex()));
            a.setPoreskaGrupa((PoreskaGrupa)this.stope.get(this.poreskaGrupa.getSelectionIndex()).getData());
            a.setJedinicaMere(this.jedMere.getItem(this.jedMere.getSelectionIndex()));
            a.setBarCode(this.barcode.getResult());
            a.setMera(this.mera.getResult());
            a.setTrenutnaNV(0.0);
            a.setSkrNaziv(this.skrNaziv.getResult());
            if (!this.slika.getText().isEmpty()) {
                a.setSlika(this.putanjaSlike);
            }
            if (this.cena1.isEnabled()) {
                a.setCena(this.cena1.getResult() != null ? this.cena1.getResult() : 0.0);
            }
            this.odeljenja = new ArrayList<Odeljenje>();
            if (this.input == null) {
                for (Button b : this.odChek) {
                    if (!b.getSelection()) continue;
                    for (Odeljenje o : this.server.readOdeljenje()) {
                        if (!o.getNaziv().equals(b.getText())) continue;
                        this.odeljenja.add(o);
                    }
                }
                a.setOdeljenja(this.odeljenja);
            } else {
                for (Button b : this.odChek) {
                    if (!b.getSelection()) continue;
                    for (Odeljenje o : this.server.readOdeljenje()) {
                        if (!o.getNaziv().equals(b.getText()) || this.odeljenja.contains(o)) continue;
                        this.odeljenja.add(o);
                    }
                }
            }
            a.setOdeljenja(this.odeljenja);
            a.setJelo(this.jelo.getSelection());
            a.setPice(this.pice.getSelection());
            a.setBlokiran(this.blokiran.getSelection());
            a.setDozvoljenPopust(this.popust.getSelection());
            a.setPrioritet(this.prioritet.getResult());
            a.setBlokiran(false);
            this.result = a;
            parent.getControl().getShell().close();
        }
        catch (InputException ex) {
            SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), "Greska", 2);
        }
    }

    private void cancel(SWTContainer parent) {
        parent.getControl().getShell().close();
    }

    public Artikal getResult() {
        return this.result;
    }

    public List<Normativ> getResult2() {
        return this.result2;
    }

    /*
     * WARNING - void declaration
     */
    private void loadData() {
        this.name.setResult(this.input.getName());
        this.name.getControl().setEnabled(this.izmenaArtikla.booleanValue());
        this.skrNaziv.setResult(this.input.getSkrNaziv());
        if (this.input.getSlika() != null) {
            this.slika.setImage(new Image((Device)this.shell3.getDisplay(), this.input.getSlika()));
        }
        for (PodgrupaArtikala podgrupaArtikala : this.podgrupe) {
            if (!podgrupaArtikala.equals(this.input.getPodgrupa())) continue;
            this.podgrupa.select(this.podgrupe.indexOf(podgrupaArtikala));
        }
        for (int i = 0; i < this.tipovi.size(); ++i) {
            if (!this.tipovi.get(i).equals((Object)this.input.getTip())) continue;
            this.tipArtikla.select(i);
        }
        for (ObjectWrapper objectWrapper : this.stope) {
            if (!objectWrapper.getData().equals(this.input.getPoreskaGrupa())) continue;
            this.poreskaGrupa.select(this.stope.indexOf(objectWrapper));
        }
        boolean didJM = false;
        for (JedMere jm : JedMere.values()) {
            if (!jm.name().equalsIgnoreCase(this.input.getJedinicaMere()) && !jm.getInterName().equalsIgnoreCase(this.input.getJedinicaMere())) continue;
            didJM = true;
            this.jedMere.select(jm.ordinal());
        }
        if (!didJM) {
            void var2_10;
            int n = JedMere.values().length;
            while (var2_10 < this.jedMere.getItemCount()) {
                String j = this.jedMere.getItem((int)var2_10);
                if (j.equalsIgnoreCase(this.input.getJedinicaMere())) {
                    this.jedMere.select((int)var2_10);
                }
                ++var2_10;
            }
        }
        this.minZalihe.setResult(this.input.getMinLager());
        this.barcode.setResult(this.input.getBarCode() != null ? this.input.getBarCode() : "");
        this.mera.setResult(this.input.getMera());
        if (!this.input.getTip().equals((Object)TipArtikla.SIRO) && !this.input.getTip().equals((Object)TipArtikla.POTR)) {
            this.cena1.setResult(this.input.getCena());
        } else {
            this.c1.setEnabled(false);
            this.cena1.setEnabled(false);
        }
        for (Button b : this.odChek) {
            b.setSelection(false);
            for (Odeljenje o : this.input.getOdeljenja()) {
                if (!o.getNaziv().equals(b.getText())) continue;
                b.setSelection(true);
                b.setEnabled(false);
            }
        }
        this.odeljenja = this.input.getOdeljenja();
        this.jelo.setSelection(this.input.getJelo().booleanValue());
        this.pice.setSelection(this.input.getPice().booleanValue());
        this.blokiran.setSelection(this.input.getBlokiran().booleanValue());
        this.popust.setSelection(this.input.getDozvoljenPopust().booleanValue());
        if (this.input.getPrioritet() != null) {
            this.prioritet.setResult(this.input.getPrioritet());
        }
    }
}

