/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTModels;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class IzmenaStavkiRacuna
extends SWTModels {
    private RestoranServer server;
    private Connection connection;
    private Shell shell;
    private Table itemsTable;
    private Composite buttons;
    private String billEdit;
    private String itemEdit;
    private String colItem;
    private String colQuantity;
    private String colPrice;
    private String colPriceWithDiscount;
    private String colValue;
    private String buttEdit;
    private String discountMessage;
    private String fiscalMessage;
    private String combinedPaymentMessage;
    private String valueMessage;
    private String btnConfrim;
    private String btnCancel;
    private String totalValue;
    private Racun bill;
    private PopisProvera provera;
    private String[] columns;
    private int[] columnWidths;
    private double value;

    public IzmenaStavkiRacuna(RestoranServer server, Racun bill, Shell billShell) {
        this.billEdit = this.barmasterText.getString("TEXT_IZMENA_RACUNA");
        this.itemEdit = this.barmasterText.getString("TEXT_IZMENA_STAVKE_RACUNA");
        this.colItem = this.barmasterText.getString("TEXT_NAZIV_ARTIKLA");
        this.colQuantity = this.barmasterText.getString("TEXT_KOLICINA");
        this.colPrice = this.barmasterText.getString("TEXT_CENA");
        this.colPriceWithDiscount = this.barmasterText.getString("TEXT_CENA_SA_POPUSTOM");
        this.colValue = this.barmasterText.getString("TEXT_VREDNOST");
        this.buttEdit = this.barmasterText.getString("TEXT_IZMENA");
        this.discountMessage = this.barmasterText.getString("PORUKA_IZMENA_NIJE_DOZVOLJENA_POPUST");
        this.fiscalMessage = this.barmasterText.getString("PORUKA_IZMENA_NIJE_DOZVOLJENA_OSNOVNI");
        this.combinedPaymentMessage = this.barmasterText.getString("PORUKA_IZMENA_NIJE_DOZVOLJENA_KOMBINOVANO");
        this.valueMessage = this.barmasterText.getString("PORUKA_UNETI_PODACI_NISU_VALIDNI");
        this.btnConfrim = this.barmasterText.getString("TEXT_POTVRDI");
        this.btnCancel = this.barmasterText.getString("TEXT_OTKAZI");
        this.totalValue = this.barmasterText.getString("TEXT_UKUPNO");
        this.columns = new String[]{this.colItem, this.colQuantity, this.colPrice, this.colValue, "id"};
        this.columnWidths = new int[]{200, 60, 60, 60, 0};
        this.server = server;
        this.bill = bill;
        this.connection = server.getConnection();
        this.provera = new PopisProvera(server, billShell, bill.getDatum(), null, true);
        this.value = 0.0;
        if (this.billHaveDiscount()) {
            Konstante.prikaziMessageBox(billShell, this.discountMessage);
            return;
        }
        if (!this.fiscalBill()) {
            Konstante.prikaziMessageBox(billShell, this.fiscalMessage);
            return;
        }
        if (this.billHaveCombinedPayment()) {
            Konstante.prikaziMessageBox(billShell, this.combinedPaymentMessage);
            return;
        }
        if (this.provera.isPopis()) {
            return;
        }
        this.shell = this.makeShell(532, 400, billShell, this.billEdit, 2);
        this.itemsTable = this.makeTable((Composite)this.shell, this.columns, this.columnWidths, 1, 2);
        this.itemsTable.getColumn(this.columns.length - 1).setResizable(false);
        this.buttons = this.makeComposite((Composite)this.shell, 1, 110, 275, 1, 1, 1, 1, 1, 1);
        Composite confirmComp = this.makeComposite((Composite)this.shell, 1, 110, 60, 1, 1, 1, 1, 1, 1);
        Button editItem = this.makeButton(this.buttons, 100, 50, 1, 1, this.buttEdit);
        editItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IzmenaStavkiRacuna.this.getEditWindow();
            }
        });
        Button confirmBtn = this.makeButton(confirmComp, 100, 50, 1, 1, this.btnConfrim);
        confirmBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IzmenaStavkiRacuna.this.shell.close();
            }
        });
        this.populateTable();
        this.shellSetCenter(this.shell);
        this.shell.open();
        billShell.setEnabled(false);
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        billShell.setEnabled(true);
    }

    private void populateTable() {
        TableItem ti;
        this.itemsTable.removeAll();
        List<StavkaRacuna> items = this.server.getStavke(this.bill.getId());
        int i = 0;
        this.value = 0.0;
        for (StavkaRacuna item : items) {
            ti = new TableItem(this.itemsTable, 0);
            ti.setText(i++, item.getNaziv());
            ti.setText(i++, String.valueOf(item.getQuantity()));
            ti.setText(i++, String.valueOf(item.getPriceWithDiscount()));
            ti.setText(i++, String.valueOf(item.getValueWithDiscount()));
            ti.setText(i++, String.valueOf(item.getId()));
            this.value += Double.parseDouble(String.valueOf(item.getValueWithDiscount()));
            i = 0;
        }
        ti = new TableItem(this.itemsTable, 0);
        ti.setText(2, this.totalValue);
        ti.setText(3, String.valueOf(this.value));
        this.itemsTable.setSelection(0);
    }

    private void getEditWindow() {
        TableItem ti = this.itemsTable.getItem(this.itemsTable.getSelectionIndex());
        final long itemId = Long.parseLong(ti.getText(this.columns.length - 1));
        final Shell editShell = this.makeShell(500, 200, this.shell, this.itemEdit, 3);
        this.shellSetCenter(editShell);
        this.makeLabel((Composite)editShell, this.colItem, 200, 30, null, 1, 1);
        this.makeLabel((Composite)editShell, this.colQuantity, 60, 30, null, 1, 1);
        this.makeLabel((Composite)editShell, this.colPrice, 60, 30, null, 1, 1);
        this.makeTextField((Composite)editShell, ti.getText(0), 200, 20, false, 1, 1);
        final Text textQuantity = this.makeTextField((Composite)editShell, ti.getText(1), 60, 20, true, 1, 1);
        final Text textPrice = this.makeTextField((Composite)editShell, ti.getText(2), 60, 20, true, 1, 1);
        Composite confirmCancel = this.makeComposite((Composite)editShell, 2, 450, 70, 3, 1, 230, 15, 1, 1);
        Button cancel = this.makeButton(confirmCancel, 90, 35, 1, 1, this.btnCancel);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                editShell.close();
            }
        });
        Button confirm = this.makeButton(confirmCancel, 90, 35, 1, 1, this.btnConfrim);
        confirm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                double quantity = IzmenaStavkiRacuna.this.convertToDouble(textQuantity.getText().trim(), editShell);
                double price = IzmenaStavkiRacuna.this.convertToDouble(textPrice.getText().trim(), editShell);
                if (quantity < 0.0 || price < 0.0) {
                    Konstante.prikaziMessageBox(editShell, IzmenaStavkiRacuna.this.valueMessage);
                    return;
                }
                if (IzmenaStavkiRacuna.this.editItem(itemId, quantity, price)) {
                    IzmenaStavkiRacuna.this.populateTable();
                    IzmenaStavkiRacuna.this.editPayment();
                }
                editShell.close();
            }
        });
        editShell.open();
        this.shell.setEnabled(false);
        while (!editShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.shell.setEnabled(true);
    }

    private boolean editItem(long id, double quantity, double price) {
        boolean edit = false;
        String query = "update stavkaracuna set kolicina = ?, cena = ? where id = ?";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDouble(1, quantity);
            ps.setDouble(2, price);
            ps.setLong(3, id);
            ps.execute();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            edit = true;
            return edit;
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                return edit;
            }
            e.printStackTrace();
            return edit;
        }
    }

    private void editPayment() {
        long paymentId = this.bill.getPlacanja().get(0).getId();
        String query = "UPDATE placanje SET iznos = ? WHERE id = ?";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDouble(1, this.value);
            ps.setLong(2, paymentId);
            ps.execute();
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private double convertToDouble(String value, Shell shell) {
        double result;
        try {
            result = Double.parseDouble(value.replace(",", "."));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
        return result;
    }

    private boolean billHaveDiscount() {
        return this.bill.getStalniGost() != null && this.bill.getStalniGost().getPopust() > 0.0;
    }

    private boolean fiscalBill() {
        return this.bill.getCrnoPlacanje() == null;
    }

    private boolean billHaveCombinedPayment() {
        return this.bill.getPlacanja().size() > 1;
    }
}

