/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.ImagePath;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.GrupaTroskova;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class IzborGrupaTroskova {
    Shell shell;
    RestoranServer server;
    List<GrupaTroskova> grupe = new ArrayList<GrupaTroskova>();
    List<GrupaTroskova> grupeL1 = new ArrayList<GrupaTroskova>();
    Map<String, GrupaTroskova> mapa = new HashMap<String, GrupaTroskova>();
    Display display;
    Text text;

    public IzborGrupaTroskova(Shell parent, RestoranServer server, List<GrupaTroskova> p) {
        this.shell = new Shell(parent.getDisplay(), 0);
        this.shell.setText("Izbor grupa troskova");
        this.display = this.shell.getDisplay();
        this.server = server;
        this.grupeL1 = p;
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.setMaximized(true);
        Composite c1 = new Composite((Composite)this.shell, 0);
        c1.setLayout((Layout)new FillLayout());
        GridData data = new GridData(1040);
        data.widthHint = 629;
        c1.setLayoutData((Object)data);
        Composite c3 = new Composite((Composite)this.shell, 0);
        c3.setLayout((Layout)new FillLayout());
        data = new GridData(1040);
        data.widthHint = 200;
        c3.setLayoutData((Object)data);
        Composite c2 = new Composite((Composite)this.shell, 0);
        c2.setLayout((Layout)new GridLayout());
        data = new GridData(1040);
        data.widthHint = 175;
        c2.setLayoutData((Object)data);
        Tree tree = new Tree(c1, 2080);
        this.fillInTreeItems(tree, this.grupeL1);
        this.text = new Text(c3, 2112);
        data = new GridData(768);
        data.heightHint = 80;
        Button ok = new Button(c2, 0x1000040);
        ok.setImage(new Image((Device)this.display, ImagePath.getPath() + "/potvrda1.gif"));
        ok.setBackground(this.display.getSystemColor(1));
        ok.setLayoutData((Object)data);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IzborGrupaTroskova.this.shell.close();
            }
        });
        Button izlaz = new Button(c2, 0x1000040);
        izlaz.setImage(new Image((Device)this.display, ImagePath.getPath() + "/ponisti1.gif"));
        izlaz.setBackground(this.display.getSystemColor(1));
        izlaz.setLayoutData((Object)data);
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IzborGrupaTroskova.this.grupe = new ArrayList<GrupaTroskova>();
                IzborGrupaTroskova.this.shell.close();
            }
        });
        this.refresh();
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArrayList items = new ArrayList();
                if (event.detail == 32) {
                    TreeItem source = (TreeItem)event.item;
                    boolean checked = source.getChecked();
                    IzborGrupaTroskova.this.selectItems(source, items, checked);
                    try {
                        for (TreeItem it : items) {
                            if (!checked) {
                                if (!IzborGrupaTroskova.this.grupe.contains(IzborGrupaTroskova.this.mapa.get(it.getText()))) continue;
                                IzborGrupaTroskova.this.grupe.remove(IzborGrupaTroskova.this.mapa.get(it.getText()));
                                continue;
                            }
                            if (IzborGrupaTroskova.this.grupe.contains(IzborGrupaTroskova.this.mapa.get(it.getText()))) continue;
                            IzborGrupaTroskova.this.grupe.add(IzborGrupaTroskova.this.mapa.get(it.getText()));
                        }
                        IzborGrupaTroskova.this.refresh();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void selectItems(TreeItem item, List<TreeItem> items, boolean check) {
        items.add(item);
        item.setChecked(check);
        for (TreeItem ti : item.getItems()) {
            this.selectItems(ti, items, check);
        }
    }

    private void fillInTreeItems(Tree tree, List<GrupaTroskova> gtList) {
        for (GrupaTroskova gt : gtList) {
            TreeItem ti = new TreeItem(tree, 0);
            ti.setText(gt.getNaziv());
            this.mapa.put(gt.getNaziv(), gt);
            if (gt.getPodGrupe() == null || gt.getPodGrupe().isEmpty()) continue;
            this.fillInTreeItems(ti, gt.getPodGrupe());
        }
    }

    private void fillInTreeItems(TreeItem treeItem, List<GrupaTroskova> gtList) {
        for (GrupaTroskova gt : gtList) {
            TreeItem ti = new TreeItem(treeItem, 0);
            ti.setText(gt.getNaziv());
            this.mapa.put(gt.getNaziv(), gt);
            if (gt.getPodGrupe() == null || gt.getPodGrupe().isEmpty()) continue;
            this.fillInTreeItems(ti, gt.getPodGrupe());
        }
    }

    public List<GrupaTroskova> getGrupe() {
        return this.grupe;
    }

    public void refresh() {
        try {
            this.text.setText("");
            String s = "\nIZABRANE GRUPE:\n__________________________\n";
            int i = 1;
            for (GrupaTroskova gt : this.grupe) {
                s = s + i++ + ") " + gt.getNaziv() + "\n";
            }
            this.text.setText(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

