/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.IDKartica;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class IDKarticaUnos {
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    private IDKartica active;
    Composite dugmici;

    public IDKarticaUnos(Shell s, Restoran hostel) {
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = new Shell(s, 34912);
        this.parent = SWTContainerClass.makeContainer(this.shell, String.format(Konstante.getBundle().getString("TEXT_ID_KARTICE"), new Object[0]));
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/placanjaV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_ID_KARTICE"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(Konstante.getBundle().getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        uputstvo.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK_ID_KARTICA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(Konstante.getBundle().getString("TEXT_ATRIBUTI_ID_KARTICE"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_NOVA_ID_KARTICA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                IDKarticaUnos.this.addKartica();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_IZMENA_ID_KARTICE"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                IDKarticaUnos.this.updatePlacanje();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_BRISANJE_ID_KARTICE"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                IDKarticaUnos.this.deletePlacanje();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = IDKarticaUnos.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                IDKarticaUnos.this.setActiveIDKartica((IDKartica)IDKarticaUnos.this.listModel.getElementAt(index));
            }
        });
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display = new Label((Composite)grupa3, 0);
        this.display.setLayoutData((Object)data);
        this.reload();
        Konstante.endShell(this.shell);
    }

    private void reload() {
        this.listModel.clear();
        List<IDKartica> kartice = this.restoran.getServer().findAllIDKartica();
        for (IDKartica idk : kartice) {
            this.listModel.addElement(idk);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addKartica() {
        Shell shell2 = new Shell(this.shell, 34912);
        IDKarticaDialog gd = new IDKarticaDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_NOVA_ID_KARTICA"), new Object[0])), null);
        SWTContainerClass.makeEnd(shell2);
        if (gd.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_NOVA_ID_KARTICA"), new Object[0]) + ":   " + gd.getResult());
            try {
                this.restoran.getServer().addIDKartica(gd.getResult());
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(this.shell, 40);
                mb.setMessage(ex.getMessage());
                mb.setText(String.format(Konstante.getBundle().getString("TEXT_BARMASTER"), new Object[0]));
                mb.open();
                Logger.getLogger(IDKarticaUnos.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.reload();
        }
    }

    private void updatePlacanje() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.shell, 34912);
        IDKarticaDialog sd = new IDKarticaDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_IZMENA_ID_KARTICE"), new Object[0])), this.active);
        SWTContainerClass.makeEnd(shell2);
        if (sd.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_IZMENA_ID_KARTICE"), new Object[0]) + ": " + sd.getResult());
            try {
                this.active = this.restoran.getServer().updateIDKartica(sd.getResult());
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(this.shell, 40);
                mb.setMessage(ex.getMessage());
                mb.setText(String.format(Konstante.getBundle().getString("TEXT_BARMASTER"), new Object[0]));
                mb.open();
                Logger.getLogger(IDKarticaUnos.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.reload();
        }
    }

    private void deletePlacanje() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_OBRISETE_ID_KARTICU"), this.active.getNaziv()));
        if (ok == 0) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_ID_KARTICE"), new Object[0]) + ": " + this.active);
            try {
                this.restoran.getServer().removeIDKartica(this.active);
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(this.shell, 40);
                mb.setMessage(ex.getMessage());
                mb.setText(String.format(Konstante.getBundle().getString("TEXT_BARMASTER"), new Object[0]));
                mb.open();
                Logger.getLogger(IDKarticaUnos.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveIDKartica(IDKartica o) {
        this.active = o;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_KOD_ID_KARTICE"), new Object[0]) + ": ").append(o.getKod()).append("\n");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_SIFRA_KOJU_POZIVA_ID_KARTICA"), new Object[0]) + ": ").append(o.getSifra()).append("\n");
        this.display.setText(bld.toString());
    }

    private class IDKarticaDialog {
        private TextInput2 naziv;
        private IntInput2 sifra;
        private TextInput2 kod;
        private IDKartica input;
        private IDKartica result;
        Shell shell3;

        public IDKarticaDialog(SWTContainer parent, IDKartica input) {
            this.input = input;
            this.shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            this.shell3.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            IDKarticaDialog.this.ok(parent2);
                        }
                    }
                }
            });
            Label n = new Label((Composite)this.shell3, 0);
            n.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]) + ":");
            this.naziv = new TextInput2(parent, String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]), false);
            Label sn = new Label((Composite)this.shell3, 0);
            sn.setText(String.format(Konstante.getBundle().getString("TEXT_SIFRA_KOJU_POZIVA_ID_KARTICA"), new Object[0]) + ":");
            this.sifra = new IntInput2(parent, String.format(Konstante.getBundle().getString("TEXT_SIFRA_KOJU_POZIVA_ID_KARTICA"), new Object[0]), false);
            Label kodL = new Label((Composite)this.shell3, 0);
            kodL.setText(String.format(Konstante.getBundle().getString("TEXT_KOD_ID_KARTICE"), new Object[0]) + ":");
            this.kod = new TextInput2(parent, String.format(Konstante.getBundle().getString("TEXT_KOD_ID_KARTICE"), new Object[0]), false);
            Label separator = new Label((Composite)this.shell3, 258);
            GridData data2 = new GridData();
            data2.horizontalSpan = 2;
            data2.widthHint = 300;
            separator.setLayoutData((Object)data2);
            Button cancelButt = Dugmici.getCancelButton(this.shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IDKarticaDialog.this.cancel(parent2);
                }
            });
            Button okButt = Dugmici.getOkButton(this.shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IDKarticaDialog.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(2, false);
            this.shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 140;
            data.heightHint = 30;
            data.horizontalAlignment = 131072;
            n.setLayoutData((Object)data);
            sn.setLayoutData((Object)data);
            kodL.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 30;
            this.naziv.getControl().setLayoutData((Object)data);
            this.sifra.getControl().setLayoutData((Object)data);
            this.kod.getControl().setLayoutData((Object)data);
            data = new GridData(64);
            data.widthHint = 120;
            data.heightHint = 80;
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 40;
            SWTContainerClass.setDimension(this.shell3);
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            IDKartica k = this.input != null ? this.input : new IDKartica();
            try {
                k.setNaziv(this.naziv.getResult());
                k.setSifra(this.sifra.getResult().toString());
                k.setKod(this.kod.getResult());
                this.result = k;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        public IDKartica getResult() {
            return this.result;
        }

        private void loadData() {
            this.naziv.setResult(this.input.getNaziv());
            this.sifra.setResult(Integer.valueOf(this.input.getSifra()));
            this.kod.setResult(this.input.getKod());
        }
    }
}

