/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.JSONoperation.JSONSerbianBookers;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PostExample;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Meni;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.ProtelReservation;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.controller.KasaController;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.NumericKeyboard;
import com.dev63.restoran.swt.resources.FontCache;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class HotelskiGostNaplata {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Shell shellFull;
    private Composite shell;
    private Composite buttons;
    private StackLayout buttonsLayout;
    private Composite[] buttonsStack;
    private double iznos;
    private String placanje;
    private HotelskiGost hg;
    private RestoranServer rs;
    private Map<String, Long> sobe = new HashMap<String, Long>();
    private Map<String, Long> gosti = new HashMap<String, Long>();
    private StalniGost sg;
    private boolean visible;
    private Racun racun;
    private Color buttCol;
    private Font buttFont;
    private String gost;
    private String soba;
    private TableViewer stavkeV;
    private MeniPromet meniPromet;
    private Meni meni;
    private HttpURLConnection httpConn;
    private List<ProtelReservation> protelReservationsList = new ArrayList<ProtelReservation>();
    private PostExample postExample = new PostExample();
    private boolean serbianBookers;
    private JSONSerbianBookers bookers;

    public HotelskiGostNaplata(RestoranServer rs, double iznos, String placanje, Racun racun, MeniPromet meniPromet) {
        this.rs = rs;
        this.iznos = iznos;
        this.placanje = placanje;
        this.racun = racun;
        this.meniPromet = meniPromet;
        this.meni = this.meni;
        this.serbianBookers = rs.getSetting(Option.SERBIAN_BOOKERS).booleanValue();
        if (this.serbianBookers) {
            this.bookers = new JSONSerbianBookers(rs);
        }
    }

    private void initComponents() {
        this.shell = new Composite((Composite)this.shellFull, 0);
        this.shell.setLayoutData((Object)new GridData(4, 4, false, true));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(this.shell, 0x1000000);
        lbl.setFont(this.buttFont);
        lbl.setText(String.format(this.barmasterText.getString("TEXT_UNOS_HOTELSKE_USLUGE"), new Object[0]));
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblSep = new Label(this.shell, 258);
        lblSep.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.postExample.setIpAddress(this.rs.getSetting(Option.RECEPCIJA_PROTEL_ADRESA).stringValue());
        Label samoTextIznos = new Label(this.shell, 131072);
        samoTextIznos.setFont(this.buttFont);
        samoTextIznos.setText(String.format(this.barmasterText.getString("TEXT_IZNOS"), new Object[0]) + ":");
        Label iznosLabel = new Label(this.shell, 0);
        iznosLabel.setFont(this.buttFont);
        if (this.meniPromet != null) {
            iznosLabel.setText("" + this.meniPromet.getTotal());
        } else {
            iznosLabel.setText("" + this.iznos);
        }
        Label lblSep2 = new Label(this.shell, 258);
        lblSep2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label sobaL = new Label(this.shell, 0);
        sobaL.setFont(this.buttFont);
        sobaL.setText(String.format(this.barmasterText.getString("TEXT_BROJ_SOBE"), new Object[0]) + ":");
        final IntInput2 brojSobe = new IntInput2(this.shell, String.format(this.barmasterText.getString("TEXT_BROJ_SOBE"), new Object[0]), true);
        brojSobe.getControl().setFont(this.buttFont);
        brojSobe.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    Integer filt = null;
                    try {
                        filt = brojSobe.getResult();
                    }
                    catch (InputException ex) {
                        ex.printStackTrace(System.out);
                    }
                    HotelskiGostNaplata.this.loadSobe(filt == null ? "" : filt.toString());
                }
            }
        });
        NumericKeyboard numericka = new NumericKeyboard(this.shell, 0, false, true, String.format(this.barmasterText.getString("TEXT_POTVRDI"), new Object[0]), null);
        numericka.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        Label lblSep3 = new Label(this.shell, 258);
        lblSep3.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        Composite c = new Composite(this.shell, 0);
        c.setLayout((Layout)new GridLayout(2, true));
        c.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        ImageButton izlaz = new ImageButton(this.shell, 524288);
        izlaz.setFont(this.buttFont);
        izlaz.setForeground(this.buttCol);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        GridData otk = new GridData(4, 4, false, false, 2, 1);
        izlaz.setLayoutData(otk);
        izlaz.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                HotelskiGostNaplata.this.sg = null;
                HotelskiGostNaplata.this.shellFull.close();
                HotelskiGostNaplata.this.visible = false;
            }
        });
        GridData gd = new GridData(4, 4, true, false);
        brojSobe.getControl().setLayoutData((Object)gd);
        this.shell.setTabList(new Control[]{brojSobe.getControl()});
        this.buttons = new Composite((Composite)this.shellFull, 2048);
        this.buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonsLayout = new StackLayout();
        this.buttonsLayout.marginHeight = 0;
        this.buttonsLayout.marginWidth = 0;
        this.buttons.setLayout((Layout)this.buttonsLayout);
        this.buttonsStack = new Composite[3];
        this.buttonsStack[0] = new Composite(this.buttons, 0);
        this.buttonsStack[1] = new Composite(this.buttons, 0);
        this.buttonsStack[2] = new Composite(this.buttons, 0);
    }

    public void open(Display display) {
        this.buttCol = new Color((Device)display, BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        this.visible = true;
        this.shellFull = new Shell(display, 65544);
        this.shellFull.setLayout((Layout)new GridLayout(2, false));
        this.hg = new HotelskiGost(this.rs);
        this.initComponents();
        this.shellFull.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent se) {
                HotelskiGostNaplata.this.visible = false;
                if (!HotelskiGostNaplata.this.rs.getSetting(Option.RECEPCIJA_PROTEL).booleanValue() && !HotelskiGostNaplata.this.serbianBookers) {
                    HotelskiGostNaplata.this.hg.closeConnenction();
                }
            }
        });
        this.shellFull.setMaximized(true);
        this.shellFull.setFullScreen(true);
        this.shellFull.open();
        this.loadSobe(null);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.buttCol.dispose();
    }

    private void transmitData() {
        if (this.hg.isNoviTip()) {
            if (!this.hg.addRestoranUsluga(this.gosti.get(this.gost), this.iznos, this.racun, this.meniPromet)) {
                Konstante.getPoruka(this.shellFull, "Greska u upisu dodatne usluge!");
            } else {
                this.sg = this.rs.getStalniGost(this.gost);
                if (this.getSg() == null) {
                    this.sg = new StalniGost();
                    this.getSg().setNaziv(this.gost);
                }
                if (this.sg != null) {
                    this.sg.setOznakaSobe(this.soba);
                }
                this.shellFull.close();
                this.visible = false;
            }
        } else if (!this.hg.addRestoranUsluga(this.gosti.get(this.gost), this.iznos)) {
            Konstante.getPoruka(this.shellFull, "Greska u upisu dodatne usluge!");
        } else {
            this.sg = this.rs.getStalniGost(this.gost);
            if (this.getSg() == null) {
                this.sg = new StalniGost();
                this.getSg().setNaziv(this.gost);
                this.sg = this.rs.getStalniGost(this.gost);
            }
            this.shellFull.close();
            this.visible = false;
        }
    }

    private void loadSobe(String filter) {
        block11: {
            if (this.rs.getSetting(Option.RECEPCIJA_PROTEL).booleanValue()) {
                try {
                    Kasa kasa = KasaController.getCurrentCounter();
                    this.postExample.getPOSTFindReservationByName(String.valueOf(kasa.getId()));
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    try {
                        this.protelReservationsList = this.postExample.getProtelReservationsList();
                        if (!this.protelReservationsList.isEmpty()) {
                            for (ProtelReservation protelReservation : this.protelReservationsList) {
                                map.put(protelReservation.getRoom(), 0L);
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                    HashMap<String, Long> sobeHG = this.sortByValues(map);
                    if (filter == null || filter.length() == 0) {
                        this.sobe = this.sortByValues(sobeHG);
                        break block11;
                    }
                    HashMap<String, Long> sobeHGF = new HashMap<String, Long>(map.entrySet().stream().filter(x -> ((String)x.getKey()).contains(filter)).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (Long)x.getValue())));
                    this.sobe = this.sortByValues(sobeHGF);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.sobe = this.serbianBookers ? this.bookers.getBookersRooms() : (filter == null || filter.length() == 0 ? this.hg.getSobe() : this.hg.getSobe(filter));
            }
        }
        int bw = 164;
        int bh = 80;
        int w = this.buttons.getClientArea().width;
        int hs = 0;
        int lm = 0;
        int rm = 0;
        int w2 = bw + hs;
        int count = (w - lm - rm - (w - lm - rm) % w2) / w2;
        for (Control control : this.buttonsStack[0].getChildren()) {
            control.dispose();
        }
        this.buttonsStack[0].setLayout((Layout)new GridLayout(1, true));
        Label room = new Label(this.buttonsStack[0], 0x1000000);
        room.setFont(this.buttFont);
        room.setText(String.format(this.barmasterText.getString("TEXT_SOBE"), new Object[0]));
        room.setLayoutData((Object)new GridData(4, 0x1000000, true, false, count, 1));
        Label roomSep = new Label(this.buttonsStack[0], 258);
        roomSep.setLayoutData((Object)new GridData(4, 0x1000000, true, false, count, 1));
        GridData bDat = new GridData(0x1000000, 0x1000000, true, false);
        bDat.widthHint = bw;
        bDat.heightHint = bh;
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.buttonsStack[0], 2560);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite innerComposite = new Composite((Composite)scrolledComposite, 0);
        innerComposite.setLayout((Layout)new GridLayout(count, true));
        for (Map.Entry<String, Long> entry : this.sobe.entrySet()) {
            String string = entry.getKey();
            Long long1 = entry.getValue();
            ImageButton ib = new ImageButton(innerComposite, 524288);
            ib.setText(string);
            ib.setData(long1);
            ib.setForeground(this.buttCol);
            ib.setFont(this.buttFont);
            ib.setLayoutData(bDat);
            ib.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImageButton ib = (ImageButton)event.widget;
                    if (HotelskiGostNaplata.this.rs.getSetting(Option.RECEPCIJA_PROTEL).booleanValue()) {
                        HotelskiGostNaplata.this.loadGosti(ib.getText());
                    } else if (HotelskiGostNaplata.this.hg.isNoviTip()) {
                        HotelskiGostNaplata.this.loadGosti(ib.getText());
                    } else if (HotelskiGostNaplata.this.serbianBookers) {
                        HotelskiGostNaplata.this.loadSerbianBookeraGuests(ib.getText());
                    } else {
                        Long idSobe = null;
                        try {
                            idSobe = (Long)ib.getData();
                        }
                        catch (Exception e) {
                            idSobe = null;
                        }
                        if (idSobe != null) {
                            HotelskiGostNaplata.this.loadGosti(idSobe);
                        }
                    }
                }
            });
        }
        scrolledComposite.setContent((Control)innerComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(innerComposite.computeSize(-1, -1));
        this.buttonsStack[0].pack();
        this.buttonsStack[0].setTabList(new Control[0]);
        this.buttonsLayout.topControl = this.buttonsStack[0];
        this.buttons.layout();
    }

    private HashMap<String, Long> sortByValues(HashMap<String, Long> map) {
        LinkedList<Map.Entry<String, Long>> list = new LinkedList<Map.Entry<String, Long>>(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap<String, Long> sortedHashMap = new LinkedHashMap<String, Long>();
        for (Map.Entry entry : list) {
            sortedHashMap.put((String)entry.getKey(), (Long)entry.getValue());
        }
        return sortedHashMap;
    }

    private void loadGosti(Long idSobe) {
        this.soba = Long.toString(idSobe);
        this.gosti = this.hg.getGosti(idSobe);
        this.showRoomGuests();
    }

    private void loadSerbianBookeraGuests(String input) {
        this.soba = input;
        this.gosti = this.bookers.getBookersGuests(this.soba);
        this.showRoomGuests();
    }

    private void loadGosti(String idSobe) {
        this.gosti.clear();
        if (!this.rs.getSetting(Option.RECEPCIJA_PROTEL).booleanValue()) {
            this.soba = idSobe;
            this.gosti = this.hg.getGosti(idSobe);
        } else {
            this.soba = idSobe;
            for (ProtelReservation protelReservation : this.protelReservationsList) {
                if (!idSobe.equals(protelReservation.getRoom())) continue;
                this.gosti.put(protelReservation.getFirstName() + " " + protelReservation.getLastname(), 0L);
            }
        }
        this.showRoomGuests();
    }

    private void showRoomGuests() {
        for (Control control : this.buttonsStack[1].getChildren()) {
            control.dispose();
        }
        int bw = 164;
        int bh = 80;
        int w = this.buttons.getClientArea().width;
        int hs = 0;
        int lm = 0;
        int rm = 0;
        int w2 = bw + hs;
        int count = (w - lm - rm - (w - lm - rm) % w2) / w2;
        GridData bDat = new GridData(0x1000000, 0x1000000, true, false);
        bDat.widthHint = bw;
        bDat.heightHint = bh;
        this.buttonsStack[1].setLayout((Layout)new GridLayout(count, true));
        Label room = new Label(this.buttonsStack[1], 0x1000000);
        room.setFont(this.buttFont);
        room.setText(String.format(this.barmasterText.getString("TEXT_SOBA"), new Object[0]) + ": " + this.soba);
        room.setLayoutData((Object)new GridData(4, 0x1000000, true, false, count, 1));
        Label roomSep = new Label(this.buttonsStack[1], 258);
        roomSep.setLayoutData((Object)new GridData(4, 0x1000000, true, false, count, 1));
        ImageButton ibBack = new ImageButton(this.buttonsStack[1], 524288);
        ibBack.setText(String.format(this.barmasterText.getString("TEXT_NAZAD"), new Object[0]));
        ibBack.setForeground(this.buttCol);
        ibBack.setFont(this.buttFont);
        ibBack.setLayoutData(bDat);
        ibBack.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((HotelskiGostNaplata)HotelskiGostNaplata.this).buttonsLayout.topControl = HotelskiGostNaplata.this.buttonsStack[0];
                HotelskiGostNaplata.this.buttons.layout();
            }
        });
        for (Map.Entry<String, Long> entry : this.gosti.entrySet()) {
            String string = entry.getKey();
            Long long1 = entry.getValue();
            ImageButton ib = new ImageButton(this.buttonsStack[1], 524288);
            ib.setText(string);
            ib.setData(long1);
            ib.setForeground(this.buttCol);
            ib.setFont(this.buttFont);
            ib.setLayoutData(bDat);
            ib.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImageButton ib = (ImageButton)event.widget;
                    HotelskiGostNaplata.this.showGuest(ib.getText());
                }
            });
        }
        this.buttonsStack[1].pack();
        this.buttonsStack[1].setTabList(new Control[0]);
        this.buttonsLayout.topControl = this.buttonsStack[1];
        this.buttons.layout();
    }

    private void showGuest(String guest) {
        this.gost = guest;
        for (Control ctrl : this.buttonsStack[2].getChildren()) {
            ctrl.dispose();
        }
        this.buttonsStack[2].setLayout((Layout)new GridLayout(2, false));
        this.buttonsStack[2].setBackgroundMode(2);
        this.stavkeV = new TableViewer(this.buttonsStack[2], 67588);
        this.stavkeV.getTable().setLinesVisible(true);
        this.stavkeV.getTable().setHeaderVisible(true);
        TableViewerColumn tvc1 = new TableViewerColumn(this.stavkeV, 16384);
        tvc1.getColumn().setWidth(300);
        tvc1.getColumn().setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tvc1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                if (HotelskiGostNaplata.this.meniPromet != null) {
                    HotelskiGostNaplata.this.meniPromet = (MeniPromet)vc.getElement();
                    vc.setText(HotelskiGostNaplata.this.meniPromet.getNaziv());
                } else {
                    StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                    vc.setText(sr.getNaziv());
                }
            }
        });
        TableViewerColumn tvc2 = new TableViewerColumn(this.stavkeV, 131072);
        tvc2.getColumn().setWidth(60);
        tvc2.getColumn().setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tvc2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                if (HotelskiGostNaplata.this.meniPromet != null) {
                    HotelskiGostNaplata.this.meniPromet = (MeniPromet)vc.getElement();
                    vc.setText(StatLogic.getNumber02NG(HotelskiGostNaplata.this.meniPromet.getKolicina()));
                } else {
                    StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                    vc.setText(StatLogic.getNumber02NG(sr.getKolicina()));
                }
            }
        });
        TableViewerColumn tvc3 = new TableViewerColumn(this.stavkeV, 131072);
        tvc3.getColumn().setWidth(100);
        tvc3.getColumn().setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
        tvc3.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                if (HotelskiGostNaplata.this.meniPromet != null) {
                    HotelskiGostNaplata.this.meniPromet = (MeniPromet)vc.getElement();
                    vc.setText(StatLogic.getNumber02NG(HotelskiGostNaplata.this.meniPromet.getTotal()));
                } else {
                    StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                    vc.setText(StatLogic.getNumber02NG(sr.getVrednostSaPopustom()));
                }
            }
        });
        this.stavkeV.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.meniPromet != null) {
            this.stavkeV.setInput((Object)this.meni);
            System.out.println("MENI PROMET : " + this.meniPromet.getNaziv() + ", " + this.meniPromet.getKolicina() + ", " + this.meniPromet.getTotal());
        } else {
            this.stavkeV.setInput(this.racun.getStavke());
        }
        this.stavkeV.getTable().setLayoutData((Object)new GridData(16384, 4, false, true));
        Composite data = new Composite(this.buttonsStack[2], 0);
        data.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        data.setLayout((Layout)new GridLayout(2, false));
        Label lRoom = new Label(data, 131072);
        lRoom.setText(String.format(this.barmasterText.getString("TEXT_SOBA"), new Object[0]) + ": ");
        lRoom.setFont(this.buttFont);
        lRoom.setData((Object)new GridData(4, 0x1000000, false, false));
        Label room = new Label(data, 131072);
        room.setText(this.soba);
        room.setFont(this.buttFont);
        room.setData((Object)new GridData(4, 0x1000000, false, false));
        Label lGuest = new Label(data, 131072);
        lGuest.setText(String.format(this.barmasterText.getString("TEXT_GOST"), new Object[0]) + ": ");
        lGuest.setFont(this.buttFont);
        lGuest.setData((Object)new GridData(4, 0x1000000, false, false));
        Label guestName = new Label(data, 131072);
        guestName.setText(this.gost);
        guestName.setFont(this.buttFont);
        guestName.setData((Object)new GridData(4, 0x1000000, false, false));
        if (this.meniPromet != null) {
            Label men = new Label(data, 131072);
            men.setText(String.format(this.barmasterText.getString("TEXT_MENI"), new Object[0]) + ": ");
            men.setFont(this.buttFont);
            men.setData((Object)new GridData(4, 0x1000000, false, false));
            Label menNaziv = new Label(data, 131072);
            menNaziv.setText(this.meniPromet.getNaziv());
            menNaziv.setFont(this.buttFont);
            menNaziv.setData((Object)new GridData(4, 0x1000000, false, false));
        }
        Label lAmmount = new Label(data, 131072);
        lAmmount.setText(String.format(this.barmasterText.getString("TEXT_IZNOS"), new Object[0]) + ": ");
        lAmmount.setFont(this.buttFont);
        lAmmount.setData((Object)new GridData(4, 0x1000000, false, false));
        Label amount = new Label(data, 131072);
        if (this.meniPromet != null) {
            amount.setText(StatLogic.getNumber02(this.meniPromet.getTotal()));
        } else {
            amount.setText(StatLogic.getNumber02(this.iznos));
        }
        amount.setFont(this.buttFont);
        amount.setData((Object)new GridData(4, 0x1000000, false, false));
        Composite control = new Composite(this.buttonsStack[2], 0);
        control.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        control.setLayout((Layout)new GridLayout(2, true));
        ImageButton back = new ImageButton(control, 524288);
        back.setText(String.format(this.barmasterText.getString("TEXT_NAZAD"), new Object[0]));
        back.setFont(this.buttFont);
        back.setForeground(this.buttCol);
        GridData backDat = new GridData(0x1000000, 0x1000000, true, false);
        backDat.widthHint = 164;
        backDat.heightHint = 80;
        back.setLayoutData(backDat);
        back.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((HotelskiGostNaplata)HotelskiGostNaplata.this).buttonsLayout.topControl = HotelskiGostNaplata.this.buttonsStack[1];
                HotelskiGostNaplata.this.buttons.layout();
            }
        });
        ImageButton potvrda = new ImageButton(control, 524288);
        potvrda.setText(String.format(this.barmasterText.getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.setFont(this.buttFont);
        potvrda.setForeground(this.buttCol);
        GridData okDat = new GridData(0x1000000, 0x1000000, true, false);
        okDat.widthHint = 164;
        okDat.heightHint = 80;
        potvrda.setLayoutData(okDat);
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (HotelskiGostNaplata.this.rs.getSetting(Option.RECEPCIJA_PROTEL).booleanValue()) {
                    try {
                        HotelskiGostNaplata.this.postExample.getPOSTFindReservationByRoom(HotelskiGostNaplata.this.soba, 1, String.valueOf(KasaController.getCurrentCounter().getId()));
                        try {
                            HotelskiGostNaplata.this.postExample.sendPOSTCloseInvoice(HotelskiGostNaplata.this.racun, "Payment", HotelskiGostNaplata.this.iznos, Long.parseLong(HotelskiGostNaplata.this.postExample.getProtelReservations().getResNo()), String.valueOf(KasaController.getCurrentCounter().getId()));
                        }
                        catch (IOException | NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    System.out.println("Ovde proveravam da li je zahtev uspesan " + HotelskiGostNaplata.this.postExample.isSuccess());
                    if (HotelskiGostNaplata.this.postExample.isSuccess()) {
                        HotelskiGostNaplata.this.sg = HotelskiGostNaplata.this.rs.getStalniGost(HotelskiGostNaplata.this.gost);
                        if (HotelskiGostNaplata.this.getSg() == null) {
                            HotelskiGostNaplata.this.sg = new StalniGost();
                            HotelskiGostNaplata.this.getSg().setNaziv(HotelskiGostNaplata.this.gost);
                            HotelskiGostNaplata.this.sg = HotelskiGostNaplata.this.rs.getStalniGost(HotelskiGostNaplata.this.gost);
                        }
                        if (HotelskiGostNaplata.this.sg != null) {
                            HotelskiGostNaplata.this.sg.setOznakaSobe(HotelskiGostNaplata.this.soba);
                        }
                        HotelskiGostNaplata.this.racun.setNapomena(HotelskiGostNaplata.this.postExample.getProtelReservations().getResNo());
                    } else {
                        Konstante.getPoruka(HotelskiGostNaplata.this.shellFull, "Prebacivanje racuna na odabranu sobu nije dozvoljeno, proverite status sobe!");
                    }
                    HotelskiGostNaplata.this.shellFull.close();
                    HotelskiGostNaplata.this.visible = false;
                } else if (HotelskiGostNaplata.this.serbianBookers) {
                    HotelskiGostNaplata.this.sg = HotelskiGostNaplata.this.rs.getStalniGost(HotelskiGostNaplata.this.gost);
                    if (HotelskiGostNaplata.this.bookers.sendBill(HotelskiGostNaplata.this.racun, HotelskiGostNaplata.this.gost, (Long)HotelskiGostNaplata.this.sobe.get(HotelskiGostNaplata.this.soba))) {
                        HotelskiGostNaplata.this.bookers.logout();
                        if (HotelskiGostNaplata.this.getSg() == null) {
                            HotelskiGostNaplata.this.sg = new StalniGost();
                            HotelskiGostNaplata.this.getSg().setNaziv(HotelskiGostNaplata.this.gost);
                        }
                        if (HotelskiGostNaplata.this.sg != null) {
                            HotelskiGostNaplata.this.sg.setOznakaSobe(HotelskiGostNaplata.this.soba);
                        }
                        HotelskiGostNaplata.this.shellFull.close();
                        HotelskiGostNaplata.this.visible = false;
                    } else {
                        Konstante.getPoruka(HotelskiGostNaplata.this.shellFull, "Prebacivanje na sobu nije uspelo, proverite va\u0161u internet konekciju. Ukoliko je internet konekcija u redu pozovite tehni\u010dku podr\u0161ku");
                    }
                } else {
                    HotelskiGostNaplata.this.transmitData();
                }
            }
        });
        this.buttonsStack[2].pack();
        this.buttonsLayout.topControl = this.buttonsStack[2];
        this.buttons.layout();
    }

    public StalniGost getSg() {
        return this.sg;
    }

    public MeniPromet getMeniPromet() {
        return this.meniPromet;
    }

    public void setMeniPromet(MeniPromet meniPromet) {
        this.meniPromet = meniPromet;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public class HotelskiGost {
        private Connection connection;
        private RestoranServer serv;
        private List<String> usluge;
        private boolean noviTip = false;
        private String nazivUsluge;

        public HotelskiGost(RestoranServer serv) {
            String[] splited;
            this.serv = serv;
            this.usluge = new ArrayList<String>();
            Setting novaRec = serv.getSetting(Option.RECEPCIJA_NOVI_TIP);
            try {
                this.noviTip = novaRec.booleanValue();
            }
            catch (NullPointerException e) {
                System.out.println("Novi tip hotela nije podesen");
            }
            catch (Exception e) {
                Logger.getLogger(HotelskiGostNaplata.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            Setting nazivUslug = serv.getSetting(Option.RECEPCIJA_USLUGA);
            try {
                this.nazivUsluge = nazivUslug.stringValue();
            }
            catch (NullPointerException e) {
                System.out.println("Naziv usluge nije podesen");
            }
            catch (Exception e) {
                Logger.getLogger(HotelskiGostNaplata.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            String list = serv.getSetting(Option.RECEPCIJA_USLUGA).stringValue();
            for (String split : splited = list.split(";")) {
                if (split.isEmpty()) continue;
                this.usluge.add(split);
            }
            if (!HotelskiGostNaplata.this.rs.getSetting(Option.RECEPCIJA_PROTEL).booleanValue() && !HotelskiGostNaplata.this.serbianBookers) {
                this.setConnection();
            }
        }

        private void setConnection() {
            block9: {
                block10: {
                    if (this.noviTip) break block10;
                    String hostName = this.serv.getSetting(Option.RECEPCIJA_HOST).stringValue();
                    try {
                        Class.forName("com.mysql.jdbc.Driver");
                    }
                    catch (ClassNotFoundException e) {
                        Logger.getLogger(HotelskiGostNaplata.class.getName()).log(Level.WARNING, e.getMessage(), e);
                    }
                    try {
                        this.connection = DriverManager.getConnection("jdbc:mysql://" + hostName + "/hotel2", "root", "928374");
                    }
                    catch (Exception e) {
                        System.err.println("Cannot connect to database server");
                        e.printStackTrace();
                        if (this.connection == null) break block9;
                        try {
                            this.connection.close();
                            break block9;
                        }
                        catch (Exception exception) {}
                    }
                    break block9;
                }
                try {
                    String userName = "sa";
                    String password = "928374";
                    String hostName = this.serv.getSetting(Option.RECEPCIJA_HOST).stringValue();
                    String baza = this.serv.getSetting(Option.BAZA_HOTEL).stringValue();
                    String url = "jdbc:sqlserver://" + hostName + "\\SQLEXPRESS;databaseName=" + baza + "";
                    Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                    this.connection = DriverManager.getConnection(url, userName, password);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(HotelskiGostNaplata.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(HotelskiGostNaplata.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Long> getSobe() {
            if (this.noviTip) {
                HashMap<String, Long> ret = new HashMap<String, Long>();
                Statement statement = null;
                ResultSet rs = null;
                String queryString = "SELECT distinct(room) FROM v_oktodo WHERE ok_department = '1' ORDER BY room ASC;";
                try {
                    statement = this.connection.createStatement();
                    rs = statement.executeQuery(queryString);
                    while (rs.next()) {
                        ret.put(rs.getString(1), 0L);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle) {
                        Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                    }
                }
                return ret;
            }
            HashMap<String, Long> ret = new HashMap<String, Long>();
            Statement statement = null;
            ResultSet rs = null;
            String queryString = "SELECT id, broj FROM soba WHERE broj > 0 AND sprat >= 0 ORDER BY broj ASC;";
            try {
                statement = this.connection.createStatement();
                rs = statement.executeQuery(queryString);
                while (rs.next()) {
                    ret.put(rs.getString(2), rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Long> getSobe(String filter) {
            if (filter == null || filter.length() == 0) {
                filter = null;
            }
            if (this.noviTip) {
                HashMap<String, Long> ret = new HashMap<String, Long>();
                Statement statement = null;
                ResultSet rs = null;
                String queryString = "SELECT distinct(room) FROM v_oktodo WHERE ok_department = '1' " + (filter != null ? "AND room LIKE '%" + filter + "%' " : "") + "ORDER BY room ASC;";
                try {
                    statement = this.connection.createStatement();
                    rs = statement.executeQuery(queryString);
                    while (rs.next()) {
                        ret.put(rs.getString(1), 0L);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle) {
                        Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                    }
                }
                return ret;
            }
            Integer broj = null;
            try {
                broj = Integer.parseInt(filter);
            }
            catch (Exception e) {
                broj = null;
            }
            if (broj != null && broj <= 0) {
                broj = null;
            }
            HashMap<String, Long> ret = new HashMap<String, Long>();
            Statement statement = null;
            ResultSet rs = null;
            String queryString = "SELECT id, broj FROM soba WHERE broj > 0 " + (broj != null ? "AND broj = " + Integer.toString(broj) : "") + "AND sprat >= 0 ORDER BY broj ASC;";
            try {
                statement = this.connection.createStatement();
                rs = statement.executeQuery(queryString);
                while (rs.next()) {
                    ret.put(rs.getString(2), rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Long> getGosti(Long sobaId) {
            HashMap<String, Long> ret = new HashMap<String, Long>();
            Statement statement = null;
            ResultSet rs = null;
            String queryString = "SELECT id, ime, prezime FROM gost WHERE odjavljen = 0 AND soba_id = " + sobaId + ";";
            try {
                statement = this.connection.createStatement();
                rs = statement.executeQuery(queryString);
                while (rs.next()) {
                    ret.put(rs.getString(2) + " " + rs.getString(3), rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Long> getGosti(String sobaId) {
            HashMap<String, Long> ret = new HashMap<String, Long>();
            PreparedStatement statement = null;
            ResultSet rs = null;
            String queryString = "SELECT guestid, name, surname FROM v_oktodo WHERE ok_department = '1' AND room = ?;";
            try {
                statement = this.connection.prepareStatement(queryString);
                statement.setString(1, sobaId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    ret.put(rs.getString(2) + " " + rs.getString(3), rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addRestoranUsluga(Long gostId, double iznos) {
            Statement statement = null;
            ResultSet rs = null;
            Long uslugaID = null;
            String nazivUsluge = "";
            for (String usluga : this.usluge) {
                if (!HotelskiGostNaplata.this.placanje.toUpperCase().contains(usluga.toUpperCase())) continue;
                nazivUsluge = usluga;
            }
            String queryString = "SELECT id FROM usluga WHERE naziv = '" + nazivUsluge + "';";
            try {
                statement = this.connection.createStatement();
                rs = statement.executeQuery(queryString);
                while (rs.next()) {
                    uslugaID = rs.getLong(1);
                }
                rs.close();
                statement.close();
                if (uslugaID == null) {
                    boolean usluga = false;
                    return usluga;
                }
                statement = this.connection.createStatement();
                String insertString = "INSERT INTO gostextra (datum, naplaceno, vrednost, gost_id, usluga_id) VALUES ('" + Konstante.getSQLDateFormat(new java.util.Date()) + "'," + 0 + "," + iznos + "," + gostId + "," + uslugaID + ");";
                statement.executeUpdate(insertString);
            }
            catch (SQLException sqle) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                boolean bl = false;
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
                        return false;
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addRestoranUsluga(Long gostId, double iznos, Racun racun, MeniPromet meniPromet) {
            Statement statement = null;
            PreparedStatement statementId = null;
            PreparedStatement statementIt = null;
            try {
                if (racun == null || racun.getStavke1() == null || racun.getStavke1().isEmpty() || racun.getKonobar() == null) {
                    boolean bl = false;
                    return bl;
                }
                this.connection.setAutoCommit(false);
                statement = this.connection.prepareStatement("INSERT INTO dbo.todo (ddate, ttime, billno, guestid, servtype, status, department, waiterid, waiter, deptid) values (?, ?, ?, ?, 4, 'N', ?, ?, ?, 0);");
                statement.setDate(1, new Date(racun.getDatum().getTime()));
                statement.setString(2, new SimpleDateFormat("HH:mm:ss").format(racun.getDatum()));
                statement.setInt(3, racun.getBrojRacuna() == null ? racun.getId().intValue() : racun.getBrojRacuna().intValue());
                statement.setInt(4, gostId.intValue());
                statement.setString(5, this.nazivUsluge != null ? this.nazivUsluge : "restoran");
                statement.setInt(6, racun.getKonobar().getId().intValue());
                statement.setString(7, racun.getKonobar().getSkrIme());
                int ret = statement.executeUpdate();
                if (ret == 0) {
                    this.connection.rollback();
                    statement.close();
                    boolean ex = false;
                    return ex;
                }
                int todoId = -1;
                statementId = this.connection.prepareStatement("SELECT MAX(id) FROM dbo.todo;");
                ResultSet idSet = statementId.executeQuery();
                while (idSet.next()) {
                    todoId = idSet.getInt(1);
                }
                if (todoId == -1) {
                    this.connection.rollback();
                    statement.close();
                    statementId.close();
                    boolean bl = false;
                    return bl;
                }
                idSet.close();
                if (meniPromet == null) {
                    statementIt = this.connection.prepareStatement("INSERT INTO dbo.tododet (idtodo, article, qtty, price, total, articleid)values (?, ?, ?, ?, ?, ?);");
                    for (StavkaRacuna sr : racun.getStavke()) {
                        statementIt.clearParameters();
                        statementIt.setInt(1, todoId);
                        statementIt.setString(2, sr.getNaziv());
                        statementIt.setDouble(3, sr.getKolicina());
                        statementIt.setDouble(4, sr.getCena());
                        statementIt.setDouble(5, sr.getVrednostSaPopustom());
                        statementIt.setInt(6, sr.getArtikal().getId().intValue());
                        int reta = statementIt.executeUpdate();
                        if (reta != 0) continue;
                        this.connection.rollback();
                        statement.close();
                        statementId.close();
                        statementIt.close();
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    statementIt = this.connection.prepareStatement("INSERT INTO dbo.tododet (idtodo, article, qtty, price, total, articleid)values (?, ?, ?, ?, ?, ?);");
                    statementIt.clearParameters();
                    statementIt.setInt(1, todoId);
                    statementIt.setString(2, meniPromet.getNaziv());
                    statementIt.setDouble(3, meniPromet.getKolicina());
                    statementIt.setDouble(4, meniPromet.getCena());
                    statementIt.setDouble(5, meniPromet.getTotal());
                    statementIt.setFloat(6, 0.0f);
                    int reta = statementIt.executeUpdate();
                    if (reta == 0) {
                        this.connection.rollback();
                        statement.close();
                        statementId.close();
                        statementIt.close();
                        boolean bl = false;
                        return bl;
                    }
                }
                this.connection.commit();
                statement.close();
                statementId.close();
                statementIt.close();
            }
            catch (SQLException sqle) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
                boolean bl = false;
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, ex);
                        return false;
                    }
                }
            }
            return true;
        }

        public void closeConnenction() {
            try {
                this.connection.close();
            }
            catch (SQLException sqle) {
                Logger.getLogger(HotelskiGost.class.getName()).log(Level.SEVERE, null, sqle);
            }
        }

        public boolean isNoviTip() {
            return this.noviTip;
        }
    }
}

