/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.backoffice.odeljenja.UpravljanjeGrupomOdeljenja;
import com.dev63.restoran.model.GrupaOdeljenja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GrupeOdeljenja {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private GrupaOdeljenja active;
    private UpravljanjeGrupomOdeljenja ugo;
    private boolean trg;
    Composite dugmici;

    public GrupeOdeljenja(SWTContainer owner, Restoran hostel, boolean bo) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        Shell shell = this.parent.getControl().getShell();
        this.ugo = new UpravljanjeGrupomOdeljenja(this.parent.getComposite().getShell());
        this.ugo.setServer(this.server);
        this.trg = false;
        try {
            this.trg = this.restoran.getServer().getSetting(Option.TRGOVINA).booleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        Composite panel2 = new Composite((Composite)shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = null;
        try {
            img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/odeljenjaV.gif");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(!this.trg ? String.format(this.barmasterText.getString("TEXT_GRUPE_PROIZVODNIH_MESTA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_GRUPE_ODELJENJA"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 72);
        Image manImg = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK_GRUPA_PROIZVODNIH_MESTA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(Konstante.getBundle().getString("TEXT_ATRIBUTI_GRUPE_PROIZVODNIH_MESTA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_NOVA_GRUPA_PROIZVODNIH_MESTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GrupeOdeljenja.this.addOdeljenje();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_IZMENA_GRUPE_PROIZVODNIH_MESTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GrupeOdeljenja.this.updateOdeljenje();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_GRUPE_PROIZVODNIH_MESTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GrupeOdeljenja.this.deleteOdeljenje();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = GrupeOdeljenja.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                GrupeOdeljenja.this.setActiveOdeljenje((GrupaOdeljenja)GrupeOdeljenja.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(shell);
    }

    private void reload() {
        this.listModel.clear();
        List<GrupaOdeljenja> grupe = this.restoran.getServer().findAllGrupeOdeljenja();
        for (GrupaOdeljenja l : grupe) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addOdeljenje() {
        this.ugo.setInput(null);
        this.ugo.setBlockOnOpen(true);
        if (this.ugo.open() == 0) {
            this.reload();
        }
    }

    private void updateOdeljenje() {
        if (this.active == null) {
            return;
        }
        this.ugo.setInput(this.active);
        this.ugo.setBlockOnOpen(true);
        if (this.ugo.open() == 0) {
            this.reload();
        }
    }

    private void deleteOdeljenje() {
        int ok;
        if (this.active == null) {
            return;
        }
        if (this.active.getOdeljenja() == null) {
            SWTMessage.showLocalizedWarningDialog(this.parent.getComposite().getShell(), String.format(Konstante.getBundle().getString("PORUKA_PROBLEM_SA_O\u010cITAVANJEM_ODELJENJA_ZA_IZABRANU_GRUPU"), new Object[0]));
            return;
        }
        if (!this.active.getOdeljenja().isEmpty()) {
            SWTMessage.showLocalizedInfoDialog(this.parent.getComposite().getShell(), String.format(Konstante.getBundle().getString("PORUKA_MORATE_PRVO_OBRISATI_ODELJENJA_KOJA_SU_DODELJENA_OVOJ_GRUPI_ILI_IH_DODELITI_DRUGOJ"), new Object[0]));
        }
        if ((ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(this.trg ? Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_GRUPU_ODELJENJA_IZ_SISTEMA") : Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKOLNITE_PROIZVODNO_MESTO_IZ_SISTEMA"), this.active.getNaziv()))) == 0) {
            try {
                this.restoran.getServer().deleteGrupaOdeljenja(this.active);
                this.server.log(String.format(Konstante.getBundle().getString("LOG_BRISANJE_GRUPE_PROZVODNIH_MESTA"), new Object[0]) + ": " + this.active);
                this.active = null;
                this.display.setText("");
                this.reload();
            }
            catch (Exception ex) {
                Logger.getLogger(GrupeOdeljenja.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedErrorDialog(this.parent.getComposite().getShell(), ex.getMessage());
            }
        }
    }

    private void setActiveOdeljenje(GrupaOdeljenja o) {
        this.active = o;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_SKLADISTA"), new Object[0]) + ": ").append(o.getSkladista() != null && o.getSkladista() != false ? String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_ODELJENJA"), new Object[0]) + ": ");
        if (o.getOdeljenja() != null) {
            for (Odeljenje od : o.getOdeljenja()) {
                bld.append("\n").append(" - " + od.getNaziv());
            }
        }
        this.display.setText(bld.toString());
        if (o.getNaziv().equalsIgnoreCase(Konstante.getMagacinName())) {
            // empty if block
        }
    }

    private class OdeljenjeDialog {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private TextInput2 name;
        private TextInput2 shortName;
        private IntInput2 blanko;
        private IntInput2 kopije;
        private Button magacin;
        private boolean magacinExists = false;
        private boolean isMagacin = false;
        final Combo stampac;
        List<Stampac> stampaci = GrupeOdeljenja.access$600(GrupeOdeljenja.this).readStampac();
        private Odeljenje input;
        private Odeljenje result;
        String putanjaSlike;
        Label slika;
        Shell shell3;

        public OdeljenjeDialog(SWTContainer parent, Odeljenje input, boolean magacinExists, boolean isMagacin) {
            this.input = input;
            this.magacinExists = magacinExists;
            this.isMagacin = isMagacin;
            this.shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            Label m = new Label((Composite)this.shell3, 0);
            m.setBackground(this.shell3.getDisplay().getSystemColor(22));
            m.setText(String.format(this.barmasterText.getString("TEXT_MAGACIN"), new Object[0]));
            this.magacin = new Button((Composite)this.shell3, 32);
            this.magacin.setEnabled(!magacinExists || isMagacin);
            m.setEnabled(!magacinExists || isMagacin);
            Label n = new Label((Composite)this.shell3, 0);
            n.setBackground(this.shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
            this.name = new TextInput2(parent, String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]), false);
            Label s = new Label((Composite)this.shell3, 0);
            s.setBackground(this.shell3.getDisplay().getSystemColor(22));
            s.setText(String.format(this.barmasterText.getString("TEXT_KRATAK_NAZIV"), new Object[0]));
            this.shortName = new TextInput2(parent, String.format(this.barmasterText.getString("TEXT_KRATAK_NAZIV"), new Object[0]), false);
            Label label1 = new Label((Composite)this.shell3, 0);
            label1.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_STAMPACA"), new Object[0]));
            label1.setBackground(this.shell3.getDisplay().getSystemColor(22));
            this.stampac = new Combo((Composite)this.shell3, 2572);
            Label e3 = new Label((Composite)this.shell3, 0);
            e3.setText("");
            e3.setBackground(this.shell3.getDisplay().getSystemColor(22));
            Label bl = new Label((Composite)this.shell3, 0);
            bl.setText(String.format(this.barmasterText.getString("TEXT_DODATNE_LINIJE"), new Object[0]));
            bl.setBackground(this.shell3.getDisplay().getSystemColor(22));
            this.blanko = new IntInput2(parent, String.format(this.barmasterText.getString("TEXT_DODATNE_LINIJE"), new Object[0]), (Integer)0);
            e3 = new Label((Composite)this.shell3, 0);
            e3.setText("");
            e3.setBackground(this.shell3.getDisplay().getSystemColor(22));
            Label kp = new Label((Composite)this.shell3, 0);
            kp.setText(String.format(this.barmasterText.getString("TEXT_BROJ_KOPIJA_PORUDZBINA"), new Object[0]));
            kp.setBackground(this.shell3.getDisplay().getSystemColor(22));
            this.kopije = new IntInput2(parent, String.format(this.barmasterText.getString("TEXT_BROJ_KOPIJA_PORUDZBINA"), new Object[0]), (Integer)0);
            for (Stampac st : this.stampaci) {
                this.stampac.add(st.toString());
                this.stampac.select(0);
            }
            Button button = new Button((Composite)this.shell3, 8);
            Image choiceImg = new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/izborSlike.gif");
            button.setImage(choiceImg);
            button.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)choiceImg));
            this.slika = new Label((Composite)this.shell3, 0);
            this.slika.setBackground(this.shell3.getDisplay().getSystemColor(22));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(OdeljenjeDialog.this.shell3, 4100);
                    File file = new File(".");
                    dialog.setFilterPath(ImagePath.getPath() + "\\odeljenja");
                    String path = dialog.open();
                    if (path != null) {
                        file = new File(path);
                        if (file.isFile()) {
                            OdeljenjeDialog.this.putanjaSlike = file.toString();
                        }
                        Image img = new Image((Device)OdeljenjeDialog.this.shell3.getDisplay(), OdeljenjeDialog.this.putanjaSlike);
                        OdeljenjeDialog.this.slika.setImage(img);
                        OdeljenjeDialog.this.slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton(this.shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdeljenjeDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(this.shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(this.shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdeljenjeDialog.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            this.shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            data.horizontalSpan = 2;
            n.setLayoutData((Object)data);
            m.setLayoutData((Object)data);
            s.setLayoutData((Object)data);
            label1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            this.name.getControl().setLayoutData((Object)data);
            this.magacin.setLayoutData((Object)data);
            this.shortName.getControl().setLayoutData((Object)data);
            this.stampac.setLayoutData((Object)data);
            this.blanko.getControl().setLayoutData((Object)data);
            this.kopije.getControl().setLayoutData((Object)data);
            data = new GridData(64);
            data.widthHint = 40;
            data.heightHint = 30;
            this.slika.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 40;
            data.horizontalSpan = 2;
            button.setLayoutData((Object)data);
            this.shell3.pack();
        }

        private void ok(SWTContainer parent) {
            Odeljenje o = this.input != null ? this.input : new Odeljenje();
            try {
                o.setNaziv(this.name.getResult());
                o.setKratkiNaziv(this.shortName.getResult());
                if (GrupeOdeljenja.this.server.readStampac().size() < 1) {
                    o.setStampac(null);
                } else {
                    o.setStampac(this.stampaci.get(this.stampac.getSelectionIndex()));
                }
                o.getStampac().setBlankoLinija(this.blanko.getResult());
                o.getStampac().setBrojKopijaPorudzbine(this.kopije.getResult());
                o.setMagacin(this.magacin.getSelection());
                if (this.putanjaSlike != null) {
                    o.setSlika(this.putanjaSlike);
                }
                this.result = o;
                parent.getControl().getShell().dispose();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().dispose();
        }

        public Odeljenje getResult() {
            return this.result;
        }

        private void loadData() {
            this.name.setResult(this.input.getNaziv());
            this.shortName.setResult(this.input.getKratkiNaziv());
            if (this.input.getStampac() != null) {
                this.stampac.select(this.stampaci.indexOf(this.input.getStampac()));
            }
            this.blanko.setResult(this.input.getStampac().getBlankoLinija());
            this.magacin.setSelection(this.isMagacin || this.input != null && this.input.getMagacin() != null && this.input.getMagacin() != false);
            this.kopije.setResult(this.input.getStampac().getBrojKopijaPorudzbine());
            if (this.input.getSlika() != null) {
                this.slika.setImage(new Image((Device)this.shell3.getDisplay(), this.input.getSlika()));
            }
        }
    }
}

