/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.sistem.LayoutExample;
import com.dev63.restoran.sistem.Tab;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class FormLayoutTab
extends Tab {
    Combo marginHeight;
    Combo marginWidth;
    FormLayout formLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor leftEditor;
    TableEditor rightEditor;
    TableEditor topEditor;
    TableEditor bottomEditor;
    CCombo combo;
    Text widthText;
    Text heightText;
    Button leftAttach;
    Button rightAttach;
    Button topAttach;
    Button bottomAttach;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int LEFT_COL = 4;
    final int RIGHT_COL = 5;
    final int TOP_COL = 6;
    final int BOTTOM_COL = 7;
    final int MODIFY_COLS = 4;
    final int TOTAL_COLS = 8;

    FormLayoutTab(LayoutExample instance) {
        super(instance);
    }

    int alignmentConstant(String align) {
        if (align.equals("LEFT")) {
            return 16384;
        }
        if (align.equals("RIGHT")) {
            return 131072;
        }
        if (align.equals("TOP")) {
            return 128;
        }
        if (align.equals("BOTTOM")) {
            return 1024;
        }
        if (align.equals("CENTER")) {
            return 0x1000000;
        }
        return -1;
    }

    String alignmentString(int align) {
        switch (align) {
            case 16384: {
                return "LEFT";
            }
            case 131072: {
                return "RIGHT";
            }
            case 128: {
                return "TOP";
            }
            case 1024: {
                return "BOTTOM";
            }
            case 0x1000000: {
                return "CENTER";
            }
        }
        return "DEFAULT";
    }

    String checkAttachment(String oldAttach, FormAttachment newAttach) {
        int i;
        String controlClass = newAttach.control.getClass().toString();
        String controlType = controlClass.substring(controlClass.lastIndexOf(46) + 1);
        for (i = 0; i < oldAttach.length() && !Character.isDigit(oldAttach.charAt(i)); ++i) {
        }
        String index = oldAttach.substring(i, oldAttach.indexOf(44));
        return controlType + index + "," + newAttach.offset + ":" + this.alignmentString(newAttach.alignment);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.table.getColumn(4).setWidth(100);
        this.table.getColumn(5).setWidth(100);
        this.table.getColumn(6).setWidth(100);
        this.table.getColumn(7).setWidth(100);
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.leftEditor = new TableEditor(this.table);
        this.rightEditor = new TableEditor(this.table);
        this.topEditor = new TableEditor(this.table);
        this.bottomEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FormLayoutTab.this.resetEditors();
                FormLayoutTab.this.index = FormLayoutTab.this.table.getSelectionIndex();
                Point pt = new Point(e.x, e.y);
                FormLayoutTab.this.newItem = FormLayoutTab.this.table.getItem(pt);
                if (FormLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem oldItem = FormLayoutTab.this.comboEditor.getItem();
                if (FormLayoutTab.this.newItem == oldItem || FormLayoutTab.this.newItem != FormLayoutTab.this.lastSelected) {
                    FormLayoutTab.this.lastSelected = FormLayoutTab.this.newItem;
                    return;
                }
                FormLayoutTab.this.table.showSelection();
                FormLayoutTab.this.combo = new CCombo((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.createComboEditor(FormLayoutTab.this.combo, FormLayoutTab.this.comboEditor);
                FormLayoutTab.this.widthText = new Text((Composite)FormLayoutTab.this.table, 4);
                FormLayoutTab.this.widthText.setText(((String[])FormLayoutTab.this.data.elementAt(FormLayoutTab.this.index))[2]);
                FormLayoutTab.this.createTextEditor(FormLayoutTab.this.widthText, FormLayoutTab.this.widthEditor, 2);
                FormLayoutTab.this.heightText = new Text((Composite)FormLayoutTab.this.table, 4);
                FormLayoutTab.this.heightText.setText(((String[])FormLayoutTab.this.data.elementAt(FormLayoutTab.this.index))[3]);
                FormLayoutTab.this.createTextEditor(FormLayoutTab.this.heightText, FormLayoutTab.this.heightEditor, 3);
                FormLayoutTab.this.leftAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.leftAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.leftEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.leftEditor.grabHorizontal = true;
                FormLayoutTab.this.leftEditor.minimumWidth = FormLayoutTab.this.leftAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.leftEditor.setEditor((Control)FormLayoutTab.this.leftAttach, FormLayoutTab.this.newItem, 4);
                FormLayoutTab.this.leftAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog dialog = new AttachDialog(shell);
                        dialog.setText(LayoutExample.getResourceString("Left_Attachment"));
                        dialog.setColumn(4);
                        String attach = dialog.open();
                        FormLayoutTab.this.newItem.setText(4, attach);
                        FormLayoutTab.this.resetEditors();
                    }
                });
                FormLayoutTab.this.rightAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.rightAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.rightEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.rightEditor.grabHorizontal = true;
                FormLayoutTab.this.rightEditor.minimumWidth = FormLayoutTab.this.rightAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.rightEditor.setEditor((Control)FormLayoutTab.this.rightAttach, FormLayoutTab.this.newItem, 5);
                FormLayoutTab.this.rightAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog dialog = new AttachDialog(shell);
                        dialog.setText(LayoutExample.getResourceString("Right_Attachment"));
                        dialog.setColumn(5);
                        String attach = dialog.open();
                        FormLayoutTab.this.newItem.setText(5, attach);
                        if (FormLayoutTab.this.newItem.getText(4).endsWith(")")) {
                            FormLayoutTab.this.newItem.setText(4, "");
                        }
                        FormLayoutTab.this.resetEditors();
                    }
                });
                FormLayoutTab.this.topAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.topAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.topEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.topEditor.grabHorizontal = true;
                FormLayoutTab.this.topEditor.minimumWidth = FormLayoutTab.this.topAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.topEditor.setEditor((Control)FormLayoutTab.this.topAttach, FormLayoutTab.this.newItem, 6);
                FormLayoutTab.this.topAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog dialog = new AttachDialog(shell);
                        dialog.setText(LayoutExample.getResourceString("Top_Attachment"));
                        dialog.setColumn(6);
                        String attach = dialog.open();
                        FormLayoutTab.this.newItem.setText(6, attach);
                        FormLayoutTab.this.resetEditors();
                    }
                });
                FormLayoutTab.this.bottomAttach = new Button((Composite)FormLayoutTab.this.table, 8);
                FormLayoutTab.this.bottomAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
                FormLayoutTab.this.bottomEditor.horizontalAlignment = 16384;
                FormLayoutTab.this.bottomEditor.grabHorizontal = true;
                FormLayoutTab.this.bottomEditor.minimumWidth = FormLayoutTab.this.bottomAttach.computeSize((int)-1, (int)-1).x;
                FormLayoutTab.this.bottomEditor.setEditor((Control)FormLayoutTab.this.bottomAttach, FormLayoutTab.this.newItem, 7);
                FormLayoutTab.this.bottomAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = FormLayoutTab.this.tabFolderPage.getShell();
                        AttachDialog dialog = new AttachDialog(shell);
                        dialog.setText(LayoutExample.getResourceString("Bottom_Attachment"));
                        dialog.setColumn(7);
                        String attach = dialog.open();
                        FormLayoutTab.this.newItem.setText(7, attach);
                        if (FormLayoutTab.this.newItem.getText(6).endsWith(")")) {
                            FormLayoutTab.this.newItem.setText(6, "");
                        }
                        FormLayoutTab.this.resetEditors();
                    }
                });
                block6: for (int i = 0; i < FormLayoutTab.this.table.getColumnCount(); ++i) {
                    Rectangle rect = FormLayoutTab.this.newItem.getBounds(i);
                    if (!rect.contains(pt)) continue;
                    switch (i) {
                        case 0: {
                            FormLayoutTab.this.resetEditors();
                            continue block6;
                        }
                        case 1: {
                            FormLayoutTab.this.combo.setFocus();
                            continue block6;
                        }
                        case 2: {
                            FormLayoutTab.this.widthText.setFocus();
                            continue block6;
                        }
                        case 3: {
                            FormLayoutTab.this.heightText.setFocus();
                            continue block6;
                        }
                    }
                }
            }
        });
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(FormLayoutTab.this.table, 0);
                String[] insert = new String[]{String.valueOf(FormLayoutTab.this.table.indexOf(item)), "Button", "-1", "-1", "0,0 (" + LayoutExample.getResourceString("Default") + ")", "", "0,0 (" + LayoutExample.getResourceString("Default") + ")", ""};
                item.setText(insert);
                FormLayoutTab.this.data.addElement(insert);
                FormLayoutTab.this.resetEditors();
            }
        });
    }

    @Override
    void createControlWidgets() {
        String[] marginValues = new String[]{"0", "3", "5", "10"};
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        marginGroup.setLayout((Layout)layout);
        marginGroup.setLayoutData((Object)new GridData(768));
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Combo((Composite)marginGroup, 0);
        this.marginHeight.setItems(marginValues);
        this.marginHeight.select(0);
        this.marginHeight.addSelectionListener(this.selectionListener);
        this.marginHeight.addTraverseListener(this.traverseListener);
        GridData data = new GridData(768);
        data.widthHint = 60;
        this.marginHeight.setLayoutData((Object)data);
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Combo((Composite)marginGroup, 0);
        this.marginWidth.setItems(marginValues);
        this.marginWidth.select(0);
        this.marginWidth.addSelectionListener(this.selectionListener);
        this.marginWidth.addTraverseListener(this.traverseListener);
        data = new GridData(768);
        data.widthHint = 60;
        this.marginWidth.setLayoutData((Object)data);
        super.createControlWidgets();
        this.sash.setWeights(new int[]{6, 4});
    }

    @Override
    void createLayout() {
        this.formLayout = new FormLayout();
        this.layoutComposite.setLayout((Layout)this.formLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.leftAttach.dispose();
        this.rightAttach.dispose();
        this.topAttach.dispose();
        this.bottomAttach.dispose();
    }

    @Override
    StringBuffer generateLayoutCode() {
        StringBuffer code = new StringBuffer();
        code.append("\t\tFormLayout formLayout = new FormLayout ();\n");
        if (this.formLayout.marginHeight != 0) {
            code.append("\t\tformLayout.marginHeight = " + this.formLayout.marginHeight + ";\n");
        }
        if (this.formLayout.marginWidth != 0) {
            code.append("\t\tformLayout.marginWidth = " + this.formLayout.marginWidth + ";\n");
        }
        code.append("\t\tshell.setLayout (formLayout);\n");
        boolean first = true;
        for (int i = 0; i < this.children.length; ++i) {
            int index;
            String controlString;
            TableItem item;
            Control control = this.children[i];
            code.append(this.getChildCode(control, i));
            FormData data = (FormData)control.getLayoutData();
            if (data == null) continue;
            code.append("\t\t");
            if (first) {
                code.append("FormData ");
                first = false;
            }
            code.append("data = new FormData ();\n");
            if (data.width != -1) {
                code.append("\t\tdata.width = " + data.width + ";\n");
            }
            if (data.height != -1) {
                code.append("\t\tdata.height = " + data.height + ";\n");
            }
            if (data.left != null) {
                if (data.left.control != null) {
                    item = this.table.getItem(i);
                    controlString = item.getText(4);
                    index = new Integer(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                    code.append("\t\tdata.left = new FormAttachment (" + this.names[index] + ", " + data.left.offset + ", SWT." + this.alignmentString(data.left.alignment) + ");\n");
                } else if (data.right != null || data.left.numerator != 0 || data.left.offset != 0) {
                    code.append("\t\tdata.left = new FormAttachment (" + data.left.numerator + ", " + data.left.offset + ");\n");
                }
            }
            if (data.right != null) {
                if (data.right.control != null) {
                    item = this.table.getItem(i);
                    controlString = item.getText(5);
                    index = new Integer(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                    code.append("\t\tdata.right = new FormAttachment (" + this.names[index] + ", " + data.right.offset + ", SWT." + this.alignmentString(data.right.alignment) + ");\n");
                } else {
                    code.append("\t\tdata.right = new FormAttachment (" + data.right.numerator + ", " + data.right.offset + ");\n");
                }
            }
            if (data.top != null) {
                if (data.top.control != null) {
                    item = this.table.getItem(i);
                    controlString = item.getText(6);
                    index = new Integer(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                    code.append("\t\tdata.top = new FormAttachment (" + this.names[index] + ", " + data.top.offset + ", SWT." + this.alignmentString(data.top.alignment) + ");\n");
                } else if (data.bottom != null || data.top.numerator != 0 || data.top.offset != 0) {
                    code.append("\t\tdata.top = new FormAttachment (" + data.top.numerator + ", " + data.top.offset + ");\n");
                }
            }
            if (data.bottom != null) {
                if (data.bottom.control != null) {
                    item = this.table.getItem(i);
                    controlString = item.getText(7);
                    index = new Integer(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                    code.append("\t\tdata.bottom = new FormAttachment (" + this.names[index] + ", " + data.bottom.offset + ", SWT." + this.alignmentString(data.bottom.alignment) + ");\n");
                } else {
                    code.append("\t\tdata.bottom = new FormAttachment (" + data.bottom.numerator + ", " + data.bottom.offset + ");\n");
                }
            }
            code.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
        }
        return code;
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"", "Control", "width", "height", "left", "right", "top", "bottom"};
    }

    @Override
    String getTabText() {
        return "FormLayout";
    }

    @Override
    void resetEditors() {
        this.resetEditors(false);
    }

    @Override
    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new Integer(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException e) {
                this.widthText.setText(oldItem.getText(2));
            }
            try {
                new Integer(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException e) {
                this.heightText.setText(oldItem.getText(3));
            }
            String[] insert = new String[]{String.valueOf(row), this.combo.getText(), this.widthText.getText(), this.heightText.getText()};
            this.data.setElementAt(insert, row);
            for (int i = 0; i < 4; ++i) {
                oldItem.setText(i, ((String[])this.data.elementAt(row))[i]);
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    FormAttachment setAttachment(String attachment) {
        int offset;
        int position;
        int comma = attachment.indexOf(44);
        char first = attachment.charAt(0);
        if (Character.isLetter(first)) {
            int offset2;
            int i;
            String control = attachment.substring(0, comma);
            for (i = 0; i < control.length() && !Character.isDigit(control.charAt(i)); ++i) {
            }
            String end = control.substring(i);
            int index = new Integer(end);
            Control attachControl = this.children[index];
            int colon = attachment.indexOf(58);
            try {
                offset2 = new Integer(attachment.substring(comma + 1, colon));
            }
            catch (NumberFormatException e) {
                offset2 = 0;
            }
            String align = attachment.substring(colon + 1);
            return new FormAttachment(attachControl, offset2, this.alignmentConstant(align));
        }
        try {
            position = new Integer(attachment.substring(0, comma));
        }
        catch (NumberFormatException e) {
            position = 0;
        }
        try {
            offset = new Integer(attachment.substring(comma + 1));
        }
        catch (NumberFormatException e) {
            offset = 0;
        }
        return new FormAttachment(position, offset);
    }

    @Override
    void setLayoutData() {
        Control[] children = this.layoutComposite.getChildren();
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < children.length; ++i) {
            String bottom;
            String top;
            String right;
            String attachment;
            String left;
            int width = new Integer(items[i].getText(2));
            int height = new Integer(items[i].getText(3));
            FormData data = new FormData();
            if (width > 0) {
                data.width = width;
            }
            if (height > 0) {
                data.height = height;
            }
            if ((left = items[i].getText(4)).length() > 0) {
                data.left = this.setAttachment(left);
                if (data.left.control != null) {
                    attachment = this.checkAttachment(left, data.left);
                    items[i].setText(4, attachment);
                }
            }
            if ((right = items[i].getText(5)).length() > 0) {
                data.right = this.setAttachment(right);
                if (data.right.control != null) {
                    attachment = this.checkAttachment(right, data.right);
                    items[i].setText(5, attachment);
                }
            }
            if ((top = items[i].getText(6)).length() > 0) {
                data.top = this.setAttachment(top);
                if (data.top.control != null) {
                    attachment = this.checkAttachment(top, data.top);
                    items[i].setText(6, attachment);
                }
            }
            if ((bottom = items[i].getText(7)).length() > 0) {
                data.bottom = this.setAttachment(bottom);
                if (data.bottom.control != null) {
                    attachment = this.checkAttachment(bottom, data.bottom);
                    items[i].setText(7, attachment);
                }
            }
            children[i].setLayoutData((Object)data);
        }
    }

    @Override
    void setLayoutState() {
        try {
            this.formLayout.marginHeight = new Integer(this.marginHeight.getText());
        }
        catch (NumberFormatException e) {
            this.formLayout.marginHeight = 0;
            this.marginHeight.select(0);
        }
        try {
            this.formLayout.marginWidth = new Integer(this.marginWidth.getText());
        }
        catch (NumberFormatException e) {
            this.formLayout.marginWidth = 0;
            this.marginWidth.select(0);
        }
    }

    public class AttachDialog
    extends Dialog {
        String result;
        String controlInput;
        String positionInput;
        String alignmentInput;
        String offsetInput;
        int col;

        public AttachDialog(Shell parent, int style) {
            super(parent, style);
            this.result = "";
            this.col = 0;
        }

        public AttachDialog(Shell parent) {
            this(parent, 0);
        }

        public void setColumn(int col) {
            this.col = col;
        }

        public String open() {
            Shell parent = this.getParent();
            final Shell shell = new Shell(parent, 67680);
            shell.setText(this.getText());
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.makeColumnsEqualWidth = true;
            shell.setLayout((Layout)layout);
            TableItem newItem = FormLayoutTab.this.leftEditor.getItem();
            String oldAttach = this.result = newItem.getText(this.col);
            String oldPos = "0";
            String oldControl = "";
            String oldAlign = "DEFAULT";
            String oldOffset = "0";
            boolean isControl = false;
            if (oldAttach.length() != 0) {
                char first = oldAttach.charAt(0);
                if (Character.isLetter(first)) {
                    isControl = true;
                    oldControl = oldAttach.substring(0, oldAttach.indexOf(44));
                    oldAlign = oldAttach.substring(oldAttach.indexOf(58) + 1);
                    oldOffset = oldAttach.substring(oldAttach.indexOf(44) + 1, oldAttach.indexOf(58));
                } else {
                    oldPos = oldAttach.substring(0, oldAttach.indexOf(44));
                    oldOffset = oldAttach.substring(oldAttach.indexOf(44) + 1);
                    if (oldOffset.endsWith(")")) {
                        oldOffset = oldOffset.substring(0, oldOffset.indexOf(32));
                    }
                }
            }
            final Button posButton = new Button((Composite)shell, 16);
            posButton.setText(LayoutExample.getResourceString("Position"));
            posButton.setSelection(!isControl);
            final Combo position = new Combo((Composite)shell, 0);
            position.setItems(new String[]{"0", "25", "50", "75", "100"});
            position.setText(oldPos);
            position.setEnabled(!isControl);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            position.setLayoutData((Object)data);
            Button contButton = new Button((Composite)shell, 16);
            contButton.setText(LayoutExample.getResourceString("Control"));
            contButton.setSelection(isControl);
            final Combo control = new Combo((Composite)shell, 8);
            TableItem[] items = FormLayoutTab.this.table.getItems();
            TableItem currentItem = FormLayoutTab.this.leftEditor.getItem();
            for (int i = 0; i < FormLayoutTab.this.table.getItemCount(); ++i) {
                if (items[i].getText(0).length() <= 0 || items[i] == currentItem) continue;
                control.add(items[i].getText(1) + i);
            }
            if (oldControl.length() != 0) {
                control.setText(oldControl);
            } else {
                control.select(0);
            }
            control.setEnabled(isControl);
            data = new GridData(768);
            data.horizontalSpan = 2;
            control.setLayoutData((Object)data);
            new Label((Composite)shell, 0).setText(LayoutExample.getResourceString("Alignment"));
            final Combo alignment = new Combo((Composite)shell, 0);
            String[] alignmentValues = this.col == 4 || this.col == 5 ? new String[]{"SWT.LEFT", "SWT.RIGHT", "SWT.CENTER", "SWT.DEFAULT"} : new String[]{"SWT.TOP", "SWT.BOTTOM", "SWT.CENTER", "SWT.DEFAULT"};
            alignment.setItems(alignmentValues);
            alignment.setText("SWT." + oldAlign);
            alignment.setEnabled(isControl);
            data = new GridData(768);
            data.horizontalSpan = 2;
            alignment.setLayoutData((Object)data);
            new Label((Composite)shell, 0).setText(LayoutExample.getResourceString("Offset"));
            final Text offset = new Text((Composite)shell, 2052);
            offset.setText(oldOffset);
            data = new GridData(768);
            data.horizontalSpan = 2;
            offset.setLayoutData((Object)data);
            posButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    position.setEnabled(true);
                    control.setEnabled(false);
                    alignment.setEnabled(false);
                }
            });
            contButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    position.setEnabled(false);
                    control.setEnabled(true);
                    alignment.setEnabled(true);
                }
            });
            Button clear = new Button((Composite)shell, 8);
            clear.setText(LayoutExample.getResourceString("Clear"));
            clear.setLayoutData((Object)new GridData(128));
            clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AttachDialog.this.result = "";
                    shell.close();
                }
            });
            Button ok = new Button((Composite)shell, 8);
            ok.setText(LayoutExample.getResourceString("OK"));
            ok.setLayoutData((Object)new GridData(64));
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AttachDialog.this.controlInput = control.getText();
                    AttachDialog.this.alignmentInput = alignment.getText().substring(4);
                    AttachDialog.this.positionInput = position.getText();
                    if (AttachDialog.this.positionInput.length() == 0) {
                        AttachDialog.this.positionInput = "0";
                    }
                    try {
                        new Integer(AttachDialog.this.positionInput).intValue();
                    }
                    catch (NumberFormatException except) {
                        AttachDialog.this.positionInput = "0";
                    }
                    AttachDialog.this.offsetInput = offset.getText();
                    if (AttachDialog.this.offsetInput.length() == 0) {
                        AttachDialog.this.offsetInput = "0";
                    }
                    try {
                        new Integer(AttachDialog.this.offsetInput).intValue();
                    }
                    catch (NumberFormatException except) {
                        AttachDialog.this.offsetInput = "0";
                    }
                    AttachDialog.this.result = posButton.getSelection() || AttachDialog.this.controlInput.length() == 0 ? AttachDialog.this.positionInput + "," + AttachDialog.this.offsetInput : AttachDialog.this.controlInput + "," + AttachDialog.this.offsetInput + ":" + AttachDialog.this.alignmentInput;
                    shell.close();
                }
            });
            Button cancel = new Button((Composite)shell, 8);
            cancel.setText(LayoutExample.getResourceString("Cancel"));
            cancel.setLayoutData((Object)new GridData(32));
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    shell.close();
                }
            });
            shell.setDefaultButton(ok);
            shell.pack();
            Point center = parent.getLocation();
            center.x = center.x + parent.getBounds().width / 2 - shell.getBounds().width / 2;
            center.y = center.y + parent.getBounds().height / 2 - shell.getBounds().height / 2;
            shell.setLocation(center);
            shell.open();
            Display display = shell.getDisplay();
            while (!shell.isDisposed()) {
                if (!display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.result;
        }
    }
}

