/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.RestoranServerBO;
import com.dev63.restoran.backoffice.rokovnik.ZakljucenjeRokovnikUnos;
import com.dev63.restoran.fiscalprint.einis.EINisWriter;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.sistem.fpProtocols.FLinkProtocol;
import com.dev63.restoran.sistem.fpProtocols.metalink.MetaLinkProtocol;
import com.dev63.restoran.stampa.StampaZRepAustria;
import com.dev63.restoran.stampa.UskaPrometPoArtiklima;
import com.dev63.restoran.swt.components.SWTMessage;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FiskalneFunkcije {
    static Date day1;
    static ResourceBundle barmasterText;
    private static RestoranServerBO serverBO;

    public static boolean zatvoriDan(Restoran restoran, RestoranServer server, Shell shellMW, int i) {
        day1 = server.getLastDateZD();
        System.out.println("datum " + day1);
        serverBO = restoran.getServerBO();
        if (i != 2) {
            ZakljucenjeRokovnikUnos zru;
            if (!FiskalneFunkcije.proveriPoslednjiZ()) {
                MessageBox mb = new MessageBox(shellMW, 34);
                mb.setText("Obave\u0161tenje");
                mb.setMessage(barmasterText.getString("PORUKA_POSLEDNJI_IZVESTAJ_JE_POSLAT_NA_STAMPU_PRE_MANJE_OD_30_MINUTA"));
                mb.open();
                return false;
            }
            if (restoran.getServerBO().getSetting(OptionBO.AUTOMATSKO_ZAKLJUCENJE_FISKALA).booleanValue() || !restoran.getServerBO().getSetting(OptionBO.FISKALNO_ZAKLJUCENJE).booleanValue()) {
                return false;
            }
            if (server.getStolove().size() > 0 && !restoran.getServerBO().getSetting(OptionBO.RAD_BEZ_STOLOVA).booleanValue()) {
                Konstante.getPoruka(shellMW, "Morate zakljuciti sve stolove!");
                return false;
            }
            if (server.getSetting(Option.ZAKLJUCENJE_DANA_NAPOMENA).booleanValue() && !(zru = new ZakljucenjeRokovnikUnos(shellMW, restoran)).isPotvrdjen()) {
                return false;
            }
            try {
                server.deleteRezervacijaDatum(new Date());
                if (i != 1) {
                    if (Konstante.getTipStampaca() == 1) {
                        XMLWriter.writeReport(0);
                    } else if (Konstante.getTipStampaca() == 2) {
                        XMLWriterHCP.writeDnevniIzvestaj();
                    } else if (Konstante.getTipStampaca() == 3) {
                        EINisWriter.printZReport();
                    } else if (Konstante.getTipStampaca() == 21) {
                        FLinkProtocol.getInstance().stampaDnevnogIzvestaja();
                    } else if (Konstante.getTipStampaca() == 22) {
                        MetaLinkProtocol.getInstance().stampaDnevnogIzvestaja();
                    }
                }
                FiskalneFunkcije.setPoslednjiZ();
                Setting setting = server.getSetting(Option.RADNO_VREME);
                if (setting != null && setting.booleanValue() && serverBO.getSetting(OptionBO.SOFTVERSKO_ZAKLJUCENJE).booleanValue()) {
                    Date otvaranjeDana = server.getLastDateZD();
                    ZD zatvaranje = new ZD();
                    zatvaranje.setDatum(otvaranjeDana);
                    zatvaranje.setZakljucenje(new Date());
                    zatvaranje.setPocetak(false);
                    server.addZD(zatvaranje);
                    Thread.sleep(2000L);
                    ZD otvaranjeSledeceg = new ZD();
                    otvaranjeSledeceg.setDatum(Konstante.dateAfter(otvaranjeDana));
                    otvaranjeSledeceg.setZakljucenje(new Date());
                    otvaranjeSledeceg.setPocetak(true);
                    otvaranjeSledeceg.setZdBroj(server.getLastOpenZD().getZdBroj() + 1L);
                    server.addZD(otvaranjeSledeceg);
                }
                try {
                    restoran.getServerBO().resetPomocniBrojStola();
                }
                catch (Exception ex) {
                    SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)shellMW), (Object)"Do\u0161lo je do gre\u0161ke prilikom resetovanja pomocnog broja stola");
                    server.warning("Do\u0161lo je do gre\u0161ke prilikom resetovanja pomocnog broja stola");
                }
                server.log("Zatvori dan (Z izvestaj)");
            }
            catch (Exception ex) {
                Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom zatvaranja dana", ex);
                return false;
            }
            return true;
        }
        try {
            if (Konstante.getTipStampaca() == 1) {
                XMLWriter.writeReport(0);
            } else if (Konstante.getTipStampaca() == 2) {
                XMLWriterHCP.writeDnevniIzvestaj();
            } else if (Konstante.getTipStampaca() == 3) {
                EINisWriter.printZReport();
            } else if (Konstante.getTipStampaca() == 21) {
                FLinkProtocol.getInstance().stampaDnevnogIzvestaja();
            } else if (Konstante.getTipStampaca() == 22) {
                MetaLinkProtocol.getInstance().stampaDnevnogIzvestaja();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom zatvaranja dana", ex);
            return false;
        }
        return true;
    }

    public static boolean zatvoriDanSaPresekom(Restoran restoran, RestoranServer server, Shell shellMW) {
        serverBO = restoran.getServerBO();
        if (restoran.getServerBO().getSetting(OptionBO.FISKALNO_ZAKLJUCENJE).booleanValue() && !restoran.getServerBO().getSetting(OptionBO.AUTOMATSKO_ZAKLJUCENJE_FISKALA).booleanValue()) {
            ZakljucenjeRokovnikUnos zru;
            if (server.getStolove().size() > 0 && !restoran.getServerBO().getSetting(OptionBO.RAD_BEZ_STOLOVA).booleanValue() && !restoran.getServerBO().getSetting(OptionBO.ISKLJUCI_PROVERU_OTVORENIH_STOLOVA).booleanValue()) {
                Konstante.getPoruka(shellMW, barmasterText.getString("TEXT_MORATE_ZAKLJUCITI_SVE_STOLOVE"));
                return false;
            }
            if (restoran.getServerBO().getSetting(OptionBO.ISKLJUCI_PROVERU_OTVORENIH_STOLOVA).booleanValue()) {
                boolean doit;
                boolean bl = doit = SWTMessage.showLocalizedYesNoDialog(shellMW, String.format(Konstante.getBundle().getString("IMATE_OTVORENE_STOLOVE"), new Object[0])) == 64;
                if (!doit) {
                    return doit;
                }
            }
            if (!FiskalneFunkcije.proveriPoslednjiZ()) {
                MessageBox mb = new MessageBox(shellMW, 34);
                mb.setText(barmasterText.getString("TEXT_OBAVESTENJE"));
                mb.setMessage(barmasterText.getString("PORUKA_POSLEDNJI_IZVESTAJ_JE_POSLAT_NA_STAMPU_PRE_MANJE_OD_30_MINUTA"));
                mb.open();
                return false;
            }
            if (server.getSetting(Option.ZAKLJUCENJE_DANA_NAPOMENA).booleanValue() && !(zru = new ZakljucenjeRokovnikUnos(shellMW, restoran)).isPotvrdjen()) {
                return false;
            }
            try {
                boolean prometArt = BMTerminalSettings.getSetting(OptionBO.FP_PRODATI_ARTIKLI) != null && BMTerminalSettings.getSetting(OptionBO.FP_PRODATI_ARTIKLI).booleanValue();
                server.deleteRezervacijaDatum(new Date());
                if (Konstante.getTipStampaca() == 1) {
                    if (prometArt) {
                        XMLWriter.writeReport(1);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za presek stanja");
                        Thread.sleep(3000L);
                        XMLWriter.writeReport(2);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za prodate artikle");
                        Thread.sleep(3000L);
                        XMLWriter.writeReport(0);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za dnevni izvestaj");
                    } else {
                        XMLWriter.writeReport(1);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za presek stanja");
                        Thread.sleep(3000L);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za dnevni izvestaj");
                        XMLWriter.writeReport(0);
                    }
                } else if (Konstante.getTipStampaca() == 2) {
                    if (prometArt) {
                        new UskaPrometPoArtiklima(new Shell(), restoran, null, true, false);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "HCP prodati artikli");
                    }
                    XMLWriterHCP.writeDnevniIzvestajIPresekStanja();
                    Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za HCP presek stanja i dnevni izvestaj");
                } else if (Konstante.getTipStampaca() == 3) {
                    EINisWriter.printXReport();
                    EINisWriter.printZReport();
                } else if (Konstante.getTipStampaca() == 11) {
                    try {
                        new StampaZRepAustria(server, new Date(), new Date());
                    }
                    catch (Exception e) {
                        SWTMessage.showMessageDialog(shellMW, String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_BARMASTER"), new Object[0]), 4);
                        Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                    }
                } else if (Konstante.getTipStampaca() == 21) {
                    FLinkProtocol.getInstance().stampaPresekaStanja();
                    FLinkProtocol.getInstance().stampaDnevnogIzvestaja();
                    Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za FLINK preske stanja i dnevni izvestaj");
                } else if (Konstante.getTipStampaca() == 22) {
                    MetaLinkProtocol.getInstance().stampaPresekaStanja();
                    MetaLinkProtocol.getInstance().stampaDnevnogIzvestaja();
                    Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.INFO, "Kreiran fajl za METALINK preske stanja i dnevni izvestaj");
                }
                FiskalneFunkcije.setPoslednjiZ();
                Setting setting = server.getSetting(Option.RADNO_VREME);
                if (setting != null && setting.booleanValue() && serverBO.getSetting(OptionBO.SOFTVERSKO_ZAKLJUCENJE).booleanValue()) {
                    day1 = server.getLastDateZD();
                    Date otvaranjeDana = server.getLastDateZD();
                    ZD zatvaranje = new ZD();
                    Thread.sleep(2000L);
                    zatvaranje.setDatum(otvaranjeDana);
                    zatvaranje.setZakljucenje(new Date());
                    zatvaranje.setPocetak(false);
                    zatvaranje.setZdBroj(server.getLastOpenZD().getZdBroj());
                    zatvaranje.setRekonstrukcija(false);
                    server.addZD(zatvaranje);
                    ZD otvaranjeSledeceg = new ZD();
                    otvaranjeSledeceg.setDatum(Konstante.dateAfter(otvaranjeDana));
                    otvaranjeSledeceg.setZakljucenje(new Date());
                    otvaranjeSledeceg.setPocetak(true);
                    otvaranjeSledeceg.setZdBroj(server.getLastOpenZD().getZdBroj() + 1L);
                    otvaranjeSledeceg.setRekonstrukcija(false);
                    server.addZD(otvaranjeSledeceg);
                }
                server.log(String.format(Konstante.getBundle().getString("LOG_ZATVORI_DAN_(Z_IZVESTAJ)"), new Object[0]));
            }
            catch (Exception ex) {
                Logger.getLogger(FiskalneFunkcije.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                restoran.getServerBO().resetPomocniBrojStola();
            }
            catch (Exception e) {
                SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)shellMW), (Object)barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_RESETOVANJA_POMOCNOG_BROJA_STOLA"));
                server.warning("Do\u0161lo je do gre\u0161ke prilikom resetovanja pomocnog broja stola");
            }
            return true;
        }
        return false;
    }

    public static boolean proveriPoslednjiZ() {
        if (Konstante.getTipStampaca() >= 10) {
            return true;
        }
        Calendar poslednjiZ = Calendar.getInstance();
        poslednjiZ.add(11, -6);
        try {
            Date dLast = BMTerminalSettings.getSetting(OptionBO.POSLEDNJI_Z).dateTimeValue();
            System.out.println("dLast = " + dLast);
            poslednjiZ.setTime(dLast);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        Calendar uporedni = Calendar.getInstance();
        uporedni.add(11, -6);
        return uporedni.after(poslednjiZ);
    }

    public static void setPoslednjiZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        BMTerminalSettings.setSetting(OptionBO.POSLEDNJI_Z, sdf.format(new Date()));
    }

    public static void presekStanja(RestoranServer server) throws Exception {
        server.log(String.format(Konstante.getBundle().getString("LOG_PRESEK_STANJA_(X_IZVESTAJ)"), new Object[0]));
        if (Konstante.getTipStampaca() == 1) {
            XMLWriter.writeReport(1);
        } else if (Konstante.getTipStampaca() == 2) {
            XMLWriterHCP.writePresekStanja();
        } else if (Konstante.getTipStampaca() == 3) {
            EINisWriter.printXReport();
        } else if (Konstante.getTipStampaca() == 21) {
            FLinkProtocol.getInstance().stampaPresekaStanja();
        } else if (Konstante.getTipStampaca() == 22) {
            MetaLinkProtocol.getInstance().stampaPresekaStanja();
        }
    }

    static {
        barmasterText = Konstante.getBundle();
    }
}

