/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.CenovnikController;
import com.dev63.restoran.swt.components.TimeInput2;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CenovnikForm {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Composite drawingArea;
    private CenovnikController controller;
    private Tree tree;
    private Table table;
    private TextInput2 name;
    private TextInput2 vrednostText;
    private Combo zaokruzivanjeText;
    private DateInput2 beginDate;
    private DateInput2 endDate;
    private TimeInput2 beginTime;
    private TimeInput2 endTime;
    private Combo beginHour;
    private Combo endHour;
    private Combo beginMinute;
    private Combo endMinute;
    private Label beginDayLabel;
    private Label d2;
    private List<Artikal> tableItemsList;
    private Map<Artikal, Double> artikal_cena;
    private Map<String, Artikal> nameToArtikal;
    private TableEditor editor;
    private TableItem item;
    private int indexOfSelected = 0;
    private int itemCount = 0;
    private List<Button> btns;
    private Composite comp;
    Composite controls;
    private Button aktivan;
    private Button automatika;
    private Button periodicni;
    private Button obrisiSve;
    RestoranServer server;
    String dani = "";

    public CenovnikForm(Composite drawingArea, CenovnikController controller, RestoranServer server) {
        this.drawingArea = drawingArea;
        this.tableItemsList = new ArrayList<Artikal>();
        this.controller = controller;
        this.nameToArtikal = new HashMap<String, Artikal>();
        this.artikal_cena = new HashMap<Artikal, Double>();
        this.btns = new LinkedList<Button>();
        this.server = server;
    }

    private void initComponents() {
        String[] daniArr;
        this.drawingArea.setLayout((Layout)new GridLayout(2, false));
        this.comp = new Composite(this.drawingArea, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.tree = new Tree(this.comp, 2848);
        Composite tablePanel = new Composite(this.drawingArea, 0);
        tablePanel.setLayout((Layout)new GridLayout(3, false));
        this.table = new Table(tablePanel, 68098);
        String[] titles = new String[]{"Naziv", "Sifra", "Cena"};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
        }
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.verticalIndent = 0;
        tableGridData.horizontalSpan = 3;
        tableGridData.widthHint = 500;
        this.table.setLayoutData((Object)tableGridData);
        GridData g = new GridData();
        g.widthHint = 150;
        Label label1 = new Label(tablePanel, 0);
        label1.setText(barmasterText.getString("TEXT_PROMENA_CENA") + ": ");
        this.vrednostText = new TextInput2(tablePanel, barmasterText.getString("TEXT_PROMENA_CENA"));
        this.vrednostText.getControl().setLayoutData((Object)g);
        Group tipGrupa = new Group(tablePanel, 4);
        tipGrupa.setText(barmasterText.getString("TEXT_TIP_PROMENE") + ": ");
        tipGrupa.setLayout((Layout)new RowLayout(256));
        final Button procenti = new Button((Composite)tipGrupa, 16);
        procenti.setText(barmasterText.getString("TEXT_U_PROCENTIMA") + ": ");
        procenti.setSelection(true);
        Button fixno = new Button((Composite)tipGrupa, 16);
        fixno.setText(barmasterText.getString("TEXT_FIKSNA_VREDNOST") + ": ");
        Label label2 = new Label(tablePanel, 0);
        label2.setText(barmasterText.getString("TEXT_ZAOKRUZIVANJE_NA") + ": ");
        this.zaokruzivanjeText = new Combo(tablePanel, 8);
        this.zaokruzivanjeText.setItems(new String[]{"Bez zaokruzivanja", "Na nizu vrednost", "Na 0.25", "Na 0.50", "Na 0.75", "Na visu vrednost"});
        this.zaokruzivanjeText.select(0);
        this.zaokruzivanjeText.setLayoutData((Object)g);
        GridData gdd = new GridData();
        gdd.widthHint = 150;
        gdd.heightHint = 40;
        Label label3 = new Label(tablePanel, 0);
        Button promenaButt = Dugmici.getIzmena(tablePanel);
        promenaButt.setLayoutData((Object)gdd);
        promenaButt.setText(barmasterText.getString("TEXT_IZMENI"));
        promenaButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                double vrednost = 0.0;
                double zaokruzivanje = 0.0;
                try {
                    vrednost = Double.parseDouble(CenovnikForm.this.vrednostText.getText());
                    switch (CenovnikForm.this.zaokruzivanjeText.getText()) {
                        case "Bez zaokruzivanja": {
                            zaokruzivanje = 0.0;
                            break;
                        }
                        case "Na nizu vrednost": {
                            zaokruzivanje = 1.0;
                            break;
                        }
                        case "Na 0.25": {
                            zaokruzivanje = 0.25;
                            break;
                        }
                        case "Na 0.50": {
                            zaokruzivanje = 0.5;
                            break;
                        }
                        case "Na 0.75": {
                            zaokruzivanje = 0.75;
                            break;
                        }
                        case "Na visu vrednost": {
                            zaokruzivanje = 2.0;
                        }
                    }
                    CenovnikForm.this.izmeniCene(vrednost, procenti.getSelection(), zaokruzivanje);
                    CenovnikForm.this.vrednostText.getTextControl().setText(String.valueOf(0.0));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException iae) {
                    Konstante.getPoruka2(CenovnikForm.this.drawingArea.getShell(), iae.getMessage());
                }
            }
        });
        this.obrisiSve = Dugmici.getBrisanje(tablePanel);
        this.obrisiSve.setLayoutData((Object)gdd);
        this.obrisiSve.setText(barmasterText.getString("TEXT_OBRISI_STAVKE"));
        this.obrisiSve.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                CenovnikForm.this.table.clearAll();
                CenovnikForm.this.controller.getCenaByArtikal().clear();
            }
        });
        GridData tablePanelGridData = new GridData();
        tablePanelGridData.grabExcessHorizontalSpace = true;
        tablePanelGridData.grabExcessVerticalSpace = true;
        tablePanelGridData.verticalAlignment = 4;
        tablePanelGridData.horizontalAlignment = 4;
        tablePanel.setLayoutData((Object)tablePanelGridData);
        this.comp.setLayoutData((Object)tablePanelGridData);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.verticalAlignment = 4;
        treeGridData.horizontalAlignment = 4;
        this.tree.setLayoutData((Object)treeGridData);
        this.indexOfSelected = 0;
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.addEditor(this.table);
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    CenovnikForm.this.selectionOnTreeItem((TreeItem)event.item, ((TreeItem)event.item).getChecked());
                }
            }
        });
        Composite osveziGrid = new Composite(this.comp, 0);
        osveziGrid.setLayout((Layout)new GridLayout(1, true));
        Button osvezi = Dugmici.getOkButton(osveziGrid);
        osvezi.setText("Osvezi");
        osvezi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                System.out.println("probam nesto");
                CenovnikForm.this.refreshTable();
            }
        });
        Composite aktivacioni = new Composite(this.comp, 0);
        aktivacioni.setLayout((Layout)new GridLayout(3, true));
        this.aktivan = new Button(aktivacioni, 32);
        this.aktivan.setText("Aktivan ");
        this.aktivan.setSelection(true);
        this.automatika = new Button(aktivacioni, 32);
        this.automatika.setText("Automatska aktivacija ");
        this.periodicni = new Button(aktivacioni, 32);
        this.periodicni.setText("Periodicna aktivacija");
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 2;
        gd1.widthHint = 200;
        Label l = new Label(aktivacioni, 0);
        l.setText(barmasterText.getString("TEXT_NAZIV") + ":");
        this.name = new TextInput2(aktivacioni, barmasterText.getString("TEXT_NAZIV"));
        this.name.getControl().setToolTipText("OVDE UPISITE NAZIV CENOVNIKA");
        this.name.getControl().setLayoutData((Object)gd1);
        this.controls = new Composite(this.comp, 0);
        this.controls.setLayout((Layout)new GridLayout(3, false));
        this.controls.setVisible(false);
        if (!this.automatika.getSelection()) {
            this.controls.setVisible(false);
        } else {
            this.controls.setVisible(true);
        }
        final Composite controls1 = new Composite(this.controls, 0);
        controls1.setLayout((Layout)new GridLayout(1, true));
        final Composite controls2 = new Composite(this.controls, 0);
        controls2.setLayout((Layout)new GridLayout(2, true));
        final Composite preiodicniControl = new Composite(this.controls, 0);
        preiodicniControl.setLayout((Layout)new GridLayout(2, true));
        preiodicniControl.setVisible(false);
        if (this.periodicni.getSelection()) {
            this.controls.setVisible(true);
            preiodicniControl.setVisible(true);
            controls1.setVisible(false);
            controls2.setVisible(false);
        } else {
            this.controls.setVisible(false);
            preiodicniControl.setVisible(false);
            controls1.setVisible(true);
            controls2.setVisible(true);
        }
        this.periodicni.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CenovnikForm.this.periodicni.getSelection()) {
                    CenovnikForm.this.controls.setVisible(true);
                    preiodicniControl.setVisible(true);
                    controls1.setVisible(false);
                    controls2.setVisible(false);
                    CenovnikForm.this.automatika.setSelection(false);
                    for (Button b : CenovnikForm.this.btns) {
                        b.setSelection(false);
                    }
                    CenovnikForm.this.dani = "";
                } else {
                    CenovnikForm.this.controls.setVisible(false);
                    preiodicniControl.setVisible(false);
                    controls1.setVisible(true);
                    controls2.setVisible(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite dugmad = new Composite(this.comp, 0);
        dugmad.setLayout((Layout)new GridLayout(6, false));
        this.automatika.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CenovnikForm.this.automatika.getSelection()) {
                    CenovnikForm.this.controls.setVisible(false);
                } else {
                    CenovnikForm.this.controls.setVisible(true);
                }
                super.widgetSelected(e);
            }
        });
        for (String dan : daniArr = new String[]{"Ponedeljak", "Utorak", "Sreda", "Cetvrtak", "Petak", "Subota", "Nedelja"}) {
            Button d = new Button(controls1, 32);
            d.setBackground(controls1.getDisplay().getSystemColor(22));
            d.setText(dan);
            this.btns.add(d);
        }
        this.beginDayLabel = new Label(preiodicniControl, 0);
        this.beginDayLabel.setBackground(preiodicniControl.getDisplay().getSystemColor(22));
        this.beginDayLabel.setText(barmasterText.getString("TEXT_DAN_POCETKA") + ": ");
        this.beginDate = new DateInput2(preiodicniControl, barmasterText.getString("TEXT_DAN_POCETKA"), new Date(), this.server);
        this.beginDate.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.beginDate, preiodicniControl.getShell()));
        this.d2 = new Label(preiodicniControl, 0);
        this.d2.setBackground(preiodicniControl.getDisplay().getSystemColor(22));
        this.d2.setText(barmasterText.getString("TEXT_DAN_ZAVRSETKA") + ": ");
        this.endDate = new DateInput2(preiodicniControl, barmasterText.getString("TEXT_DAN_ZAVRSETKA"), new Date(), this.server);
        this.endDate.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.endDate, preiodicniControl.getShell()));
        Label beginDayLabel1 = new Label(preiodicniControl, 0);
        beginDayLabel1.setBackground(preiodicniControl.getDisplay().getSystemColor(22));
        beginDayLabel1.setText(barmasterText.getString("TEXT_SAT_POCETKA") + ": ");
        this.beginTime = new TimeInput2(preiodicniControl, 0);
        this.beginTime.setDefault(new Date());
        Label d21 = new Label(preiodicniControl, 0);
        d21.setBackground(preiodicniControl.getDisplay().getSystemColor(22));
        d21.setText(barmasterText.getString("TEXT_SAT_ZAVRSETKA") + ": ");
        this.endTime = new TimeInput2(preiodicniControl, 0);
        this.endTime.setDefault(new Date());
        Label beginHourLabel = new Label(controls2, 0);
        beginHourLabel.setBackground(controls2.getDisplay().getSystemColor(22));
        beginHourLabel.setText(barmasterText.getString("TEXT_SAT_POCETKA") + ": ");
        this.beginHour = new Combo(controls2, 0);
        Label beginMinuteLabel = new Label(controls2, 0);
        beginMinuteLabel.setBackground(controls2.getDisplay().getSystemColor(22));
        beginMinuteLabel.setText(barmasterText.getString("TEXT_MINUT_POCETKA") + ": ");
        this.beginMinute = new Combo(controls2, 0);
        Label s2 = new Label(controls2, 0);
        s2.setBackground(controls2.getDisplay().getSystemColor(22));
        s2.setText(barmasterText.getString("TEXT_SAT_ZAVRSETKA") + ": ");
        this.endHour = new Combo(controls2, 0);
        for (int i = 0; i < 24; ++i) {
            String s = i < 10 ? "0" + i + "h" : "" + i + "h";
            this.beginHour.add(s);
            this.endHour.add(s);
        }
        this.beginHour.select(0);
        this.endHour.select(0);
        Label endMinuteLabel = new Label(controls2, 0);
        endMinuteLabel.setBackground(controls2.getDisplay().getSystemColor(22));
        endMinuteLabel.setText(barmasterText.getString("TEXT_MINUT_ZAVRSETKA") + ": ");
        this.endMinute = new Combo(controls2, 0);
        for (int i = 0; i < 60; i += 15) {
            this.beginMinute.add("" + i);
            this.endMinute.add("" + i);
        }
        this.beginMinute.select(0);
        this.endMinute.select(0);
        GridData gda = new GridData();
        gda.horizontalSpan = 2;
        gda.widthHint = 120;
        Button cancelButt = Dugmici.getCancelButton(dugmad);
        cancelButt.setLayoutData((Object)gda);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CenovnikForm.this.dispose();
                CenovnikForm.this.controller.cancelChanges();
            }
        });
        Button helpButt = Dugmici.getHelpButton(dugmad);
        helpButt.setLayoutData((Object)gda);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(dugmad);
        okButt.setLayoutData((Object)gda);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                for (Button b : CenovnikForm.this.btns) {
                    if (!b.getSelection()) continue;
                    CenovnikForm.this.dani = CenovnikForm.this.dani + b.getText() + ",";
                }
                if (CenovnikForm.this.name.getText().isEmpty()) {
                    Konstante.getPoruka3(CenovnikForm.this.drawingArea.getShell(), "Morate popuniti naziv cenovnika");
                    return;
                }
                for (Artikal a : CenovnikForm.this.artikal_cena.keySet()) {
                    CenovnikForm.this.controller.getCenaByArtikal().put(a, (Double)CenovnikForm.this.artikal_cena.get(a));
                }
                String naziv = CenovnikForm.this.name.getText();
                Date danOd = null;
                Date danDo = null;
                if (CenovnikForm.this.periodicni.getSelection()) {
                    try {
                        Calendar ood = Calendar.getInstance();
                        ood.setTime(CenovnikForm.this.beginDate.getResult());
                        ood.set(10, CenovnikForm.this.beginTime.getHours());
                        ood.set(12, CenovnikForm.this.beginTime.getMinutes());
                        Calendar doo = Calendar.getInstance();
                        doo.setTime(CenovnikForm.this.endDate.getResult());
                        doo.set(10, CenovnikForm.this.endTime.getHours());
                        doo.set(12, CenovnikForm.this.endTime.getMinutes());
                        danOd = ood.getTime();
                        danDo = doo.getTime();
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                }
                int satOd = CenovnikForm.this.beginHour.getSelectionIndex();
                int satDo = CenovnikForm.this.endHour.getSelectionIndex();
                int minutOd = CenovnikForm.this.beginMinute.getSelectionIndex() * 15;
                int minutDo = CenovnikForm.this.endMinute.getSelectionIndex() * 15;
                boolean akt = CenovnikForm.this.aktivan.getSelection();
                CenovnikForm.this.dispose();
            }
        });
        GridData dataForButtons = new GridData();
        dataForButtons.horizontalSpan = 2;
        okButt.setLayoutData((Object)dataForButtons);
        cancelButt.setLayoutData((Object)dataForButtons);
        helpButt.setLayoutData((Object)dataForButtons);
        GridData dataForControls = new GridData();
        this.controls.setLayoutData((Object)dataForControls);
    }

    private void selectionOnTreeItem(TreeItem item, boolean checked) {
        if (item.getItemCount() == 0) {
            item.setChecked(checked);
            if (checked) {
                this.tableItemsList.add(this.nameToArtikal.get(item.getText()));
                this.artikal_cena.put(this.nameToArtikal.get(item.getText()), this.nameToArtikal.get(item.getText()).getCena());
            } else {
                System.out.println(this.nameToArtikal.get(item.getText()) + " nameToArtikal.get(item.getText())");
                this.tableItemsList.remove(this.nameToArtikal.get(item.getText()));
                this.artikal_cena.remove(this.nameToArtikal.get(item.getText()));
            }
        } else {
            System.out.println("da l ovde ulazi");
            this.tableItemsList.clear();
            item.setChecked(checked);
            for (TreeItem child : item.getItems()) {
                this.selectionOnTreeItem(child, checked);
            }
        }
    }

    private void loadData() {
    }

    private void refreshTable() {
        this.table.removeAll();
        for (Artikal artikal : this.tableItemsList) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, artikal.getName());
            ti.setText(1, artikal.getBarCode() == null ? "" : artikal.getBarCode());
            System.out.println(artikal.getName());
            ti.setText(2, Konstante.getNumber2(this.artikal_cena.get(artikal)));
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        this.itemCount = this.table.getItemCount();
    }

    public void show() {
        if (this.drawingArea != null && !this.drawingArea.isDisposed()) {
            for (Control control : this.drawingArea.getChildren()) {
                control.dispose();
            }
            this.initComponents();
            this.loadData();
            this.drawingArea.layout();
            if (this.drawingArea instanceof Shell) {
                ((Shell)this.drawingArea).open();
            }
        }
    }

    public void dispose() {
        if (this.drawingArea instanceof Shell) {
            ((Shell)this.drawingArea).close();
        } else {
            for (Control control : this.drawingArea.getChildren()) {
                control.getShell().close();
            }
        }
    }

    private void addEditor(final Table table) {
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CenovnikForm.this.item = (TableItem)e.item;
                CenovnikForm.this.indexOfSelected = table.indexOf(CenovnikForm.this.item);
                CenovnikForm.this.selectNextRow(CenovnikForm.this.item);
            }
        });
    }

    private void selectNextRow(TableItem ti) {
        this.table.setSelection(ti);
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (this.item == null) {
            return;
        }
        Text newEditor = new Text((Composite)this.table, 0);
        newEditor.setText(this.item.getText(2));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text text = (Text)CenovnikForm.this.editor.getEditor();
                if (!text.getText().isEmpty()) {
                    CenovnikForm.this.editor.getItem().setText(2, text.getText());
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, this.item, 2);
        newEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    CenovnikForm.this.table.showSelection();
                    CenovnikForm.this.indexOfSelected++;
                    if (CenovnikForm.this.indexOfSelected >= CenovnikForm.this.itemCount) {
                        CenovnikForm.this.indexOfSelected = 0;
                    }
                    CenovnikForm.this.controller.getCenaByArtikal().put((Artikal)CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0)), (Double)CenovnikForm.this.artikal_cena.get(CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0))));
                    CenovnikForm.this.item = CenovnikForm.this.item.getParent().getItem(CenovnikForm.this.indexOfSelected);
                    e.widget.dispose();
                    CenovnikForm.this.item.getParent().select(CenovnikForm.this.indexOfSelected);
                    CenovnikForm.this.selectNextRow(CenovnikForm.this.item);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    Control oldEditor = CenovnikForm.this.editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    CenovnikForm.this.artikal_cena.put(CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0)), Double.valueOf(CenovnikForm.this.item.getText(2)));
                    CenovnikForm.this.controller.getCenaByArtikal().put((Artikal)CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0)), (Double)CenovnikForm.this.artikal_cena.get(CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0))));
                } else if (e.keyCode == 0x1000001) {
                    CenovnikForm.this.table.showSelection();
                    CenovnikForm.this.indexOfSelected--;
                    if (CenovnikForm.this.indexOfSelected < 0) {
                        CenovnikForm.this.indexOfSelected = CenovnikForm.this.itemCount - 1;
                    }
                    CenovnikForm.this.artikal_cena.put(CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0)), Double.valueOf(CenovnikForm.this.item.getText(2)));
                    CenovnikForm.this.controller.getCenaByArtikal().put((Artikal)CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0)), (Double)CenovnikForm.this.artikal_cena.get(CenovnikForm.this.nameToArtikal.get(CenovnikForm.this.item.getText(0))));
                    CenovnikForm.this.item = CenovnikForm.this.item.getParent().getItem(CenovnikForm.this.indexOfSelected);
                    e.widget.dispose();
                    CenovnikForm.this.item.getParent().select(CenovnikForm.this.indexOfSelected);
                    CenovnikForm.this.selectNextRow(CenovnikForm.this.item);
                }
            }
        });
    }

    private String danBr(int i) {
        switch (i) {
            case 1: {
                return "Nedelja";
            }
            case 2: {
                return "Ponedeljak";
            }
            case 3: {
                return "Utorak";
            }
            case 4: {
                return "Sreda";
            }
            case 5: {
                return "Cetvrtak";
            }
            case 6: {
                return "Petak";
            }
            case 7: {
                return "Subota";
            }
        }
        return "";
    }

    private void izmeniCene(double vrednost, boolean uProcentima, double zaokruzivanje) throws IllegalArgumentException {
        if (zaokruzivanje < 0.0) {
            throw new IllegalArgumentException("Zaokruzivanje ne moze biti manje od nule.");
        }
        if (vrednost <= -100.0 && uProcentima) {
            throw new IllegalArgumentException("Zadate vrednosti ce promeniti cene na negativne vrednosti.");
        }
        for (Artikal artikal : this.tableItemsList) {
            double toSet;
            double trenutna = this.artikal_cena.get(artikal);
            if (trenutna == 0.0) continue;
            if (uProcentima) {
                toSet = trenutna + trenutna * vrednost / 100.0;
            } else {
                toSet = trenutna + vrednost;
                if (toSet <= 0.0) {
                    toSet = trenutna;
                }
            }
            if (zaokruzivanje > 0.0 && (toSet = zaokruzivanje * (double)Math.round(toSet / zaokruzivanje)) == 0.0) {
                toSet = zaokruzivanje;
            }
            this.artikal_cena.put(artikal, toSet);
            this.controller.getCenaByArtikal().put(artikal, toSet);
        }
        this.refreshTable();
    }
}

