/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Cenovnici;
import com.dev63.restoran.model.CenovnikDetalji;
import com.dev63.restoran.model.CenovnikStavka;
import com.dev63.restoran.model.CenovnikTip;
import com.dev63.restoran.sistem.CenovnikFormNew;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class CenovnikController {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer rs;
    private Map<Artikal, Double> cenaByArtikal;
    private List<Artikal> artikli;
    private List<CenovnikStavka> stavke;
    private final boolean postojeciStanje;
    private CenovnikTip cenovnikTip;
    private Cenovnici cenovnici;

    public CenovnikController(RestoranServer rs) {
        this.rs = rs;
        this.postojeciStanje = false;
    }

    public CenovnikController(Cenovnici cenovnici, RestoranServer rs) {
        this.cenovnici = cenovnici;
        this.rs = rs;
        this.postojeciStanje = true;
    }

    public void createNew(Shell shell) throws IllegalStateException {
        if (this.postojeciStanje) {
            throw new IllegalStateException(String.format(this.barmasterText.getString("PORUKA_KONTROLER_NE_MOZE_BITI_KORISCEN_ZA_KREIRANJE_NOVOG_CENOVNIKA"), new Object[0]));
        }
        this.artikli = new ArrayList<Artikal>(this.rs.ArtikliZaFO());
        this.stavke = new LinkedList<CenovnikStavka>();
        this.cenaByArtikal = new HashMap<Artikal, Double>();
        final Shell shell2 = new Shell(shell.getDisplay(), 67680);
        shell2.setLayout((Layout)new GridLayout(2, false));
        shell2.setText(String.format(this.barmasterText.getString("TEXT_NOVI_STALNI_GOST"), new Object[0]));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setBounds(x, y, 300, 300);
        shell2.addListener(64, new Listener(){

            public void handleEvent(Event event) {
                CenovnikController.this.cenovnikTip = null;
            }
        });
        final LinkedList<Button> grupeCombo = new LinkedList<Button>();
        Group g = new Group((Composite)shell2, 0);
        g.setLayout((Layout)new GridLayout());
        Button r = null;
        for (CenovnikTip cTip : this.rs.readCenovnikTip()) {
            r = new Button((Composite)g, 16);
            r.setText(cTip.getNaziv());
            grupeCombo.add(r);
        }
        Button b = Dugmici.getOkButton(shell2);
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (Button b : grupeCombo) {
                    if (!b.getSelection()) continue;
                    CenovnikController.this.cenovnikTip = CenovnikController.this.rs.getCenovnikTip(b.getText());
                }
                shell2.close();
            }
        });
        SWTContainerClass.makeEnd(shell2);
        if (this.cenovnikTip != null) {
            CenovnikFormNew cenovnikFormNew = new CenovnikFormNew(SWTContainerClass.makeContainer(shell, String.format(this.barmasterText.getString("TEXT_NOVI_CENOVNIK"), new Object[0])), this.rs, this, this.cenovnikTip, null);
        }
    }

    public void updateNew(Shell shell) throws IllegalStateException {
        if (!this.postojeciStanje) {
            throw new IllegalStateException(String.format(this.barmasterText.getString("PORUKA_KONTROLER_NE_MOZE_BITI_KORISCEN_ZA_IZMENU_CENOVNIKA"), new Object[0]));
        }
        this.stavke = new LinkedList<CenovnikStavka>();
        this.artikli = new ArrayList<Artikal>(this.rs.ArtikliZaFO());
        CenovnikFormNew cenovnikFormNew = new CenovnikFormNew(SWTContainerClass.makeContainer(shell, String.format(this.barmasterText.getString("TEXT_NOVI_CENOVNIK"), new Object[0])), this.rs, this, this.cenovnici.getCenovnikTip(), this.cenovnici);
    }

    public Cenovnici getCenovnici() {
        return this.cenovnici;
    }

    public void setCenovnici(Cenovnici cenovnici) {
        this.cenovnici = cenovnici;
    }

    public void delete() throws IllegalStateException {
        this.rs.deleteCenovnici(this.cenovnici);
    }

    public void cancelChanges() {
        this.rs.refresh();
        this.cenaByArtikal = null;
        this.artikli = null;
    }

    public Map<Artikal, Double> getCenaByArtikal() throws IllegalStateException {
        if (this.cenaByArtikal != null) {
            return this.cenaByArtikal;
        }
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        this.cenaByArtikal = ret;
        return ret;
    }

    public List<Artikal> getCenovniciArtikli() throws IllegalStateException {
        if (this.artikli != null) {
            return this.artikli;
        }
        ArrayList<Artikal> ret = new ArrayList<Artikal>();
        for (CenovnikStavka cena : this.cenovnici.getArtiklli()) {
            ret.add(cena.getArtikal());
        }
        this.artikli = ret;
        return ret;
    }

    public String getDisplayName() throws IllegalStateException {
        if (this.cenovnici == null) {
            throw new IllegalStateException("Nemoguce je vratiti naziv, kontroleru cenovnika nije dodeljen cenovnik.");
        }
        return this.cenovnici.getNaziv() + " - Tip cenovnika: " + this.cenovnici.getCenovnikTip().getNaziv();
    }

    public String getInfo() {
        int i = 1;
        StringBuilder builder = new StringBuilder();
        for (CenovnikDetalji cenovnikDetalji : this.rs.getCenovnikDetalji(this.cenovnici)) {
            String datumOd = "Datum od: " + new SimpleDateFormat("dd-MM-YYYY").format(cenovnikDetalji.getDatumOd()) + "\n    ";
            String datumDo = "Datum do: " + new SimpleDateFormat("dd-MM-YYYY").format(cenovnikDetalji.getDatumDo()) + "\n    ";
            String danPocetak = "Dan pocetka: " + this.getDayName(cenovnikDetalji.getDanPocetak() != null ? cenovnikDetalji.getDanPocetak() : 0) + "\n    ";
            String danZavrsetak = "Dan zavrsetka: " + this.getDayName(cenovnikDetalji.getDanZavrsetak() != null ? cenovnikDetalji.getDanZavrsetak() : 0) + "\n    ";
            String vremePocetak = "Vreme pocetka: " + String.format("%02d", cenovnikDetalji.getSatPocetak()) + ":" + String.format("%02d", cenovnikDetalji.getMinutPocetak()) + "\n    ";
            String vremeZavrsetak = "Vreme zavrsetka: " + String.format("%02d", cenovnikDetalji.getSatZavrsetak()) + ":" + String.format("%02d", cenovnikDetalji.getMinutZavrsetak()) + "\n\n";
            builder.append(String.valueOf(i) + ". ").append(datumOd).append(datumDo).append(danPocetak).append(danZavrsetak).append(vremePocetak).append(vremeZavrsetak);
            ++i;
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private String getDayName(int day) {
        String number = "";
        switch (day) {
            case 0: {
                number = "";
                break;
            }
            case 1: {
                number = "Ponedeljak";
                break;
            }
            case 2: {
                number = "Utorak";
                break;
            }
            case 3: {
                number = "Sreda";
                break;
            }
            case 4: {
                number = "\u010cetvrtak";
                break;
            }
            case 5: {
                number = "Petak";
                break;
            }
            case 6: {
                number = "Subota";
                break;
            }
            case 7: {
                number = "Nedelja";
                break;
            }
        }
        return number;
    }
}

