/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.sistem.CenovnikController;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class Cenovnici {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    ToolItem item2;
    ToolItem item3;
    private CenovnikController active;
    private RestoranServer rs;
    private Shell shell;
    private List<CenovnikController> controlers;
    private org.eclipse.swt.widgets.List gList;
    private Label detalji;
    Button b;

    public Cenovnici(SWTContainer composite, RestoranServer rs) {
        this.rs = rs;
        this.shell = composite.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        if (this.shell != null && !this.shell.isDisposed()) {
            for (Control control : this.shell.getChildren()) {
                control.dispose();
            }
            this.initComponents();
            this.loadData();
            this.shell.layout();
            if (this.shell instanceof Shell) {
                this.shell.open();
            }
        }
    }

    private void loadData() {
        this.controlers = new ArrayList<CenovnikController>();
        for (com.dev63.restoran.model.Cenovnici cenovnici : this.rs.readCenovnici()) {
            this.controlers.add(new CenovnikController(cenovnici, this.rs));
        }
        this.gList.removeAll();
        this.detalji.setText("");
        for (CenovnikController controller : this.controlers) {
            this.gList.add(controller.getDisplayName());
            if (controller.getCenovnici().getAktivan().booleanValue()) {
                this.gList.setForeground(Display.getCurrent().getSystemColor(9));
                continue;
            }
            this.gList.setForeground(Display.getCurrent().getSystemColor(3));
        }
    }

    private void initComponents() {
        Composite headerComposite = new Composite((Composite)this.shell, 0);
        Composite mainComposite = new Composite((Composite)this.shell, 0);
        GridData layoutDataForHeader = new GridData();
        layoutDataForHeader.horizontalAlignment = 4;
        GridData layoutDataForMain = new GridData();
        layoutDataForMain.heightHint = 600;
        headerComposite.setLayoutData((Object)layoutDataForHeader);
        mainComposite.setLayoutData((Object)layoutDataForMain);
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 5;
        headerLayout.marginHeight = 5;
        headerComposite.setLayout((Layout)headerLayout);
        Label slika = new Label(headerComposite, 0);
        Image sgImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/podgrupeV.gif");
        slika.setImage(sgImg);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)sgImg));
        Group grupaText = new Group(headerComposite, 0);
        grupaText.setText(String.format(this.barmasterText.getString("TEXT_CENOVNICI"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        GridData layoutDataForHeaderImages = new GridData();
        GridData layoutDataForHeaderDescription = new GridData();
        layoutDataForHeaderDescription.horizontalAlignment = 4;
        layoutDataForHeaderDescription.verticalAlignment = 4;
        layoutDataForHeaderDescription.grabExcessVerticalSpace = true;
        layoutDataForHeaderDescription.grabExcessHorizontalSpace = true;
        slika.setLayoutData((Object)layoutDataForHeaderImages);
        grupaText.setLayoutData((Object)layoutDataForHeaderDescription);
        Rectangle rect = this.shell.getBounds();
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginHeight = 5;
        mainLayout.marginWidth = 5;
        mainComposite.setLayout((Layout)mainLayout);
        Group grupaOpcije = new Group(mainComposite, 0);
        grupaOpcije.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        Group grupaObjekti = new Group(mainComposite, 0);
        grupaObjekti.setText(String.format(this.barmasterText.getString("TEXT_LISTA_CENOVNIKA"), new Object[0]));
        Group grupaDetalji = new Group(mainComposite, 0);
        grupaDetalji.setText(String.format(this.barmasterText.getString("TEXT_DETALJI"), new Object[0]));
        GridData layoutDataForMainOpcijeAndDetalji = new GridData();
        layoutDataForMainOpcijeAndDetalji.widthHint = 220;
        GridData layoutDataForObjekti = new GridData();
        layoutDataForObjekti.widthHint = rect.width / 3;
        layoutDataForMainOpcijeAndDetalji.heightHint = 500;
        layoutDataForObjekti.heightHint = 500;
        grupaOpcije.setLayoutData((Object)layoutDataForMainOpcijeAndDetalji);
        grupaDetalji.setLayoutData((Object)layoutDataForMainOpcijeAndDetalji);
        grupaObjekti.setLayoutData((Object)layoutDataForObjekti);
        GridLayout mainOpcijeLayout = new GridLayout(1, true);
        mainOpcijeLayout.marginHeight = 5;
        mainOpcijeLayout.marginWidth = 5;
        grupaOpcije.setLayout((Layout)mainOpcijeLayout);
        Button noviButton = Dugmici.getNovi((Composite)grupaOpcije);
        noviButton.setText(String.format(this.barmasterText.getString("TEXT_NOVI_CENOVNIK"), new Object[0]));
        noviButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Cenovnici.this.onNoviSelectX();
            }
        });
        Button izmenaButton = Dugmici.getIzmena((Composite)grupaOpcije);
        izmenaButton.setText(String.format(this.barmasterText.getString("TEXT_IZMENI_CENOVNIK"), new Object[0]));
        izmenaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Cenovnici.this.onIzmenaSelect();
            }
        });
        Button brisanjeButton = Dugmici.getBrisanje((Composite)grupaOpcije);
        brisanjeButton.setText(String.format(this.barmasterText.getString("TEXT_OBRISI_CENOVNIK"), new Object[0]));
        brisanjeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Cenovnici.this.onDeleteSelect();
            }
        });
        this.b = new Button((Composite)grupaOpcije, 32);
        this.b.setText("Aktivan cenovnik");
        this.b.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (Cenovnici.this.active != null) {
                    com.dev63.restoran.model.Cenovnici c;
                    c.setAktivan((c = Cenovnici.this.active.getCenovnici()).getAktivan() == false);
                    Cenovnici.this.rs.updateCenovnici(c);
                }
            }
        });
        FillLayout layoutForObjekti = new FillLayout();
        grupaObjekti.setLayout((Layout)layoutForObjekti);
        this.gList = new org.eclipse.swt.widgets.List((Composite)grupaObjekti, 516);
        this.gList.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.gList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Cenovnici.this.onListSelect(Cenovnici.this.gList.getSelectionIndex());
            }
        });
        grupaDetalji.setLayout((Layout)new FillLayout());
        this.detalji = new Label((Composite)grupaDetalji, 0);
    }

    private void onListSelect(int selectionIndex) {
        this.setActive(selectionIndex);
        this.printDetails();
    }

    private void onNoviSelectX() {
        CenovnikController ctrl = new CenovnikController(this.rs);
        Shell shell1 = new Shell(this.shell, 34032);
        ctrl.createNew(shell1);
        this.loadData();
    }

    private void onIzmenaSelect() {
        if (this.active != null) {
            Shell shell1 = new Shell(this.shell, 34032);
            this.active.updateNew(shell1);
            this.loadData();
        }
    }

    private void onDeleteSelect() {
        if (this.active != null) {
            this.active.delete();
            this.loadData();
        }
    }

    private void setActive(int index) {
        try {
            this.active = this.controlers.get(index);
            this.b.setSelection(this.active.getCenovnici().getAktivan().booleanValue());
        }
        catch (IndexOutOfBoundsException e) {
            this.active = null;
        }
    }

    private void printDetails() {
        if (this.active == null) {
            this.detalji.setText("");
        } else {
            this.detalji.setText(this.active.getInfo());
        }
    }
}

