/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.setup;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.lang.Language;
import com.dev63.restoran.model.Country;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class IzborDrzaveIJezika {
    private Country country;
    private Language language;
    private final String cLabelKey = "TEXT_IZABERITE_DRZAVU";
    private final String lLabelKey = "TEXT_IZABERITE_JEZIK";

    public IzborDrzaveIJezika(Display d) {
        final Shell s = new Shell(d, 67680);
        s.setLayout((Layout)new GridLayout(2, false));
        final Label l = new Label((Composite)s, 131136);
        l.setText(String.format(Konstante.getBundle().getString("TEXT_IZABERITE_DRZAVU"), new Object[0]) + ":");
        GridData gd = new GridData(4, 0x1000000, false, false);
        l.setLayoutData((Object)gd);
        final ComboViewer cv = new ComboViewer((Composite)s, 12);
        cv.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        cv.setContentProvider((IContentProvider)new ArrayContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Country) {
                    Country c = (Country)((Object)element);
                    return c.getName();
                }
                return super.getText(element);
            }
        });
        cv.setInput((Object)Country.values());
        final Label ll = new Label((Composite)s, 131136);
        ll.setText(String.format(Konstante.getBundle().getString("TEXT_IZABERITE_JEZIK"), new Object[0]) + ":");
        gd = new GridData(4, 0x1000000, false, false);
        ll.setLayoutData((Object)gd);
        final ComboViewer cvl = new ComboViewer((Composite)s, 12);
        cvl.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        cvl.setContentProvider((IContentProvider)new ArrayContentProvider());
        cvl.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Language) {
                    Language l = (Language)((Object)element);
                    return l.getName();
                }
                return super.getText(element);
            }
        });
        cvl.setInput((Object)Language.values());
        cv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                Country c;
                IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                if (!iSel.isEmpty() && (c = (Country)((Object)iSel.getFirstElement())) != null) {
                    Language lang;
                    List<Language> langList = Language.listPrioritizedByLocales(c.getLocales());
                    cvl.setInput(langList);
                    cvl.refresh();
                    Language language = lang = langList.isEmpty() ? null : langList.get(0);
                    if (lang != null) {
                        BMTerminalSettings.setCurLanguage(lang.getName());
                        cvl.setSelection((ISelection)new StructuredSelection((Object)lang));
                    }
                    s.update();
                }
            }
        });
        gd = new GridData(0x1000000, 0x1000000, true, false);
        gd.widthHint = 120;
        gd.heightHint = 50;
        final Button bOk = Dugmici.getOkButton(s);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection iSelC = (IStructuredSelection)cv.getSelection();
                IStructuredSelection iSelL = (IStructuredSelection)cvl.getSelection();
                if (iSelC.isEmpty() || iSelL.isEmpty()) {
                    IzborDrzaveIJezika.this.setCountry(null);
                    IzborDrzaveIJezika.this.setLanguage(null);
                    return;
                }
                IzborDrzaveIJezika.this.setCountry((Country)((Object)iSelC.getFirstElement()));
                IzborDrzaveIJezika.this.setLanguage((Language)((Object)iSelL.getFirstElement()));
                s.dispose();
            }
        });
        final Button bCanc = Dugmici.getCancelButton(s);
        bCanc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                s.dispose();
            }
        });
        cvl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                if (!iSel.isEmpty()) {
                    Language lang = (Language)((Object)iSel.getFirstElement());
                    if (l != null) {
                        BMTerminalSettings.setCurLanguage(lang.getName());
                        l.setText(String.format(Konstante.getBundle().getString("TEXT_IZABERITE_DRZAVU"), new Object[0]) + ":");
                        ll.setText(String.format(Konstante.getBundle().getString("TEXT_IZABERITE_JEZIK"), new Object[0]) + ":");
                        bOk.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
                        bCanc.setText(String.format(Konstante.getBundle().getString("TEXT_OTKAZI"), new Object[0]));
                        s.update();
                    }
                }
            }
        });
        if (this.country != null) {
            try {
                cv.setSelection((ISelection)new StructuredSelection((Object)this.country));
                cv.refresh();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        if (this.language != null) {
            try {
                cvl.setSelection((ISelection)new StructuredSelection((Object)this.language));
                cvl.refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        s.pack();
        Konstante.centerShellOnDisplay(s);
        s.open();
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }
}

