/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.scale.overfolder;

import com.dev63.restoran.scale.overfolder.OverFolderMeasurement;
import com.dev63.restoran.scale.overfolder.OverFolderMeasurementCallable;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverFolderMeasurementFutureTask
extends FutureTask<OverFolderMeasurement> {
    private static final Logger log = Logger.getLogger(OverFolderMeasurementFutureTask.class.getName());
    OverFolderMeasurementCallable callable;

    public OverFolderMeasurementFutureTask(OverFolderMeasurementCallable callable) {
        super(callable);
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled) {
            this.deleteOutFile();
        }
        return cancelled;
    }

    protected void deleteOutFile() {
        if (this.callable != null && this.callable.getOutFile() != null) {
            try {
                Files.deleteIfExists(this.callable.getOutFile());
            }
            catch (Exception e) {
                log.log(Level.INFO, MessageFormat.format("Failed to delete out file:\nMessage: {0}", e.getMessage()), e);
            }
        }
    }
}

