/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.scale.overfolder;

import com.dev63.restoran.scale.overfolder.FileExistanceCallable;
import com.dev63.restoran.scale.overfolder.OverFolderMeasurement;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverFolderMeasurementCallable
implements Callable<OverFolderMeasurement> {
    private static final Logger log = Logger.getLogger(OverFolderMeasurementCallable.class.getName());
    private static final String FILE_NAME_FORMAT = "%1$d.measure";
    private final Path outFolder;
    private final Path inFolder;
    private Path outFile;

    public OverFolderMeasurementCallable(Path outFolder, Path inFolder) {
        this.outFolder = outFolder;
        this.inFolder = inFolder;
    }

    public Path getOutFile() {
        return this.outFile;
    }

    public Path getOutFolder() {
        return this.outFolder;
    }

    public Path getInFolder() {
        return this.inFolder;
    }

    protected Path createInitiateMeasurementFile(Path fromFolder) throws IOException {
        if (fromFolder == null) {
            throw new IllegalStateException("getFromFolderMethod returns null");
        }
        long ctim = System.currentTimeMillis();
        String fileName = String.format(FILE_NAME_FORMAT, ctim);
        return Files.createFile(fromFolder.resolve(fileName), new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverFolderMeasurement call() throws Exception {
        if (this.outFolder == null) {
            throw new NullPointerException("outFolder is null");
        }
        if (this.inFolder == null) {
            throw new NullPointerException("outFile is null");
        }
        this.outFile = this.createInitiateMeasurementFile(this.outFolder);
        Path fileName = this.outFile.getFileName();
        Path inFile = this.inFolder.resolve(fileName);
        Boolean inFileExists = false;
        FileExistanceCallable fec = new FileExistanceCallable(inFile);
        ScheduledExecutorService fileWatchExecutor = Executors.newSingleThreadScheduledExecutor();
        try {
            ScheduledFuture<Boolean> schedule;
            while (!(inFileExists = (Boolean)(schedule = fileWatchExecutor.schedule(fec, 500L, TimeUnit.MILLISECONDS)).get()).booleanValue()) {
            }
        }
        finally {
            fileWatchExecutor.shutdownNow();
        }
        OverFolderMeasurement m = null;
        if (inFileExists.booleanValue()) {
            List<String> allLines = Files.readAllLines(inFile, StandardCharsets.UTF_8);
            try {
                if (allLines.isEmpty()) {
                    throw new RuntimeException("No value is provided in result file");
                }
                m = new OverFolderMeasurement(BigDecimal.valueOf(Double.parseDouble(allLines.get(0))));
                Files.delete(inFile);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, MessageFormat.format("Error parsing measurement value from file {0}.\nMessage: {1}", inFile.toAbsolutePath(), e.getMessage()), e);
                throw e;
            }
        }
        return m;
    }
}

